/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.dao.consultation.RtcRoomMapper;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.bo.video.CompensationMember;
import com.byh.pojo.bo.video.ImSession;
import com.byh.pojo.bo.video.Member;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationTranscodeVideoEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationTranscodeVideoService;
import com.byh.service.cosultation.RtcRoomService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.HttpUtils;
import com.byh.util.MD5Utils;
import com.byh.util.StringUtil;
import com.byh.util.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.vod.v20180717.VodClient;
import com.tencentcloudapi.vod.v20180717.models.DescribeMediaInfosRequest;
import com.tencentcloudapi.vod.v20180717.models.DescribeMediaInfosResponse;
import com.tencentcloudapi.vod.v20180717.models.MediaInfo;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskInput;
import com.tencentcloudapi.vod.v20180717.models.ProcessMediaRequest;
import com.tencentcloudapi.vod.v20180717.models.ProcessMediaResponse;
import com.tencentcloudapi.vod.v20180717.models.SearchMediaRequest;
import com.tencentcloudapi.vod.v20180717.models.SearchMediaResponse;
import com.tencentcloudapi.vod.v20180717.models.TranscodeTaskInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TRTCManage {
    private static final Logger log = LoggerFactory.getLogger(TRTCManage.class);
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private RtcRoomService rtcRoomService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private ConsultationTranscodeVideoService consultationTranscodeVideoService;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private RtcRoomMapper rtcRoomMapper;
    private ReentrantLock lock = new ReentrantLock();

    private String createTRTCRoom(Long orderId) {
        String roomId = "";
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        if (Objects.isNull(order)) {
            log.info("\u8ba2\u5355 orderId{}\uff0c\u4e0d\u5b58\u5728\uff01", (Object)order);
            return roomId;
        }
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/imsys/imapi/saveimsession").toString();
        ImSession imSession = new ImSession();
        imSession.setBusiCode(order.getId().toString());
        imSession.setCreateUser("byh");
        imSession.setSaveType(true);
        ArrayList<Member> memberList = new ArrayList<Member>();
        Member memberDoctor = new Member();
        memberDoctor.setAppCode("EHOS_DOCTOR");
        memberDoctor.setDoctorId("1");
        memberDoctor.setPatientId("0");
        memberDoctor.setFlowType("master");
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(order.getDoctorId());
        memberDoctor.setUserId(doctorInfoRespVO.getUserId());
        memberList.add(memberDoctor);
        List mdtConsultationEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(order.getViewId());
        if (CollectionUtils.isNotEmpty((Collection)mdtConsultationEntityList)) {
            for (ConsultationMdtEntity consultationMdtEntity : mdtConsultationEntityList) {
                Member memberExpert = new Member();
                memberExpert.setAppCode("EHOS_DOCTOR");
                memberExpert.setDoctorId("1");
                memberExpert.setPatientId("0");
                memberExpert.setFlowType("slave");
                DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                memberExpert.setUserId(expertInfoRespVO.getUserId());
                memberList.add(memberExpert);
            }
        } else {
            Member memberExpert = new Member();
            memberExpert.setAppCode("EHOS_DOCTOR");
            memberExpert.setDoctorId("1");
            memberExpert.setPatientId("0");
            memberExpert.setFlowType("slave");
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(order.getExpertId());
            memberExpert.setUserId(expertInfoRespVO.getUserId());
            memberList.add(memberExpert);
        }
        imSession.setMemberList(memberList);
        imSession.setTreatmentId(order.getViewId());
        log.info("\u8ba2\u5355:{}====\u521b\u5efa\u623f\u95f4\u53f7\u65f6\u7684url\u662f:{}=====\u53c2\u6570\u4e32\u662f:{}", new Object[]{order, url, JSONObject.toJSONString((Object)imSession)});
        try {
            String respData = HttpUtils.post((String)url, (String)JSONObject.toJSONString((Object)imSession));
            log.info("\u8ba2\u5355:{}\u521b\u5efa\u623f\u95f4\u53f7\u662f\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)orderId, (Object)respData);
            if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSON.parseObject((String)respData).getString("code")) && JSON.parseObject((String)respData).getJSONObject("data") != null) {
                roomId = JSON.parseObject((String)respData).getJSONObject("data").getString("roomNum");
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u623f\u95f4\u53f7\u5931\u8d25{}", (Throwable)e);
        }
        return roomId;
    }

    public void saveRtcRoomId(Long orderId) {
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        RtcRoomEntity room = this.getByOrderIdAndOrderType(order.getId(), order.getType());
        if (room == null) {
            String roomId = this.createTRTCRoom(orderId);
            RtcRoomEntity roomEntity = new RtcRoomEntity();
            roomEntity.setOrderId(orderId);
            roomEntity.setOrderType(order.getType());
            roomEntity.setViewId(UniqueKeyGenerator.generateViewId().toString());
            roomEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
            if (StringUtil.isNotEmpty((String)roomId)) {
                log.info("===roomId==={}", (Object)roomId);
                roomEntity.setId(Long.valueOf(Long.parseLong(roomId)));
                this.rtcRoomService.insertRtcRoom(roomEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtcRoomEntity createRoomId(Long orderId, Integer orderType) {
        String roomId = this.createTRTCRoom(orderId);
        if (StringUtil.isEmpty((String)roomId)) {
            return null;
        }
        RtcRoomEntity roomEntity = null;
        try {
            this.lock.tryLock(3L, TimeUnit.SECONDS);
            roomEntity = this.rtcRoomMapper.selectById(Long.valueOf(Long.parseLong(roomId)));
            if (Objects.isNull(roomEntity)) {
                roomEntity = new RtcRoomEntity();
                roomEntity.setOrderId(orderId);
                roomEntity.setOrderType(orderType);
                roomEntity.setViewId(UniqueKeyGenerator.generateViewId().toString());
                roomEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
                roomEntity.setId(Long.valueOf(Long.parseLong(roomId)));
                this.rtcRoomMapper.insertRtcRoom(roomEntity);
            }
        }
        catch (InterruptedException e) {
            log.error("\u521b\u5efa\u623f\u95f4\u52a0\u9501\u5931\u8d25{}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        return roomEntity;
    }

    public RtcRoomEntity getByOrderIdAndOrderType(Long orderId, Integer orderType) {
        return this.rtcRoomService.selectByOrderIdAndOrderType(orderId, orderType.intValue());
    }

    public String getUnitVedioId(Long roomId, String sdkAccountId) {
        return "26052_" + MD5Utils.string2MD5((String)(roomId + "_" + sdkAccountId + "_main"));
    }

    public SearchMediaResponse getVedioInfoByStreamId(String streamId) {
        log.info("\u67e5\u627e\u89c6\u9891\u6d41\u7684id\u662f:" + streamId);
        SearchMediaResponse mediaResponse = null;
        try {
            Credential cred = new Credential("AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf", "qUvAC261kKVoxxlOr15b4MSM7g4GHcrw");
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("vod.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            VodClient client = new VodClient(cred, "ap-chengdu", clientProfile);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("StreamId", (Object)streamId);
            SearchMediaRequest req = (SearchMediaRequest)SearchMediaRequest.fromJsonString((String)jsonObject.toJSONString(), SearchMediaRequest.class);
            mediaResponse = client.SearchMedia(req);
        }
        catch (TencentCloudSDKException e) {
            System.out.println(e.toString());
        }
        return mediaResponse;
    }

    public String getSdkAccount(String flowType, ConsultationEntity consultationEntity) {
        String sdkAcountId = "";
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + "cloud/imsys/imapi/batchgetsession";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("busiCode", (Object)consultationEntity.getId());
        ArrayList<String> longs = new ArrayList<String>();
        longs.add(consultationEntity.getViewId());
        jsonObject.put("treatmentId", longs);
        log.info("\u83b7\u53d6\u7528\u6237sdkAccoutId\u8bf7\u6c42\u7684url\u662f:{}====\u8bf7\u6c42\u7684\u53c2\u6570\u662f:{}", (Object)url, (Object)jsonObject.toJSONString());
        try {
            JSONObject jsonObject1;
            String memListStr;
            List compensationMembers;
            String dataStr = HttpUtils.post((String)url, (String)jsonObject.toJSONString());
            log.info("\u83b7\u53d6\u7528\u6237sdkAccoutId\u8fd4\u56de\u7684\u7ed3\u679c\u662f:{}", (Object)dataStr);
            JSONObject resData = JSON.parseObject((String)dataStr);
            if (resData.getString("code").equals(ReturnCodeEnum.SUCCEED.getValue()) && StringUtil.isNotEmpty((String)resData.getString("data")) && CollectionUtils.isNotEmpty((Collection)(compensationMembers = JSONArray.parseArray((String)(memListStr = (jsonObject1 = resData.getJSONArray("data").getJSONObject(0)).getString("memberList")), CompensationMember.class)))) {
                for (CompensationMember compensationMember : compensationMembers) {
                    if (!flowType.equals(compensationMember.getFlowType())) continue;
                    sdkAcountId = compensationMember.getSdkAccount();
                }
            }
        }
        catch (IOException e) {
            log.error("getSdkAccount", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("getSdkAccount", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("getSdkAccount", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return sdkAcountId;
    }

    private ProcessMediaResponse processMediaReq(String fileId) {
        log.info("\u4e91\u70b9\u64ad\u8f6c\u7801\u7684\u6587\u4ef6id\u662f:{}", (Object)fileId);
        ProcessMediaResponse resp = null;
        try {
            Credential cred = new Credential("AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf", "qUvAC261kKVoxxlOr15b4MSM7g4GHcrw");
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("vod.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            VodClient client = new VodClient(cred, "", clientProfile);
            ProcessMediaRequest processMediaRequest = new ProcessMediaRequest();
            processMediaRequest.setFileId(fileId);
            MediaProcessTaskInput mediaProcessTaskInput = new MediaProcessTaskInput();
            TranscodeTaskInput[] transcodeTaskInputs = new TranscodeTaskInput[1];
            TranscodeTaskInput transcodeTaskInput = new TranscodeTaskInput();
            transcodeTaskInput.setDefinition(Long.valueOf(20L));
            transcodeTaskInputs[0] = transcodeTaskInput;
            mediaProcessTaskInput.setTranscodeTaskSet(transcodeTaskInputs);
            processMediaRequest.setMediaProcessTask(mediaProcessTaskInput);
            String params = JSONObject.toJSONString((Object)processMediaRequest);
            log.info("\u8f6c\u7801\u62fc\u63a5\u540e\u7684\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)params);
            resp = client.ProcessMedia(processMediaRequest);
            log.info("\u89c6\u9891\u8f6c\u7801\u817e\u8baf\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)JSON.toJSONString((Object)resp));
        }
        catch (TencentCloudSDKException e) {
            log.error(e.getRequestId(), (Throwable)e);
        }
        return resp;
    }

    private Map<String, String> getVideoFilesId(ConsultationEntity consultationEntity) {
        MediaInfo[] mediaInfos;
        String sdkAccountId;
        HashMap<String, String> map = new HashMap<String, String>();
        RtcRoomEntity rtcRoomEntity = this.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
        try {
            sdkAccountId = this.getSdkAccount("master", consultationEntity);
            String expertStreamId = this.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            SearchMediaResponse expertMediaRespose = this.getVedioInfoByStreamId(expertStreamId);
            mediaInfos = expertMediaRespose.getMediaInfoSet();
            map.put("expertVideoFileId", mediaInfos[0].getFileId());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e13\u5bb6\u7aef\u89c6\u9891\u6587\u4ef6id\u5f02\u5e38," + e.getMessage(), (Throwable)e);
        }
        try {
            sdkAccountId = this.getSdkAccount("slave", consultationEntity);
            String doctorStreamId = this.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            SearchMediaResponse doctorMediaRespose = this.getVedioInfoByStreamId(doctorStreamId);
            mediaInfos = doctorMediaRespose.getMediaInfoSet();
            map.put("doctorVideoFileId", mediaInfos[0].getFileId());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533b\u751f\u7aef\u89c6\u9891\u6587\u4ef6id\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public BaseResponse<String> invokeProcessMedia(ConsultationEntity consultationEntity) {
        Map map = this.getVideoFilesId(consultationEntity);
        ProcessMediaResponse processMediaResponse = null;
        ConsultationTranscodeVideoEntity videoEntity = new ConsultationTranscodeVideoEntity();
        videoEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
        if (!map.isEmpty() && StringUtil.isNotEmpty((String)((String)map.get("expertVideoFileId")))) {
            videoEntity.setFileId((String)map.get("expertVideoFileId"));
            processMediaResponse = this.processMediaReq((String)map.get("expertVideoFileId"));
        } else if (!map.isEmpty() && StringUtil.isNotEmpty((String)((String)map.get("doctorVideoFileId")))) {
            videoEntity.setFileId((String)map.get("doctorVideoFileId"));
            processMediaResponse = this.processMediaReq((String)map.get("doctorVideoFileId"));
        } else {
            return BaseResponse.error((String)"\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8f6c\u7801\u5931\u8d25!");
        }
        if (processMediaResponse != null && StringUtil.isNotEmpty((String)processMediaResponse.getTaskId())) {
            videoEntity.setOrderViewId(consultationEntity.getViewId());
            videoEntity.setOrderType(consultationEntity.getType());
            this.consultationTranscodeVideoService.insert(videoEntity);
            return BaseResponse.success((Object)"\u8f6c\u7801\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b");
        }
        return BaseResponse.error((String)"\u8f6c\u7801\u8bf7\u6c42\u5931\u8d25");
    }

    public Map<String, List<String>> getDoctorVideoFileds(ConsultationEntity consultationEntity) {
        Object[] mediaInfos;
        String sdkAccountId;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        RtcRoomEntity rtcRoomEntity = this.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
        log.info("==========rtcRoomEntity:{}", (Object)rtcRoomEntity);
        ArrayList<String> expertFiledsInfo = new ArrayList<String>();
        ArrayList<String> doctorFiledsInfo = new ArrayList<String>();
        try {
            sdkAccountId = this.getSdkAccount("master", consultationEntity);
            log.info("==========sdkAccountId:{}", (Object)sdkAccountId);
            String expertStreamId = this.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            log.info("==========expertStreamId:{}", (Object)expertStreamId);
            SearchMediaResponse expertMediaRespose = this.getVedioInfoByStreamId(expertStreamId);
            log.info("==========expertMediaRespose:{}", (Object)expertMediaRespose);
            mediaInfos = expertMediaRespose.getMediaInfoSet();
            log.info("==========mediaInfos:{}", mediaInfos);
            for (Object mediaInfo : mediaInfos) {
                expertFiledsInfo.add(mediaInfo.getFileId());
            }
            log.info("==========expertFiledsInfo:{}", expertFiledsInfo);
            map.put("expertVideoFileId", expertFiledsInfo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e13\u5bb6\u7aef\u89c6\u9891\u6587\u4ef6id\u5f02\u5e38," + e.getMessage(), (Throwable)e);
        }
        try {
            sdkAccountId = this.getSdkAccount("slave", consultationEntity);
            log.info("==========sdkAccountId:{}", (Object)sdkAccountId);
            String doctorStreamId = this.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            log.info("==========doctorStreamId:{}", (Object)doctorStreamId);
            SearchMediaResponse doctorMediaRespose = this.getVedioInfoByStreamId(doctorStreamId);
            log.info("==========doctorMediaRespose:{}", (Object)doctorMediaRespose);
            mediaInfos = doctorMediaRespose.getMediaInfoSet();
            log.info("==========mediaInfos:{}", mediaInfos);
            for (Object mediaInfo : mediaInfos) {
                doctorFiledsInfo.add(mediaInfo.getFileId());
            }
            log.info("==========doctorFiledsInfo:{}", doctorFiledsInfo);
            map.put("doctorVideoFileId", doctorFiledsInfo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533b\u751f\u7aef\u89c6\u9891\u6587\u4ef6id\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public Long getTotalVideoDuration(List<String> strings) {
        Long totalDuration = 0L;
        try {
            Credential cred = new Credential("AKIDSnwteh1VAdw3yh7dpqeGgvypUwCrsflf", "qUvAC261kKVoxxlOr15b4MSM7g4GHcrw");
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("vod.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            VodClient client = new VodClient(cred, "ap-beijing", clientProfile);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("FileIds", strings);
            DescribeMediaInfosRequest req = (DescribeMediaInfosRequest)DescribeMediaInfosRequest.fromJsonString((String)jsonObject.toJSONString(), DescribeMediaInfosRequest.class);
            DescribeMediaInfosResponse resp = client.DescribeMediaInfos(req);
            MediaInfo[] mediaInfos = resp.getMediaInfoSet();
            if (mediaInfos != null) {
                for (MediaInfo mediaInfo : mediaInfos) {
                    Float perDuration = mediaInfo.getTranscodeInfo().getTranscodeSet()[0].getDuration();
                    totalDuration = totalDuration + (perDuration == null ? 0L : perDuration.longValue());
                }
            }
        }
        catch (TencentCloudSDKException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return totalDuration;
    }
}

