/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.dao.consultation.ConsultationMdtMapper;
import com.byh.enums.HxgyPushCenterEnum;
import com.byh.enums.HxgyPushCodeIntegerEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.exception.PushInfoException;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.pojo.bo.GoEasyPushDataBo;
import com.byh.pojo.bo.YouMengPushDataBo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.mdt.vo.PushConfigurationDetailVO;
import com.byh.pojo.mdt.vo.UmPushMsgAndroidReqVO;
import com.byh.pojo.mdt.vo.UmPushMsgIOSReqVo;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.consultation.res.UserLastLoginDeviceRespVo;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.AppWebPushUtil;
import com.byh.util.HttpUtils;
import com.byh.util.PushInfoManagerUtils;
import com.byh.util.PushParamUtil;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class WebAndAppMessageManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(WebAndAppMessageManager.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private ConsultationMdtMapper consultationMdtMapper;

    public String getAppCode(Long hospitalId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        return (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
    }

    private void fillExtraMap(Map<String, String> map, YouMengPushDataBo youMengPushDataBo, ConsultationEntity consultationEntity1) {
        map.put("content", youMengPushDataBo.getText());
        map.put("orderViewId", consultationEntity1.getViewId());
        map.put("orderStatus", consultationEntity1.getStatus().toString());
        map.put("orderType", consultationEntity1.getType().toString());
        map.put("orderId", consultationEntity1.getId().toString());
    }

    @Async
    public void addOrderSendMessageToPatient(ConsultationEntity consultationEntity1) {
        DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity1.getExpertId());
        HashMap<String, String> map = new HashMap<String, String>();
        int orderType = consultationEntity1.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? OrderTypeEnum.TYPE_VEDIO.getValue() : OrderTypeEnum.TYPE_TUWEN.getValue();
        try {
            log.info("\u4e0b\u5355\u5b8c\u6210\u5f00\u59cb\u7ed9\u76f8\u5173\u7684\u4eba\u5458\u53d1\u9001app=============");
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a3\u8005" + consultationEntity1.getPatientName() + "," + consultationEntity1.getDoctorHosName() + consultationEntity1.getDoctorDepName() + consultationEntity1.getDoctorName() + "\u5411\u60a8\u53d1\u8d77\u4e00\u4e2a" + OrderTypeEnum.getByValue((Integer)orderType).getDisplay() + "\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.NEW_ORDER.getValue().toString());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.NEW_ORDER.getDisplay());
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.NEW_ORDER.getCode().toString());
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity1);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity1.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.NEW_ORDER.getValue().toString());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
            this.shortMessageManager.newConsultationToDoctor(consultationEntity1.getViewId());
            this.shortMessageManager.videoConsultationApplyToExpert(consultationEntity1.getViewId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("==========\u4e0b\u5355\u53d1\u9001\u63a8\u9001\u5b8c\u6210==========");
    }

    @Async
    public void orderExpertAcceptSendMessage(Long orderId, String acceptTimeStr, String consultationDate, String consultationTime) {
        log.info("\u63a8\u9001_\u4e13\u5bb6\u63a5\u8bca=====================");
        try {
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
            Integer orderType = consultationEntity.getType();
            HashMap<String, String> map = new HashMap<String, String>();
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            switch (orderType) {
                case 4: {
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001");
                    this.shortMessageManager.expertHaveAcceptApply(consultationEntity.getViewId());
                    this.shortMessageManager.videoConsultationAccept(consultationEntity.getViewId());
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001_\u966a\u8bca\u533b\u751f_APP====================");
                    YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                    youMengPushDataBo.setText(consultationEntity.getExpertName() + "\u4e13\u5bb6\u5df2\u63a5\u53d7\u60a8\u7684\u89c6\u9891\u4f1a\u8bca\u9080\u8bf7,\u8bf7\u4e8e" + consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime() + "\u51c6\u65f6\u53c2\u52a0,\u8c22\u8c22!");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription("");
                    youMengPushDataBo.setPlayAction("");
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.AGREE_ORDER.getDisplay());
                    youMengPushDataBo.setTicker("");
                    youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.AGREE_ORDER.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String doctorVideoAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorVideoAppCode, youMengPushDataBo);
                    GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorVideoAppCode, goEasyPushDataBo);
                    this.shortMessageManager.videoConsultationApplyToExpert(consultationEntity.getViewId());
                    youMengPushDataBo.setText("\u60a8\u5df2\u63a5\u53d7" + consultationEntity.getPatientName() + "," + consultationEntity.getExpertHosName() + consultationEntity.getDoctorHosName() + consultationEntity.getDoctorName() + "\u533b\u751f\u53d1\u8d77\u89c6\u9891\u4f1a\u8bca\u7533\u8bf7\u3002");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription("");
                    youMengPushDataBo.setPlayAction("");
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.AGREE_ORDER.getDisplay());
                    youMengPushDataBo.setTicker("");
                    youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.AGREE_ORDER.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String expertVideoAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo);
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001_\u966a\u8bca\u533b\u751f_web====================");
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(expertVideoAppCode, goEasyPushDataBo);
                    break;
                }
                case 5: {
                    log.info("\u63a5\u8bca_\u56fe\u6587\u63a8\u9001");
                    this.shortMessageManager.expertHaveAcceptApply(consultationEntity.getViewId());
                    this.shortMessageManager.photoConsultationAccept(consultationEntity.getViewId());
                    YouMengPushDataBo youMengPushDataBo1 = new YouMengPushDataBo();
                    youMengPushDataBo1.setText(consultationEntity.getExpertName() + "\u4e13\u5bb6\u5df2\u63a5\u53d7\u60a8\u7684\u56fe\u6587\u4f1a\u8bca\u9080\u8bf7,\u8bf7\u4e8e" + consultationDate + " " + consultationTime + "\u51c6\u65f6\u53c2\u52a0,\u8c22\u8c22!");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription("");
                    youMengPushDataBo1.setPlayAction("");
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.AGREE_ORDER.getDisplay());
                    youMengPushDataBo1.setTicker("");
                    youMengPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.AGREE_ORDER.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                    youMengPushDataBo1.setExtra(map);
                    youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                    String doctorTuwenAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorTuwenAppCode, youMengPushDataBo1);
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001_\u966a\u8bca\u533b\u751f_web====================");
                    GoEasyPushDataBo goEasyPushDataBo1 = new GoEasyPushDataBo();
                    goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                    goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    goEasyPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorTuwenAppCode, goEasyPushDataBo1);
                    this.shortMessageManager.photoConsultationApplyToExpert(consultationEntity.getViewId());
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001_\u4e13\u5bb6_APP====================");
                    youMengPushDataBo1.setText(consultationEntity.getExpertName() + "\u4e13\u5bb6\u63a5\u53d7\u60a8\u7684\u56fe\u6587\u4f1a\u8bca\u9080\u8bf7,\u4f1a\u8bca\u5df2\u5728\u8fdb\u884c\u4e2d,\u5c06\u4e8e" + acceptTimeStr + "\u7ed3\u675f,\u6301\u7eed24\u5c0f\u65f6.\u8bf7\u7acb\u5373\u53c2\u4e0e\u4f1a\u8bae\u3002");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription("");
                    youMengPushDataBo1.setPlayAction("");
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.AGREE_ORDER.getDisplay());
                    youMengPushDataBo1.setTicker("");
                    youMengPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.AGREE_ORDER.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                    youMengPushDataBo1.setExtra(map);
                    youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                    String expertTuwenAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(expertTuwenAppCode, youMengPushDataBo1);
                    log.info("\u63a5\u8bca_\u89c6\u9891\u63a8\u9001_\u966a\u8bca\u533b\u751f_web===========");
                    goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                    goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.AGREE_ORDER.getValue().toString());
                    goEasyPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(expertTuwenAppCode, goEasyPushDataBo1);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void saveUpdateConsultationReportSendMessage(Long id) {
        log.info("\u63a8\u9001_\u4f1a\u8bca\u62a5\u544a====================");
        try {
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(id);
            Integer orderType = consultationEntity.getType();
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            this.shortMessageManager.reportHaveSubmitToDoctor(consultationEntity.getViewId());
            HashMap<String, String> map = new HashMap<String, String>();
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u4e13\u5bb6\u4f1a\u8bca\u62a5\u544a\u5b8c\u6210." + consultationEntity.getExpertName() + "\u5df2\u5b8c\u6210\u4f1a\u8bca\u62a5\u544a\u7684\u586b\u5199,\u8bf7\u53ca\u65f6\u67e5\u770b\u548c\u786e\u8ba4\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.SAVE_CONSULTATION_OPINION.getValue().toString());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.SAVE_CONSULTATION_OPINION.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.SAVE_CONSULTATION_OPINION.getCode().toString());
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.SAVE_CONSULTATION_OPINION.getValue().toString());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void hospitalManageOrderDistributionSendMessage(ConsultationEntity consultationEntity) {
        try {
            log.info("\u8ba2\u5355\u6570\u636e=====================" + consultationEntity.toString());
            Integer orderType = consultationEntity.getType();
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            switch (orderType) {
                case 4: {
                    YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                    youMengPushDataBo.setText("\u60a8\u7533\u8bf7\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5206\u914d" + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u4e13\u5bb6,\u8bf7\u505a\u597d\u51c6\u5907\u3002");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription("");
                    youMengPushDataBo.setPlayAction("");
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo.setTicker("");
                    youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.VIDEO_ORDER_DISTRIBUTED.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String doctorVideoAppcode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorVideoAppcode, youMengPushDataBo);
                    GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorVideoAppcode, goEasyPushDataBo);
                    log.info("\u63a8\u9001_\u4e13\u5bb6\u5206\u914d(\u89c6\u9891)_\u4f1a\u8bca\u4e13\u5bb6\u77ed\u4fe1=====================");
                    youMengPushDataBo.setText("\u7ba1\u7406\u5458\u4e3a\u60a8\u5206\u914d\u4e86\u60a3\u8005" + consultationEntity.getPatientName() + "," + consultationEntity.getDoctorHosName() + consultationEntity.getDoctorDepName() + consultationEntity.getDoctorName() + "\u533b\u751f\u7684\u4f1a\u8bca,\u8bf7\u67e5\u770b\u8be6\u60c5\u3002");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription("");
                    youMengPushDataBo.setPlayAction("");
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo.setTicker("");
                    youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.VIDEO_ORDER_DISTRIBUTED.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String expertVideoAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo);
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(expertVideoAppCode, goEasyPushDataBo);
                    break;
                }
                case 5: {
                    YouMengPushDataBo youMengPushDataBo1 = new YouMengPushDataBo();
                    youMengPushDataBo1.setText("\u60a8\u7533\u8bf7\u7684\u56fe\u6587\u4f1a\u8bca\u5df2\u5206\u914d" + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u4e13\u5bb6,\u4e13\u5bb6\u63a5\u8bca\u540e\u7acb\u5373\u5f00\u59cb,\u6301\u7eed24\u5c0f\u65f6,\u8bf7\u8010\u5fc3\u7b49\u5019\u4e13\u5bb6\u63a5\u8bca\u3002");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription("");
                    youMengPushDataBo1.setPlayAction("");
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo1.setTicker("");
                    youMengPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.PHOTO_ORDER_DISTRIBUTED.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                    youMengPushDataBo1.setExtra(map);
                    youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                    String doctorTuwenAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorTuwenAppCode, youMengPushDataBo1);
                    GoEasyPushDataBo goEasyPushDataBo1 = new GoEasyPushDataBo();
                    goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                    goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorTuwenAppCode, goEasyPushDataBo1);
                    youMengPushDataBo1.setText("\u7ba1\u7406\u5458\u4e3a\u60a8\u5206\u914d\u4e86\u60a3\u8005" + consultationEntity.getPatientName() + "," + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u533b\u751f\u7684\u56fe\u6587\u4f1a\u8bca,\u8bf7\u505a\u67e5\u770b\u8be6\u60c5\u3002");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription("");
                    youMengPushDataBo1.setPlayAction("");
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo1.setTicker("");
                    youMengPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.PHOTO_ORDER_DISTRIBUTED.getCode().toString());
                    this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                    youMengPushDataBo1.setExtra(map);
                    youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                    String expertTuwenAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(expertTuwenAppCode, youMengPushDataBo1);
                    goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                    goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(expertTuwenAppCode, goEasyPushDataBo1);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void pushToDoctor(ConsultationEntity consultationEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        try {
            if (patientInfoRespVO != null) {
                this.shortMessageManager.newConsultationToDoctor(consultationEntity.getViewId());
            }
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            String sex = consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973";
            youMengPushDataBo.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "," + sex + "\uff0c" + consultationExtendEntity.getPatientAge() + "\u5c81\uff0c\u5411\u60a8\u53d1\u6765\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\uff0c\u9080\u8bf7\u60a8\u5e2e\u5fd9\u7533\u8bf7\u5e76\u4e00\u540c\u53c2\u4e0e\u4e13\u5bb6\u4f1a\u8bca\uff0c\u8bf7\u7acb\u5373\u5904\u7406\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getValue().toString());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.PATIENT_ADD_ORDER.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getValue().toString());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("\u7ed9\u966a\u8bca\u533b\u751f\u53d1\u9001\u77ed\u4fe1\u6210\u529f=============");
    }

    @Async
    public void startConsultationSendMessage(ConsultationEntity consultationEntity) {
        log.info("\u63a8\u9001_\u5f00\u59cb\u89c6\u9891======================");
        try {
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u4e13\u5bb6" + consultationEntity.getExpertName() + "\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5f00\u59cb,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bca\u804a\u5929\u5ba4\u53c2\u4e0e\u4f1a\u8bae\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.BEFORE_ORDER_BEGIN.getCode().toString());
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            this.shortMessageManager.consultationStartedToExpert(consultationEntity.getViewId());
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u533b\u751f" + consultationEntity.getDoctorName() + "\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5230\u5f00\u59cb\u65f6\u95f4,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bca\u804a\u5929\u5ba4\u5f00\u59cb\u4f1a\u8bca\u76f4\u64ad\u3002");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.toString().equals(consultationEntity.getApplicationChannels().toString())) {
                youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u533b\u751f" + consultationEntity.getDoctorName() + "\u7684\u89c6\u9891\u4f1a\u8bae\u5df2\u5230\u5f00\u59cb\u65f6\u95f4,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bae\u804a\u5929\u5ba4\u5f00\u59cb\u4f1a\u8bae\u76f4\u64ad\u3002");
            }
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.BEFORE_ORDER_BEGIN.getCode().toString());
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancellationOfConsultationSendMessage(ConsultationEntity consultationEntity, String cancelReason) {
        log.info("===========\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u5f00\u59cb=========\u8ba2\u5355id\u662f:" + consultationEntity.getId() + "\u53d6\u6d88\u7684\u539f\u56e0\u662f:" + cancelReason);
        try {
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u53d6\u6d88\uff0c\u539f\u56e0:" + cancelReason);
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.CANCEL_ORDER.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.CANCEL_ORDER.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.CANCEL_ORDER.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.CANCEL_ORDER.getValue());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            youMengPushDataBo.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u53d6\u6d88\uff0c\u539f\u56e0:" + cancelReason);
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.CANCEL_ORDER.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.CANCEL_ORDER.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.CANCEL_ORDER.getCode().toString());
            map.put("applyAccepts", "2");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.CANCEL_ORDER.getValue());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
            log.info("==========\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u5b8c\u6210==========");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("===========\u53d6\u6d88\u6700\u540e\u7684\u51fa\u53e3==========");
    }

    @Async
    public void refundOfConsultationSendMessage(ConsultationEntity consultationEntity, String refundReason) {
        log.info("===========\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u5f00\u59cb=========\u8ba2\u5355id\u662f:" + consultationEntity.getId() + "\u53d6\u6d88\u7684\u539f\u56e0\u662f:" + refundReason);
        try {
            HashMap<String, String> mapDb;
            PushConfigurationDetailVO pushConfig;
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            List consultationMdtEntityList = this.consultationMdtMapper.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
            HashMap<String, String> map = new HashMap<String, String>();
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            UserLastLoginDeviceRespVo userLastLoginDeviceRespVoDb = PushParamUtil.getDocUserDeviceToken((String)doctorInfoRespVO.getUserId(), (Short)new Short("1"));
            if (userLastLoginDeviceRespVoDb.getDeviceType().equals("IOS")) {
                pushConfig = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"IOS");
                UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
                iosPush.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
                iosPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                iosPush.setUserId(doctorInfoRespVO.getUserId());
                iosPush.setClientCode(pushConfig.getClientCode());
                iosPush.setDeviceTokens(userLastLoginDeviceRespVoDb.getDeviceNumber());
                iosPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                iosPush.setDescription("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                iosPush.setBody("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                iosPush.setBusiStyle("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                iosPush.setSubTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                mapDb = new HashMap();
                mapDb.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
                iosPush.setExtra(mapDb);
                AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
            }
            if (userLastLoginDeviceRespVoDb.getDeviceType().equals("ANDROID")) {
                pushConfig = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"Android");
                UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
                androidPush.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
                androidPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                androidPush.setUserId(doctorInfoRespVO.getUserId());
                androidPush.setClientCode(pushConfig.getClientCode());
                androidPush.setDeviceTokens(userLastLoginDeviceRespVoDb.getDeviceNumber());
                androidPush.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                androidPush.setDescription("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                androidPush.setTicker(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                mapDb = new HashMap<String, String>();
                mapDb.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
                androidPush.setExtra(mapDb);
                AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
            }
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            youMengPushDataBo.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
            youMengPushDataBo.setTicker("");
            map.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
            map.put("applyAccepts", "2");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                HashMap<String, String> mapDb2;
                PushConfigurationDetailVO pushConfig2;
                DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)expertInfoRespVO.getUserId(), (Short)new Short("1"));
                if (userLastLoginDeviceRespVo.getDeviceType().equals("IOS")) {
                    pushConfig2 = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"IOS");
                    UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
                    iosPush.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
                    iosPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                    iosPush.setUserId(expertInfoRespVO.getUserId());
                    iosPush.setClientCode(pushConfig2.getClientCode());
                    iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
                    iosPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                    iosPush.setDescription("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                    iosPush.setBody("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                    iosPush.setBusiStyle("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                    iosPush.setSubTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                    mapDb2 = new HashMap();
                    mapDb2.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
                    iosPush.setExtra(mapDb2);
                    AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
                }
                if (userLastLoginDeviceRespVo.getDeviceType().equals("ANDROID")) {
                    pushConfig2 = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"Android");
                    UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
                    androidPush.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
                    androidPush.setTitle(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                    androidPush.setUserId(expertInfoRespVO.getUserId());
                    androidPush.setClientCode(pushConfig2.getClientCode());
                    androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
                    androidPush.setText("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                    androidPush.setDescription("\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\u5df2\u9000\u6b3e\uff0c\u539f\u56e0:" + refundReason);
                    androidPush.setTicker(HxgyPushCenterEnum.REFUND_ORDER.getDisplay());
                    mapDb2 = new HashMap<String, String>();
                    mapDb2.put("pushCode", HxgyPushCodeIntegerEnum.REFUND_ORDER.getCode().toString());
                    androidPush.setExtra(mapDb2);
                    AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
                }
                goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.REFUND_ORDER.getValue());
                goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
            }
            log.info("==========\u9000\u6b3e\u8ba2\u5355\u63a8\u9001\u5b8c\u6210==========");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("===========\u9000\u6b3e\u6700\u540e\u7684\u51fa\u53e3==========");
    }

    @Async
    public void secondConsultationSendMessage(ConsultationEntity consultationEntity) {
        log.info("===========\u7b2c\u4e8c\u610f\u89c1-\u4e0b\u5355\u63a8\u9001\u5f00\u59cb=========\u8ba2\u5355id\u662f:" + consultationEntity.getId());
        try {
            List consultationMdtEntityList = this.consultationMdtMapper.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                HashMap<String, String> mapDb;
                PushConfigurationDetailVO pushConfig;
                DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                UserLastLoginDeviceRespVo userLastLoginDeviceRespVo = PushParamUtil.getDocUserDeviceToken((String)expertInfoRespVO.getUserId(), (Short)new Short("1"));
                String doctorAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
                if (userLastLoginDeviceRespVo.getDeviceType().equals("IOS")) {
                    pushConfig = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"IOS");
                    UmPushMsgIOSReqVo iosPush = new UmPushMsgIOSReqVo();
                    iosPush.setBusiCode(HxgyPushCenterEnum.SECOND_NEW_ORDER.getValue());
                    iosPush.setTitle(HxgyPushCenterEnum.SECOND_NEW_ORDER.getDisplay());
                    iosPush.setUserId(expertInfoRespVO.getUserId());
                    iosPush.setClientCode(pushConfig.getClientCode());
                    iosPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
                    iosPush.setTitle(HxgyPushCenterEnum.SECOND_NEW_ORDER.getDisplay());
                    if (OrderTypeEnum.TYPE_VEDIO.getValue().intValue() == consultationEntity.getType().intValue()) {
                        iosPush.setDescription("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        iosPush.setBody("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        iosPush.setBusiStyle("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                    } else {
                        iosPush.setDescription("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u56fe\u6587\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        iosPush.setBody("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u56fe\u6587\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        iosPush.setBusiStyle("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u56fe\u6587\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                    }
                    iosPush.setSubTitle(HxgyPushCenterEnum.SECOND_NEW_ORDER.getDisplay());
                    mapDb = new HashMap();
                    mapDb.put("pushCode", HxgyPushCodeIntegerEnum.SECOND_NEW_ORDER.getCode().toString());
                    mapDb.put("orderViewId", consultationEntity.getViewId());
                    iosPush.setExtra(mapDb);
                    AppWebPushUtil.pushIOSMessage((UmPushMsgIOSReqVo)iosPush);
                }
                if (userLastLoginDeviceRespVo.getDeviceType().equals("ANDROID")) {
                    pushConfig = PushParamUtil.getPushConfig((String)"YYHT", (String)"youmengPush", (String)"doctor", (String)"Android");
                    UmPushMsgAndroidReqVO androidPush = new UmPushMsgAndroidReqVO();
                    androidPush.setBusiCode(HxgyPushCenterEnum.SECOND_NEW_ORDER.getValue());
                    androidPush.setTitle(HxgyPushCenterEnum.SECOND_NEW_ORDER.getDisplay());
                    androidPush.setUserId(expertInfoRespVO.getUserId());
                    androidPush.setClientCode(pushConfig.getClientCode());
                    androidPush.setDeviceTokens(userLastLoginDeviceRespVo.getDeviceNumber());
                    if (OrderTypeEnum.TYPE_VEDIO.getValue().intValue() == consultationEntity.getType().intValue()) {
                        androidPush.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        androidPush.setDescription("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                    } else {
                        androidPush.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u56fe\u6587\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                        androidPush.setDescription("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u56fe\u6587\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                    }
                    androidPush.setTicker(HxgyPushCenterEnum.SECOND_NEW_ORDER.getDisplay());
                    mapDb = new HashMap<String, String>();
                    mapDb.put("pushCode", HxgyPushCodeIntegerEnum.SECOND_NEW_ORDER.getCode().toString());
                    mapDb.put("orderViewId", consultationEntity.getViewId());
                    androidPush.setExtra(mapDb);
                    AppWebPushUtil.pushAndroidMessage((UmPushMsgAndroidReqVO)androidPush);
                }
                HashMap<String, String> map = new HashMap<String, String>();
                YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                youMengPushDataBo.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorHosName() + "\u533b\u9662" + consultationEntity.getDoctorDepName() + "\u79d1\u5ba4" + consultationEntity.getDoctorName() + "\u533b\u751f\u5411\u4f60\u53d1\u8d77\u4e00\u4e2a\u89c6\u9891\u4f1a\u8bae\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
                youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.NEW_ORDER.getValue());
                youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                youMengPushDataBo.setDescription("");
                youMengPushDataBo.setPlayAction("");
                youMengPushDataBo.setType("ychzdeyj");
                youMengPushDataBo.setTitle(HxgyPushCenterEnum.NEW_ORDER.getDisplay());
                youMengPushDataBo.setTicker("");
                youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                map.put("pushCode", HxgyPushCodeIntegerEnum.NEW_ORDER.getCode().toString());
                map.put("applyAccepts", "1");
                this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                youMengPushDataBo.setExtra(map);
                youMengPushDataBo.setCustom(JSON.toJSONString(map));
                GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.NEW_ORDER.getValue());
                goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            }
            log.info("==========\u9000\u6b3e\u8ba2\u5355\u63a8\u9001\u5b8c\u6210==========");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("===========\u9000\u6b3e\u6700\u540e\u7684\u51fa\u53e3==========");
    }

    @Async
    public void consultationReportInspectSendMessage(String orderViewId, String reason) {
        log.info("\u63a8\u9001_\u4f1a\u8bca\u62a5\u544a_\u5ba1\u6838========================");
        try {
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            this.shortMessageManager.expertConsultationReportRefused(consultationEntity.getViewId(), reason);
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u901a\u77e5\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6709\u4e00\u4e2a\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u539f\u56e0:" + reason + "\u3002\u8bf7\u60a8\u53ca\u65f6\u67e5\u770b\u62a5\u544a\u8be6\u60c5");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.REPORT_CHECK_FAILED.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.REPORT_CHECK_FAILED.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.REPORT_CHECK_FAILED.getCode().toString());
            map.put("applyAccepts", "2");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.REPORT_CHECK_FAILED.getValue());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void pushAheadMessage(ConsultationEntity consultationEntity) {
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
        DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u4e13\u5bb6" + consultationEntity.getExpertName() + "\u7684\u89c6\u9891\u4f1a\u8bca\u5c06\u4e8e1\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u51c6\u65f6\u53c2\u52a0\u4f1a\u8bae\uff0c\u5e76\u4fdd\u8bc1\u7f51\u7edc\u72b6\u51b5\u826f\u597d\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.VIDEO_ORDER_REMIND.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getValue());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId() != 0L) {
                YouMengPushDataBo youMengPushDataBo1 = new YouMengPushDataBo();
                youMengPushDataBo1.setText("\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u4e13\u5bb6" + consultationEntity.getExpertName() + "\u7684\u89c6\u9891\u4f1a\u8bca\u5c06\u4e8e1\u5c0f\u65f6\u540e\u5f00\u59cb\uff0c\u8bf7\u51c6\u65f6\u53c2\u52a0\u4f1a\u8bae\uff0c\u5e76\u4fdd\u8bc1\u7f51\u7edc\u72b6\u51b5\u826f\u597d\u3002");
                youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getValue());
                youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                youMengPushDataBo1.setDescription("");
                youMengPushDataBo1.setPlayAction("");
                youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getDisplay());
                youMengPushDataBo1.setTicker("");
                youMengPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                map.put("pushCode", HxgyPushCodeIntegerEnum.VIDEO_ORDER_REMIND.getCode().toString());
                map.put("applyAccepts", "2");
                this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                youMengPushDataBo1.setExtra(map);
                youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo1);
                GoEasyPushDataBo goEasyPushDataBo1 = new GoEasyPushDataBo();
                goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_REMIND.getValue());
                goEasyPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo1);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindExpertWriteReportNews(String orderViewId) {
        log.info("\u63a8\u9001_\u4f1a\u8bca\u62a5\u544a_\u63d0\u9192\u4e13\u5bb6\u586b\u5199\u4f1a\u8bca\u62a5\u544a========================");
        try {
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            this.shortMessageManager.expertConsultationReportNews(consultationEntity.getViewId());
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorName() + "\u533b\u751f\u7684\u4f1a\u8bca\u5df2\u5b8c\u6210,\u8bf7\u53ca\u65f6\u586b\u5199\u5e76\u63d0\u4ea4\u4f1a\u8bca\u62a5\u544a\u3002");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription("");
            youMengPushDataBo.setPlayAction("");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getDisplay());
            youMengPushDataBo.setTicker("");
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.REMIND_EXPERTS_REPORT.getCode().toString());
            map.put("applyAccepts", "2");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getValue());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void verifyYoumengDoctorBillInfo(DoctorInfoRespVO doctorInfoRespVO, DoctorBillInfoEntity billInfoEntity, Long doctorHospitalId) {
        try {
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setBusiCode("yc_doctor_bill");
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            youMengPushDataBo.setTicker("\u4f70\u533b\u6c47");
            youMengPushDataBo.setTitle("\u4f70\u533b\u6c47");
            youMengPushDataBo.setText("\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u5165\u8d26\uff0c\u5171\u8ba1\uffe5" + billInfoEntity.getActualMoney() + "\uff0c\u70b9\u51fb\u8d26\u6237\u7ba1\u7406\u67e5\u770b\u5165\u8d26\u8be6\u60c5\u3002");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", youMengPushDataBo.getText());
            map.put("applyAccepts", "1");
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(doctorHospitalId);
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void verifyGoeasyDoctorBillInfo(DoctorInfoRespVO doctorInfoRespVO, DoctorBillInfoEntity billInfoEntity, Long doctorHospitalId) {
        try {
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBusiCode("yc_doctor_bill");
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            goEasyPushDataBo.setBody("\u60a8\u6709\u4e00\u7b14\u65b0\u7684\u5165\u8d26\uff0c\u5171\u8ba1\uffe5" + billInfoEntity.getActualMoney() + "\uff0c\u70b9\u51fb\u8d26\u6237\u7ba1\u7406\u67e5\u770b\u5165\u8d26\u8be6\u60c5\u3002");
            String doctorAppCode = this.getAppCode(doctorHospitalId);
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void pushToDoctorWhenJoinRoom(ConsultationEntity consultationEntity, String doctorId) {
        YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
        youMengPushDataBo.setText("\u533b\u751f" + consultationEntity.getDoctorName() + "\u5df2\u7ecf\u8fdb\u5165\u4e86\u89c6\u9891\uff0c\u9080\u8bf7\u60a8\u4e5f\u4e00\u8d77\u52a0\u5165\u89c6\u9891\u4f1a\u8bca");
        youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.INVITE_JOIN_ROOM.getValue());
        youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
        youMengPushDataBo.setDescription("");
        youMengPushDataBo.setPlayAction("");
        youMengPushDataBo.setTitle(HxgyPushCenterEnum.INVITE_JOIN_ROOM.getDisplay());
        youMengPushDataBo.setTicker("");
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(Long.valueOf(Long.parseLong(doctorId)));
        youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pushCode", HxgyPushCodeIntegerEnum.INVITE_JOIN_ROOM.getCode().toString());
        map.put("applyAccepts", "1");
        this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
        youMengPushDataBo.setExtra(map);
        youMengPushDataBo.setCustom(JSON.toJSONString(map));
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(Long.valueOf(Long.parseLong(doctorId)));
        String doctorAppCode = this.getAppCode(Long.valueOf(Long.parseLong(doctorEntityInfoVO.getOrganId().toString())));
        this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
    }

    @Async
    public void applyOrderToNodeAdminUser(ConsultationEntity consultationEntity) {
        if (OrderStatusEnum.WAIT_DISTRIBUTION.getValue().equals(consultationEntity.getStatus()) && !consultationEntity.getExpertHospitalId().equals(0L)) {
            try {
                String expertAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                String expertUrl = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(expertAppCode).append("/").append("permissions/user/role/findalladminuserid").toString();
                log.info("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{expertAppCode}", (Object)expertUrl, (Object)expertAppCode);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("appCode", expertAppCode);
                String resExpertData = HttpUtils.get((String)expertUrl, data);
                log.info("------------------------------\u6743\u9650\u7ba1\u7406\u83b7\u53d6\u7684\u7ba1\u7406\u5458ID-------------------:{}", (Object)resExpertData);
                this.pushMsgToAdmin(resExpertData, consultationEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PushInfoException(e.getMessage());
            }
        }
    }

    private void pushMsgToAdmin(String resData, ConsultationEntity consultationEntity) {
        List strings;
        if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSON.parseObject((String)resData).getString("code")) && StringUtil.isNotBlank((String)JSON.parseObject((String)resData).getString("data")) && CollectionUtils.isNotEmpty((Collection)(strings = JSONArray.parseArray((String)JSON.parseObject((String)resData).getString("data"), String.class)))) {
            for (String userId : strings) {
                YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                youMengPushDataBo.setText("\u7cfb\u7edf\u65b0\u589e\u4e86\u5f85\u5206\u914d\u8ba2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
                youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getValue());
                youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                youMengPushDataBo.setTitle(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getDisplay());
                youMengPushDataBo.setTicker("");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("content", youMengPushDataBo.getText());
                this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                youMengPushDataBo.setExtra(map);
                GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                goEasyPushDataBo.setUserId(userId);
                goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getValue());
                goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                this.pushInfoManagerUtils.goEasyPushData(consultationEntity.getAccompanyAppCode(), goEasyPushDataBo);
            }
        }
    }
}

