/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdt;

import com.alibaba.fastjson.JSONObject;
import com.byh.controller.BaseController;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.PatientSignerRelationshipEnum;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.mdt.vo.ExportApplyVo;
import com.byh.pojo.mdt.vo.ExportConsultationReportVo;
import com.byh.pojo.mdt.vo.ExportInformedConsentVo;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.DateTimeUtil;
import com.byh.util.RandomUtil;
import com.byh.util.StringUtil;
import com.byh.util.WordUtils;
import com.byh.util.ZipUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdtExportWordManage
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtExportWordManage.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;
    public static final String FILE_NAME = "FILE_NAME";

    public void moreApplicationForm(ExportApplyVo exportApplyVo, HttpServletResponse response) {
        List orderViewIdList = exportApplyVo.getOrderViewIdList();
        if (CollectionUtils.isNotEmpty((Collection)orderViewIdList)) {
            File zipFile;
            String wordPath = "/tmp/world/";
            log.info("\u6587\u4ef6\u5939\u7684\u540d\u79f0\u662f:{}", (Object)wordPath);
            String zipPath = "/tmp/zip/";
            log.info("\u538b\u7f29\u5305\u7684\u540d\u79f0\u662f:{}", (Object)zipPath);
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (String orderViewId : orderViewIdList) {
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
                if (CollectionUtils.isEmpty((Collection)consultationMdtEntityList)) {
                    Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, null);
                    try {
                        WordUtils.exportWordToPath((Map)dataMap, (String)"importConsultationApplyWord.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, consultationMdtEntity);
                    try {
                        WordUtils.exportWordToPath((Map)dataMap, (String)"importConsultationApplyWord.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moreInformedConsent(ExportInformedConsentVo exportInformedConsentVo, HttpServletResponse response) {
        List orderViewIdList = exportInformedConsentVo.getOrderViewIdList();
        if (CollectionUtils.isNotEmpty((Collection)orderViewIdList)) {
            File zipFile;
            String wordPath = "/tmp/world/";
            String zipPath = "/tmp/zip";
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (String orderViewId : orderViewIdList) {
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
                if (CollectionUtils.isEmpty((Collection)consultationMdtEntityList)) {
                    Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, null);
                    try {
                        if ("SDFYY".equals(consultationEntity.getAccompanyAppCode())) {
                            WordUtils.exportWordToPath((Map)dataMap, (String)"agreeWord2.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                            continue;
                        }
                        WordUtils.exportWordToPath((Map)dataMap, (String)"agreeWord.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, consultationMdtEntity);
                    try {
                        if ("SDFYY".equals(consultationEntity.getAccompanyAppCode())) {
                            WordUtils.exportWordToPath((Map)dataMap, (String)"agreeWord2.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                            continue;
                        }
                        WordUtils.exportWordToPath((Map)dataMap, (String)"agreeWord.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                    }
                    catch (IOException e) {
                        log.error("=======\u5bfc\u51fa\u77e5\u60c5\u540c\u610f\u4e66\u6587\u4ef6\u9519\u8bef=======");
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            try {
                ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
            }
            catch (Exception e) {
                log.error("=======\u5bfc\u51fa\u77e5\u60c5\u540c\u610f\u4e66\u538b\u7f29\u5305\u9519\u8bef=======");
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    log.error("moreInformedConsent", (Throwable)e);
                }
                try {
                    FileUtils.deleteDirectory((File)zipFile);
                }
                catch (IOException e) {
                    log.error("moreInformedConsent", (Throwable)e);
                }
            }
        }
    }

    public void moreConsultationReport(ExportConsultationReportVo exportConsultationReportVo, HttpServletResponse response) {
        List orderViewIdList = exportConsultationReportVo.getOrderViewIdList();
        if (CollectionUtils.isNotEmpty((Collection)orderViewIdList)) {
            File zipFile;
            String wordPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u6587\u4ef6\u5939\u7684\u540d\u79f0\u662f:{}", (Object)wordPath);
            String zipPath = "/tmp/" + System.currentTimeMillis();
            log.info("\u4f1a\u8bca\u62a5\u544a\u538b\u7f29\u5305\u7684\u540d\u79f0\u662f:{}", (Object)zipPath);
            File file = new File(wordPath);
            if (!file.exists()) {
                file.mkdir();
            }
            if (!(zipFile = new File(zipPath)).exists()) {
                zipFile.mkdir();
            }
            for (String orderViewId : orderViewIdList) {
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    if (consultationMdtEntity.getStatus().intValue() != OrderStatusEnum.MDT_UP_REPORT.getValue().intValue()) continue;
                    ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryByMdtViewId(consultationMdtEntity.getViewId());
                    if (consultationReportEntity != null && StringUtil.isNotEmpty((String)consultationReportEntity.getPhotoReport())) {
                        if (consultationReportEntity.getPhotoReport().contains(",")) {
                            List strings = Arrays.asList(consultationReportEntity.getPhotoReport().split(",")).stream().collect(Collectors.toList());
                            for (String s : strings) {
                                com.byh.util.FileUtils.writeImgeUrlToDir((String)s, (String)(consultationEntity.getViewId() + "_" + RandomUtil.getRandom() + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".") + 1), (String)wordPath);
                            }
                            continue;
                        }
                        com.byh.util.FileUtils.writeImgeUrlToDir((String)consultationReportEntity.getPhotoReport(), (String)(consultationEntity.getViewId() + "_" + consultationEntity.getPatientName()), (String)consultationReportEntity.getPhotoReport().substring(consultationReportEntity.getPhotoReport().lastIndexOf(".") + 1), (String)wordPath);
                        continue;
                    }
                    Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, consultationMdtEntity);
                    try {
                        WordUtils.exportWordToPath((Map)dataMap, (String)"report.ftl", (String)wordPath, (String)(RandomUtil.getRandom() + (String)dataMap.get(FILE_NAME)));
                    }
                    catch (IOException e) {
                        log.error("=======\u5bfc\u51fa\u4f1a\u8bca\u62a5\u544a\u6587\u4ef6\u9519\u8bef=======", (Throwable)e);
                    }
                }
            }
            ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateTimeUtil.formatTime((Date)new Date(), (String)"yyyyMMddHHmmss"), (HttpServletResponse)response);
        }
    }

    private Map<String, String> exportWorldData(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity, ConsultationMdtEntity consultationMdtEntity) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (consultationEntity != null && consultationExtendEntity != null) {
            String mainSuit = "";
            String pastHistory = "";
            String presentHistory = "";
            String familyHistory = "";
            String medicationHistory = "";
            String primaryDiagno = "";
            String consultAim = "";
            String advice = "";
            String medicalDetail = "";
            if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
                log.info("=======\u4e0b\u8f7d\u6570\u636e\u52a8\u6001\u75c5\u4f8b======");
                PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
                patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
                BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
                if (response.getCode().equals("1") && response.getData() != null) {
                    medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
                    log.info("=======\u4e0b\u8f7d\u6570\u636e\u52a8\u6001\u75c5\u4f8b\u8fd4\u56demedicalDetail\uff1a{}", (Object)medicalDetail);
                }
                JSONObject json = JSONObject.parseObject((String)medicalDetail);
                Set sets = json.keySet();
                for (String str : sets) {
                    if ("mainSuit".equalsIgnoreCase(str)) {
                        mainSuit = json.get((Object)str).toString();
                    }
                    if ("pastHistory".equalsIgnoreCase(str)) {
                        pastHistory = json.get((Object)str).toString();
                    }
                    if ("presentHistory".equalsIgnoreCase(str)) {
                        presentHistory = json.get((Object)str).toString();
                    }
                    if ("familyHistory".equalsIgnoreCase(str)) {
                        familyHistory = json.get((Object)str).toString();
                    }
                    if ("medicationHistory".equalsIgnoreCase(str)) {
                        medicationHistory = json.get((Object)str).toString();
                    }
                    if ("primaryDiagno".equalsIgnoreCase(str)) {
                        primaryDiagno = json.get((Object)str).toString();
                    }
                    if ("consultAim".equalsIgnoreCase(str)) {
                        consultAim = json.get((Object)str).toString();
                    }
                    if (!"advice".equalsIgnoreCase(str)) continue;
                    advice = json.get((Object)str).toString();
                }
                dataMap.put("mainsuit", mainSuit);
                dataMap.put("past_history", pastHistory);
                dataMap.put("present_history", presentHistory);
                dataMap.put("family_history", familyHistory);
                dataMap.put("medication_history", medicationHistory);
                dataMap.put("primary_diagno", primaryDiagno);
                dataMap.put("consult_aim", consultAim);
                dataMap.put("advice", advice);
            } else {
                PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
                mainSuit = StringUtil.isBlank((String)patientCaseInfoEntity.getMainSuit()) ? "" : patientCaseInfoEntity.getMainSuit().replace(">", "&gt;").replace("<", "&lt;");
                dataMap.put("mainsuit", mainSuit);
                dataMap.put("past_history", StringUtil.isBlank((String)patientCaseInfoEntity.getPastHistory()) ? "" : patientCaseInfoEntity.getPastHistory());
                dataMap.put("present_history", StringUtil.isBlank((String)patientCaseInfoEntity.getPresentHistory()) ? "" : patientCaseInfoEntity.getPresentHistory());
                dataMap.put("family_history", StringUtil.isNotBlank((String)patientCaseInfoEntity.getFamilyHistory()) ? "" : patientCaseInfoEntity.getFamilyHistory());
                dataMap.put("medication_history", StringUtil.isBlank((String)patientCaseInfoEntity.getMedicationHistory()) ? "" : patientCaseInfoEntity.getMedicationHistory());
                dataMap.put("primary_diagno", StringUtil.isBlank((String)patientCaseInfoEntity.getPrimaryDiagno()) ? "" : patientCaseInfoEntity.getPrimaryDiagno());
                dataMap.put("consult_aim", patientCaseInfoEntity.getConsultAim());
                dataMap.put("advice", StringUtil.isBlank((String)patientCaseInfoEntity.getTreatAdvice()) ? "" : patientCaseInfoEntity.getTreatAdvice());
            }
            ConsultationReportEntity consultationReportEntity = null;
            if (consultationMdtEntity != null) {
                consultationReportEntity = this.consultationReportService.queryByMdtViewId(consultationMdtEntity.getViewId());
            }
            dataMap.put("order_view_id", consultationEntity.getViewId());
            dataMap.put("type", OrderTypeEnum.TYPE_VEDIO.getValue().equals(consultationEntity.getType()) ? "\u89c6\u9891\u4f1a\u8bca" : "\u56fe\u6587\u4f1a\u8bca");
            dataMap.put("date", DateTimeUtil.formatTime((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd"));
            dataMap.put("name", consultationEntity.getPatientName());
            dataMap.put("sex", consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973");
            dataMap.put("age", String.valueOf(consultationExtendEntity.getPatientAge()));
            dataMap.put("mobile_number", consultationExtendEntity.getPatientPhone());
            dataMap.put("id_card", consultationExtendEntity.getPatientIdCard());
            dataMap.put("from_hospital", consultationEntity.getDoctorHosName());
            dataMap.put("from_dept", consultationEntity.getDoctorDepName());
            dataMap.put("from_doctor", consultationEntity.getDoctorName());
            dataMap.put("begin_time", consultationEntity.getBeginTime() == null ? "" : consultationEntity.getBeginTime());
            dataMap.put("finish_time", consultationEntity.getFinishTime() == null ? "" : consultationEntity.getFinishTime());
            if (consultationReportEntity != null) {
                dataMap.put("data", DateTimeUtil.formatTime((Date)consultationReportEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                dataMap.put("opinion", consultationReportEntity.getTreatPlan());
                dataMap.put("expert_sign", WordUtils.getImgUrlToBase64((String)consultationReportEntity.getSignature()));
            } else {
                dataMap.put("data", "");
                dataMap.put("opinion", "");
                dataMap.put("expert_sign", "");
            }
            if (consultationEntity.getPatientSignerRelationship().intValue() == PatientSignerRelationshipEnum.ONESELF.getValue().intValue()) {
                dataMap.put("relation_ship", "\u672c\u4eba");
            } else if (consultationEntity.getPatientSignerRelationship().intValue() == PatientSignerRelationshipEnum.SPOUSE.getValue().intValue()) {
                dataMap.put("relation_ship", "\u592b\u59bb");
            } else if (consultationEntity.getPatientSignerRelationship().intValue() == PatientSignerRelationshipEnum.PARENT.getValue().intValue()) {
                dataMap.put("relation_ship", "\u7236\u6bcd");
            } else if (consultationEntity.getPatientSignerRelationship().intValue() == PatientSignerRelationshipEnum.CHILDREN.getValue().intValue()) {
                dataMap.put("relation_ship", "\u5b50\u5973");
            } else {
                dataMap.put("relation_ship", "\u5176\u4ed6");
            }
            dataMap.put("to_hospital", consultationMdtEntity == null ? "" : consultationMdtEntity.getExpertHospitalName());
            dataMap.put("f_hosp", consultationMdtEntity == null ? "" : consultationMdtEntity.getExpertHospitalName());
            dataMap.put("to_dept", consultationMdtEntity == null ? "" : consultationMdtEntity.getExpertDepName());
            dataMap.put("to_doctor", consultationMdtEntity == null ? "" : consultationMdtEntity.getExpertName());
            dataMap.put("headHospitalName", consultationMdtEntity == null ? "" : consultationMdtEntity.getExpertHospitalName());
            dataMap.put("head", "head");
            log.info("consultationEntity.getPatientSignature():{}", (Object)consultationEntity.getPatientSignature());
            if (StringUtil.isEmpty((String)consultationEntity.getPatientSignature())) {
                dataMap.put("sign", "");
            } else {
                dataMap.put("sign", WordUtils.getImgUrlToBase64((String)consultationEntity.getPatientSignature()));
            }
            dataMap.put(FILE_NAME, consultationEntity.getViewId() + "_" + consultationEntity.getPatientName());
        }
        return dataMap;
    }

    public String exportAgreeWord(String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        Map dataMap = this.exportWorldData(consultationEntity, consultationExtendEntity, null);
        String ossUdl = "";
        try {
            ossUdl = "SDFYY".equals(consultationEntity.getAccompanyAppCode()) ? WordUtils.exportMillCertificateReportWord((Map)dataMap, (String)"agreeWord2.ftl", (String)((String)dataMap.get(FILE_NAME))) : WordUtils.exportMillCertificateReportWord((Map)dataMap, (String)"agreeWord.ftl", (String)((String)dataMap.get(FILE_NAME)));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ossUdl;
    }
}

