/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdt;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.common.ResultInfo;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.dao.consultation.ServicePayBillMapper;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.PayStateEnum;
import com.byh.enums.PayTypeEnum;
import com.byh.feign.DoctorBaseApiClient;
import com.byh.feign.IOssApiClient;
import com.byh.feign.OrganServiceApiClient;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.TRTCManage;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.manage.mdt.MdtWebAndAppMessageManager;
import com.byh.pojo.bo.PatientCaseInfoDTO;
import com.byh.pojo.bo.consultation.DynamicMedicalRecordsDto;
import com.byh.pojo.bo.consultation.NormalImagesDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.byh.pojo.entity.consultation.ServicePayBillEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.mdt.dto.DoctorInfoDto;
import com.byh.pojo.mdt.dto.OrderDetailMdtDto;
import com.byh.pojo.mdt.dto.OrderInfoDto;
import com.byh.pojo.mdt.dto.OrderVideoingDto;
import com.byh.pojo.mdt.dto.PatientCaseDTO;
import com.byh.pojo.mdt.dto.PatientInfoDto;
import com.byh.pojo.mdt.dto.ReportDetailDto;
import com.byh.pojo.mdt.dto.ReportInfoDto;
import com.byh.pojo.mdt.vo.ApplicationPatientInfoParamVo;
import com.byh.pojo.mdt.vo.HealthDoctorParamVo;
import com.byh.pojo.mdt.vo.ImSdkAccountVo;
import com.byh.pojo.mdt.vo.MdtExpertInfoVo;
import com.byh.pojo.mdt.vo.OrderImproveMdtVo;
import com.byh.pojo.mdt.vo.OrderMdtVo;
import com.byh.pojo.mdt.vo.OrderParamVo;
import com.byh.pojo.mdt.vo.OrderPatientMdtVo;
import com.byh.pojo.mdt.vo.OrderPriceVo;
import com.byh.pojo.mdt.vo.OrderVideoingVo;
import com.byh.pojo.mdt.vo.PatientSignatureVo;
import com.byh.pojo.mdt.vo.ReportCreatVo;
import com.byh.pojo.mdt.vo.ReportDraftVo;
import com.byh.pojo.mdt.vo.ReportUpdateVo;
import com.byh.pojo.mdt.vo.SignatureParamVo;
import com.byh.pojo.mdt.vo.UpdateAppointmentTimeVo;
import com.byh.pojo.mdt.vo.UpdatePatientCaseVo;
import com.byh.pojo.mdt.vo.VideoOngoingVo;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.mdtconsultation.OrderAssignMdtVo;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.CommonUtils;
import com.byh.util.DateUtils;
import com.byh.util.HttpUtils;
import com.byh.util.MdtUtil;
import com.byh.util.StringUtil;
import com.byh.util.UniqueKeyGenerator;
import com.doctor.basedata.api.vo.GetBusinessDoctorListVo;
import com.doctor.basedata.api.vo.OrganServiceIterationVo;
import com.doctor.basedata.api.vo.RetBusinessDoctorListVo;
import com.doctoruser.api.pojo.dto.doctor.QueryPiontServiceDTO;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.PointDoctorServiceInfoVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientGetMedicalTemplateReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientMedicalTemplateResVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.SavePatientDynamicMedicalReqVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdtManage
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtManage.class);
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private HealthAllianceMemberService healthAllianceMemberService;
    @Autowired
    private DoctorBaseApiClient doctorBaseApi;
    @Autowired
    private OrganServiceApiClient organServiceApi;
    @Autowired
    private IOssApiClient iOssApiClient;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ProgramMessageManager programMessageManager;
    @Autowired
    private MdtWebAndAppMessageManager mdtWebAndAppMessageManager;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    private static final String DATE_IS_NULL = "\u6682\u65e0";

    @Transactional
    public ResultInfo<String> saveOrder(OrderMdtVo orderMdtVo) {
        log.info("\u591a\u5b66\u79d1\u4e0b\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)orderMdtVo.toString());
        SavePatientDynamicMedicalReqVo savePatientDynamicMedicalReqVo = new SavePatientDynamicMedicalReqVo();
        savePatientDynamicMedicalReqVo.setMedicalUserFills(orderMdtVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setMedicalDetail(orderMdtVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setPatientId(orderMdtVo.getPatientId().toString());
        savePatientDynamicMedicalReqVo.setServType(Integer.valueOf(6));
        savePatientDynamicMedicalReqVo.setAppCode("0");
        savePatientDynamicMedicalReqVo.setHospitalId("0");
        savePatientDynamicMedicalReqVo.setTags("");
        savePatientDynamicMedicalReqVo.setDescription("");
        String dynamicId = this.addDynamicMedical(savePatientDynamicMedicalReqVo);
        OrderParamVo orderParamVo = new OrderParamVo();
        BeanUtil.copyProperties((Object)orderMdtVo, (Object)orderParamVo, (String[])new String[0]);
        ConsultationEntity consultationEntity = this.addConsultation(orderParamVo, dynamicId);
        if (consultationEntity.getCreateTime() == null) {
            consultationEntity.setCreateTime(new Date());
        }
        ConsultationExtendEntity consultationExtendEntity = this.addConsultationExtendEntity(orderParamVo, consultationEntity);
        if (!orderMdtVo.getApplicationChannels().equals(ConsultationConstant.TYPE_APPLICATION_MDT_DISTRIBUTION) && CollectionUtils.isNotEmpty((Collection)orderMdtVo.getList())) {
            this.addMdt(orderMdtVo.getList(), consultationEntity);
            OrderPriceVo orderPriceVo = new OrderPriceVo();
            orderPriceVo.setConsultationExtendEntity(consultationExtendEntity);
            orderPriceVo.setConsultationEntity(consultationEntity);
            orderPriceVo.setOrderId(consultationEntity.getId());
            orderPriceVo.setOrderViewId(consultationEntity.getViewId());
            orderPriceVo.setList(orderMdtVo.getList());
            orderPriceVo.setTotalPrice(orderMdtVo.getTotalPrice());
            orderPriceVo.setType(orderMdtVo.getType());
            orderPriceVo.setDoctorId(orderMdtVo.getDoctorId());
            orderPriceVo.setDoctorHospitalId(orderMdtVo.getDoctorHostId());
            orderPriceVo.setList(orderMdtVo.getList());
            this.orderPrice(orderPriceVo);
        }
        try {
            if (!orderMdtVo.getApplicationChannels().equals(ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID)) {
                this.shortMessageManager.remindUserSignName(consultationEntity, consultationExtendEntity.getPatientPhone());
                this.shortMessageManager.doctorHaveSubmitApply(consultationEntity);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
    }

    public String addDynamicMedical(SavePatientDynamicMedicalReqVo savePatientDynamicMedicalReqVo) {
        String dynamicMedicalRecordsId = "";
        dynamicMedicalRecordsId = (String)this.patientDynamicMedicalClient.insertMedical(savePatientDynamicMedicalReqVo).getData();
        if (StringUtil.isNotBlank((String)dynamicMedicalRecordsId)) {
            return dynamicMedicalRecordsId;
        }
        return dynamicMedicalRecordsId;
    }

    public ConsultationEntity addConsultation(OrderParamVo orderParamVo, String dynamicId) {
        log.info("4\u8868\u53c2\u6570orderParamVo:{}\uff0cdynamicId\uff1a{}", (Object)orderParamVo, (Object)dynamicId);
        if (null == orderParamVo.getCaseId() || orderParamVo.getCaseId().intValue() == 0) {
            PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
            patientCaseInfoVO.setMainSuit(orderParamVo.getMainSuit() != null ? orderParamVo.getMainSuit() : "");
            log.info("patientCaseInfoVO\uff1a{}", (Object)patientCaseInfoVO);
            PatientCaseInfoVO patientCaseInfo = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
            orderParamVo.setCaseId(patientCaseInfo.getId());
        }
        ConsultationEntity consultationEntity = new ConsultationEntity();
        consultationEntity.setViewId(UniqueKeyGenerator.generateViewId().toString());
        consultationEntity.setApplicationChannels(orderParamVo.getApplicationChannels());
        consultationEntity.setType(orderParamVo.getType());
        consultationEntity.setDynamicId(dynamicId);
        consultationEntity.setDistributionDescribe(orderParamVo.getDistributionDescribe());
        consultationEntity.setTencentRong(Integer.valueOf(2));
        if (StringUtil.isNotEmpty((String)orderParamVo.getAppointedTime())) {
            String[] split = orderParamVo.getAppointedTime().split(" ");
            consultationEntity.setConsultationDate(split[0]);
            consultationEntity.setConsultationTime(split[1]);
        }
        consultationEntity.setPatientSignerRelationship(orderParamVo.getPatientSignerRelationship());
        consultationEntity.setPatientSignature(orderParamVo.getPatientSignature());
        consultationEntity.setPatientInformedConsentUrl(orderParamVo.getPatientInformedConsentUrl());
        consultationEntity.setCaseId(orderParamVo.getCaseId());
        if ("1".equals(orderParamVo.getInitiatorType().toString())) {
            consultationEntity.setStatus(OrderStatusEnum.NEW_APPLY.getValue());
        } else if ("2".equals(orderParamVo.getInitiatorType().toString()) && orderParamVo.getApplicationChannels().equals(ConsultationConstant.TYPE_APPLICATION_MDT_DISTRIBUTION)) {
            consultationEntity.setStatus(OrderStatusEnum.WAIT_DISTRIBUTION.getValue());
        } else {
            consultationEntity.setStatus(OrderStatusEnum.WAIT_PATIENT_SIGN.getValue());
        }
        consultationEntity.setPatientId(orderParamVo.getPatientId());
        consultationEntity.setPatientName(orderParamVo.getPatientName());
        consultationEntity.setDoctorId(orderParamVo.getDoctorId());
        consultationEntity.setDoctorName(orderParamVo.getDoctorName());
        consultationEntity.setDoctorDepId(orderParamVo.getDoctorDeptId());
        consultationEntity.setDoctorDepName(orderParamVo.getDoctorDeptName());
        consultationEntity.setDoctorHospitalId(orderParamVo.getDoctorHostId());
        consultationEntity.setDoctorHosName(orderParamVo.getDoctorHostName());
        String accompanyAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(orderParamVo.getDoctorHostId().intValue()));
        consultationEntity.setAccompanyAppCode(accompanyAppCode);
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(orderParamVo.getDoctorId());
        consultationEntity.setDoctorSecondDeptId(Long.valueOf(doctorEntityInfoVO.getStdSecondDeptId().longValue()));
        consultationEntity.setDoctorSecondDeptName(doctorEntityInfoVO.getStdSecondDeptName());
        Integer serviceId = 0;
        if (orderParamVo.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_MDT_UNION.intValue() || orderParamVo.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
            Integer n = serviceId = orderParamVo.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue();
        }
        if (orderParamVo.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_MDT_EXPERT.intValue()) {
            serviceId = orderParamVo.getType().intValue() == ConsultationConstant.TYPE_ORDER_VIDEO.intValue() ? DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue();
        }
        consultationEntity.setServiceCode(serviceId);
        ConsultationEntity consultation = this.consultationService.saveConsultation(consultationEntity);
        return consultation;
    }

    public ConsultationExtendEntity addConsultationExtendEntity(OrderParamVo orderParamVo, ConsultationEntity consultation) {
        log.info("\u539f\u526f\u8868\u53c2\u6570orderParamVo:{}\uff0cconsultation\uff1a{}", (Object)orderParamVo, (Object)consultation);
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(orderParamVo.getDoctorId());
        ConsultationExtendEntity consultationExtendEntity = new ConsultationExtendEntity();
        consultationExtendEntity.setPatientSex(orderParamVo.getPatientSex());
        consultationExtendEntity.setPatientIdCard(orderParamVo.getPatientIdCard());
        consultationExtendEntity.setPatientPhone(orderParamVo.getPatientMobileNumber());
        consultationExtendEntity.setPatientAge(Integer.valueOf(orderParamVo.getPatientAge()));
        consultationExtendEntity.setPatientNo(orderParamVo.getPatientNo());
        BigDecimal accompanyFee = BigDecimal.ZERO;
        if (consultation.getType() != null && consultation.getType() != 0) {
            Integer surgeryType = OrderTypeEnum.getByValue((Integer)consultation.getType()).getValue().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? DoctorServiceEnum.CONSULTATION_VEDIO_SURGERY.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_SURGERY.getValue();
            ArrayList<QueryPiontServiceDTO> doctorQueryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
            QueryPiontServiceDTO doctorPiontService = new QueryPiontServiceDTO();
            doctorPiontService.setDoctorId(Integer.valueOf(consultation.getDoctorId().intValue()));
            doctorPiontService.setServiceCode(surgeryType.toString());
            doctorQueryPiontServiceDTOS.add(doctorPiontService);
            List doctorInfoVOS = this.remoteManage.queryDoctorServiceInfo(doctorQueryPiontServiceDTOS);
            accompanyFee = doctorInfoVOS.isEmpty() || doctorInfoVOS.get(0) == null ? new BigDecimal(0) : ((PointDoctorServiceInfoVO)doctorInfoVOS.get(0)).getPrice();
            consultationExtendEntity.setAccompanyFee(accompanyFee);
        }
        consultationExtendEntity.setServiceFee(BigDecimal.ZERO);
        consultationExtendEntity.setDoctorFirstDeptId(Long.valueOf(doctorEntityInfoVO.getStdFirstDeptId() == null ? 0L : doctorEntityInfoVO.getStdFirstDeptId().longValue()));
        consultationExtendEntity.setDoctorFirstDeptName(doctorEntityInfoVO.getStdFirstDeptName());
        consultationExtendEntity.setDoctorDistCode(Long.valueOf(StringUtil.isNotEmpty((String)doctorEntityInfoVO.getAreaCode()) ? Long.parseLong(doctorEntityInfoVO.getAreaCode()) : 0L));
        consultationExtendEntity.setDoctorPhone(doctorEntityInfoVO.getRegisterMobile());
        consultationExtendEntity.setPrice(orderParamVo.getTotalPrice().add(accompanyFee));
        consultationExtendEntity.setConsultationId(consultation.getId());
        consultationExtendEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
        consultationExtendEntity.setQualified(BaseStatusEnum.STATUS_INVALID.getValue());
        consultationExtendEntity.setInitiatorType(orderParamVo.getInitiatorType());
        consultationExtendEntity.setPayType(PayTypeEnum.NORMAL_SETTLE.getValue());
        consultationExtendEntity.setPayState(PayStateEnum.NO_PAY_STATE.getValue());
        ConsultationExtendEntity extendEntity = this.consultationExtendService.insert(consultationExtendEntity);
        return extendEntity;
    }

    public void addMdt(List<MdtExpertInfoVo> expertInfoVolist, ConsultationEntity consultationEntity) {
        log.info("\u591a\u5b66\u79d1\u526f\u8868\u53c2\u6570expertInfoVolist:{}consultationEntity\uff1a{}", expertInfoVolist, (Object)consultationEntity);
        ArrayList<ConsultationMdtEntity> list = new ArrayList<ConsultationMdtEntity>();
        for (MdtExpertInfoVo expertInfoVo : expertInfoVolist) {
            ConsultationMdtEntity consultationMdtEntity = new ConsultationMdtEntity();
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_NOT_ACCEPTS.getValue());
            consultationMdtEntity.setViewId(UniqueKeyGenerator.generateViewId().toString());
            consultationMdtEntity.setOrderViewId(consultationEntity.getViewId());
            consultationMdtEntity.setExpertId(expertInfoVo.getExpertId());
            consultationMdtEntity.setExpertName(expertInfoVo.getExpertName());
            consultationMdtEntity.setExpertDepId(expertInfoVo.getExpertDeptId());
            consultationMdtEntity.setExpertDepName(expertInfoVo.getExpertDeptName());
            consultationMdtEntity.setExpertHospitalId(expertInfoVo.getExpertHosId());
            consultationMdtEntity.setExpertHospitalName(expertInfoVo.getExpertHosName());
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(expertInfoVo.getExpertHosId().intValue()));
            consultationMdtEntity.setClinicalAppcode(expertAppCode);
            DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(expertInfoVo.getExpertId());
            consultationMdtEntity.setExpertType(expertDetailInfoEntity.getDoctorType());
            consultationMdtEntity.setExpertSecondDeptId(Long.valueOf(expertDetailInfoEntity.getStdSecondDeptId().longValue()));
            consultationMdtEntity.setExpertSecondDeptName(expertDetailInfoEntity.getStdSecondDeptName());
            consultationMdtEntity.setExpertFirstDeptid(Long.valueOf(expertDetailInfoEntity.getStdFirstDeptId() == null ? 0L : expertDetailInfoEntity.getStdFirstDeptId().longValue()));
            consultationMdtEntity.setExpertFirstDeptname(expertDetailInfoEntity.getStdFirstDeptName());
            consultationMdtEntity.setExpertDistCode(StringUtil.isNotEmpty((String)expertDetailInfoEntity.getAreaCode()) ? expertDetailInfoEntity.getAreaCode() : "0");
            consultationMdtEntity.setExpertPhone(expertDetailInfoEntity.getRegisterMobile());
            consultationMdtEntity.setAmissionFee(expertInfoVo.getPrice());
            list.add(consultationMdtEntity);
        }
        this.mdtConsultationService.insertMore(list);
    }

    public void orderPrice(OrderPriceVo orderPriceVo) {
        log.info("\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u53c2\u6570orderPriceVo:{}", (Object)orderPriceVo.toString());
        BigDecimal totalPrice = BigDecimal.ZERO;
        log.info("totalPrice1:{}", (Object)totalPrice);
        Integer mdtpayType = 0;
        List mdtExpertInfoVoList = orderPriceVo.getList();
        log.info("mdtExpertInfoVoList\uff1a{}", (Object)mdtExpertInfoVoList);
        List hosList = mdtExpertInfoVoList.stream().map(MdtExpertInfoVo::getExpertHosId).collect(Collectors.toList());
        log.info("\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u2014\u2014\u4e13\u5bb6\u533b\u9662\u805a\u5408hosList:{}", hosList);
        Long count = hosList.stream().distinct().count();
        log.info("\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\u2014\u2014count:{}", (Object)count);
        if ("1".equals(count.toString()) && hosList.size() > 1 && orderPriceVo.getDoctorHospitalId().toString().equals(((Long)hosList.get(0)).toString())) {
            List organServiceIterationVoList = (List)this.organServiceApi.getOrganServiceInfoIteration(((MdtExpertInfoVo)mdtExpertInfoVoList.get(0)).getExpertHosId()).getData();
            log.info("\u7ed3\u7b97\u65b9\u5f0forganServiceIterationVoList:{}", (Object)organServiceIterationVoList);
            List organServiceList = organServiceIterationVoList.stream().filter(e -> e.getServiceCode().equals("51100")).collect(Collectors.toList());
            log.info("\u7ed3\u7b97\u65b9\u5f0forganServiceList:{}", organServiceList);
            if (CollectionUtils.isNotEmpty(organServiceList)) {
                mdtpayType = ((OrganServiceIterationVo)organServiceList.get(0)).getSettlement();
                if ("1".equals(mdtpayType.toString())) {
                    for (MdtExpertInfoVo mdtExpertInfoVo : mdtExpertInfoVoList) {
                        log.info("mdtExpertInfoVo.getPrice():{}", (Object)mdtExpertInfoVo.getPrice());
                        totalPrice = totalPrice.add(mdtExpertInfoVo.getPrice());
                        log.info("totalPrice22:{}", (Object)totalPrice);
                    }
                } else {
                    int depSize = mdtExpertInfoVoList.stream().map(MdtExpertInfoVo::getExpertDeptId).distinct().collect(Collectors.toList()).size();
                    totalPrice = ((OrganServiceIterationVo)organServiceList.get(0)).getDeptPrice().multiply(new BigDecimal(depSize)).setScale(2, 4);
                }
            }
        } else {
            for (MdtExpertInfoVo mdtExpertInfoVo : mdtExpertInfoVoList) {
                log.info("mdtExpertInfoVo.getPrice():{}", (Object)mdtExpertInfoVo.getPrice());
                if (mdtExpertInfoVo.getPrice() == null) {
                    mdtExpertInfoVo.setPrice(BigDecimal.ZERO);
                }
                totalPrice = totalPrice.add(mdtExpertInfoVo.getPrice());
                log.info("totalPrice2:{}", (Object)totalPrice);
            }
            mdtpayType = 1;
        }
        log.info("totalPrice3:{}", (Object)totalPrice);
        log.info("mdtpayType:{}", (Object)mdtpayType);
        ConsultationEntity consultationEntity = orderPriceVo.getConsultationEntity();
        ConsultationExtendEntity consultationExtendEntity = orderPriceVo.getConsultationExtendEntity();
        log.info("consultationExtendEntity:{}", (Object)consultationExtendEntity);
        if (0 == BigDecimal.ZERO.compareTo(totalPrice) && 0 == consultationExtendEntity.getAccompanyFee().compareTo(BigDecimal.ZERO)) {
            log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e3a0\u5143=====");
            totalPrice = BigDecimal.ZERO;
            consultationExtendEntity.setAmissionFee(totalPrice);
            consultationExtendEntity.setPrice(totalPrice.add(consultationExtendEntity.getAccompanyFee()));
            consultationExtendEntity.setMdtPayType(mdtpayType);
            consultationExtendEntity.setPayState(PayStateEnum.HAS_PAY_STATE.getValue());
            consultationExtendEntity.setPayType(PayTypeEnum.NORMAL_SETTLE.getValue());
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.WAIT_DISTRIBUTION.getValue().intValue()) {
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e3a0\u5143\uff1a\u5206\u914d\u8ba2\u5355====");
                consultationEntity.setStatus(OrderStatusEnum.WAITING.getValue());
            } else if (consultationEntity.getStatus().intValue() == OrderStatusEnum.NEW_APPLY.getValue().intValue()) {
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e3a0\u5143\uff1a\u65b0\u7533\u8bf7\u5b8c\u5584\u8ba2\u5355====");
                consultationEntity.setStatus(OrderStatusEnum.WAITING.getValue());
            } else {
                consultationEntity.setStatus(OrderStatusEnum.WAIT_PATIENT_SIGN.getValue());
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e3a0\u5143\uff1aconsultationEntity\uff1a{}====", (Object)consultationEntity.getStatus());
            }
            this.consultationService.updateConsultationEntity(consultationEntity);
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.WAITING.getValue().intValue() && StringUtil.isEmpty((String)consultationEntity.getGroupId())) {
                this.commonService.tencentMdtGroup(consultationEntity);
                this.commonService.tencentPushGroupMdtMsg(consultationEntity);
            }
        } else {
            consultationExtendEntity.setAmissionFee(totalPrice);
            consultationExtendEntity.setPrice(totalPrice.add(consultationExtendEntity.getAccompanyFee()));
            consultationExtendEntity.setMdtPayType(mdtpayType);
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.WAIT_DISTRIBUTION.getValue().intValue()) {
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e0d\u4e3a0\u5143\uff1a\u5206\u914d\u8ba2\u5355====");
                consultationEntity.setStatus(OrderStatusEnum.UN_PAY.getValue());
            } else if (consultationEntity.getStatus().intValue() == OrderStatusEnum.NEW_APPLY.getValue().intValue()) {
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e0d\u4e3a0\u5143\uff1a\u65b0\u7533\u8bf7\u5b8c\u5584\u8ba2\u5355====");
                consultationEntity.setStatus(OrderStatusEnum.UN_PAY.getValue());
            } else {
                consultationEntity.setStatus(OrderStatusEnum.WAIT_PATIENT_SIGN.getValue());
                log.info("=====\u8ba2\u5355\u4ef7\u683c\u8ba1\u7b97\uff1a\u8ba2\u5355\u4ef7\u683c\u4e0d\u4e3a0\u5143\uff1aconsultationEntity\uff1a{}====", (Object)consultationEntity.getStatus());
            }
        }
        this.consultationExtendService.update(consultationExtendEntity);
    }

    public ResultInfo<String> patientSignature(PatientSignatureVo patientSignatureVo) {
        log.info("\u591a\u5b66\u79d1\u60a3\u8005\u7b7e\u540d\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)patientSignatureVo.toString());
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(patientSignatureVo.getOrderViewId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        consultationEntity.setPatientSignature(patientSignatureVo.getPatientSignature());
        consultationEntity.setPatientSignerRelationship(patientSignatureVo.getPatientSignerRelationship());
        consultationEntity.setPatientInformedConsentUrl(patientSignatureVo.getPatientInformedConsentUrl());
        if (ConsultationConstant.TYPE_APPLICATION_MDT_DISTRIBUTION.equals(consultationEntity.getApplicationChannels()) || ConsultationConstant.TYPE_APPLICATION_DISTRIBUTION.equals(consultationEntity.getApplicationChannels())) {
            log.info("=====\u60a3\u8005\u7b7e\u540d\u5206\u914d====");
            consultationEntity.setStatus(OrderStatusEnum.WAIT_DISTRIBUTION.getValue());
        } else if (Integer.valueOf(1).equals(consultationExtendEntity.getInitiatorType())) {
            log.info("=====\u60a3\u8005\u7b7e\u540d\u65b0\u7533\u8bf7====");
            consultationEntity.setStatus(OrderStatusEnum.NEW_APPLY.getValue());
        } else if (0 != consultationExtendEntity.getPrice().compareTo(BigDecimal.ZERO)) {
            log.info("=====\u60a3\u8005\u7b7e\u540d\u4ef7\u683c\u4e0d\u4e3a0====");
            consultationEntity.setStatus(OrderStatusEnum.UN_PAY.getValue());
        } else {
            log.info("=====\u60a3\u8005\u7b7e\u540d\u4ef7\u683c\u4e3a0====");
            consultationExtendEntity.setPayState(PayStateEnum.HAS_PAY_STATE.getValue());
            consultationExtendEntity.setPayType(PayTypeEnum.NORMAL_SETTLE.getValue());
            this.consultationExtendService.update(consultationExtendEntity);
            consultationEntity.setStatus(OrderStatusEnum.WAITING.getValue());
        }
        this.consultationService.updateConsultationEntity(consultationEntity);
        List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
        if (consultationEntity.getStatus().intValue() == OrderStatusEnum.WAITING.getValue().intValue() && StringUtil.isEmpty((String)consultationEntity.getGroupId()) && 0 == consultationExtendEntity.getPrice().compareTo(new BigDecimal(0))) {
            this.commonService.tencentMdtGroup(consultationEntity);
            this.commonService.tencentPushGroupMdtMsg(consultationEntity);
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() != consultationEntity.getApplicationChannels().intValue()) {
                this.mdtWebAndAppMessageManager.addOrderSendMessageToPatient(consultationEntity, consultationMdtEntityList);
            }
        }
        if (consultationEntity.getStatus().intValue() == OrderStatusEnum.WAIT_DISTRIBUTION.getValue().intValue() && CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
            this.mdtWebAndAppMessageManager.applyOrderToNodeAdminUser(consultationEntity, consultationMdtEntityList);
        }
        if (OrderStatusEnum.WAITING.getValue().intValue() == consultationEntity.getStatus().intValue() && ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
            this.webAndAppMessageManager.secondConsultationSendMessage(consultationEntity);
            if (OrderTypeEnum.TYPE_VEDIO.getValue().intValue() == consultationEntity.getType().intValue()) {
                this.shortMessageManager.expertSecondVideoConsultationNews(consultationEntity.getViewId());
            } else {
                this.shortMessageManager.expertSecondMsgConsultationNews(consultationEntity.getViewId());
            }
        }
        return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
    }

    public ResultInfo<String> addOrderPatient(OrderPatientMdtVo orderPatientMdtVo) {
        log.info("\u591a\u5b66\u79d1\u60a3\u8005\u4e0b\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)orderPatientMdtVo.toString());
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        patientCaseInfoVO.setCaseName("");
        patientCaseInfoVO.setMainSuit(orderPatientMdtVo.getMainSuit() != null ? orderPatientMdtVo.getMainSuit() : "");
        patientCaseInfoVO.setConsultAim(orderPatientMdtVo.getConsultAim() != null ? orderPatientMdtVo.getConsultAim() : "");
        patientCaseInfoVO.setPatientId(Long.valueOf(0L));
        patientCaseInfoVO.setPatientViewId(orderPatientMdtVo.getPatientId().toString());
        patientCaseInfoVO.setPatientName(orderPatientMdtVo.getPatientName());
        patientCaseInfoVO.setHospitalId(orderPatientMdtVo.getDoctorHostId());
        patientCaseInfoVO.setHospitalName(orderPatientMdtVo.getDoctorHostName());
        patientCaseInfoVO.setDoctorName(orderPatientMdtVo.getDoctorName());
        patientCaseInfoVO.setDoctorId(orderPatientMdtVo.getDoctorId());
        patientCaseInfoVO.setDeptDetailId(orderPatientMdtVo.getDoctorDeptId());
        patientCaseInfoVO.setDeptDetailName(orderPatientMdtVo.getDoctorDeptName());
        patientCaseInfoVO.setCaseType(PatientCaseInfoDTO.CONSULTATION_TYPE);
        if (CollectionUtils.isNotEmpty((Collection)orderPatientMdtVo.getOssFileIds())) {
            log.info("\u60a3\u8005\u4e0b\u5355\uff0c\u83b7\u53d6\u56fe\u7247\u53c2\u6570\uff1a{}", (Object)orderPatientMdtVo.getOssFileIds());
            List list = orderPatientMdtVo.getOssFileIds();
            ArrayList<String> strings = new ArrayList<String>();
            for (Long aLong : list) {
                strings.add(aLong.toString());
            }
            String normalImages = String.join((CharSequence)",", strings);
            patientCaseInfoVO.setNormalImages(normalImages);
        }
        patientCaseInfoVO.setPastHistory("");
        patientCaseInfoVO.setPresentHistory("");
        log.info("\u60a3\u8005\u4e0b\u5355\uff0c\u6dfb\u52a0\u75c5\u4f8b\u53c2\u6570patientCaseInfoVO\uff1a{}", (Object)patientCaseInfoVO);
        this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        if (StringUtil.isBlank((String)patientCaseInfoVO.getId().toString())) {
            return this.returnFailure("\u75c5\u4f8b\u521b\u5efa\u5931\u8d25");
        }
        OrderParamVo orderParamVo = new OrderParamVo();
        BeanUtil.copyProperties((Object)orderPatientMdtVo, (Object)orderParamVo, (String[])new String[0]);
        orderParamVo.setCaseId(patientCaseInfoVO.getId());
        ConsultationEntity consultationEntity = this.addConsultation(orderParamVo, "");
        if (consultationEntity.getCreateTime() == null) {
            consultationEntity.setCreateTime(new Date());
        }
        ConsultationExtendEntity consultationExtendEntity = this.addConsultationExtendEntity(orderParamVo, consultationEntity);
        try {
            this.mdtWebAndAppMessageManager.pushToDoctor(consultationEntity);
            this.shortMessageManager.applySubmittedToUser(consultationEntity.getViewId());
            this.programMessageManager.patientOrderPush(consultationEntity);
        }
        catch (Exception e) {
            log.error("addOrderPatient", (Throwable)e);
        }
        return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
    }

    public ResultInfo<String> improveOrder(OrderImproveMdtVo orderImproveMdtVo) {
        log.info("\u591a\u5b66\u79d1\u5b8c\u5584\u8ba2\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)orderImproveMdtVo.toString());
        PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
        patientCaseInfoVO.setMainSuit(orderImproveMdtVo.getMainSuit() != null ? orderImproveMdtVo.getMainSuit() : "");
        PatientCaseInfoVO patientCaseInfo = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        ConsultationEntity consultation = this.consultationService.queryConsultationEntityById(orderImproveMdtVo.getOrderId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultation.getId());
        SavePatientDynamicMedicalReqVo savePatientDynamicMedicalReqVo = new SavePatientDynamicMedicalReqVo();
        savePatientDynamicMedicalReqVo.setMedicalUserFills(orderImproveMdtVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setMedicalDetail(orderImproveMdtVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setPatientId(consultation.getPatientId().toString());
        savePatientDynamicMedicalReqVo.setServType(Integer.valueOf(6));
        savePatientDynamicMedicalReqVo.setAppCode("0");
        savePatientDynamicMedicalReqVo.setHospitalId("0");
        savePatientDynamicMedicalReqVo.setTags("");
        savePatientDynamicMedicalReqVo.setDescription("");
        String dynamicId = this.addDynamicMedical(savePatientDynamicMedicalReqVo);
        Integer surgeryType = OrderTypeEnum.getByValue((Integer)orderImproveMdtVo.getType()).getValue().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? DoctorServiceEnum.CONSULTATION_VEDIO_SURGERY.getValue() : DoctorServiceEnum.CONSULTATION_TUWEN_SURGERY.getValue();
        ArrayList<QueryPiontServiceDTO> doctorQueryPiontServiceDTOS = new ArrayList<QueryPiontServiceDTO>();
        QueryPiontServiceDTO doctorPiontService = new QueryPiontServiceDTO();
        doctorPiontService.setDoctorId(Integer.valueOf(consultation.getDoctorId().intValue()));
        doctorPiontService.setServiceCode(surgeryType.toString());
        doctorQueryPiontServiceDTOS.add(doctorPiontService);
        List doctorInfoVOS = this.remoteManage.queryDoctorServiceInfo(doctorQueryPiontServiceDTOS);
        BigDecimal accompanyFee = doctorInfoVOS.isEmpty() || doctorInfoVOS.get(0) == null ? new BigDecimal(0) : ((PointDoctorServiceInfoVO)doctorInfoVOS.get(0)).getPrice();
        consultationExtendEntity.setAccompanyFee(accompanyFee);
        consultation.setDynamicId(dynamicId);
        consultation.setApplicationChannels(orderImproveMdtVo.getApplicationChannels());
        consultation.setType(orderImproveMdtVo.getType());
        consultation.setDistributionDescribe(orderImproveMdtVo.getDistributionDescribe());
        this.consultationExtendService.update(consultationExtendEntity);
        if (CollectionUtils.isNotEmpty((Collection)orderImproveMdtVo.getList())) {
            this.addMdt(orderImproveMdtVo.getList(), consultation);
        }
        if (CollectionUtils.isNotEmpty((Collection)orderImproveMdtVo.getList())) {
            OrderPriceVo orderPriceVo = new OrderPriceVo();
            orderPriceVo.setConsultationExtendEntity(consultationExtendEntity);
            orderPriceVo.setConsultationEntity(consultation);
            orderPriceVo.setOrderId(consultation.getId());
            orderPriceVo.setOrderViewId(consultation.getViewId());
            orderPriceVo.setList(orderImproveMdtVo.getList());
            orderPriceVo.setTotalPrice(orderImproveMdtVo.getTotalPrice());
            orderPriceVo.setType(orderImproveMdtVo.getType());
            orderPriceVo.setDoctorId(consultation.getDoctorId());
            orderPriceVo.setDoctorHospitalId(consultation.getDoctorHospitalId());
            this.orderPrice(orderPriceVo);
        } else {
            consultation.setStatus(OrderStatusEnum.WAIT_DISTRIBUTION.getValue());
        }
        if (StringUtil.isNotEmpty((String)orderImproveMdtVo.getAppointedTime())) {
            String[] split = orderImproveMdtVo.getAppointedTime().split(" ");
            consultation.setConsultationDate(split[0]);
            consultation.setConsultationTime(split[1]);
        }
        this.consultationService.updateConsultationEntity(consultation);
        return this.returnSucceed((Object)consultation.getViewId(), "ok");
    }

    public ResultInfo<PageResult<RetBusinessDoctorListVo>> healthAllianceDoctorList(HealthDoctorParamVo healthDoctorParamVo) {
        GetBusinessDoctorListVo getBusinessDoctorListVo = new GetBusinessDoctorListVo();
        List<Long> hosList = new ArrayList<Long>();
        if ("1".equals(healthDoctorParamVo.getIsDefault())) {
            hosList = this.getHealthAllianceHosId(healthDoctorParamVo.getHospitalId());
            if (CollectionUtils.isEmpty(hosList)) {
                return this.returnSucceed("\u7a7a");
            }
        } else {
            hosList.add(healthDoctorParamVo.getHospitalId());
        }
        getBusinessDoctorListVo.setOrganIdList(hosList);
        getBusinessDoctorListVo.setServiceCode(healthDoctorParamVo.getServiceCode());
        getBusinessDoctorListVo.setProfessionCode(healthDoctorParamVo.getProfessionCode());
        getBusinessDoctorListVo.setDeptId(healthDoctorParamVo.getDeptId());
        getBusinessDoctorListVo.setSearchParam(healthDoctorParamVo.getSearch());
        getBusinessDoctorListVo.setPageNum(healthDoctorParamVo.getPageNum().intValue());
        getBusinessDoctorListVo.setPageSize(healthDoctorParamVo.getPageSize().intValue());
        getBusinessDoctorListVo.setFilterDoctorIdList(healthDoctorParamVo.getFilterDoctorIdList());
        log.info("\u8bf7\u6c42\u53c2\u6570getBusinessDoctorListVo\uff1a{}", (Object)getBusinessDoctorListVo);
        PageResult data = (PageResult)this.doctorBaseApi.getMedicalDoctorList(getBusinessDoctorListVo).getData();
        if (data != null && data.getContent() != null) {
            log.info("data\uff1a{}", (Object)data.getContent().toString());
            ArrayList<RetBusinessDoctorListVo> list = new ArrayList<RetBusinessDoctorListVo>();
            List listVos = data.getContent();
            for (RetBusinessDoctorListVo retBusinessDoctorListVo : listVos) {
                retBusinessDoctorListVo.setDoctorType(Integer.valueOf(1));
                list.add(retBusinessDoctorListVo);
            }
            data.setContent(list);
            return this.returnSucceed((Object)data, "ok");
        }
        return this.returnSucceed((Object)new PageResult(), "\u7a7a");
    }

    public List<Long> getHealthAllianceHosId(Long hosId) {
        List hosList = this.healthAllianceMemberService.getHealthAlliance(hosId);
        log.info("\u533b\u9662\u6240\u5728\u533b\u8054\u4f53ids\uff1a{}", (Object)hosList.toString());
        return hosList;
    }

    public ResultInfo<List<PatientInfoDto>> queryOncePatient(ApplicationPatientInfoParamVo applicationPatientInfoParamVo) {
        ArrayList<PatientInfoDto> list = new ArrayList<PatientInfoDto>();
        Long doctorId = applicationPatientInfoParamVo.getDoctorId();
        List consultationList = this.consultationService.queryConsultation(doctorId, OrderStatusEnum.NEW_APPLY.getValue());
        for (ConsultationEntity consultationEntity : consultationList) {
            PatientInfoDto patientInfoDto = new PatientInfoDto();
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            patientInfoDto.setOrderId(consultationEntity.getId());
            patientInfoDto.setOrderViewId(consultationEntity.getViewId());
            patientInfoDto.setPatientId(consultationEntity.getPatientId().toString());
            patientInfoDto.setApplyTime(String.valueOf(consultationEntity.getCreateTime().getTime()));
            patientInfoDto.setDoctorId(consultationEntity.getDoctorId().toString());
            patientInfoDto.setDoctorName(consultationEntity.getDoctorName());
            patientInfoDto.setPatientName(consultationEntity.getPatientName());
            patientInfoDto.setPatientAge(consultationExtendEntity.getPatientAge().toString());
            patientInfoDto.setPatientSex(consultationExtendEntity.getPatientSex() == 1 ? "\u7537" : "\u5973");
            patientInfoDto.setPatientIdCard(consultationExtendEntity.getPatientIdCard());
            patientInfoDto.setPatientNo(consultationExtendEntity.getPatientNo());
            patientInfoDto.setPatientPhone(consultationExtendEntity.getPatientPhone());
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            patientInfoDto.setPatientMainSuit(patientCaseInfoEntity.getMainSuit());
            String normalImages = patientCaseInfoEntity.getNormalImages();
            ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
            if (StringUtil.isNotEmpty((String)normalImages)) {
                List<String> stringList = Arrays.asList(normalImages.split(","));
                for (String s : stringList) {
                    BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                    if (!ossFileVOBaseResponse.getCode().equals("1")) {
                        return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                    }
                    OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                    NormalImagesDto normalImagesDto = new NormalImagesDto();
                    normalImagesDto.setId(ossFileEntity.getId());
                    normalImagesDto.setUrl(ossFileEntity.getUrl());
                    caseAttachmentList.add(normalImagesDto);
                    patientInfoDto.setPatientCaseImage(caseAttachmentList);
                }
            } else {
                patientInfoDto.setPatientCaseImage(caseAttachmentList);
            }
            list.add(patientInfoDto);
        }
        return this.returnSucceed(list, "ok");
    }

    public ResultInfo<List<PatientInfoDto>> queryNewApplicationPatientInfoList(ApplicationPatientInfoParamVo applicationPatientInfoParamVo) {
        ArrayList<PatientInfoDto> list = new ArrayList<PatientInfoDto>();
        Long doctorId = applicationPatientInfoParamVo.getDoctorId();
        List consultationList = this.consultationService.queryConsultation(doctorId, OrderStatusEnum.NEW_APPLY.getValue());
        if (StringUtil.isNotEmpty((String)applicationPatientInfoParamVo.getSearch())) {
            consultationList = consultationList.stream().filter(c -> c.getPatientName().contains(applicationPatientInfoParamVo.getSearch())).collect(Collectors.toList());
        }
        for (ConsultationEntity consultationEntity : consultationList) {
            PatientInfoDto patientInfoDto = new PatientInfoDto();
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            patientInfoDto.setOrderId(consultationEntity.getId());
            patientInfoDto.setOrderViewId(consultationEntity.getViewId());
            patientInfoDto.setApplyTime(DateUtils.dateToString((Date)consultationEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            patientInfoDto.setPatientId(consultationEntity.getPatientId().toString());
            patientInfoDto.setDoctorId(consultationEntity.getDoctorId().toString());
            patientInfoDto.setDoctorName(consultationEntity.getDoctorName());
            patientInfoDto.setPatientName(consultationEntity.getPatientName());
            patientInfoDto.setPatientAge(consultationExtendEntity.getPatientAge().toString());
            patientInfoDto.setPatientSex(consultationExtendEntity.getPatientSex() == 1 ? "\u7537" : "\u5973");
            patientInfoDto.setPatientIdCard(consultationExtendEntity.getPatientIdCard());
            patientInfoDto.setPatientNo(consultationExtendEntity.getPatientNo());
            patientInfoDto.setPatientPhone(consultationExtendEntity.getPatientPhone());
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            patientInfoDto.setPatientMainSuit(patientCaseInfoEntity.getMainSuit());
            String normalImages = patientCaseInfoEntity.getNormalImages();
            ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
            if (StringUtil.isNotEmpty((String)normalImages)) {
                List<String> stringList = Arrays.asList(normalImages.split(","));
                for (String s : stringList) {
                    BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                    if (!ossFileVOBaseResponse.getCode().equals("1")) {
                        return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                    }
                    OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                    NormalImagesDto normalImagesDto = new NormalImagesDto();
                    normalImagesDto.setId(ossFileEntity.getId());
                    normalImagesDto.setUrl(ossFileEntity.getUrl());
                    caseAttachmentList.add(normalImagesDto);
                    patientInfoDto.setPatientCaseImage(caseAttachmentList);
                }
            } else {
                patientInfoDto.setPatientCaseImage(caseAttachmentList);
            }
            list.add(patientInfoDto);
        }
        return this.returnSucceed(list, "ok");
    }

    public ResultInfo<OrderDetailMdtDto> orderDetail(String orderViewId, Long doctorId) {
        boolean dynamicPatient;
        boolean needRoomId;
        boolean greaterOneMdtConsultation;
        if (StringUtil.isEmpty((String)orderViewId) || Objects.isNull(doctorId)) {
            return this.returnFailure("\u53c2\u6570\u5f02\u5e38");
        }
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        if (Objects.isNull(consultationEntity)) {
            return this.returnFailure("\u5f53\u524d\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        OrderDetailMdtDto orderDetailDto = new OrderDetailMdtDto();
        OrderInfoDto orderInfoDto = new OrderInfoDto();
        orderInfoDto.setOrderId(consultationEntity.getId());
        orderInfoDto.setOrderViewId(consultationEntity.getViewId());
        orderInfoDto.setApplicationChannels(consultationEntity.getApplicationChannels());
        orderInfoDto.setType(consultationEntity.getType());
        orderInfoDto.setConsultationDate(consultationEntity.getConsultationDate() == null ? DATE_IS_NULL : consultationEntity.getConsultationDate());
        orderInfoDto.setConsultationTime(consultationEntity.getConsultationDate() == null ? "" : consultationEntity.getConsultationTime());
        orderInfoDto.setOrderBeginTime(consultationEntity.getBeginTime());
        orderInfoDto.setOrderFinishTime(consultationEntity.getFinishTime());
        orderInfoDto.setOrderClosedTime(consultationEntity.getClosedTime());
        orderInfoDto.setOrderCreateTime(consultationEntity.getCreateTime());
        orderInfoDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
        orderInfoDto.setTencentRong(consultationEntity.getTencentRong());
        orderInfoDto.setGroupId(consultationEntity.getGroupId());
        orderInfoDto.setPatientSignerRelationship(consultationEntity.getPatientSignerRelationship());
        orderInfoDto.setPatientSignature(consultationEntity.getPatientSignature());
        orderInfoDto.setPatientInformedConsentUrl(consultationEntity.getPatientInformedConsentUrl());
        orderInfoDto.setPayTime(consultationEntity.getPayTime() == null ? DATE_IS_NULL : consultationEntity.getPayTime());
        orderInfoDto.setDistributionDescribe(consultationEntity.getDistributionDescribe());
        List mdtConsultationList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
        boolean isWaiting = !doctorId.equals(0L) && OrderStatusEnum.WAITING.getValue().equals(consultationEntity.getStatus());
        boolean bl = greaterOneMdtConsultation = CollectionUtils.isNotEmpty((Collection)mdtConsultationList) && mdtConsultationList.size() > 1 && mdtConsultationList.stream().filter(entity -> entity.getExpertId().equals(doctorId) && entity.getStatus().equals(OrderStatusEnum.MDT_IS_ACCEPTS.getValue())).count() > 1L;
        if (isWaiting && greaterOneMdtConsultation) {
            orderInfoDto.setOrderStatus(OrderStatusEnum.WAITING_OTHER.getValue());
        } else {
            orderInfoDto.setOrderStatus(consultationEntity.getStatus());
        }
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        orderInfoDto.setOrderPrice(consultationExtendEntity.getPrice());
        orderInfoDto.setOrderPayStats(consultationExtendEntity.getPayState());
        orderInfoDto.setOrderPayType(consultationExtendEntity.getPayType());
        orderInfoDto.setInitiatorType(consultationExtendEntity.getInitiatorType());
        orderInfoDto.setVideoTime(consultationExtendEntity.getVideoTime());
        orderInfoDto.setVideoUrl(consultationExtendEntity.getVideoUrl());
        boolean bl2 = needRoomId = OrderTypeEnum.TYPE_VEDIO.getValue().equals(consultationEntity.getType()) && consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue();
        if (needRoomId) {
            String roomId = this.getRoomId(consultationEntity);
            if (StringUtil.isEmpty((String)roomId)) {
                return this.returnFailure("\u521b\u5efa\u623f\u95f4\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            orderInfoDto.setRoomId(roomId);
        }
        orderDetailDto.setOrderInfoDto(orderInfoDto);
        DoctorInfoDto doctorInfoDto = new DoctorInfoDto();
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        DoctorInfoRespVO doctorInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getDoctorId(), consultationEntity.getDoctorHospitalId());
        String docSdkAccount = "";
        try {
            docSdkAccount = this.getImUserid(doctorInfo.getUserId());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u533b\u751fsdkAccount\u5931\u8d25{}", (Throwable)e);
        }
        doctorInfoDto.setImUserId(docSdkAccount);
        doctorInfoDto.setDoctorId(consultationEntity.getDoctorId());
        doctorInfoDto.setDoctorName(consultationEntity.getDoctorName());
        doctorInfoDto.setDoctorHeadUrl(doctorEntityInfoVO.getHeadPortrait());
        doctorInfoDto.setDoctorDeptId(consultationEntity.getDoctorDepId());
        doctorInfoDto.setDoctorDeptName(consultationEntity.getDoctorDepName());
        doctorInfoDto.setDoctorHosId(consultationEntity.getDoctorHospitalId());
        doctorInfoDto.setDoctorHosName(consultationEntity.getDoctorHosName());
        doctorInfoDto.setDoctorPhone(consultationExtendEntity.getDoctorPhone());
        doctorInfoDto.setDocProfession(doctorEntityInfoVO.getProfession());
        orderDetailDto.setDoctorInfoDto(doctorInfoDto);
        PatientInfoDto patientInfoDto = new PatientInfoDto();
        patientInfoDto.setPatientId(consultationEntity.getPatientId().toString());
        patientInfoDto.setPatientName(consultationEntity.getPatientName());
        patientInfoDto.setPatientSex(consultationExtendEntity.getPatientSex().toString());
        patientInfoDto.setPatientAge(consultationExtendEntity.getPatientAge().toString());
        patientInfoDto.setPatientNo(consultationExtendEntity.getPatientNo());
        patientInfoDto.setPatientIdCard(CommonUtils.idEncrypt((String)consultationExtendEntity.getPatientIdCard()));
        patientInfoDto.setPatientPhone(consultationExtendEntity.getPatientPhone());
        patientInfoDto.setPatientHeadUrl("");
        orderDetailDto.setPatientInfoDto(patientInfoDto);
        List expertList = this.getDoctorInfoList(mdtConsultationList);
        orderDetailDto.setExpertInfoList(expertList);
        boolean bl3 = dynamicPatient = StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10;
        if (dynamicPatient) {
            List listStr = mdtConsultationList.stream().map(entity -> String.valueOf(entity.getExpertHospitalId())).collect(Collectors.toList());
            PatientGetMedicalTemplateReqVo patientGetMedicalTemplateReqVo = new PatientGetMedicalTemplateReqVo();
            patientGetMedicalTemplateReqVo.setServType(Integer.valueOf(6));
            patientGetMedicalTemplateReqVo.setHospitalId("0");
            patientGetMedicalTemplateReqVo.setHospitalIdList(listStr);
            log.info("\u8be6\u60c5\u52a8\u6001\u75c5\u4f8b\u6a21\u677f\u53c2\u6570patientGetMedicalTemplateReqVo\uff1a{}", (Object)patientGetMedicalTemplateReqVo);
            List TemplateList = (List)this.patientDynamicMedicalClient.getMedicalTemplateMoreHospital(patientGetMedicalTemplateReqVo).getData();
            log.info("\u8be6\u60c5\u52a8\u6001\u75c5\u4f8b\u6a21\u677fTemplateList\uff1a{}", (Object)TemplateList);
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            String medicalDetail = "";
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            ArrayList<DynamicMedicalRecordsDto> list = new ArrayList<DynamicMedicalRecordsDto>();
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            if (Objects.nonNull(json)) {
                Set sets = json.keySet();
                for (String str : sets) {
                    DynamicMedicalRecordsDto dynamicMedicalRecordsDto = new DynamicMedicalRecordsDto();
                    for (PatientMedicalTemplateResVo patientMedicalTemplateResVo : TemplateList) {
                        if (!patientMedicalTemplateResVo.getKeywords().equals(str)) continue;
                        log.info("key:{}", (Object)str);
                        dynamicMedicalRecordsDto.setKey(str);
                        dynamicMedicalRecordsDto.setKeyType(patientMedicalTemplateResVo.getTitleType());
                        dynamicMedicalRecordsDto.setKeyName(patientMedicalTemplateResVo.getTitleContent());
                        dynamicMedicalRecordsDto.setContent(json.get((Object)str).toString());
                        dynamicMedicalRecordsDto.setInputType(patientMedicalTemplateResVo.getInputType());
                        dynamicMedicalRecordsDto.setSort(patientMedicalTemplateResVo.getSort());
                        list.add(dynamicMedicalRecordsDto);
                    }
                }
            }
            orderDetailDto.setDynamicMedicalRecordsList(list.stream().sorted(Comparator.comparing(DynamicMedicalRecordsDto::getInputType)).sorted(Comparator.comparing(DynamicMedicalRecordsDto::getSort)).collect(Collectors.toList()));
        } else {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            PatientCaseDTO patientCaseDTO = new PatientCaseDTO();
            if (patientCaseInfoEntity != null) {
                patientCaseDTO.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
                patientCaseDTO.setPastHistory(patientCaseInfoEntity.getPastHistory());
                patientCaseDTO.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
                patientCaseDTO.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
                patientCaseDTO.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
                patientCaseDTO.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
                patientCaseDTO.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
                String normalImages = patientCaseInfoEntity.getNormalImages();
                ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
                if (StringUtil.isNotEmpty((String)normalImages)) {
                    if (normalImages.contains(",")) {
                        List<String> stringList = Arrays.asList(normalImages.split(","));
                        for (String s : stringList) {
                            BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                            if (!ossFileVOBaseResponse.getCode().equals("1")) {
                                return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                            }
                            OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                            NormalImagesDto normalImagesDto = new NormalImagesDto();
                            normalImagesDto.setId(ossFileEntity.getId());
                            normalImagesDto.setUrl(ossFileEntity.getUrl());
                            caseAttachmentList.add(normalImagesDto);
                            patientCaseDTO.setCaseAttachmentList(caseAttachmentList);
                        }
                    } else {
                        OssFileVO ossFileEntity = (OssFileVO)this.iOssApiClient.getById(Long.valueOf(Long.parseLong(normalImages))).getData();
                        NormalImagesDto normalImagesDto = new NormalImagesDto();
                        normalImagesDto.setId(ossFileEntity.getId());
                        normalImagesDto.setUrl(ossFileEntity.getUrl());
                        caseAttachmentList.add(normalImagesDto);
                        patientCaseDTO.setCaseAttachmentList(caseAttachmentList);
                    }
                } else {
                    patientCaseDTO.setCaseAttachmentList(caseAttachmentList);
                }
            }
            orderDetailDto.setPatientCaseDTO(patientCaseDTO);
        }
        orderDetailDto.setIsRefund(consultationEntity.getIsRefund());
        orderDetailDto.setRefundStatus(consultationEntity.getRefundStatus());
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillMapper.selectByOutTradeNoAndStatus(consultationEntity.getViewId());
        if (Objects.nonNull(servicePayBillEntity)) {
            orderDetailDto.setRefundPrice(servicePayBillEntity.getRefundAmount());
        } else {
            orderDetailDto.setRefundPrice(consultationExtendEntity.getPrice());
        }
        return this.returnSucceed((Object)orderDetailDto, "ok");
    }

    private List<DoctorInfoDto> getDoctorInfoList(List<ConsultationMdtEntity> mdtConsultationList) {
        ArrayList<DoctorInfoDto> expertList = new ArrayList<DoctorInfoDto>();
        if (CollectionUtils.isEmpty(mdtConsultationList)) {
            return expertList;
        }
        mdtConsultationList.forEach(consultationMdtEntity -> {
            DoctorEntityInfoVO expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationMdtEntity.getExpertId());
            DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationMdtEntity.getExpertId(), consultationMdtEntity.getExpertHospitalId());
            DoctorInfoDto expertInfoDto = new DoctorInfoDto();
            expertInfoDto.setDoctorId(consultationMdtEntity.getExpertId());
            String expertSdkAccount = "";
            try {
                expertSdkAccount = this.getImUserid(expertInfo.getUserId());
            }
            catch (Exception e) {
                log.error("addOrderPatient", (Throwable)e);
            }
            expertInfoDto.setImUserId(expertSdkAccount);
            expertInfoDto.setDoctorName(consultationMdtEntity.getExpertName());
            expertInfoDto.setDoctorHeadUrl(expertEntityInfoVO.getHeadPortrait());
            expertInfoDto.setDoctorDeptId(consultationMdtEntity.getExpertDepId());
            expertInfoDto.setDoctorDeptName(consultationMdtEntity.getExpertDepName());
            expertInfoDto.setDoctorHosId(consultationMdtEntity.getExpertHospitalId());
            expertInfoDto.setDoctorHosName(consultationMdtEntity.getExpertHospitalName());
            expertInfoDto.setDoctorPhone(consultationMdtEntity.getExpertPhone());
            expertInfoDto.setMdtViewId(consultationMdtEntity.getViewId());
            expertInfoDto.setStatus(consultationMdtEntity.getStatus());
            expertInfoDto.setDocProfession(expertEntityInfoVO.getProfession());
            ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryByMdtViewId(consultationMdtEntity.getViewId());
            ReportInfoDto reportInfoDto = new ReportInfoDto();
            if (consultationReportEntity != null) {
                reportInfoDto.setId(consultationReportEntity.getId().toString());
                reportInfoDto.setOrderViewId(consultationReportEntity.getOrderViewId());
                reportInfoDto.setOrderType(consultationReportEntity.getOrderType().toString());
                reportInfoDto.setMdtViewId(consultationReportEntity.getMdtViewId());
                reportInfoDto.setDiagnosis(consultationReportEntity.getDiagnosis());
                reportInfoDto.setTreatPlan(consultationReportEntity.getTreatPlan());
                reportInfoDto.setSignature(consultationReportEntity.getSignature());
                reportInfoDto.setPhotoReport(consultationReportEntity.getPhotoReport());
                reportInfoDto.setReason(consultationReportEntity.getReason());
                reportInfoDto.setStatus(consultationReportEntity.getStatus().toString());
            }
            expertInfoDto.setReportInfoDto(reportInfoDto);
            expertList.add(expertInfoDto);
        });
        return expertList;
    }

    private synchronized String getRoomId(ConsultationEntity consultationEntity) {
        String roomId = "";
        RtcRoomEntity oldRoomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
        log.info("orderId={},orderType={},\u662f\u5426\u5df2\u6709\u623f\u95f4:{}", new Object[]{consultationEntity.getId(), consultationEntity.getType(), Objects.isNull(oldRoomEntity) ? "\u65e0" : JSONObject.toJSONString((Object)oldRoomEntity)});
        RtcRoomEntity newRoomEntity = null;
        if (oldRoomEntity == null) {
            newRoomEntity = this.trtcManage.createRoomId(consultationEntity.getId(), consultationEntity.getType());
            log.info("=========\u521b\u5efa\u623f\u95f4\u4fe1\u606f{}", (Object)(Objects.isNull(newRoomEntity) ? "\u5931\u8d25" : JSONObject.toJSONString((Object)newRoomEntity)));
            if (Objects.nonNull(newRoomEntity)) {
                roomId = String.valueOf(newRoomEntity.getId());
            }
        } else {
            roomId = String.valueOf(oldRoomEntity.getId());
        }
        log.info("=========== roomId\u4e3a{}", (Object)roomId);
        return roomId;
    }

    public String getImUserid(String userId) throws Exception {
        ImSdkAccountVo imSdkAccountVo = new ImSdkAccountVo();
        imSdkAccountVo.setAppCode("EHOS_DOCTOR");
        imSdkAccountVo.setUserId(userId);
        String httpResponse = HttpUtils.doPost((String)(this.remoteCallAddressConfig.getRemoteCallAddress() + "cloud/imsys/imapi/queryuserlogin"), (String)JSON.toJSONString((Object)imSdkAccountVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        String data = JSON.parseObject((String)httpResponse).getString("data");
        String sdkAccount = JSON.parseObject((String)data).getString("sdkAccount");
        log.info("sdkAccount:{}", (Object)sdkAccount);
        return sdkAccount;
    }

    @Transactional
    public ResultInfo<String> mdtOrderAssign(OrderAssignMdtVo orderAssignMdtVo) {
        log.info("\u591a\u5b66\u79d1\u4e0b\u5355\u65f6\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)orderAssignMdtVo.toString());
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderAssignMdtVo.getOrderViewId());
        if (consultationEntity != null) {
            if (consultationEntity.getStatus().intValue() == OrderStatusEnum.CANCEL.getValue().intValue()) {
                return this.returnFailure("\u8be5\u8ba2\u5355\u5df2\u88ab\u53d6\u6d88");
            }
            if (consultationEntity.getStatus().intValue() != OrderStatusEnum.WAIT_DISTRIBUTION.getValue().intValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.UN_PAY.getValue().intValue()) {
                return this.returnFailure("\u8be5\u8ba2\u5355\u4e0d\u662f'\u5f85\u5206\u914d'\u6216'\u5f85\u652f\u4ed8'\u72b6\u6001\uff0c\u4e0d\u80fd\u5206\u914d");
            }
            if (MdtUtil.decideMdtDataType((Integer)consultationEntity.getApplicationChannels()) == 0) {
                return this.returnFailure("\u8be5\u8ba2\u5355\u4e0d\u5c5e\u4e8eMDT\u6e20\u9053\u8303\u56f4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u5206\u914d");
            }
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            if (consultationExtendEntity != null) {
                this.mdtConsultationService.deleteConsultationMdtByOrderViewId(consultationEntity.getViewId());
                this.addMdt(orderAssignMdtVo.getList(), consultationEntity);
                OrderPriceVo orderPriceVo = new OrderPriceVo();
                orderPriceVo.setConsultationExtendEntity(consultationExtendEntity);
                orderPriceVo.setOrderId(consultationEntity.getId());
                orderPriceVo.setOrderViewId(consultationEntity.getViewId());
                orderPriceVo.setList(orderAssignMdtVo.getList());
                orderPriceVo.setTotalPrice(orderAssignMdtVo.getTotalPrice());
                orderPriceVo.setType(consultationEntity.getType());
                orderPriceVo.setDoctorId(consultationEntity.getDoctorId());
                orderPriceVo.setDoctorHospitalId(consultationEntity.getDoctorHospitalId());
                orderPriceVo.setConsultationEntity(consultationEntity);
                this.orderPrice(orderPriceVo);
                consultationEntity.setApplicationChannels(orderAssignMdtVo.getApplicationChannels());
                this.consultationService.updateConsultationEntity(consultationEntity);
                try {
                    List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
                    if (consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO)) {
                        this.shortMessageManager.videoConsultationFromAdminToDoctor(consultationEntity);
                        this.mdtWebAndAppMessageManager.videoConsultationFromAdminToReport(consultationEntity, consultationMdtEntityList);
                    } else {
                        this.shortMessageManager.photoConsultationFromAdminToDoctor(consultationEntity.getViewId());
                        this.mdtWebAndAppMessageManager.photoConsultationFromAdminToReport(consultationEntity, consultationMdtEntityList);
                    }
                    this.mdtWebAndAppMessageManager.hospitalManageOrderDistributionSendMessage(consultationEntity, consultationMdtEntityList);
                }
                catch (Exception e) {
                    log.error("addOrderPatient", (Throwable)e);
                }
                return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
            }
            return this.returnFailure("\u8be5\u8ba2\u5355\u6570\u636e\u4e0d\u4e00\u81f4");
        }
        return this.returnFailure("\u8ba2\u5355viewId\u4e0d\u6b63\u786e");
    }

    public ResultInfo<String> creatReport(ReportCreatVo reportCreatVo) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(reportCreatVo.getOrderViewId());
        ConsultationMdtEntity consultationMdtEntity = this.mdtConsultationService.selectByViewId(reportCreatVo.getMdtViewId());
        if (consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationMdtEntity.getStatus().intValue() == OrderStatusEnum.MDT_IS_ACCEPTS.getValue().intValue()) {
            ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
            consultationReportEntity.setViewId(UniqueKeyGenerator.generateViewId().toString());
            consultationReportEntity.setStatus(reportCreatVo.getReportStatus());
            BeanUtil.copyProperties((Object)reportCreatVo, (Object)consultationReportEntity, (String[])new String[0]);
            ConsultationReportEntity consultationReport = this.consultationReportService.queryByMdtViewId(consultationReportEntity.getMdtViewId());
            if (consultationReport != null) {
                return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u5b58\u5728\u6216\u8005\u8349\u7a3f\u5b58\u5728");
            }
            this.consultationReportService.insert(consultationReportEntity);
            if (consultationReportEntity.getStatus().equals(OrderStatusEnum.REPORT_ONLINE.getValue())) {
                consultationMdtEntity.setStatus(OrderStatusEnum.MDT_UP_REPORT.getValue());
                this.mdtConsultationService.update(consultationMdtEntity);
            }
            List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(reportCreatVo.getOrderViewId());
            log.info("=======\u65b0\u5efa\u62a5\u544a\u5b50\u8ba2\u5355\u6570\u636e\uff1a{}", (Object)consultationMdtEntityList);
            List consultationMdtList = consultationMdtEntityList.stream().filter(e -> e.getStatus().equals(OrderStatusEnum.MDT_UP_REPORT.getValue())).collect(Collectors.toList());
            log.info("=======\u65b0\u5efa\u62a5\u544a\u5b50\u8ba2\u5355\u957f\u5ea6\uff1a{},\u63d0\u4ea4\u62a5\u544a\u957f\u5ea6\uff1a{}", (Object)consultationMdtEntityList.size(), (Object)consultationMdtList.size());
            if (consultationMdtEntityList.size() == consultationMdtList.size()) {
                log.info("=======\u65b0\u5efa\u62a5\u544a\u5168\u90e8\u63d0\u4ea4=======");
                consultationEntity.setReportStatus(OrderStatusEnum.REPORT_ONLINE.getValue());
                this.consultationService.updateConsultationEntity(consultationEntity);
            }
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u4e0a\u4f20\u6210\u529f");
        }
        return this.returnSucceed("\u4e0d\u53ef\u586b\u5199\u4f1a\u8bca\u62a5\u544a");
    }

    public ResultInfo<String> updateReport(ReportUpdateVo reportUpdateVo) {
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryByMdtViewId(reportUpdateVo.getMdtViewId());
        if (null == consultationReportEntity) {
            return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728");
        }
        BeanUtil.copyProperties((Object)reportUpdateVo, (Object)consultationReportEntity, (String[])new String[0]);
        consultationReportEntity.setStatus(reportUpdateVo.getReportStatus());
        this.consultationReportService.update(consultationReportEntity);
        ConsultationMdtEntity consultationMdtEntity = this.mdtConsultationService.selectByViewId(reportUpdateVo.getMdtViewId());
        if (consultationReportEntity.getStatus().equals(OrderStatusEnum.REPORT_ONLINE.getValue())) {
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_UP_REPORT.getValue());
        } else if (consultationReportEntity.getStatus().equals(OrderStatusEnum.REPORT_DRAFT.getValue())) {
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_IS_ACCEPTS.getValue());
        } else {
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_IS_ACCEPTS.getValue());
        }
        this.mdtConsultationService.update(consultationMdtEntity);
        List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(reportUpdateVo.getOrderViewId());
        List consultationMdtList = consultationMdtEntityList.stream().filter(e -> e.getStatus().equals(OrderStatusEnum.MDT_UP_REPORT.getValue())).collect(Collectors.toList());
        log.info("=======\u4fee\u6539\u62a5\u544a\u5b50\u8ba2\u5355\u957f\u5ea6\uff1a{},\u63d0\u4ea4\u62a5\u544a\u957f\u5ea6\uff1a{}", (Object)consultationMdtEntityList.size(), (Object)consultationMdtList.size());
        if (consultationMdtEntityList.size() == consultationMdtList.size()) {
            log.info("=======\u4fee\u6539\u62a5\u544a\u5168\u90e8\u63d0\u4ea4=======");
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(reportUpdateVo.getOrderViewId());
            consultationEntity.setReportStatus(OrderStatusEnum.REPORT_ONLINE.getValue());
            this.consultationService.updateConsultationEntity(consultationEntity);
        }
        return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u66f4\u65b0\u6210\u529f");
    }

    public ResultInfo<String> draftReport(ReportDraftVo reportDraftVo) {
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryByMdtViewId(reportDraftVo.getMdtViewId());
        consultationReportEntity.setStatus(reportDraftVo.getReportStatus());
        consultationReportEntity.setReason(reportDraftVo.getReason());
        this.consultationReportService.update(consultationReportEntity);
        ConsultationMdtEntity consultationMdtEntity = this.mdtConsultationService.selectByViewId(reportDraftVo.getMdtViewId());
        if (consultationReportEntity.getStatus().equals(OrderStatusEnum.REPORT_ONLINE.getValue())) {
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_UP_REPORT.getValue());
        }
        if (consultationReportEntity.getStatus().equals(OrderStatusEnum.REPORT_DRAFT.getValue())) {
            consultationMdtEntity.setStatus(OrderStatusEnum.MDT_REPORT_BACK.getValue());
        }
        this.mdtConsultationService.update(consultationMdtEntity);
        List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(reportDraftVo.getOrderViewId());
        List consultationMdtList = consultationMdtEntityList.stream().filter(e -> e.getStatus().equals(OrderStatusEnum.MDT_UP_REPORT.getValue())).collect(Collectors.toList());
        log.info("=======\u5ba1\u6838\u62a5\u544a\u5b50\u8ba2\u5355\u957f\u5ea6\uff1a{},\u63d0\u4ea4\u62a5\u544a\u957f\u5ea6\uff1a{}", (Object)consultationMdtEntityList.size(), (Object)consultationMdtList.size());
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(reportDraftVo.getOrderViewId());
        if (consultationMdtEntityList.size() == consultationMdtList.size()) {
            log.info("=======\u5ba1\u6838\u62a5\u544a\u5168\u90e8\u63d0\u4ea4=======");
            consultationEntity.setReportStatus(OrderStatusEnum.REPORT_ONLINE.getValue());
        } else {
            log.info("=======\u5ba1\u6838\u62a5\u544a\u5b58\u5728\u672a\u63d0\u4ea4=======");
            consultationEntity.setReportStatus(Integer.valueOf(0));
        }
        this.consultationService.updateConsultationEntity(consultationEntity);
        return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u6210\u529f");
    }

    public ResultInfo<String> updatePatientCaseInfo(UpdatePatientCaseVo updatePatientCaseVo) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(updatePatientCaseVo.getOrderViewId());
        SavePatientDynamicMedicalReqVo savePatientDynamicMedicalReqVo = new SavePatientDynamicMedicalReqVo();
        savePatientDynamicMedicalReqVo.setMedicalUserFills(updatePatientCaseVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setMedicalDetail(updatePatientCaseVo.getDynamicMedicalRecords());
        savePatientDynamicMedicalReqVo.setPatientId(consultationEntity.getPatientId().toString());
        savePatientDynamicMedicalReqVo.setServType(Integer.valueOf(6));
        savePatientDynamicMedicalReqVo.setAppCode("0");
        savePatientDynamicMedicalReqVo.setHospitalId("0");
        savePatientDynamicMedicalReqVo.setTags("");
        savePatientDynamicMedicalReqVo.setDescription("");
        String dynamicId = this.addDynamicMedical(savePatientDynamicMedicalReqVo);
        consultationEntity.setDynamicId(dynamicId);
        this.consultationService.updateConsultationEntity(consultationEntity);
        return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
    }

    public ResultInfo<String> updateAppointmentTime(UpdateAppointmentTimeVo updateAppointmentTimeVo) {
        log.info("\u9884\u7ea6\u65f6\u95f4\u4fee\u6539\u7684\u53c2\u6570\u662f:{}", (Object)updateAppointmentTimeVo.toString());
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(updateAppointmentTimeVo.getOrderViewId());
        String[] appointmentTime = updateAppointmentTimeVo.getAppointmentTime().split(" ");
        consultationEntity.setConsultationDate(appointmentTime[0]);
        consultationEntity.setConsultationTime(appointmentTime[1]);
        this.consultationService.updateConsultationEntity(consultationEntity);
        return this.returnSucceed((Object)consultationEntity.getViewId(), "ok");
    }

    public ResultInfo<ReportDetailDto> reportDetail(String orderViewId) {
        ReportDetailDto reportDetailDto = new ReportDetailDto();
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        List mdtConsultationEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
        PatientInfoDto patientInfoDto = new PatientInfoDto();
        patientInfoDto.setPatientId(consultationEntity.getPatientId().toString());
        patientInfoDto.setPatientName(consultationEntity.getPatientName());
        patientInfoDto.setPatientSex(consultationExtendEntity.getPatientSex().toString());
        patientInfoDto.setPatientAge(consultationExtendEntity.getPatientAge().toString());
        patientInfoDto.setPatientNo(consultationExtendEntity.getPatientNo());
        patientInfoDto.setPatientIdCard(consultationExtendEntity.getPatientIdCard());
        patientInfoDto.setPatientPhone(consultationExtendEntity.getPatientPhone());
        patientInfoDto.setPatientHeadUrl("");
        reportDetailDto.setPatientInfoDto(patientInfoDto);
        DoctorInfoDto doctorInfoDto = new DoctorInfoDto();
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        doctorInfoDto.setDoctorId(consultationEntity.getDoctorId());
        doctorInfoDto.setDoctorName(consultationEntity.getDoctorName());
        doctorInfoDto.setDoctorHeadUrl(doctorEntityInfoVO.getHeadPortrait());
        doctorInfoDto.setDoctorDeptId(consultationEntity.getDoctorDepId());
        doctorInfoDto.setDoctorDeptName(consultationEntity.getDoctorDepName());
        doctorInfoDto.setDoctorHosId(consultationEntity.getDoctorHospitalId());
        doctorInfoDto.setDoctorHosName(consultationEntity.getDoctorHosName());
        doctorInfoDto.setDoctorPhone(consultationExtendEntity.getDoctorPhone());
        doctorInfoDto.setDocProfession(doctorEntityInfoVO.getProfession());
        reportDetailDto.setDoctorInfoDto(doctorInfoDto);
        ArrayList<DoctorInfoDto> expertList = new ArrayList<DoctorInfoDto>();
        if (CollectionUtils.isNotEmpty((Collection)mdtConsultationEntityList)) {
            for (ConsultationMdtEntity consultationMdtEntity : mdtConsultationEntityList) {
                DoctorEntityInfoVO expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationMdtEntity.getExpertId());
                DoctorInfoDto expertInfoDto = new DoctorInfoDto();
                expertInfoDto.setDoctorId(consultationMdtEntity.getExpertId());
                expertInfoDto.setDoctorName(consultationMdtEntity.getExpertName());
                expertInfoDto.setDoctorHeadUrl(expertEntityInfoVO.getHeadPortrait());
                expertInfoDto.setDoctorDeptId(consultationMdtEntity.getExpertDepId());
                expertInfoDto.setDoctorDeptName(consultationMdtEntity.getExpertDepName());
                expertInfoDto.setDoctorHosId(consultationMdtEntity.getExpertHospitalId());
                expertInfoDto.setDoctorHosName(consultationMdtEntity.getExpertHospitalName());
                expertInfoDto.setDoctorPhone(consultationMdtEntity.getExpertPhone());
                expertInfoDto.setMdtViewId(consultationMdtEntity.getViewId());
                expertInfoDto.setStatus(consultationMdtEntity.getStatus());
                expertInfoDto.setDocProfession(expertEntityInfoVO.getProfession());
                ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryByMdtViewId(consultationMdtEntity.getViewId());
                ReportInfoDto reportInfoDto = new ReportInfoDto();
                if (consultationReportEntity != null) {
                    reportInfoDto.setId(consultationReportEntity.getId().toString());
                    reportInfoDto.setOrderViewId(consultationReportEntity.getOrderViewId());
                    reportInfoDto.setOrderType(consultationReportEntity.getOrderType().toString());
                    reportInfoDto.setMdtViewId(consultationReportEntity.getMdtViewId());
                    reportInfoDto.setDiagnosis(consultationReportEntity.getDiagnosis());
                    reportInfoDto.setTreatPlan(consultationReportEntity.getTreatPlan());
                    reportInfoDto.setSignature(consultationReportEntity.getSignature());
                    String photoReport = consultationReportEntity.getPhotoReport();
                    reportInfoDto.setPhotoReport(photoReport);
                    if (StringUtils.isNotBlank((CharSequence)photoReport)) {
                        photoReport = photoReport.replaceAll("\\s*", "");
                        reportInfoDto.setPhotoReport(photoReport);
                    }
                    reportInfoDto.setReason(consultationReportEntity.getReason());
                    reportInfoDto.setStatus(consultationReportEntity.getStatus().toString());
                }
                expertInfoDto.setReportInfoDto(reportInfoDto);
                expertList.add(expertInfoDto);
            }
        }
        reportDetailDto.setExpertInfoList(expertList);
        return this.returnSucceed((Object)reportDetailDto, "ok");
    }

    public ResultInfo<String> updateVideoOngoing(VideoOngoingVo videoOngoingVo) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(videoOngoingVo.getOrderViewId());
        if (consultationEntity.getStatus().intValue() == OrderStatusEnum.RUNNING.getValue().intValue()) {
            consultationEntity.setIsVideoOngoing(videoOngoingVo.getVideoOngoing());
            this.consultationService.updateConsultationEntity(consultationEntity);
            return this.returnSucceed("ok");
        }
        if (consultationEntity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue()) {
            consultationEntity.setIsVideoOngoing("0");
            this.consultationService.updateConsultationEntity(consultationEntity);
            return this.returnSucceed("ok");
        }
        return this.returnFailure("\u4e0d\u662f\u8fdb\u884c\u4e2d\u8ba2\u5355");
    }

    public ResultInfo<List<OrderVideoingDto>> selectOrderVideoing(OrderVideoingVo orderVideoingVo) {
        ArrayList<OrderVideoingDto> list = new ArrayList<OrderVideoingDto>();
        List consultationEntityList = this.consultationService.getOrderListByDocIdAndStatus(orderVideoingVo.getDoctorId(), OrderStatusEnum.RUNNING.getValue(), "1");
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            List consultationMdtEntityList;
            OrderVideoingDto orderVideoingDto = new OrderVideoingDto();
            List<Object> docNameStr = new ArrayList<String>();
            orderVideoingDto.setOrderViewId(consultationEntity.getViewId());
            if (consultationEntity.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue() && consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
                RtcRoomEntity roomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
                orderVideoingDto.setRoomId(roomEntity.getId().toString());
            }
            if (CollectionUtils.isNotEmpty((Collection)(consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId())))) {
                docNameStr = consultationMdtEntityList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.toList());
                docNameStr.add(consultationEntity.getDoctorName());
            } else {
                docNameStr.add(consultationEntity.getDoctorName());
                docNameStr.add(consultationEntity.getExpertName());
            }
            orderVideoingDto.setDoctorNameStr(docNameStr);
            list.add(orderVideoingDto);
        }
        return this.returnSucceed(list, "ok");
    }

    public ResultInfo<String> selectPatientSignatureQrCode(SignatureParamVo signatureParamVo) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(signatureParamVo.getOrderViewId());
        return this.returnSucceed((Object)consultationEntity.getPatientSignature(), "ok");
    }
}

