/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.HxgyPushCenterEnum;
import com.byh.enums.HxgyPushCodeIntegerEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.exception.PushInfoException;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.pojo.bo.GoEasyPushDataBo;
import com.byh.pojo.bo.YouMengPushDataBo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.httppojo.PushSubscribeMessageReqVO;
import com.byh.pojo.httppojo.UcWxAuthReqVo;
import com.byh.pojo.vo.consultation.req.BaseAliSmsReqVO;
import com.byh.pojo.vo.consultation.req.UcConfigurationReqVO;
import com.byh.pojo.vo.consultation.res.ClientCodeVO;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.consultation.res.SmsClientCode;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.HttpUtils;
import com.byh.util.ProgramUtils;
import com.byh.util.PushInfoManagerUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MdtWebAndAppMessageManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtWebAndAppMessageManager.class);
    public static final String SMSAPPCODE = "";
    public static final Integer USER = 0;
    public static final Integer DOCTOR = 1;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private ProgramUtils programUtils;

    public String getAppCode(Long hospitalId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        return (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
    }

    @Async
    public void applyOrderToNodeAdminUser(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> consultationMdtEntityList) {
        if (OrderStatusEnum.WAIT_DISTRIBUTION.getValue().equals(consultationEntity.getStatus()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(consultationMdtEntityList)) {
            try {
                ArrayList<String> appCpdeList = new ArrayList<String>();
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    String expertAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
                    String expertUrl = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(expertAppCode).append("/").append("permissions/user/role/findalladminuserid").toString();
                    log.info("\u8bf7\u6c42\u5730\u5740\uff1a{},\u8bf7\u6c42\u53c2\u6570\uff1a{expertAppCode}", (Object)expertUrl, (Object)expertAppCode);
                    if (!appCpdeList.contains(expertAppCode)) {
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("appCode", expertAppCode);
                        String resExpertData = HttpUtils.get((String)expertUrl, data);
                        log.info("------------------------------\u6743\u9650\u7ba1\u7406\u83b7\u53d6\u7684\u7ba1\u7406\u5458ID-------------------:{}", (Object)resExpertData);
                        this.pushMsgToAdmin(resExpertData, consultationEntity);
                    }
                    appCpdeList.add(expertAppCode);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new PushInfoException(e.getMessage());
            }
        }
    }

    private void pushMsgToAdmin(String resData, ConsultationEntity consultationEntity) {
        List strings;
        if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSON.parseObject((String)resData).getString("code")) && StringUtil.isNotBlank((String)JSON.parseObject((String)resData).getString("data")) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(strings = JSONArray.parseArray((String)JSON.parseObject((String)resData).getString("data"), String.class)))) {
            for (String userId : strings) {
                YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                youMengPushDataBo.setType("ychzMdt");
                youMengPushDataBo.setText("\u7cfb\u7edf\u65b0\u589e\u4e86\u5f85\u5206\u914d\u8ba2\u5355\uff0c\u8bf7\u53ca\u65f6\u5904\u7406");
                youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getValue());
                youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                youMengPushDataBo.setTitle(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getDisplay());
                youMengPushDataBo.setTicker(SMSAPPCODE);
                youMengPushDataBo.setType("ychzMdt");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("content", youMengPushDataBo.getText());
                this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                youMengPushDataBo.setExtra(map);
                GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                goEasyPushDataBo.setUserId(userId);
                goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.PUSH_NODE_ADMIN_NEW.getValue());
                goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                this.pushInfoManagerUtils.goEasyPushData(consultationEntity.getAccompanyAppCode(), goEasyPushDataBo);
            }
        }
    }

    private void fillExtraMap(Map<String, String> map, YouMengPushDataBo youMengPushDataBo, ConsultationEntity consultationEntity1) {
        map.put("content", youMengPushDataBo.getText());
        map.put("orderViewId", consultationEntity1.getViewId());
        map.put("orderStatus", consultationEntity1.getStatus().toString());
        map.put("orderType", consultationEntity1.getType().toString());
        map.put("orderId", consultationEntity1.getId().toString());
    }

    @Async
    public void addOrderSendMessageToPatient(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> consultationMdtEntityList) {
        HashMap<String, String> map = new HashMap<String, String>();
        int orderType = consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) ? OrderTypeEnum.TYPE_VEDIO.getValue() : OrderTypeEnum.TYPE_TUWEN.getValue();
        try {
            log.info("\u4e0b\u5355\u5b8c\u6210\u5f00\u59cb\u7ed9\u76f8\u5173\u7684\u4eba\u5458\u53d1\u9001app=============");
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "," + consultationEntity.getDoctorHosName() + consultationEntity.getDoctorDepName() + consultationEntity.getDoctorName() + "\u5411\u60a8\u53d1\u8d77\u4e00\u4e2a" + OrderTypeEnum.getByValue((Integer)orderType).getDisplay() + "\u7533\u8bf7,\u8bf7\u53ca\u65f6\u5904\u7406");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.MTD_MNEW_ORDER.getValue().toString());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription(SMSAPPCODE);
            youMengPushDataBo.setPlayAction(SMSAPPCODE);
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTicker(SMSAPPCODE);
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.MTD_MNEW_ORDER.getDisplay());
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.MTD_MNEW_ORDER.getValue().toString());
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                String expertAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
                youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                map.put("pushCode", HxgyPushCodeIntegerEnum.MTD_MNEW_ORDER.getCode().toString());
                map.put("applyAccepts", "2");
                this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                youMengPushDataBo.setExtra(map);
                youMengPushDataBo.setCustom(JSON.toJSONString(map));
                this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
                goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
                this.videoConsultationApplyToExpert(consultationMdtEntity.getViewId(), consultationMdtEntity);
            }
            this.shortMessageManager.newConsultationToDoctor(consultationEntity.getViewId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("==========\u4e0b\u5355\u53d1\u9001\u63a8\u9001\u5b8c\u6210==========");
    }

    @Async
    public void videoConsultationApplyToExpert(String orderViewId, ConsultationMdtEntity consultationMdtEntity) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505111");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            String clientCode = this.getClientCodeDoc(configurationVO);
            baseAliSmsReqVO.setSmsAppCode(clientCode);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertAcceptPush(ConsultationEntity consultationEntity, String acceptTime) throws ParseException {
        try {
            log.info("============\u8fdb\u5165\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001==============");
            String appCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
            UcConfigurationVO configurationVO = this.getUcConfigurationVO(appCode, "weChatApplets");
            String clientCode = this.getClientCode(configurationVO);
            pushSubscribeMessageReqVO.setClientCode(clientCode);
            pushSubscribeMessageReqVO.setTemplateCode("doctor_received_remind");
            pushSubscribeMessageReqVO.setPage(SMSAPPCODE);
            LinkedHashMap data = new LinkedHashMap();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("value", "\u4e13\u5bb6\u5df2\u63a5\u8bca,\u8bf7\u8010\u5fc3\u7b49\u5f85\u4f1a\u8bca\u5b8c\u6210");
            data.put("remake", map);
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("value", "\u8fdc\u7a0b\u4f1a\u8bca");
            data.put("projectName", map1);
            HashMap<String, String> map2 = new HashMap<String, String>();
            map2.put("value", consultationEntity.getPatientName());
            data.put("patientName", map2);
            HashMap<String, String> map3 = new HashMap<String, String>();
            if (StringUtil.isEmpty((String)consultationEntity.getExpertName())) {
                List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
                    String expertName = consultationMdtEntityList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.joining(","));
                    map3.put("value", expertName);
                } else {
                    map3.put("value", consultationEntity.getExpertName());
                }
            } else {
                map3.put("value", consultationEntity.getExpertName());
            }
            data.put("expertName", map3);
            HashMap<String, String> map4 = new HashMap<String, String>();
            map4.put("value", DateTimeUtil.chinaTime((String)acceptTime));
            data.put("time", map4);
            List userIdList = this.programUtils.getUserIdList(consultationEntity.getPatientId(), appCode);
            if (!CollectionUtils.isEmpty((Collection)userIdList)) {
                for (String userId : userIdList) {
                    UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
                    ucWxAuthReqVo.setStatus(Integer.valueOf(1));
                    ucWxAuthReqVo.setUserId(userId);
                    ucWxAuthReqVo.setUserType(Integer.valueOf(0));
                    String openId = this.programUtils.getWxOpenId(ucWxAuthReqVo, appCode);
                    pushSubscribeMessageReqVO.setOpenId(openId);
                    pushSubscribeMessageReqVO.setData(data);
                    log.info("============pushSubscribeMessageReqVO:{}", (Object)pushSubscribeMessageReqVO);
                    log.info("============\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001\u5f00\u59cb==============");
                    this.programUtils.ProgramPush(pushSubscribeMessageReqVO, appCode);
                    log.info("============\u5c0f\u7a0b\u5e8f\u63a5\u8bca\u63a8\u9001\u7ed3\u675f==============");
                }
            }
        }
        catch (ParseException e) {
            log.error("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u5f02\u5e38{}", (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    public UcConfigurationVO getUcConfigurationVO(String appCode, String type) {
        UcConfigurationVO ucConfigurationVO = new UcConfigurationVO();
        StringBuffer url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress());
        url = url.append("cloud/doctoruser/configuration/getdetail");
        UcConfigurationReqVO ucConfigurationReqVO = new UcConfigurationReqVO();
        ucConfigurationReqVO.setAppCode(appCode);
        ucConfigurationReqVO.setType(type);
        log.info("\u83b7\u53d6clientCode\u7684\u8bf7\u6c42url\u662f:{}====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)ucConfigurationReqVO));
        String resData = SMSAPPCODE;
        try {
            resData = HttpUtils.post((String)url.toString(), (String)JSON.toJSONString((Object)ucConfigurationReqVO));
            log.info("\u8c03\u7528\u4e91\u7aef\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)resData);
            if (StringUtil.isNotBlank((String)JSONObject.parseObject((String)resData).getString("data"))) {
                ucConfigurationVO = (UcConfigurationVO)JSONObject.parseObject((String)JSONObject.parseObject((String)resData).getString("data"), UcConfigurationVO.class);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ucConfigurationVO;
    }

    public String getClientCode(UcConfigurationVO ucConfigurationVO) {
        String clientCode = SMSAPPCODE;
        if (ucConfigurationVO != null) {
            String code = ucConfigurationVO.getClientCode();
            ClientCodeVO codeVO = (ClientCodeVO)JSONObject.parseObject((String)code, ClientCodeVO.class);
            clientCode = codeVO.getClientCode();
        }
        return clientCode;
    }

    @Async
    public void startConsultationSendMessage(ConsultationEntity consultationEntity) {
        log.info("\u63a8\u9001_\u5f00\u59cb\u89c6\u9891======================");
        try {
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
            String expertName = SMSAPPCODE;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
                expertName = consultationMdtEntityList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.joining(","));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u4e13\u5bb6" + expertName + "\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5f00\u59cb,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bca\u804a\u5929\u5ba4\u53c2\u4e0e\u4f1a\u8bae\u3002");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u4e13\u5bb6" + expertName + "\u7684\u89c6\u9891\u4f1a\u8bae\u5df2\u5f00\u59cb,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bae\u804a\u5929\u5ba4\u53c2\u4e0e\u4f1a\u8bae\u3002");
            }
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription(SMSAPPCODE);
            youMengPushDataBo.setPlayAction(SMSAPPCODE);
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getDisplay());
            youMengPushDataBo.setTicker(SMSAPPCODE);
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.BEFORE_ORDER_BEGIN.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
            this.consultationStartedToExpert(consultationEntity.getViewId(), consultationMdtEntityList);
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u533b\u751f" + consultationEntity.getDoctorName() + "\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5230\u5f00\u59cb\u65f6\u95f4,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bca\u804a\u5929\u5ba4\u5f00\u59cb\u4f1a\u8bca\u76f4\u64ad\u3002");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + ",\u533b\u751f" + consultationEntity.getDoctorName() + "\u7684\u89c6\u9891\u4f1a\u8bae\u5df2\u5230\u5f00\u59cb\u65f6\u95f4,\u8bf7\u7acb\u5373\u8fdb\u5165\u4f1a\u8bae\u804a\u5929\u5ba4\u5f00\u59cb\u4f1a\u8bae\u76f4\u64ad\u3002");
            }
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription(SMSAPPCODE);
            youMengPushDataBo.setPlayAction(SMSAPPCODE);
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getDisplay());
            youMengPushDataBo.setTicker(SMSAPPCODE);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                    youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.BEFORE_ORDER_BEGIN.getCode().toString());
                    map.put("applyAccepts", "2");
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String expertAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.BEFORE_ORDER_BEGIN.getValue());
                    goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartedToExpert(String orderViewId, List<ConsultationMdtEntity> consultationMdtEntityList) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152289971");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                baseAliSmsReqVO.setTemplateCode("yyht_yysj");
            }
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(consultationMdtEntityList)) {
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                    this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("patientname", consultationEntity.getPatientName());
                    map.put("doctorname", consultationEntity.getDoctorName());
                    baseAliSmsReqVO.setParams(map);
                    String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
                    UcConfigurationVO configurationVO = this.getUcConfigurationVO(expertAppCode, "sms");
                    String signCodeExp = this.getSignCodeDoc(configurationVO);
                    String clientCode = this.getClientCodeDoc(configurationVO);
                    baseAliSmsReqVO.setSmsAppCode(clientCode);
                    this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
                }
            }
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    private void improveBaseAliSmsReqVO(BaseAliSmsReqVO baseAliSmsReqVO, Long doctorId) {
        String phone = this.remoteManage.getDoctorDetailById(doctorId).getRegisterMobile();
        baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
        baseAliSmsReqVO.setPhone(phone);
        baseAliSmsReqVO.setUserType(DOCTOR);
        baseAliSmsReqVO.setAppSdkType("ali");
    }

    public String getSignCodeDoc(UcConfigurationVO configurationVO) {
        String signCode = SMSAPPCODE;
        if (configurationVO != null) {
            String code = configurationVO.getClientCode();
            SmsClientCode smsClientCode = (SmsClientCode)JSONObject.parseObject((String)code, SmsClientCode.class);
            signCode = smsClientCode.getSignCode().getDoctorCode();
        }
        return signCode;
    }

    @Async
    public void consultationStartedToDoctor(ConsultationEntity consultationEntity) {
        try {
            String expertName = SMSAPPCODE;
            List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
                expertName = consultationMdtEntityList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.joining(","));
            }
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152208306");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                baseAliSmsReqVO.setTemplateCode("yyht_kstx");
            }
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("expertname", expertName);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            String clientCode = this.getClientCodeDoc(configurationVO);
            baseAliSmsReqVO.setSmsAppCode(clientCode);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindExpertWriteReportNews(String orderViewId, Long doctorId) {
        log.info("\u63a8\u9001_\u4f1a\u8bca\u62a5\u544a_\u63d0\u9192\u4e13\u5bb6\u586b\u5199\u4f1a\u8bca\u62a5\u544a========================");
        ConsultationMdtEntity consultationMdtEntity = this.mdtConsultationService.selectByOrderviewIdDoctorId(orderViewId, doctorId);
        try {
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(doctorId);
            HashMap<String, String> map = new HashMap<String, String>();
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.toString().equals(consultationEntity.getApplicationChannels().toString())) {
                List consultationMdtEntitys = this.mdtConsultationService.selectByViewIdList(orderViewId);
                this.expertConsultationReport(consultationEntity.getViewId(), consultationMdtEntitys);
            } else {
                this.expertConsultationReportNews(consultationEntity.getViewId(), consultationMdtEntity);
            }
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorName() + "\u533b\u751f\u7684\u4f1a\u8bca\u5df2\u5b8c\u6210,\u8bf7\u53ca\u65f6\u586b\u5199\u5e76\u63d0\u4ea4\u4f1a\u8bca\u62a5\u544a\u3002");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                youMengPushDataBo.setText("\u60a8\u4e0e\u60a3\u8005" + consultationEntity.getPatientName() + "\u3001" + consultationEntity.getDoctorName() + "\u533b\u751f\u7684\u4f1a\u8bae\u5df2\u5b8c\u6210,\u8bf7\u53ca\u65f6\u586b\u5199\u5e76\u63d0\u4ea4\u4f1a\u8bae\u62a5\u544a\u3002");
            }
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getValue());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription(SMSAPPCODE);
            youMengPushDataBo.setPlayAction(SMSAPPCODE);
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getDisplay());
            youMengPushDataBo.setTicker(SMSAPPCODE);
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.REMIND_EXPERTS_REPORT.getCode().toString());
            map.put("applyAccepts", "2");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String expertAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.REMIND_EXPERTS_REPORT.getValue());
            goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(expertAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReportNews(String orderViewId, ConsultationMdtEntity consultationMdtEntity) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_164155640");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                baseAliSmsReqVO.setTemplateCode("yyht_jshz");
            }
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientName", consultationEntity.getPatientName());
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            String clientCode = this.getClientCodeDoc(configurationVO);
            baseAliSmsReqVO.setSmsAppCode(clientCode);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReport(String orderViewId, List<ConsultationMdtEntity> consultationMdtEntitys) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_164155640");
            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == consultationEntity.getApplicationChannels().intValue()) {
                baseAliSmsReqVO.setTemplateCode("yyht_jshz");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientName", consultationEntity.getPatientName());
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            if (!consultationMdtEntitys.isEmpty()) {
                for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntitys) {
                    this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
                    String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
                    UcConfigurationVO configurationVO = this.getUcConfigurationVO(expertAppCode, "sms");
                    String signCodeExp = this.getSignCodeDoc(configurationVO);
                    String clientCode = this.getClientCodeDoc(configurationVO);
                    baseAliSmsReqVO.setSmsAppCode(clientCode);
                    this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    public String getClientCodeDoc(UcConfigurationVO configurationVO) {
        String clientCode = SMSAPPCODE;
        if (configurationVO != null) {
            String code = configurationVO.getClientCode();
            SmsClientCode smsClientCode = (SmsClientCode)JSONObject.parseObject((String)code, SmsClientCode.class);
            clientCode = smsClientCode.getClientCode();
        }
        return clientCode;
    }

    @Async
    public void videoConsultationFromAdminToReport(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> consultationMdtEntityList) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505120");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
                UcConfigurationVO configurationVO = this.getUcConfigurationVO(expertAppCode, "sms");
                String signCodeExp = this.getSignCodeDoc(configurationVO);
                this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
            }
        }
        catch (Exception e) {
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationFromAdminToReport(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> consultationMdtEntityList) {
        try {
            String userId = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId()).getUserId();
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_152505121");
            baseAliSmsReqVO.setUserType(DOCTOR);
            baseAliSmsReqVO.setAppSdkType("ali");
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertId().intValue()));
                UcConfigurationVO configurationVO = this.getUcConfigurationVO(doctorAppCode, "sms");
                String signCodeExp = this.getSignCodeDoc(configurationVO);
                this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeExp);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void hospitalManageOrderDistributionSendMessage(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> consultationMdtEntityList) {
        try {
            log.info("\u8ba2\u5355\u6570\u636e=====================" + consultationEntity.toString());
            Integer orderType = consultationEntity.getType();
            DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            switch (orderType) {
                case 4: {
                    YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
                    youMengPushDataBo.setText("\u60a8\u7533\u8bf7\u7684\u89c6\u9891\u4f1a\u8bca\u5df2\u5206\u914d" + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u4e13\u5bb6,\u8bf7\u505a\u597d\u51c6\u5907\u3002");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription(SMSAPPCODE);
                    youMengPushDataBo.setPlayAction(SMSAPPCODE);
                    youMengPushDataBo.setType("ychzMdt");
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo.setTicker(SMSAPPCODE);
                    youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.MTD_VIDEO_ORDER_DISTRIBUTED.getCode().toString());
                    map.put("applyAccepts", "1");
                    this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                    youMengPushDataBo.setExtra(map);
                    youMengPushDataBo.setCustom(JSON.toJSONString(map));
                    String doctorVideoAppcode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorVideoAppcode, youMengPushDataBo);
                    GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
                    goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                    goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorVideoAppcode, goEasyPushDataBo);
                    log.info("\u63a8\u9001_\u4e13\u5bb6\u5206\u914d(\u89c6\u9891)_\u4f1a\u8bca\u4e13\u5bb6\u77ed\u4fe1=====================");
                    youMengPushDataBo.setText("\u7ba1\u7406\u5458\u4e3a\u60a8\u5206\u914d\u4e86\u60a3\u8005" + consultationEntity.getPatientName() + "," + consultationEntity.getDoctorHosName() + consultationEntity.getDoctorDepName() + consultationEntity.getDoctorName() + "\u533b\u751f\u7684\u4f1a\u8bca,\u8bf7\u67e5\u770b\u8be6\u60c5\u3002");
                    youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
                    youMengPushDataBo.setDescription(SMSAPPCODE);
                    youMengPushDataBo.setPlayAction(SMSAPPCODE);
                    youMengPushDataBo.setTitle(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo.setTicker(SMSAPPCODE);
                    for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                        DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                        youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
                        map.put("pushCode", HxgyPushCodeIntegerEnum.MTD_VIDEO_ORDER_DISTRIBUTED.getCode().toString());
                        map.put("applyAccepts", "2");
                        this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
                        youMengPushDataBo.setExtra(map);
                        youMengPushDataBo.setCustom(JSON.toJSONString(map));
                        String expertVideoAppCode = this.getAppCode(consultationMdtEntity.getExpertHospitalId());
                        this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo);
                        goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
                        goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.VIDEO_ORDER_DISTRIBUTED.getValue());
                        goEasyPushDataBo.setUserId(expertInfoRespVO.getUserId());
                        this.pushInfoManagerUtils.goEasyPushData(expertVideoAppCode, goEasyPushDataBo);
                    }
                    break;
                }
                case 5: {
                    YouMengPushDataBo youMengPushDataBo1 = new YouMengPushDataBo();
                    youMengPushDataBo1.setText("\u60a8\u7533\u8bf7\u7684\u56fe\u6587\u4f1a\u8bca\u5df2\u5206\u914d" + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u4e13\u5bb6,\u4e13\u5bb6\u63a5\u8bca\u540e\u7acb\u5373\u5f00\u59cb,\u6301\u7eed24\u5c0f\u65f6,\u8bf7\u8010\u5fc3\u7b49\u5019\u4e13\u5bb6\u63a5\u8bca\u3002");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription(SMSAPPCODE);
                    youMengPushDataBo1.setPlayAction(SMSAPPCODE);
                    youMengPushDataBo1.setType("ychzMdt");
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo1.setTicker(SMSAPPCODE);
                    youMengPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    map.put("pushCode", HxgyPushCodeIntegerEnum.MTD_PHOTO_ORDER_DISTRIBUTED.getCode().toString());
                    map.put("applyAccepts", "1");
                    this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                    youMengPushDataBo1.setExtra(map);
                    youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                    String doctorTuwenAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
                    this.pushInfoManagerUtils.youmengPushDataByUserId(doctorTuwenAppCode, youMengPushDataBo1);
                    GoEasyPushDataBo goEasyPushDataBo1 = new GoEasyPushDataBo();
                    goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                    goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    goEasyPushDataBo1.setUserId(doctorInfoRespVO.getUserId());
                    this.pushInfoManagerUtils.goEasyPushData(doctorTuwenAppCode, goEasyPushDataBo1);
                    youMengPushDataBo1.setText("\u7ba1\u7406\u5458\u4e3a\u60a8\u5206\u914d\u4e86\u60a3\u8005" + consultationEntity.getPatientName() + "," + consultationEntity.getExpertHosName() + consultationEntity.getExpertDeptName() + consultationEntity.getExpertName() + "\u533b\u751f\u7684\u56fe\u6587\u4f1a\u8bca,\u8bf7\u505a\u67e5\u770b\u8be6\u60c5\u3002");
                    youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                    youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
                    youMengPushDataBo1.setDescription(SMSAPPCODE);
                    youMengPushDataBo1.setPlayAction(SMSAPPCODE);
                    youMengPushDataBo1.setTitle(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getDisplay());
                    youMengPushDataBo1.setTicker(SMSAPPCODE);
                    for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                        DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationMdtEntity.getExpertId());
                        youMengPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                        map.put("pushCode", HxgyPushCodeIntegerEnum.MTD_PHOTO_ORDER_DISTRIBUTED.getCode().toString());
                        map.put("applyAccepts", "2");
                        this.fillExtraMap(map, youMengPushDataBo1, consultationEntity);
                        youMengPushDataBo1.setExtra(map);
                        youMengPushDataBo1.setCustom(JSON.toJSONString(map));
                        String expertTuwenAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
                        this.pushInfoManagerUtils.youmengPushDataByUserId(expertTuwenAppCode, youMengPushDataBo1);
                        goEasyPushDataBo1.setBody(JSON.toJSONString((Object)youMengPushDataBo1));
                        goEasyPushDataBo1.setBusiCode(HxgyPushCenterEnum.PHOTO_ORDER_DISTRIBUTED.getValue());
                        goEasyPushDataBo1.setUserId(expertInfoRespVO.getUserId());
                        this.pushInfoManagerUtils.goEasyPushData(expertTuwenAppCode, goEasyPushDataBo1);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void pushToDoctor(ConsultationEntity consultationEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorInfoRespVO doctorInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getDoctorId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        try {
            if (patientInfoRespVO != null) {
                this.shortMessageManager.newConsultationToDoctor(consultationEntity.getViewId());
            }
            YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
            String sex = consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973";
            youMengPushDataBo.setText("\u60a3\u8005" + consultationEntity.getPatientName() + "," + sex + "\uff0c" + consultationExtendEntity.getPatientAge() + "\u5c81\uff0c\u5411\u60a8\u53d1\u6765\u4e00\u4e2a\u4f1a\u8bca\u7533\u8bf7\uff0c\u9080\u8bf7\u60a8\u5e2e\u5fd9\u7533\u8bf7\u5e76\u4e00\u540c\u53c2\u4e0e\u4e13\u5bb6\u4f1a\u8bca\uff0c\u8bf7\u7acb\u5373\u5904\u7406");
            youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getValue().toString());
            youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
            youMengPushDataBo.setDescription(SMSAPPCODE);
            youMengPushDataBo.setPlayAction(SMSAPPCODE);
            youMengPushDataBo.setType("ychzMdt");
            youMengPushDataBo.setTitle(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getDisplay());
            youMengPushDataBo.setTicker(SMSAPPCODE);
            youMengPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            map.put("pushCode", HxgyPushCodeIntegerEnum.PATIENT_ADD_ORDER.getCode().toString());
            map.put("applyAccepts", "1");
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            String doctorAppCode = this.getAppCode(consultationEntity.getDoctorHospitalId());
            this.pushInfoManagerUtils.youmengPushDataByUserId(doctorAppCode, youMengPushDataBo);
            GoEasyPushDataBo goEasyPushDataBo = new GoEasyPushDataBo();
            goEasyPushDataBo.setBody(JSON.toJSONString((Object)youMengPushDataBo));
            goEasyPushDataBo.setBusiCode(HxgyPushCenterEnum.PATIENT_ADD_ORDER.getValue().toString());
            goEasyPushDataBo.setUserId(doctorInfoRespVO.getUserId());
            this.pushInfoManagerUtils.goEasyPushData(doctorAppCode, goEasyPushDataBo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
        log.info("\u7ed9\u966a\u8bca\u533b\u751f\u53d1\u9001\u77ed\u4fe1\u6210\u529f=============");
    }
}

