/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdtconsultation;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSONObject;
import com.byh.constants.ConsultationConstant;
import com.byh.dao.allocation.BillInfoMapper;
import com.byh.dao.consultation.ConsultationExtendMapper;
import com.byh.dao.consultation.ConsultationMdtMapper;
import com.byh.dao.consultation.ConsultationReportMapper;
import com.byh.dao.consultation.OperationLogMapper;
import com.byh.dao.patient.PatientCaseInfoMapper;
import com.byh.enums.AllocationStatusEnum;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.ConfigurationEnum;
import com.byh.enums.ExpertReportEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.bo.consultation.ConsulationEntityDto;
import com.byh.pojo.entity.allocation.BillInfo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.MdtConsultationEntity;
import com.byh.pojo.entity.consultation.OperationLogEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.AppOrderListVo;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.mdtconsultation.MdtHosManageOrderVo;
import com.byh.pojo.vo.mdtconsultation.MdtListReqVO;
import com.byh.pojo.vo.mdtconsultation.MdtOrderDataVO;
import com.byh.pojo.vo.mdtconsultation.MdtReportDto;
import com.byh.pojo.vo.mdtconsultation.MdtWeChatListVo;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.util.CommonUtils;
import com.byh.util.CompleteUtils;
import com.byh.util.DateTimeUtil;
import com.byh.util.MdtUtil;
import com.byh.util.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsultationOrderProcess {
    private static final Logger log = LoggerFactory.getLogger(ConsultationOrderProcess.class);
    @Autowired
    private ConsultationExtendMapper consultationExtendMapper;
    @Autowired
    private ConsultationMdtMapper consultationMdtMapper;
    @Autowired
    private ConsultationReportMapper consultationReportMapper;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private OperationLogMapper operationLogMapper;
    @Autowired
    private BillInfoMapper billInfoMapper;
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;
    @Autowired
    private PatientCaseInfoMapper patientCaseInfoMapper;
    @Autowired
    private PatientInfoRemote patientInfoRemote;

    public List<MdtHosManageOrderVo> processManagerOrder(List<MdtConsultationEntity> consultationEntityList, String appCode) {
        ArrayList<MdtHosManageOrderVo> mdtHosManageOrderVoList = new ArrayList<MdtHosManageOrderVo>();
        for (MdtConsultationEntity consultation : consultationEntityList) {
            ConsultationExtendEntity consultationExtend = this.consultationExtendMapper.queryByConsultationId(consultation.getId());
            MdtHosManageOrderVo manageOrder = new MdtHosManageOrderVo();
            manageOrder.setIsMDT(MdtUtil.decideMdtDataType((Integer)consultation.getApplicationChannels()));
            manageOrder.setOrderId(consultation.getId());
            manageOrder.setOrderCreateTimeStr(DateUtil.format((Date)consultation.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            manageOrder.setOrderViewId(consultation.getViewId());
            manageOrder.setOrderStatus(consultation.getStatus());
            manageOrder.setOrderType(consultation.getType());
            manageOrder.setConsultationDate(CompleteUtils.judgeAvailableString((String)consultation.getConsultationDate()));
            manageOrder.setConsultationTime(CompleteUtils.judgeEmptyString((String)consultation.getConsultationTime()));
            manageOrder.setBeginTime(consultation.getBeginTime());
            manageOrder.setFinishTime(consultation.getFinishTime());
            manageOrder.setAcceptTime(consultation.getAcceptTime());
            manageOrder.setCloseTime(consultation.getClosedTime());
            manageOrder.setOrderPrice(consultationExtend.getPrice());
            manageOrder.setOrderApplicationChannels(consultation.getApplicationChannels());
            manageOrder.setGroupId(consultation.getGroupId());
            manageOrder.setOrderUpdateTime(consultation.getUpdateTime());
            manageOrder.setOrderVideoTime(consultationExtend.getVideoTime());
            manageOrder.setDistributionDescribe(consultation.getDistributionDescribe());
            manageOrder.setPatientId(consultation.getPatientId());
            manageOrder.setPatientName(consultation.getPatientName());
            manageOrder.setPatIdCard(consultationExtend.getPatientIdCard());
            manageOrder.setPatientSex(consultationExtend.getPatientSex());
            manageOrder.setPatientAge(consultationExtend.getPatientAge());
            manageOrder.setDocId(consultation.getDoctorId());
            manageOrder.setDocName(consultation.getDoctorName());
            manageOrder.setDocDepName(consultation.getDoctorDepName());
            manageOrder.setDoctorHospitalId(consultation.getDoctorHospitalId());
            manageOrder.setDocHosName(consultation.getDoctorHosName());
            manageOrder.setExpertId(CompleteUtils.judgeNullLong((Long)consultation.getExpertId()));
            manageOrder.setExpertName(CompleteUtils.judgeEmptyString((String)consultation.getExpertName()));
            manageOrder.setExpertDepName(CompleteUtils.judgeEmptyString((String)consultation.getExpertDeptName()));
            manageOrder.setExpertDeptName(CompleteUtils.judgeEmptyString((String)consultation.getExpertDeptName()));
            manageOrder.setExpertHosName(CompleteUtils.judgeEmptyString((String)consultation.getExpertHosName()));
            manageOrder.setExpertHospitalId(consultation.getExpertHospitalId());
            manageOrder.setPatientTel(CommonUtils.mobileEncrypt((String)consultationExtend.getPatientPhone()));
            manageOrder.setDocTel(CommonUtils.mobileEncrypt((String)consultationExtend.getDoctorPhone()));
            manageOrder.setExpertTel(CommonUtils.mobileEncrypt((String)consultationExtend.getExpertPhone()));
            manageOrder.setIsRefund(consultation.getIsRefund());
            manageOrder.setRefundStatus(consultation.getRefundStatus());
            this.setMdtInfo((Object)manageOrder, consultation.getViewId());
            if (consultation.getStatus() >= OrderStatusEnum.WAIT_DISTRIBUTION.getValue() && consultation.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue() && consultation.getExpertHospitalId() != 0L) {
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultation.getExpertHospitalId().intValue()));
                if (appCode.equalsIgnoreCase(expertAppCode)) {
                    manageOrder.setIsApply(Integer.valueOf(2));
                } else {
                    manageOrder.setIsApply(Integer.valueOf(1));
                }
            }
            mdtHosManageOrderVoList.add(manageOrder);
        }
        return mdtHosManageOrderVoList;
    }

    public List<MdtOrderDataVO> processConsultation(List<MdtOrderDataVO> consultationEntities) {
        ArrayList<MdtOrderDataVO> mdtOrderDataVOS = new ArrayList<MdtOrderDataVO>();
        if (CollectionUtils.isEmpty(consultationEntities)) {
            return mdtOrderDataVOS;
        }
        for (MdtOrderDataVO orderDataVO : consultationEntities) {
            OperationLogEntity logEntity;
            orderDataVO.setIsMDT(MdtUtil.decideMdtDataType((Integer)orderDataVO.getApplicationChannal()));
            if (OrderStatusEnum.FINISH.getValue().equals(orderDataVO.getOrderStatus()) && BaseStatusEnum.STATUS_INVALID.getValue().equals(orderDataVO.getQualified()) && (logEntity = this.operationLogMapper.getByBusinessCodeAndOrderViewId(ConfigurationEnum.VIDEO_VIWE.getValue(), orderDataVO.getOrderViewId())) != null && StringUtil.isNotBlank((String)logEntity.getRecordLog())) {
                List notQualifiedReson = Arrays.asList(logEntity.getRecordLog().split(",")).stream().filter(s -> s.trim().length() > 0).collect(Collectors.toList());
                orderDataVO.setNotQualifiedReson(notQualifiedReson);
            }
            orderDataVO.setIsAssign(Integer.valueOf(0));
            BillInfo billInfo = this.billInfoMapper.getByOrderId(Long.valueOf(orderDataVO.getOrderId()));
            if (billInfo != null && AllocationStatusEnum.HAVE_ALLOCATED.getValue().equals(billInfo.getAssignStatus())) {
                orderDataVO.setIsAssign(Integer.valueOf(1));
            }
            orderDataVO.setPatientPhone(CommonUtils.mobileEncrypt((String)orderDataVO.getPatientPhone()));
            orderDataVO.setDoctorPhone(CommonUtils.mobileEncrypt((String)orderDataVO.getDoctorPhone()));
            this.setMdtInfo((Object)orderDataVO, orderDataVO.getOrderViewId());
            mdtOrderDataVOS.add(orderDataVO);
        }
        return mdtOrderDataVOS;
    }

    public List<AppOrderListVo> processAppOrderList(List<ConsultationEntity> consultationEntities, Map<Long, ConsultationExtendEntity> extendEntityMap, Map<String, ConsultationReportEntity> reportEntityMap, Map<String, ConsultationMdtEntity> mdtEntityMap, Long doctorId) {
        ArrayList<AppOrderListVo> appOrderListVos = new ArrayList<AppOrderListVo>();
        for (ConsultationEntity entity : consultationEntities) {
            AppOrderListVo appOrderListVo = new AppOrderListVo();
            appOrderListVo.setIsMDT(MdtUtil.decideMdtDataType((Integer)entity.getApplicationChannels()));
            appOrderListVo.setPatientName(entity.getPatientName());
            ConsultationExtendEntity extendEntity = extendEntityMap.get(entity.getId());
            if (Objects.nonNull(extendEntity)) {
                appOrderListVo.setPatientAge(extendEntity.getPatientAge());
                appOrderListVo.setPatientSex(extendEntity.getPatientSex());
            }
            appOrderListVo.setOrderStatus(entity.getStatus());
            ConsultationMdtEntity consultationMdtEntity = mdtEntityMap.get(entity.getViewId());
            if (Objects.nonNull(consultationMdtEntity) && consultationMdtEntity.getStatus().equals(OrderStatusEnum.MDT_IS_ACCEPTS.getValue())) {
                appOrderListVo.setOrderStatus(Integer.valueOf(21));
            }
            Integer procedure = entity.getDoctorId().equals(doctorId) ? ConsultationConstant.TYPE_APPLY : ConsultationConstant.TYPE_RECEIVE;
            appOrderListVo.setProcedure(procedure);
            appOrderListVo.setOrderId(entity.getId());
            appOrderListVo.setOrderViewId(entity.getViewId());
            appOrderListVo.setOrderType(entity.getType());
            appOrderListVo.setGroupId(entity.getGroupId());
            appOrderListVo.setTencentRong(entity.getTencentRong());
            appOrderListVo.setApplicationChannal(entity.getApplicationChannels());
            if (StringUtil.isNotEmpty((String)entity.getClosedTime())) {
                appOrderListVo.setCloseTime(entity.getClosedTime());
            }
            appOrderListVo.setCreateTime(DateTimeUtil.formatTime((Date)entity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            appOrderListVo.setUpdateTime(DateTimeUtil.formatTime((Date)entity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            ConsultationReportEntity consultationReportEntity = reportEntityMap.get(entity.getViewId());
            Integer isHaveReport = Objects.isNull(consultationReportEntity) ? ConsultationConstant.NO_REPORT : ConsultationConstant.HAVE_REPORT;
            appOrderListVo.setIsHaveReport(isHaveReport);
            if (Objects.nonNull(consultationReportEntity) && ConsultationConstant.HAVE_REPORT.equals(isHaveReport)) {
                appOrderListVo.setReportStatus(consultationReportEntity.getStatus());
            }
            appOrderListVo.setDoctorName(entity.getDoctorName());
            appOrderListVo.setDoctorDeptName(entity.getDoctorDepName());
            appOrderListVo.setDoctorHosName(entity.getDoctorHosName());
            appOrderListVo.setDoctorId(entity.getDoctorId());
            String mainSuit = "";
            mainSuit = StringUtil.isNotEmpty((String)entity.getDynamicId()) && entity.getDynamicId().length() > 10 ? this.patientCaseMainSuit(entity.getDynamicId()) : this.patientCaseInfoMapper.selectById(entity.getCaseId()).getMainSuit();
            appOrderListVo.setMainSuit(mainSuit);
            appOrderListVo.setExpertName(CompleteUtils.judgeEmptyString((String)entity.getExpertName()));
            appOrderListVo.setExpertDeptName(CompleteUtils.judgeEmptyString((String)entity.getExpertDeptName()));
            appOrderListVo.setExpertHosName(CompleteUtils.judgeEmptyString((String)entity.getExpertHosName()));
            appOrderListVo.setStartTime(CompleteUtils.judgeEmptyString((String)entity.getBeginTime()));
            appOrderListVo.setEndTime(CompleteUtils.judgeEmptyString((String)entity.getFinishTime()));
            String consultationTime = CompleteUtils.judgeEmptyString((String)entity.getConsultationTime());
            appOrderListVo.setConsultationTime(CompleteUtils.judgeAvailableString((String)entity.getConsultationDate()) + " " + consultationTime);
            appOrderListVos.add(appOrderListVo);
        }
        return appOrderListVos;
    }

    public List<MdtHosManageOrderVo> processMdtHosManageOrderVoList(List<MdtConsultationEntity> consultationEntityList, MdtListReqVO mdtReq) {
        ArrayList<MdtHosManageOrderVo> mdtHosManageOrderVoList = new ArrayList<MdtHosManageOrderVo>();
        for (MdtConsultationEntity mdtConsultationEntity : consultationEntityList) {
            ConsultationReportEntity consultationReport;
            ConsultationMdtEntity consultationMdtEntity;
            log.debug("\u8ba2\u5355id:{}", (Object)mdtConsultationEntity.getId());
            ConsultationExtendEntity consultationExtend = this.consultationExtendMapper.queryByConsultationId(mdtConsultationEntity.getId());
            MdtHosManageOrderVo hosManageOrderDto = new MdtHosManageOrderVo();
            hosManageOrderDto.setIsMDT(MdtUtil.decideMdtDataType((Integer)mdtConsultationEntity.getApplicationChannels()));
            hosManageOrderDto.setOrderId(mdtConsultationEntity.getId());
            hosManageOrderDto.setOrderCreateTime(mdtConsultationEntity.getCreateTime().toString());
            String format = DateTimeUtil.formatTime((Date)mdtConsultationEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            hosManageOrderDto.setOrderCreateTimeStr(format);
            hosManageOrderDto.setOrderViewId(mdtConsultationEntity.getViewId());
            hosManageOrderDto.setOrderStatus(mdtConsultationEntity.getStatus());
            if (mdtReq.getIsSponsor() != 1 && mdtConsultationEntity.getStatus().equals(OrderStatusEnum.WAITING.getValue()) && (consultationMdtEntity = this.consultationMdtMapper.queryConsultationMdtList(mdtConsultationEntity.getViewId(), mdtReq.getDoctorId())) != null && consultationMdtEntity.getStatus().equals(OrderStatusEnum.MDT_IS_ACCEPTS.getValue())) {
                hosManageOrderDto.setOrderStatus(Integer.valueOf(21));
            }
            hosManageOrderDto.setOrderType(mdtConsultationEntity.getType());
            hosManageOrderDto.setConsultationDate(StringUtil.isNotEmpty((String)mdtConsultationEntity.getConsultationDate()) ? mdtConsultationEntity.getConsultationDate() : "\u6682\u65e0");
            hosManageOrderDto.setConsultationTime(StringUtil.isNotEmpty((String)mdtConsultationEntity.getConsultationDate()) ? mdtConsultationEntity.getConsultationTime() : "\u6682\u65e0");
            hosManageOrderDto.setBeginTime(mdtConsultationEntity.getBeginTime());
            hosManageOrderDto.setFinishTime(mdtConsultationEntity.getFinishTime());
            hosManageOrderDto.setAcceptTime(mdtConsultationEntity.getAcceptTime());
            hosManageOrderDto.setOrderPrice(consultationExtend.getPrice());
            hosManageOrderDto.setPatientId(mdtConsultationEntity.getPatientId());
            hosManageOrderDto.setPatientName(mdtConsultationEntity.getPatientName());
            hosManageOrderDto.setPatientSex(consultationExtend.getPatientSex());
            hosManageOrderDto.setPatientAge(consultationExtend.getPatientAge());
            hosManageOrderDto.setDocId(mdtConsultationEntity.getDoctorId());
            hosManageOrderDto.setDocDepName(mdtConsultationEntity.getDoctorDepName());
            hosManageOrderDto.setDocHosName(mdtConsultationEntity.getDoctorHosName());
            hosManageOrderDto.setExpertId(Long.valueOf(mdtConsultationEntity.getExpertId() == null ? 0L : mdtConsultationEntity.getExpertId()));
            if (mdtReq.getIsSponsor() == 1) {
                hosManageOrderDto.setExpertName(mdtConsultationEntity.getGetDoctor());
            } else {
                hosManageOrderDto.setDocName(mdtConsultationEntity.getGetDoctor());
            }
            hosManageOrderDto.setExpertDepName(CompleteUtils.judgeEmptyString((String)mdtConsultationEntity.getExpertDeptName()));
            hosManageOrderDto.setExpertHosName(CompleteUtils.judgeEmptyString((String)mdtConsultationEntity.getExpertHosName()));
            if (mdtConsultationEntity.getStatus().intValue() == OrderStatusEnum.FINISH.getValue().intValue() && (consultationReport = this.consultationReportMapper.queryConsultationReportEntityByViewId(mdtConsultationEntity.getViewId())) != null && consultationReport.getStatus() == 1) {
                hosManageOrderDto.setIsReport(Integer.valueOf(1));
            }
            hosManageOrderDto.setPatientTel(consultationExtend.getPatientPhone());
            String mainSuit = "";
            if (StringUtil.isNotEmpty((String)mdtConsultationEntity.getDynamicId()) && mdtConsultationEntity.getDynamicId().length() > 10) {
                mainSuit = this.patientCaseMainSuit(mdtConsultationEntity.getDynamicId());
            } else if (Objects.nonNull(mdtConsultationEntity.getCaseId())) {
                mainSuit = this.patientCaseInfoMapper.selectById(mdtConsultationEntity.getCaseId()).getMainSuit();
            }
            hosManageOrderDto.setPatCaseMainSuit(mainSuit);
            mdtHosManageOrderVoList.add(hosManageOrderDto);
        }
        return mdtHosManageOrderVoList;
    }

    public List<ConsulationEntityDto> processSuperOrder(List<MdtConsultationEntity> consultationEntityList) {
        ArrayList<ConsulationEntityDto> list = new ArrayList<ConsulationEntityDto>(consultationEntityList.size());
        for (MdtConsultationEntity mdtConsultationEntity : consultationEntityList) {
            ConsultationExtendEntity consultationExtend = this.consultationExtendMapper.queryByConsultationId(mdtConsultationEntity.getId());
            ConsulationEntityDto consulationEntityDto = new ConsulationEntityDto();
            consulationEntityDto.setIsMDT(MdtUtil.decideMdtDataType((Integer)mdtConsultationEntity.getApplicationChannels()));
            consulationEntityDto.setOrderId(mdtConsultationEntity.getId());
            consulationEntityDto.setOrderTime(mdtConsultationEntity.getCreateTime().toString());
            consulationEntityDto.setViewId(mdtConsultationEntity.getViewId());
            consulationEntityDto.setStatus(mdtConsultationEntity.getStatus());
            consulationEntityDto.setApplicationChannels(mdtConsultationEntity.getApplicationChannels());
            consulationEntityDto.setType(mdtConsultationEntity.getType());
            consulationEntityDto.setPrice(consultationExtend.getPrice());
            consulationEntityDto.setVideoTime(consultationExtend.getVideoTime());
            consulationEntityDto.setFinishTime(mdtConsultationEntity.getFinishTime());
            consulationEntityDto.setDistributionDescribe(mdtConsultationEntity.getDistributionDescribe());
            consulationEntityDto.setPatientName(mdtConsultationEntity.getPatientName());
            consulationEntityDto.setPatientSex(consultationExtend.getPatientSex());
            consulationEntityDto.setPatientAge(consultationExtend.getPatientAge());
            consulationEntityDto.setDoctorId(mdtConsultationEntity.getDoctorId());
            consulationEntityDto.setDoctorName(mdtConsultationEntity.getDoctorName());
            consulationEntityDto.setDoctorDepId(mdtConsultationEntity.getDoctorDepId());
            consulationEntityDto.setDoctorDetpName(mdtConsultationEntity.getDoctorDepName());
            consulationEntityDto.setDoctorHospitalId(mdtConsultationEntity.getDoctorHospitalId());
            consulationEntityDto.setDoctorHosName(mdtConsultationEntity.getDoctorHosName());
            consulationEntityDto.setExpertId(CompleteUtils.judgeNullLong((Long)mdtConsultationEntity.getExpertId()));
            consulationEntityDto.setExpertName(CompleteUtils.judgeEmptyString((String)mdtConsultationEntity.getExpertName()));
            consulationEntityDto.setExpertDepId(CompleteUtils.judgeNullLong((Long)mdtConsultationEntity.getExpertDepId()));
            consulationEntityDto.setExpertDeptName(CompleteUtils.judgeEmptyString((String)mdtConsultationEntity.getExpertDeptName()));
            consulationEntityDto.setExpertHospitalId(CompleteUtils.judgeNullLong((Long)mdtConsultationEntity.getExpertHospitalId()));
            consulationEntityDto.setExpertHosName(CompleteUtils.judgeEmptyString((String)mdtConsultationEntity.getExpertHosName()));
            this.setMdtInfo((Object)consulationEntityDto, mdtConsultationEntity.getViewId());
            list.add(consulationEntityDto);
        }
        return list;
    }

    public List<MdtWeChatListVo> processWeixinOrderList(List<MdtConsultationEntity> list) {
        ArrayList<MdtWeChatListVo> orderDetailList = new ArrayList<MdtWeChatListVo>();
        for (MdtConsultationEntity consultationEntity : list) {
            ConsultationExtendEntity consultationExtend = this.consultationExtendMapper.queryByConsultationId(consultationEntity.getId());
            MdtWeChatListVo orderDetailDto = new MdtWeChatListVo();
            orderDetailDto.setIsMDT(MdtUtil.decideMdtDataType((Integer)consultationEntity.getApplicationChannels()));
            orderDetailDto.setOrderId(consultationEntity.getId());
            orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
            orderDetailDto.setOrderViewId(consultationEntity.getViewId());
            orderDetailDto.setOrderStatus(consultationEntity.getStatus());
            orderDetailDto.setOrderType(consultationEntity.getType());
            orderDetailDto.setOrderPrice(consultationExtend.getPrice());
            orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
            orderDetailDto.setWeixinOrderUpdateTime(DateTimeUtil.formatTime((Date)consultationEntity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
            orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
            orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
            orderDetailDto.setConsultationDate(CompleteUtils.judgeAvailableString((String)consultationEntity.getConsultationDate()));
            orderDetailDto.setConsultationTime(CompleteUtils.judgeEmptyString((String)consultationEntity.getConsultationDate()));
            orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
            orderDetailDto.setPatientId(consultationEntity.getPatientId());
            orderDetailDto.setPatientName(consultationEntity.getPatientName());
            orderDetailDto.setPatientSex(consultationExtend.getPatientSex());
            orderDetailDto.setPatientAge(consultationExtend.getPatientAge());
            orderDetailDto.setPatIdCard(consultationExtend.getPatientIdCard());
            orderDetailDto.setDocId(consultationEntity.getDoctorId());
            orderDetailDto.setDocName(consultationEntity.getDoctorName());
            orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
            orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
            orderDetailDto.setExpertName(consultationEntity.getGetDoctor());
            orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
            orderDetailDto.setExpertDepName(CompleteUtils.judgeEmptyString((String)consultationEntity.getExpertDeptName()));
            orderDetailDto.setExpertHosName(CompleteUtils.judgeEmptyString((String)consultationEntity.getExpertHosName()));
            orderDetailDto.setPatientTel(consultationExtend.getPatientPhone());
            PatientCaseInfoEntity PatientCaseInfoDTO2 = this.patientCaseInfoMapper.selectById(consultationEntity.getCaseId());
            if (PatientCaseInfoDTO2 != null) {
                orderDetailDto.setPatCaseMainSuit(PatientCaseInfoDTO2.getMainSuit());
            }
            String mainSuit = "";
            mainSuit = StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10 ? this.patientCaseMainSuit(consultationEntity.getDynamicId()) : this.patientCaseInfoMapper.selectById(consultationEntity.getCaseId()).getMainSuit();
            orderDetailDto.setPatCaseMainSuit(mainSuit);
            orderDetailList.add(orderDetailDto);
        }
        return orderDetailList;
    }

    public MdtReportDto getConsultationReportDto(ConsultationEntity consultationEntity) {
        ConsultationReportEntity consultationReportEntity;
        MdtReportDto consultationReportDto = new MdtReportDto();
        ConsultationExtendEntity consultationExtend = this.consultationExtendMapper.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtend == null) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728=======");
            return null;
        }
        this.buildOrderInfo(consultationEntity, consultationReportDto);
        this.buildPersonInfo(consultationEntity, consultationExtend, consultationReportDto);
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        if (Objects.isNull(consultationReportEntity = this.consultationReportMapper.queryConsultationReportEntityByViewId1(consultationEntity.getViewId()))) {
            log.info("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728===\u8ba2\u5355id\u662f:{}", (Object)consultationEntity.getId());
            return null;
        }
        consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
        consultationReportDto.setSignature(consultationReportEntity.getSignature());
        consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
        return consultationReportDto;
    }

    private void buildPersonInfo(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtend, MdtReportDto consultationReportDto) {
        consultationReportDto.setReportCreateTime(consultationEntity.getCreateTime());
        consultationReportDto.setReportUpdateTime(consultationEntity.getUpdateTime());
        consultationReportDto.setPatientId(consultationEntity.getPatientId());
        consultationReportDto.setPatientName(consultationEntity.getPatientName());
        consultationReportDto.setPatientSex(consultationExtend.getPatientSex());
        consultationReportDto.setPatientAge(consultationExtend.getPatientAge());
        consultationReportDto.setPatIdCard(consultationExtend.getPatientIdCard());
        consultationReportDto.setDocId(consultationEntity.getDoctorId());
        consultationReportDto.setDocName(consultationEntity.getDoctorName());
        consultationReportDto.setDocDepName(consultationEntity.getDoctorDepName());
        consultationReportDto.setDocHosName(consultationEntity.getDoctorHosName());
        consultationReportDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        consultationReportDto.setExpertName(CompleteUtils.judgeEmptyString((String)consultationEntity.getExpertName()));
        consultationReportDto.setExpertDepName(CompleteUtils.judgeEmptyString((String)consultationEntity.getExpertDeptName()));
        consultationReportDto.setExpertHosName(CompleteUtils.judgeEmptyString((String)consultationEntity.getExpertHosName()));
    }

    public <T> void setMdtInfo(T t, String viewId) {
        List reportList = this.consultationReportMapper.queryMdtByOrderViewId(viewId);
        List mdtExpertList = this.consultationMdtMapper.getMdtExpertInfoByOrderViewId(viewId);
        String expertBaseInfo = "";
        boolean uploadReport = false;
        Integer isMDT = (Integer)ReflectUtil.getFieldValue(t, (String)"isMDT");
        if (isMDT == 1 && CollectionUtils.isNotEmpty((Collection)mdtExpertList)) {
            uploadReport = CollectionUtils.isNotEmpty((Collection)reportList) && reportList.size() == mdtExpertList.size() && reportList.stream().allMatch(e -> OrderStatusEnum.REPORT_ONLINE.getValue().equals(e.getStatus()));
            expertBaseInfo = mdtExpertList.stream().collect(Collectors.joining(","));
        } else if (isMDT == 0) {
            uploadReport = CollectionUtils.isNotEmpty((Collection)reportList) && ((ConsultationReportEntity)reportList.get(0)).getStatus().intValue() == OrderStatusEnum.REPORT_ONLINE.getValue().intValue();
            String expertName = (String)ReflectUtil.getFieldValue(t, (String)"expertName");
            String expertDeptName = (String)ReflectUtil.getFieldValue(t, (String)"expertDeptName");
            String expertHosName = (String)ReflectUtil.getFieldValue(t, (String)"expertHosName");
            expertBaseInfo = CompleteUtils.judeProvisionalString((String)expertHosName) + "/" + CompleteUtils.judeProvisionalString((String)expertDeptName) + "/" + CompleteUtils.judeProvisionalString((String)expertName);
        }
        if (uploadReport) {
            if (ReflectUtil.hasField(t.getClass(), (String)"existReport")) {
                BeanUtil.setFieldValue(t, (String)"existReport", (Object)1);
            } else if (ReflectUtil.hasField(t.getClass(), (String)"isReport")) {
                BeanUtil.setFieldValue(t, (String)"isReport", (Object)1);
            }
        }
        if (ReflectUtil.hasField(t.getClass(), (String)"expertBaseInfo")) {
            BeanUtil.setFieldValue(t, (String)"expertBaseInfo", (Object)expertBaseInfo);
        } else if (ReflectUtil.hasField(t.getClass(), (String)"mdtData")) {
            BeanUtil.setFieldValue(t, (String)"mdtData", (Object)expertBaseInfo);
        }
    }

    public String patientCaseMainSuit(String dynamicId) {
        JSONObject json;
        log.info("dynamicId:{}", (Object)dynamicId);
        String medicalDetail = "";
        String mainSuit = "";
        PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
        patientDynamicMedicalIdVo.setId(dynamicId);
        BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
        if (response.getCode().equals("1") && response.getData() != null) {
            medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
        }
        if (Objects.nonNull(json = JSONObject.parseObject((String)medicalDetail))) {
            Set sets = json.keySet();
            for (String str : sets) {
                if (!"mainSuit".equals(str)) continue;
                mainSuit = json.get((Object)"mainSuit").toString();
            }
        }
        return mainSuit;
    }

    public List<MdtReportDto> processReport(List<ConsultationEntity> consultationList, Long doctorId) {
        ConsultationEntity consultation;
        ConsultationExtendEntity consultationExtend;
        ArrayList<MdtReportDto> list = new ArrayList<MdtReportDto>(consultationList.size());
        Iterator<ConsultationEntity> iterator = consultationList.iterator();
        while (iterator.hasNext() && (consultationExtend = this.consultationExtendMapper.queryByConsultationId((consultation = iterator.next()).getId())) != null) {
            MdtReportDto consultationReportDto = new MdtReportDto();
            this.buildOrderInfo(consultation, consultationReportDto);
            consultationReportDto.setPatientId(consultation.getPatientId());
            consultationReportDto.setPatientName(consultation.getPatientName());
            consultationReportDto.setPatientSex(consultationExtend.getPatientSex());
            consultationReportDto.setPatientAge(consultationExtend.getPatientAge());
            PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultation.getPatientId(), consultation.getDoctorHospitalId());
            if (patientInfoRespVO != null) {
                consultationReportDto.setPatIdCard(patientInfoRespVO.getCredNo());
                consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
            }
            consultationReportDto.setDocId(consultation.getDoctorId());
            consultationReportDto.setDocName(consultation.getDoctorName());
            consultationReportDto.setDocDepName(consultation.getDoctorDepName());
            consultationReportDto.setDocHosName(consultation.getDoctorHosName());
            consultationReportDto.setExpertId(Long.valueOf(consultation.getExpertId() == null ? 0L : consultation.getExpertId()));
            consultationReportDto.setExpertName(CompleteUtils.judgeEmptyString((String)consultation.getExpertName()));
            consultationReportDto.setExpertDepName(CompleteUtils.judgeEmptyString((String)consultation.getExpertDeptName()));
            consultationReportDto.setExpertHosName(CompleteUtils.judgeEmptyString((String)consultation.getExpertHosName()));
            if (consultationReportDto.getIsMDT() == 1) {
                List consultationMdtList;
                consultationReportDto.setIsWriteDisplay(ExpertReportEnum.REPORT_TO_BE_SUBMITTED.getDisplay());
                if (consultation.getReportStatus() == 1) {
                    consultationReportDto.setIsWriteDisplay(ExpertReportEnum.ALL_REPORTS_SUBMITTED.getDisplay());
                } else if (consultation.getReportStatus() == 0 && CollectionUtils.isNotEmpty((Collection)(consultationMdtList = this.consultationMdtMapper.getConsultationMdtListByOrderViewId(consultation.getViewId()))) && consultationMdtList.stream().anyMatch(a -> doctorId.equals(a.getExpertId()) && OrderStatusEnum.MDT_UP_REPORT.getValue().equals(a.getStatus()))) {
                    consultationReportDto.setIsWriteDisplay(ExpertReportEnum.TO_BE_SUBMITTED_BY_OTHERS.getDisplay());
                }
            } else {
                ConsultationReportEntity consultationReportEntity = this.consultationReportMapper.queryConsultationReportEntityByViewId(consultation.getViewId());
                if (consultationReportEntity == null) {
                    consultationReportDto.setIsWrite(ExpertReportEnum.REPORT_TO_BE_SUBMITTED.getValue());
                    consultationReportDto.setIsWriteDisplay(ExpertReportEnum.REPORT_TO_BE_SUBMITTED.getDisplay());
                } else {
                    consultationReportDto.setIsWrite(ExpertReportEnum.ALL_REPORTS_SUBMITTED.getValue());
                    consultationReportDto.setIsWriteDisplay(ExpertReportEnum.ALL_REPORTS_SUBMITTED.getDisplay());
                    consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
                    consultationReportDto.setSignature(consultationReportEntity.getSignature());
                    consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
                    consultationReportDto.setReportCreateTime(consultationReportEntity.getCreateTime());
                    consultationReportDto.setReportUpdateTime(consultationReportEntity.getUpdateTime());
                    consultationReportDto.setReportStatus(consultationReportEntity.getStatus());
                }
            }
            list.add(consultationReportDto);
        }
        return list;
    }

    private void buildOrderInfo(ConsultationEntity consultation, MdtReportDto consultationReportDto) {
        consultationReportDto.setIsMDT(MdtUtil.decideMdtDataType((Integer)consultation.getApplicationChannels()));
        consultationReportDto.setOrderId(consultation.getId());
        consultationReportDto.setOrderViewId(consultation.getViewId());
        consultationReportDto.setOrderBeginTime(consultation.getBeginTime());
        consultationReportDto.setOrderFinishTime(consultation.getFinishTime());
        consultationReportDto.setConsultationDate(CompleteUtils.judgeAvailableString((String)consultation.getConsultationDate()));
        consultationReportDto.setConsultationTime(CompleteUtils.judgeEmptyString((String)consultation.getConsultationTime()));
        consultationReportDto.setOrderType(consultation.getType());
        consultationReportDto.setDate(consultation.getBeginTime() + " \u81f3 " + consultation.getFinishTime());
    }
}

