/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdtconsultation;

import com.byh.common.ResultInfo;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.manage.consultation.OrderPayManage;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.TRTCManage;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.manage.mdt.MdtWebAndAppMessageManager;
import com.byh.pojo.dto.pay.RefundVo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.byh.pojo.vo.mdtconsultation.CancelOrderMdtVo;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdtClinicManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtClinicManager.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ProgramMessageManager programMessageManager;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private MdtWebAndAppMessageManager mdtWebAndAppMessageManager;
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private CommonService commonService;

    public ResultInfo finishConsultaion(String orderViewId, Long doctorId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity != null) {
            if (!consultationEntity.getDoctorId().equals(doctorId)) {
                return this.returnFailure("\u7ed3\u675f\u4f1a\u8bca\u8005\u4e0d\u662f\u7533\u8bf7\u533b\u751f");
            }
            int value = this.mdtConsultationService.updateOrderFinishTimeById(consultationEntity.getId(), DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), OrderStatusEnum.FINISH.getValue());
            if (value > 0) {
                try {
                    this.mdtWebAndAppMessageManager.remindExpertWriteReportNews(consultationEntity.getViewId(), doctorId);
                    this.programMessageManager.finishOrderPush(consultationEntity);
                    if (StringUtils.isNotEmpty((CharSequence)consultationEntity.getGroupId())) {
                        this.commonService.tencentDestroyGroupMsg(consultationEntity);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnFailure("orderViewId\u4e0d\u6b63\u786e");
    }

    public ResultInfo startConsultation(String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity != null) {
            if (consultationEntity.getType().intValue() != OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                return this.returnFailure("\u4f1a\u8bca\u5f62\u5f0f\u4e0d\u662f\u89c6\u9891");
            }
            String systemTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            String startTime = consultationEntity.getBeginTime();
            if (StringUtil.isBlank((String)startTime)) {
                startTime = systemTime;
                int value = this.mdtConsultationService.updateOrderBeginTimeById(consultationEntity.getId(), startTime);
                if (value > 0) {
                    try {
                        consultationEntity.setBeginTime(startTime);
                        this.mdtWebAndAppMessageManager.startConsultationSendMessage(consultationEntity);
                        this.mdtWebAndAppMessageManager.consultationStartedToDoctor(consultationEntity);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("startTime", startTime);
                    map.put("systemTime", systemTime);
                    return this.returnSucceed(map, ReturnCodeEnum.SUCCEED.getDisplay());
                }
                return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
            }
            return this.returnSucceed("ok");
        }
        return this.returnFailure("orderViewId\u4e0d\u6b63\u786e");
    }

    public ResultInfo orderExpertAccept(String orderViewId, Long expertId, Integer type) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity == null) {
            return this.returnFailure("orderViewId\u4e0d\u6b63\u786e");
        }
        if (consultationEntity.getStatus().intValue() != OrderStatusEnum.WAITING.getValue().intValue()) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u5f85\u63a5\u8bca\uff0c\u4e0d\u80fd\u63a5\u8bca");
        }
        List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
        if (consultationMdtEntityList == null || consultationMdtEntityList.size() == 0) {
            log.error("\u591a\u5b66\u79d1\u63a5\u8bca\u5931\u8d25,\u8be5\u8ba2\u5355\u4e0d\u652f\u6301MDT:{}", (Object)consultationEntity.getViewId());
            return this.returnFailure("\u591a\u5b66\u79d1\u63a5\u8bca\u5931\u8d25,\u8be5\u8ba2\u5355\u4e0d\u652f\u6301MDT");
        }
        this.updateForExpertAccept(consultationEntity, expertId, type);
        try {
            String acceptTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            this.mdtWebAndAppMessageManager.expertAcceptPush(consultationEntity, acceptTime);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return this.returnSucceed("\u8be5\u4e13\u5bb6\u5df2\u63a5\u8bca");
    }

    @Transactional(rollbackFor={Exception.class})
    void updateForExpertAccept(ConsultationEntity consultationEntity, Long expertId, Integer type) {
        Date date = new Date();
        String acceptTime = DateTimeUtil.formatTime((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        int j = this.mdtConsultationService.updateConsultationMdtForAccept(consultationEntity.getViewId(), expertId, OrderStatusEnum.MDT_IS_ACCEPTS.getValue(), acceptTime);
        if (j == 0) {
            log.error("\u591a\u5b66\u79d1\u63a5\u8bca\u5931\u8d25,viewId:{},expertId:{}", (Object)consultationEntity.getViewId(), (Object)expertId);
            throw new RuntimeException();
        }
        List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
        if (consultationMdtEntityList == null || consultationMdtEntityList.size() == 0) {
            log.error("\u591a\u5b66\u79d1\u63a5\u8bca\u5931\u8d25,\u8ba2\u5355viewId\u65e0MDT\u6570\u636e:{}", (Object)consultationEntity.getViewId());
            throw new RuntimeException();
        }
        if (consultationMdtEntityList.stream().allMatch(a -> OrderStatusEnum.MDT_IS_ACCEPTS.getValue().equals(a.getStatus()))) {
            int i = 0;
            if (type.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                RtcRoomEntity roomEntity;
                i = this.consultationService.updateConsultationEntityByIdStatus(consultationEntity.getId(), OrderStatusEnum.RUNNING.getValue(), acceptTime);
                if (consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue() && (roomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType())) == null) {
                    this.trtcManage.saveRtcRoomId(consultationEntity.getId());
                }
            } else if (type.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
                String consultationDate = DateTimeUtil.formatTime((Date)date, (String)"yyyy-MM-dd");
                String consultationTime = DateTimeUtil.formatTime((Date)date, (String)"HH:mm:ss");
                i = this.consultationService.updateAcceptConsultationTuwen(consultationEntity.getId(), OrderStatusEnum.RUNNING.getValue(), acceptTime, consultationDate, consultationTime);
            }
            if (i == 0) {
                log.error("\u591a\u5b66\u79d1\u63a5\u8bca\u4e3b\u8868\u4fee\u6539\u5931\u8d25,\u5165\u53c2:{}", (Object)consultationEntity.getId());
                throw new RuntimeException();
            }
        }
    }

    public ResultInfo<String> cancelOrder(CancelOrderMdtVo cancelOrderMdtVo) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(cancelOrderMdtVo.getOrderViewId());
        if (consultationEntity == null) {
            return this.returnFailure("orderViewId\u4e0d\u6b63\u786e");
        }
        int status = consultationEntity.getStatus();
        if (status == OrderStatusEnum.CANCEL.getValue()) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88,\u8bf7\u52ff\u91cd\u590d\u53d6\u6d88");
        }
        if (status == OrderStatusEnum.RUNNING.getValue() || status == OrderStatusEnum.FINISH.getValue()) {
            return this.returnFailure("\u8fdb\u884c\u4e2d\u6216\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88");
        }
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        switch (cancelOrderMdtVo.getCloserType()) {
            case 201: {
                if (status > 0 && status < OrderStatusEnum.WAITING.getValue() && cancelOrderMdtVo.getCloserId().equals(consultationEntity.getPatientId())) {
                    this.updateOrderForClose(cancelOrderMdtVo, consultationEntity);
                    if (status > OrderStatusEnum.UN_PAY.getValue()) {
                        RefundVo refundVo = new RefundVo();
                        refundVo.setOrderViewId(consultationEntity.getViewId());
                        if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() != consultationEntity.getApplicationChannels().intValue() && consultationExtendEntity.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                            this.orderPayManage.refund(refundVo);
                        }
                    }
                    try {
                        this.messagePush(consultationEntity);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    return this.returnSucceed("\u4fee\u6539\u6210\u529f");
                }
                return this.returnFailure("\u8be5\u8ba2\u5355\u65e0\u6cd5\u53d6\u6d88");
            }
            case 205: {
                if (consultationEntity.getDoctorId().intValue() == cancelOrderMdtVo.getCloserId().intValue()) {
                    if (status > 0 && status < OrderStatusEnum.WAITING.getValue() && status != OrderStatusEnum.NEW_APPLY.getValue()) {
                        this.updateOrderForClose(cancelOrderMdtVo, consultationEntity);
                        if (status > OrderStatusEnum.UN_PAY.getValue()) {
                            RefundVo refundVo = new RefundVo();
                            refundVo.setOrderViewId(consultationEntity.getViewId());
                            if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() != consultationEntity.getApplicationChannels().intValue() && consultationExtendEntity.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                                this.orderPayManage.refund(refundVo);
                            }
                        }
                        return this.returnSucceed("\u4fee\u6539\u6210\u529f");
                    }
                    try {
                        this.messagePush(consultationEntity);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                    break;
                }
                return this.returnFailure("\u65e0\u53d6\u6d88\u8ba2\u5355\u64cd\u4f5c");
            }
            case 203: {
                if (status <= 0 || status >= OrderStatusEnum.RUNNING.getValue()) break;
                this.updateOrderForClose(cancelOrderMdtVo, consultationEntity);
                if (status > OrderStatusEnum.UN_PAY.getValue()) {
                    RefundVo refundVo = new RefundVo();
                    refundVo.setOrderViewId(consultationEntity.getViewId());
                    if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() != consultationEntity.getApplicationChannels().intValue() && consultationExtendEntity.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                        this.orderPayManage.refund(refundVo);
                    }
                }
                try {
                    this.messagePush(consultationEntity);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                return this.returnSucceed("\u4fee\u6539\u6210\u529f");
            }
            default: {
                return this.returnFailure("closerType\u4e0d\u6b63\u786e");
            }
        }
        return this.returnFailure("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
    }

    @Async
    public void messagePush(ConsultationEntity consultationEntity) {
        try {
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            this.shortMessageManager.cancelConsultationApply(consultationEntity.getViewId(), consultationExtendEntity.getCloseReason());
            this.shortMessageManager.cancelConsultationToDoctor(consultationEntity.getViewId());
            this.webAndAppMessageManager.cancellationOfConsultationSendMessage(consultationEntity, consultationExtendEntity.getCloseReason());
            this.programMessageManager.cancelOrderPush(consultationEntity, consultationExtendEntity, consultationEntity.getClosedTime());
            if (StringUtils.isNotEmpty((CharSequence)consultationEntity.getGroupId())) {
                this.commonService.tencentDestroyGroupMsg(consultationEntity);
            }
        }
        catch (Exception e) {
            log.error("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u63a8\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void updateOrderForClose(CancelOrderMdtVo cancelOrderMdtVo, ConsultationEntity consultationEntity) {
        String closeTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        int i = this.consultationService.updateOrderStatusByOrderIdAndClose(consultationEntity.getId(), closeTime);
        if (i == 0) {
            log.error("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u4e3b\u8868\u4fee\u6539\u5931\u8d25,\u5165\u53c2:{}", (Object)cancelOrderMdtVo.toString());
            throw new RuntimeException();
        }
        int j = this.consultationExtendService.updateCloseIdAndCloseTypeAndCloseReason(cancelOrderMdtVo.getCloserId(), cancelOrderMdtVo.getCloserType(), cancelOrderMdtVo.getCancelReason(), consultationEntity.getId());
        if (j == 0) {
            log.error("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u6269\u5c55\u8868\u4fee\u6539\u5931\u8d25,\u5165\u53c2:{}", (Object)cancelOrderMdtVo.toString());
            throw new RuntimeException();
        }
    }
}

