/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.mdtconsultation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.common.ResultInfo;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.dao.consultation.ConsultationExtendMapper;
import com.byh.dao.consultation.ConsultationMapper;
import com.byh.dao.consultation.ConsultationMdtMapper;
import com.byh.dao.consultation.ConsultationReportMapper;
import com.byh.dao.consultation.ServicePayBillMapper;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.ConsultationOrderStatusEnum;
import com.byh.enums.ExpertReportEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.manage.mdtconsultation.ConsultationOrderProcess;
import com.byh.pojo.dto.pay.RefundHttpVo;
import com.byh.pojo.entity.BaseEntity;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.ServiceMerchantConfigEntity;
import com.byh.pojo.entity.consultation.ServicePayBillEntity;
import com.byh.pojo.vo.consultation.AppOrderListVo;
import com.byh.pojo.vo.consultation.OrderReqVo;
import com.byh.pojo.vo.consultation.OrganizationResVO;
import com.byh.pojo.vo.consultation.req.AdminAuditConsultationReqVo;
import com.byh.pojo.vo.consultation.req.AdminRefundConsultationReqVo;
import com.byh.pojo.vo.consultation.res.UserRefundRespVo;
import com.byh.pojo.vo.mdtconsultation.AdminMdtListReqVO;
import com.byh.pojo.vo.mdtconsultation.CancelOrderMdtVo;
import com.byh.pojo.vo.mdtconsultation.DoctorOrderConsultationVo;
import com.byh.pojo.vo.mdtconsultation.DoctorReportListReqVo;
import com.byh.pojo.vo.mdtconsultation.ManagerMdtReqVO;
import com.byh.pojo.vo.mdtconsultation.MdtConsultationDataInfoVO;
import com.byh.pojo.vo.mdtconsultation.MdtHosManageOrderVo;
import com.byh.pojo.vo.mdtconsultation.MdtListReqVO;
import com.byh.pojo.vo.mdtconsultation.MdtOrderDataVO;
import com.byh.pojo.vo.mdtconsultation.MdtReportDto;
import com.byh.pojo.vo.mdtconsultation.MdtWeChatListVo;
import com.byh.pojo.vo.mdtconsultation.SuperOrderConsultationVo;
import com.byh.remotecall.IhosBaseDataRemote;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ServiceMerchantConfigService;
import com.byh.service.cosultation.ServicePayBillService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.CompleteUtils;
import com.byh.util.DateTimeUtil;
import com.byh.util.HttpUtils;
import com.byh.util.SignUtil;
import com.byh.util.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdtConsultationManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtConsultationManager.class);
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private IhosBaseDataRemote ihosBaseDataRemote;
    @Autowired
    private ConsultationExtendMapper consultationExtendMapper;
    @Autowired
    private ConsultationMdtMapper consultationMdtMapper;
    @Autowired
    private ConsultationReportMapper consultationReportMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ConsultationMapper consultationMapper;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ServiceMerchantConfigService serviceMerchantConfigService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ConsultationOrderProcess consultationOrderProcess;

    public ResultInfo<List<MdtReportDto>> queryConsultationReportByPatient(Long patientId, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.mdtConsultationService.queryConsultationEntityByPatientId(patientId);
        if (consultationEntityList == null || consultationEntityList.size() == 0) {
            log.info("\u8be5\u60a3\u8005\u4f1a\u8bca\u62a5\u544a\u5217\u8868\u672a\u67e5\u5230\u6570\u636e===========" + patientId);
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        ArrayList<MdtReportDto> list = new ArrayList<MdtReportDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            MdtReportDto mdtReportDto = this.consultationOrderProcess.getConsultationReportDto(consultationEntity);
            if (mdtReportDto == null) {
                log.info("\u8be5\u8ba2\u5355\u65e0\u4f1a\u8bca\u62a5\u544a=====" + consultationEntity.getViewId());
                continue;
            }
            mdtReportDto.setIsWriteDisplay(ExpertReportEnum.ALL_REPORTS_SUBMITTED.getDisplay());
            list.add(mdtReportDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<List<MdtReportDto>> queryConsultationReportByDoctorId(DoctorReportListReqVo reqVo) {
        PageHelper.startPage((int)reqVo.getPageIndex(), (int)reqVo.getPageSize());
        List consultationEntityList = this.mdtConsultationService.queryConsultationListByDocIdAndType(reqVo.getDoctorId(), reqVo.getType(), reqVo.getSearch());
        if (CollectionUtils.isEmpty((Collection)consultationEntityList)) {
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        List list = this.consultationOrderProcess.processReport(consultationEntityList, reqVo.getDoctorId());
        return this.returnSucceed((Object)list, "\u6210\u529f");
    }

    public List<MdtWeChatListVo> getWeixinOrderListByPatientId(String appCode, Integer pageIndex, Integer pageSize, Long patientId) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List list = this.mdtConsultationService.getListByPatientId(patientId, appCode);
        List orderDetailList = this.consultationOrderProcess.processWeixinOrderList(list);
        return orderDetailList;
    }

    public List<MdtWeChatListVo> getWeixinOrderListByUserId(String appCode, Integer pageIndex, Integer pageSize, Long userId) {
        List orderDetailDtos = null;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List patientInfoListRespVOList = this.userCenterRemote.getUserBindPatientList(appCode, userId.toString());
        if (CollectionUtils.isNotEmpty((Collection)patientInfoListRespVOList)) {
            List patientStrList = patientInfoListRespVOList.stream().map(queryPatientInfoListRespVO -> Long.parseLong(queryPatientInfoListRespVO.getPatientId())).collect(Collectors.toList());
            List list = this.mdtConsultationService.getListByPatientIds(patientStrList, appCode);
            orderDetailDtos = this.consultationOrderProcess.processWeixinOrderList(list);
        }
        return orderDetailDtos;
    }

    public List<MdtConsultationDataInfoVO> superAdminExportDataInfo(String ids, String search, Integer type, Integer status, Integer timeType, String beginTime, String endTime, Integer qualified, Integer applicationChannels) {
        List consultationDataInfoVOS = null;
        beginTime = StringUtil.isNotBlank((String)beginTime) ? beginTime + " 00:00:00" : "";
        String string = endTime = StringUtil.isNotBlank((String)endTime) ? endTime + " 23:59:59" : "";
        if (StringUtil.isNotEmpty((String)ids)) {
            List idList = Arrays.asList(ids.trim().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            consultationDataInfoVOS = this.mdtConsultationService.getExcelOrderData(timeType, beginTime, endTime, search, type, status, qualified, null, idList, applicationChannels);
        } else {
            consultationDataInfoVOS = this.mdtConsultationService.getExcelOrderData(timeType, beginTime, endTime, search, type, status, qualified, null, null, applicationChannels);
        }
        return consultationDataInfoVOS;
    }

    public Map<String, Object> superAdminOrderData(ManagerMdtReqVO mdtReqVO) {
        mdtReqVO.setBeginTime(CompleteUtils.compleBeginTime((String)mdtReqVO.getBeginTime()));
        mdtReqVO.setEndTime(CompleteUtils.compleEndTime((String)mdtReqVO.getEndTime()));
        Integer pageIndex = (mdtReqVO.getPageIndex() - 1) * mdtReqVO.getPageSize();
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(mdtReqVO.getPageSize());
        mdtReqVO.setIsMdt(Integer.valueOf(1));
        List orderDataVOList = this.consultationMdtMapper.getMdtOrderData(mdtReqVO, null);
        Long total = this.consultationMdtMapper.countMdtOrderData(mdtReqVO, null);
        int qualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_VALID.getValue());
        int notQualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_INVALID.getValue());
        Map objectMap = this.pageHelper(mdtReqVO, orderDataVOList, total, qualifiedOrderCount, notQualifiedOrderCount);
        return objectMap;
    }

    private Map<String, Object> pageHelper(ManagerMdtReqVO mdtReqVO, List<MdtOrderDataVO> orderDataVOList, Long total, int qualifiedOrderCount, int notQualifiedOrderCount) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        List consultationList = this.consultationOrderProcess.processConsultation(orderDataVOList);
        objectMap.put("data", consultationList);
        objectMap.put("total", total);
        objectMap.put("qualifiedOrderCount", qualifiedOrderCount);
        objectMap.put("notQualifiedOrderCount", notQualifiedOrderCount);
        objectMap.put("currentPage", mdtReqVO.getPageIndex());
        objectMap.put("pageSize", mdtReqVO.getPageSize());
        double c = (double)total.longValue() / (double)mdtReqVO.getPageSize().intValue();
        int pageNum = (int)Math.ceil(c);
        objectMap.put("pageNum", pageNum);
        return objectMap;
    }

    public List<MdtConsultationDataInfoVO> exportConsultationDataInfo(String ids, String appCode, String search, Integer orderType, Integer orderStatus, Integer timeType, String beginTime, String endTime, String userId, Integer qualified, Integer applicationChannels) {
        List consultationDataInfoVOS = null;
        beginTime = StringUtil.isNotBlank((String)beginTime) ? beginTime + " 00:00:00" : "";
        String string = endTime = StringUtil.isNotBlank((String)endTime) ? endTime + " 23:59:59" : "";
        if (StringUtil.isNotEmpty((String)ids)) {
            List idList = Arrays.asList(ids.trim().split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            consultationDataInfoVOS = this.mdtConsultationService.getExcelOrderData(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, null, idList, applicationChannels);
        } else {
            log.info("====\u7ba1\u7406\u5e73\u53f0\u53d6\u5230\u7684userId\u662f:{},\u53d6\u5230\u7684appCode\u662f:{}", (Object)userId, (Object)appCode);
            List nodeOrganInfosList = this.ihosBaseDataRemote.getNodeOrganInfos(appCode);
            List<Long> hospitalIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfosList)) {
                for (OrganizationResVO organizationVo : nodeOrganInfosList) {
                    hospitalIds.add(Long.parseLong(organizationVo.getOrganId()));
                }
            }
            log.info("\u8be5\u8282\u70b9\u4e0b\u5168\u90e8\u7684\u533b\u9662\u662f:{}", (Object)((Object)hospitalIds).toString());
            String hospitalIdsStr = (String)this.pumpPermission(appCode, userId).getData();
            log.info("----\u4ece\u6743\u9650\u670d\u52a1\u4e2d\u53d6\u51fa\u7684\u533b\u9662\u662f:" + hospitalIdsStr);
            if (StringUtil.isEmpty((String)hospitalIdsStr)) {
                consultationDataInfoVOS = new ArrayList();
            } else if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
                hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                consultationDataInfoVOS = this.mdtConsultationService.getExcelOrderData(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, hospitalIds, null, applicationChannels);
            } else {
                consultationDataInfoVOS = this.mdtConsultationService.getExcelOrderData(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, hospitalIds, null, applicationChannels);
            }
        }
        return consultationDataInfoVOS;
    }

    public ResultInfo<Map<String, Object>> queryManageDataConsultation(ManagerMdtReqVO mdtReqVO) {
        mdtReqVO.setBeginTime(CompleteUtils.compleBeginTime((String)mdtReqVO.getBeginTime()));
        mdtReqVO.setEndTime(CompleteUtils.compleEndTime((String)mdtReqVO.getEndTime()));
        List consultationEntities = null;
        log.info("====\u7ba1\u7406\u5e73\u53f0\u53d6\u5230\u7684userId\u662f:{},\u53d6\u5230\u7684appCode\u662f:{}", (Object)mdtReqVO.getUserId(), (Object)mdtReqVO.getAppCode());
        BaseResponse stringBaseResponse = this.pumpPermission(mdtReqVO.getAppCode(), mdtReqVO.getUserId());
        if (!ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(stringBaseResponse.getCode()) || StringUtil.isBlank((String)((String)stringBaseResponse.getData()))) {
            return this.returnFailure("\u6b64\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u67e5\u770b\u6570\u636e\u7684\u6743\u9650!");
        }
        List hospitalIds = null;
        String hospitalIdsStr = (String)stringBaseResponse.getData();
        log.info("\u4ece\u6743\u9650\u670d\u52a1\u62ff\u5230\u7684\u533b\u9662\u662f:{}", (Object)hospitalIdsStr);
        int qualifiedOrderCount = 0;
        int notQualifiedOrderCount = 0;
        long total = 0L;
        Integer pageIndex = (mdtReqVO.getPageIndex() - 1) * mdtReqVO.getPageSize();
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(mdtReqVO.getPageSize());
        if (!"YYHT".equals(mdtReqVO.getAppCode())) {
            mdtReqVO.setIsMdt(Integer.valueOf(1));
        }
        if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
            hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            mdtReqVO.setHospitalIds(hospitalIds);
            total = this.consultationMdtMapper.countMdtOrderData(mdtReqVO, null);
            consultationEntities = this.consultationMdtMapper.getMdtOrderData(mdtReqVO, null);
            qualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_VALID.getValue());
            notQualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_INVALID.getValue());
        } else {
            List nodeOrganInfoList = this.ihosBaseDataRemote.getNodeOrganInfos(mdtReqVO.getAppCode());
            if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfoList)) {
                hospitalIds = nodeOrganInfoList.stream().filter(x -> StringUtil.isNotEmpty((String)x.getOrganId())).map(x -> Long.parseLong(x.getOrganId())).collect(Collectors.toList());
            }
            mdtReqVO.setHospitalIds(hospitalIds);
            total = this.consultationMdtMapper.countMdtOrderData(mdtReqVO, null);
            consultationEntities = this.consultationMdtMapper.getMdtOrderData(mdtReqVO, null);
            qualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_VALID.getValue());
            notQualifiedOrderCount = this.consultationMdtMapper.getMdtOrderCount(mdtReqVO, BaseStatusEnum.STATUS_INVALID.getValue());
        }
        Map objectMap = this.pageHelper(mdtReqVO, consultationEntities, Long.valueOf(total), qualifiedOrderCount, notQualifiedOrderCount);
        return this.returnSucceed((Object)objectMap, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    public ResultInfo<DoctorOrderConsultationVo> queryHospitalManageOrderByHospitalId(ManagerMdtReqVO mdtReqVO) {
        List consultationEntityList;
        DoctorOrderConsultationVo doctorOrderConsultationVo = new DoctorOrderConsultationVo();
        mdtReqVO.setBeginTime(CompleteUtils.compleBeginTime((String)mdtReqVO.getBeginTime()));
        mdtReqVO.setEndTime(CompleteUtils.compleEndTime((String)mdtReqVO.getEndTime()));
        BaseResponse stringBaseResponse = this.pumpPermission(mdtReqVO.getAppCode(), mdtReqVO.getUserId());
        if (!ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(stringBaseResponse.getCode()) || StringUtil.isBlank((String)((String)stringBaseResponse.getData()))) {
            return this.returnFailure("\u6b64\u7528\u6237\u6ca1\u6709\u914d\u7f6e\u67e5\u770b\u8ba2\u5355\u7684\u6743\u9650!");
        }
        String hospitalIdsStr = (String)stringBaseResponse.getData();
        List<Object> hospitalIds = new ArrayList();
        Long finishOrderNum = 0L;
        PageHelper.startPage((int)mdtReqVO.getPageIndex(), (int)mdtReqVO.getPageSize());
        if (StringUtil.isEmpty((String)hospitalIdsStr)) {
            log.info("\u7efc\u7ba1\u7aef\u67e5\u8be2\uff1ahospitalIdsStr:{}", (Object)hospitalIdsStr);
            consultationEntityList = null;
        } else if (StringUtil.isNotEmpty((String)hospitalIdsStr) && !hospitalIdsStr.equals("-1")) {
            hospitalIds = Arrays.asList(hospitalIdsStr.split(",")).stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            mdtReqVO.setHospitalIds(hospitalIds);
            consultationEntityList = this.consultationMdtMapper.getConsultationEntityListApplyByHosId(mdtReqVO);
            mdtReqVO.setStatus(OrderStatusEnum.FINISH.getValue());
            finishOrderNum = this.consultationMdtMapper.countConsultationEntityListApplyByHosId(mdtReqVO);
        } else {
            List nodeOrganInfosList = this.ihosBaseDataRemote.getNodeOrganInfos(mdtReqVO.getAppCode());
            if (CollectionUtils.isNotEmpty((Collection)nodeOrganInfosList)) {
                hospitalIds = nodeOrganInfosList.stream().filter(x -> StringUtil.isNotEmpty((String)x.getOrganId())).map(x -> Long.parseLong(x.getOrganId())).collect(Collectors.toList());
            }
            log.info("\u8be5\u8282\u70b9\u4e0b\u7684\u6240\u6709\u7684\u533b\u9662\u662f:{}", hospitalIds);
            mdtReqVO.setHospitalIds(hospitalIds);
            consultationEntityList = this.consultationMdtMapper.getConsultationEntityListApplyByHosId(mdtReqVO);
            mdtReqVO.setStatus(OrderStatusEnum.FINISH.getValue());
            finishOrderNum = this.consultationMdtMapper.countConsultationEntityListApplyByHosId(mdtReqVO);
        }
        if (CollectionUtils.isEmpty(consultationEntityList)) {
            return this.returnSucceed("\u6b64\u8282\u70b9\u65e0\u8ba2\u5355");
        }
        PageInfo pageInfo = new PageInfo(consultationEntityList);
        doctorOrderConsultationVo.setOrderNum(Long.valueOf(pageInfo.getTotal()));
        doctorOrderConsultationVo.setFinishTotal(finishOrderNum);
        List list = this.consultationOrderProcess.processManagerOrder(consultationEntityList, mdtReqVO.getAppCode());
        doctorOrderConsultationVo.setHosManageOrderDtoList(list);
        return this.returnSucceed((Object)doctorOrderConsultationVo, "\u533b\u9662\u7ba1\u7406\u540e\u53f0\u7ba1\u7406\u8ba2\u5355\u6210\u529f");
    }

    public ResultInfo<SuperOrderConsultationVo> queryConsultationList(AdminMdtListReqVO adminReq) {
        adminReq.setBeginTime(CompleteUtils.compleBeginTime((String)adminReq.getBeginTime()));
        adminReq.setEndTime(CompleteUtils.compleEndTime((String)adminReq.getEndTime()));
        SuperOrderConsultationVo superOrderConsultationVo = new SuperOrderConsultationVo();
        Integer pageIndex = (adminReq.getPageIndex() - 1) * adminReq.getPageSize();
        adminReq.setPageIndex(pageIndex);
        adminReq.setPageSize(adminReq.getPageSize());
        log.info("\u8d85\u7ba1\u7aef\u4f1a\u8bca\u5217\u8868\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)adminReq);
        Long total = this.consultationMdtMapper.countConsultationList(adminReq);
        List consultationEntityList = this.consultationMdtMapper.queryConsultationList(adminReq);
        Integer finishTotal = 0;
        if (total > 0L) {
            adminReq.setStatus(OrderStatusEnum.FINISH.getValue());
            finishTotal = this.consultationMdtMapper.countConsultationByStatus(adminReq);
        }
        superOrderConsultationVo.setOrderNum(Integer.valueOf(total.intValue()));
        superOrderConsultationVo.setFinishTotal(finishTotal);
        if (CollectionUtils.isEmpty((Collection)consultationEntityList)) {
            return this.returnSucceed((Object)superOrderConsultationVo, "\u6210\u529f");
        }
        List list = this.consultationOrderProcess.processSuperOrder(consultationEntityList);
        superOrderConsultationVo.setSuperOrderDtoList(list);
        return this.returnSucceed((Object)superOrderConsultationVo, "\u6210\u529f");
    }

    public ResultInfo<DoctorOrderConsultationVo> queryConsultationListByDoctorId(MdtListReqVO mdtReq) {
        Long finishOrderNum;
        List consultationEntityList;
        DoctorOrderConsultationVo doctorOrderConsultationVo = new DoctorOrderConsultationVo();
        mdtReq.setBeginTime(CompleteUtils.compleBeginTime((String)mdtReq.getBeginTime()));
        mdtReq.setEndTime(CompleteUtils.compleEndTime((String)mdtReq.getEndTime()));
        PageHelper.startPage((int)mdtReq.getPageIndex(), (int)mdtReq.getPageSize());
        if (mdtReq.getIsSponsor() == 1) {
            consultationEntityList = this.consultationMdtMapper.queryMdtConsultationEntityByDoctorId(mdtReq);
            mdtReq.setStatus(OrderStatusEnum.FINISH.getValue());
            finishOrderNum = this.consultationMdtMapper.countMdtConsultionByDoctorIdAndStatus(mdtReq);
        } else {
            consultationEntityList = this.consultationMdtMapper.queryMdtConsultationEntityByExpertId(mdtReq);
            mdtReq.setStatus(OrderStatusEnum.FINISH.getValue());
            finishOrderNum = this.consultationMdtMapper.countMdtConsultionByExpertIdAndStatus(mdtReq);
        }
        log.info("\u533b\u751f\u7aef\u5217\u8868\u6570\u636econsultationEntityList:{}", (Object)consultationEntityList);
        PageInfo pageInfo = new PageInfo(consultationEntityList);
        long total = pageInfo.getTotal();
        doctorOrderConsultationVo.setOrderNum(Long.valueOf(total));
        doctorOrderConsultationVo.setFinishTotal(Long.valueOf(Objects.isNull(finishOrderNum) ? 0L : finishOrderNum));
        if (CollectionUtils.isEmpty((Collection)consultationEntityList)) {
            return this.returnSucceed(null);
        }
        List mdtHosManageOrderVoList = this.consultationOrderProcess.processMdtHosManageOrderVoList(consultationEntityList, mdtReq);
        doctorOrderConsultationVo.setHosManageOrderDtoList(mdtHosManageOrderVoList);
        return this.returnSucceed((Object)doctorOrderConsultationVo, "\u6210\u529f");
    }

    public BaseResponse<List<AppOrderListVo>> getMdtAppOrderList(OrderReqVo orderReqVo) {
        List reportStatus = orderReqVo.getReportStatus();
        List orderStatus = orderReqVo.getOrderStatus();
        if (CollectionUtils.isNotEmpty((Collection)reportStatus) && CollectionUtils.isNotEmpty((Collection)orderStatus) && !orderStatus.contains(OrderStatusEnum.FINISH.getValue())) {
            return BaseResponse.success(new ArrayList());
        }
        if (CollectionUtils.isNotEmpty((Collection)reportStatus) && CollectionUtils.isNotEmpty((Collection)orderStatus) && orderStatus.contains(OrderStatusEnum.FINISH.getValue())) {
            orderStatus.clear();
            orderStatus.add(OrderStatusEnum.FINISH.getValue());
        }
        Integer typeApply = ConsultationConstant.TYPE_ALL;
        if (CollectionUtils.isNotEmpty((Collection)orderReqVo.getProduce()) && orderReqVo.getProduce().size() == 1) {
            typeApply = (Integer)orderReqVo.getProduce().get(0);
        }
        List<Object> consultationEntities = new ArrayList();
        List partList = this.consultationMdtMapper.getMdtPartAppOrderList(orderReqVo.getDoctorId(), typeApply, orderStatus, orderReqVo.getOrderTypes(), orderReqVo.getSerarchParam(), reportStatus, orderReqVo.getIsMdt().intValue());
        List mdtList = null;
        if (typeApply.equals(ConsultationConstant.TYPE_ALL) || typeApply.equals(ConsultationConstant.TYPE_RECEIVE)) {
            mdtList = this.consultationMdtMapper.getType3AppOrderList(orderReqVo.getDoctorId(), typeApply, orderStatus, orderReqVo.getOrderTypes(), orderReqVo.getSerarchParam(), reportStatus, orderReqVo.getIsMdt().intValue());
        }
        if (CollectionUtils.isNotEmpty((Collection)partList)) {
            consultationEntities.addAll(partList);
        }
        if (CollectionUtils.isNotEmpty(mdtList)) {
            consultationEntities.addAll(mdtList);
        }
        long pageIndex = (long)(orderReqVo.getPageIndex() - 1) * (long)orderReqVo.getPageSize().intValue();
        if (CollectionUtils.isEmpty(consultationEntities = consultationEntities.stream().sorted(Comparator.comparing(BaseEntity::getCreateTime).reversed()).skip(pageIndex).limit(orderReqVo.getPageSize().intValue()).collect(Collectors.toList()))) {
            return BaseResponse.success(new ArrayList());
        }
        List idList = consultationEntities.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List extendEntities = this.consultationExtendMapper.queryByConsultationIds(idList);
        Map<Long, ConsultationExtendEntity> extendEntityMap = extendEntities.stream().collect(Collectors.toMap(ConsultationExtendEntity::getConsultationId, x -> x, (k1, k2) -> k1));
        Map<Object, Object> mdtEntityMap = new HashMap();
        List filterViewIdList = consultationEntities.stream().filter(entity -> !entity.getDoctorId().equals(orderReqVo.getDoctorId()) && entity.getStatus().equals(OrderStatusEnum.WAITING.getValue())).map(ConsultationEntity::getViewId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterViewIdList)) {
            List mdtEntities = this.consultationMdtMapper.getConsultationMdtEntitys(filterViewIdList, orderReqVo.getDoctorId());
            mdtEntityMap = mdtEntities.stream().collect(Collectors.toMap(ConsultationMdtEntity::getViewId, x -> x, (k1, k2) -> k1));
        }
        List allViewIdList = consultationEntities.stream().map(ConsultationEntity::getViewId).distinct().collect(Collectors.toList());
        List reportEntities = this.consultationReportMapper.queryConsultationReportEntityByViewIds(allViewIdList);
        Map<String, ConsultationReportEntity> reportEntityMap = reportEntities.stream().collect(Collectors.toMap(ConsultationReportEntity::getViewId, x -> x, (o1, o2) -> o1));
        List appOrderListVos = this.consultationOrderProcess.processAppOrderList(consultationEntities, extendEntityMap, reportEntityMap, mdtEntityMap, orderReqVo.getDoctorId());
        return BaseResponse.success((Object)appOrderListVos);
    }

    private BaseResponse<String> pumpPermission(String appCode, String userId) {
        String permissionUrl = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/").append("permissions/api/v1/dataScope/getPermissionsByKey?key=YCHZ_").append(userId).toString();
        String userPermissions = "";
        try {
            log.info("\u7528\u6237userId:{}====>\u83b7\u53d6\u6743\u9650\u7684\u8bf7\u6c42\u662f:{}", (Object)userId, (Object)permissionUrl);
            userPermissions = HttpUtils.get((String)permissionUrl);
            log.info("\u7528\u6237userId:{}====>\u8fd4\u56de\u6743\u9650\u8bf7\u6c42\u662f:{}", (Object)userId, (Object)userPermissions);
        }
        catch (IOException e) {
            log.error("\u6743\u9650\u67e5\u8be2\u5931\u8d25{}", (Throwable)e);
        }
        return (BaseResponse)JSONObject.parseObject((String)userPermissions, BaseResponse.class);
    }

    public String userRefundConsultation(Long consultationId, String refundReason) {
        ConsultationEntity consultationEntity = this.consultationMapper.selectById(consultationId);
        if (ConsultationOrderStatusEnum.WAITING.getValue().intValue() != consultationEntity.getStatus().intValue()) {
            return "\u5f53\u524d\u8ba2\u5355\u4e0d\u53ef\u7533\u8bf7\u9000\u6b3e";
        }
        this.consultationExtendService.updateRefundReason(consultationId, refundReason);
        return "\u9000\u6b3e\u7533\u8bf7\u6210\u529f";
    }

    public UserRefundRespVo userGetRefundStatusConsultation(Long consultationId) {
        ConsultationEntity consultationEntity = this.consultationMapper.selectById(consultationId);
        UserRefundRespVo userRefundRespVo = this.consultationExtendService.userGetRefundStatusConsultation(consultationId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendMapper.queryByConsultationId(consultationId);
        ServicePayBillEntity servicePayBillEntity = this.servicePayBillMapper.selectByOutTradeNoAndStatus(consultationEntity.getViewId());
        userRefundRespVo.setRefundPrice(consultationExtendEntity.getPrice());
        if (Objects.nonNull(servicePayBillEntity)) {
            userRefundRespVo.setRefundNo(servicePayBillEntity.getOutRefundNo());
            userRefundRespVo.setRefundPrice(servicePayBillEntity.getRefundAmount());
        }
        return userRefundRespVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<String> adminRefundConsultation(AdminRefundConsultationReqVo adminRefundConsultationReqVo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ConsultationEntity consultationEntity = this.consultationMapper.selectById(adminRefundConsultationReqVo.getConsultationId());
        if (ConsultationOrderStatusEnum.WAITING.getValue().intValue() != consultationEntity.getStatus().intValue() && ConsultationOrderStatusEnum.FINISH.getValue().intValue() != consultationEntity.getStatus().intValue()) {
            return this.returnFailure("\u5f53\u524d\u8ba2\u5355\u4e0d\u53ef\u7533\u8bf7\u9000\u6b3e");
        }
        ResultInfo res = this.refundConsultation(consultationEntity.getViewId(), adminRefundConsultationReqVo.getRefundPrice());
        if (ReturnCodeEnum.SUCCEED.getValue().equals(res.getCode())) {
            this.consultationMapper.updateConsultationRefund(adminRefundConsultationReqVo.getConsultationId(), adminRefundConsultationReqVo.getRefundReason(), "", Integer.valueOf(20), Integer.valueOf(0), sdf.format(new Date()));
            CancelOrderMdtVo cancelOrderMdtVo = new CancelOrderMdtVo();
            cancelOrderMdtVo.setCancelReason(consultationEntity.getRefundReason());
            cancelOrderMdtVo.setOrderViewId(consultationEntity.getViewId());
            cancelOrderMdtVo.setCloserId(adminRefundConsultationReqVo.getCloserId());
            cancelOrderMdtVo.setCloserType(Integer.valueOf(203));
            this.cancelOrder(cancelOrderMdtVo);
            return this.returnSucceed("\u9000\u6b3e\u6210\u529f");
        }
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<String> adminAuditRefundConsultation(AdminAuditConsultationReqVo adminAuditConsultationReqVo) {
        ConsultationEntity consultationEntity = this.consultationMapper.selectById(adminAuditConsultationReqVo.getConsultationId());
        if (1 == adminAuditConsultationReqVo.getIsAudit()) {
            if (ConsultationOrderStatusEnum.WAITING.getValue().intValue() != consultationEntity.getStatus().intValue()) {
                return this.returnFailure("\u533b\u751f\u5df2\u63a5\u8bca,\u4e0d\u53ef\u8fdb\u884c\u9000\u6b3e");
            }
            ResultInfo res = this.refundConsultation(consultationEntity.getViewId(), adminAuditConsultationReqVo.getRefundPrice());
            if (ReturnCodeEnum.SUCCEED.getValue().equals(res.getCode())) {
                this.consultationMapper.updateConsultationRefund(adminAuditConsultationReqVo.getConsultationId(), "", "", Integer.valueOf(20), Integer.valueOf(1), "");
                CancelOrderMdtVo cancelOrderMdtVo = new CancelOrderMdtVo();
                cancelOrderMdtVo.setCancelReason(consultationEntity.getRefundReason());
                cancelOrderMdtVo.setOrderViewId(consultationEntity.getViewId());
                cancelOrderMdtVo.setCloserId(adminAuditConsultationReqVo.getCloserId());
                cancelOrderMdtVo.setCloserType(Integer.valueOf(203));
                this.cancelOrder(cancelOrderMdtVo);
                return this.returnSucceed("\u540c\u610f\u9000\u6b3e\u6210\u529f");
            }
            return res;
        }
        if (2 == adminAuditConsultationReqVo.getIsAudit()) {
            this.consultationMapper.updateConsultationRefund(adminAuditConsultationReqVo.getConsultationId(), "", adminAuditConsultationReqVo.getRefuseReason(), Integer.valueOf(30), Integer.valueOf(1), "");
            return this.returnSucceed("\u62d2\u7edd\u9000\u6b3e\u6210\u529f");
        }
        return this.returnFailure("\u5ba1\u6838\u72b6\u6001\u6709\u8bef");
    }

    public ResultInfo<String> refundConsultation(String orderViewId, BigDecimal refundPrice) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        List servicePayBillEntityList = this.servicePayBillService.selectByOutTradeNo(orderViewId);
        if (Objects.isNull(servicePayBillEntityList) || servicePayBillEntityList.isEmpty()) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)servicePayBillEntityList.get(0);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByAppCode(servicePayBillEntity.getAppCode());
        RefundHttpVo refundHttpVo = new RefundHttpVo();
        refundHttpVo.setPayChannel(servicePayBillEntity.getPayChannel());
        refundHttpVo.setMchCode(servicePayBillEntity.getApplyCode());
        refundHttpVo.setOutTradeNo(servicePayBillEntity.getOutTradeNo());
        refundHttpVo.setDealTradeNo(servicePayBillEntity.getDealTradeNo());
        refundHttpVo.setTotalAmount(consultationExtendEntity.getPrice());
        refundHttpVo.setRefundAmount(refundPrice);
        refundHttpVo.setNonceStr(StringUtil.getRandomString((int)32));
        refundHttpVo.setRefundNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/cloud/consultation/api/order/pay/refundCallback");
        refundHttpVo.setApplyCode(servicePayBillEntity.getApplyCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)refundHttpVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])str);
        refundHttpVo.setSign(sign);
        String url = this.remoteCallAddressConfig.getPayHttpAddress() + "/trade/refund";
        String respStr = "";
        log.info("\u9000\u6b3e\u8bf7\u6c42url\u662f:{} http\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)refundHttpVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)refundHttpVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (Exception e) {
            log.error("refundConsultation", (Throwable)e);
        }
        log.info("\u9000\u6b3e\u8bf7\u6c42http\u8bf7\u6c42\u8fd4\u56de:{}", (Object)respStr);
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
            return this.returnSucceed("\u9000\u6b3e\u6210\u529f");
        }
        return this.returnFailure("\u9000\u6b3e\u5931\u8d25");
    }

    public ResultInfo<String> cancelOrder(CancelOrderMdtVo cancelOrderMdtVo) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(cancelOrderMdtVo.getOrderViewId());
        if (consultationEntity == null) {
            return this.returnFailure("orderViewId\u4e0d\u6b63\u786e");
        }
        int status = consultationEntity.getStatus();
        if (status == OrderStatusEnum.CANCEL.getValue()) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u5df2\u53d6\u6d88,\u8bf7\u52ff\u91cd\u590d\u53d6\u6d88");
        }
        if (status == OrderStatusEnum.RUNNING.getValue()) {
            return this.returnFailure("\u8fdb\u884c\u4e2d\u7684\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88");
        }
        if (status > 0 && status < OrderStatusEnum.RUNNING.getValue()) {
            this.updateOrderForClose(cancelOrderMdtVo, consultationEntity);
            try {
                this.messagePush(consultationEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            return this.returnSucceed("\u4fee\u6539\u6210\u529f");
        }
        return this.returnFailure("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    void updateOrderForClose(CancelOrderMdtVo cancelOrderMdtVo, ConsultationEntity consultationEntity) {
        String closeTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        int i = this.consultationService.updateOrderStatusByOrderIdAndClose(consultationEntity.getId(), closeTime);
        if (i == 0) {
            log.error("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u4e3b\u8868\u4fee\u6539\u5931\u8d25,\u5165\u53c2:{}", (Object)cancelOrderMdtVo.toString());
            throw new RuntimeException();
        }
        int j = this.consultationExtendService.updateCloseIdAndCloseTypeAndCloseReason(cancelOrderMdtVo.getCloserId(), cancelOrderMdtVo.getCloserType(), cancelOrderMdtVo.getCancelReason(), consultationEntity.getId());
        if (j == 0) {
            log.error("\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355\u6269\u5c55\u8868\u4fee\u6539\u5931\u8d25,\u5165\u53c2:{}", (Object)cancelOrderMdtVo.toString());
            throw new RuntimeException();
        }
    }

    @Async
    public void messagePush(ConsultationEntity consultationEntity) {
        try {
            this.webAndAppMessageManager.refundOfConsultationSendMessage(consultationEntity, consultationEntity.getRefundReason());
        }
        catch (Exception e) {
            log.error("\u591a\u5b66\u79d1\u9000\u6b3e\u8ba2\u5355\u63a8\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public ResultInfo<List<MdtHosManageOrderVo>> listConsultation(ManagerMdtReqVO mdtReqVO) {
        ResultInfo resultInfo = this.queryHospitalManageOrderByHospitalId(mdtReqVO);
        if (resultInfo.getCode().equals(ReturnCodeEnum.FAILURE.getValue())) {
            return this.returnFailure(resultInfo.getMsg());
        }
        List result = ((DoctorOrderConsultationVo)resultInfo.getData()).getHosManageOrderDtoList();
        return this.returnSucceed((Object)result, "\u533b\u9662\u7ba1\u7406\u540e\u53f0\u7ba1\u7406\u8ba2\u5355\u6210\u529f");
    }
}

