/*
 * Decompiled with CFR 0.152.
 */
package com.byh.remotecall.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IhospitalApiClient;
import com.byh.pojo.vo.consultation.req.QueryDeptParamReqVO;
import com.byh.pojo.vo.consultation.req.StandDeptIdReqVO;
import com.byh.pojo.vo.consultation.res.DepartmentResVO;
import com.byh.pojo.vo.consultation.res.StandDeptInfoResVO;
import com.byh.remotecall.DepartMentInfoRemote;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DepartMentInfoRemoteImpl
implements DepartMentInfoRemote {
    private static final Logger log = LoggerFactory.getLogger(DepartMentInfoRemoteImpl.class);
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public DepartmentResVO getHosDeptDetailId(Long id, Long hospitalId) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/doctorbasedata/organization/deptinfo").toString();
        QueryDeptParamReqVO queryDeptParamVO = new QueryDeptParamReqVO();
        queryDeptParamVO.setDeptId(id.intValue());
        DepartmentResVO departmentResVO = new DepartmentResVO();
        try {
            String resData = HttpUtils.post((String)url, (String)JSONObject.toJSONString((Object)queryDeptParamVO));
            log.info("\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)resData);
            if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSON.parseObject((String)resData).getString("code")) && StringUtil.isNotBlank((String)JSON.parseObject((String)resData).getString("data"))) {
                departmentResVO = (DepartmentResVO)JSON.parseObject((String)JSON.parseObject((String)resData).getString("data"), DepartmentResVO.class);
            }
        }
        catch (IOException e) {
            log.error("getHosDeptDetailId", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("getHosDeptDetailId", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("getHosDeptDetailId", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return departmentResVO;
    }

    public StandDeptInfoResVO getStandDeptDetailId(Long id, Long hospitalId) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/doctorbasedata/organization/queryStandDeptInfoById").toString();
        StandDeptIdReqVO standDeptIdVO = new StandDeptIdReqVO();
        standDeptIdVO.setStandDeptId(id.intValue());
        StandDeptInfoResVO standDeptInfoVO = new StandDeptInfoResVO();
        try {
            String resData = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)standDeptIdVO));
            log.info("\u67e5\u8be2\u6807\u51c6\u79d1\u5ba4\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)resData);
            if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSON.parseObject((String)resData).getString("code")) && StringUtil.isNotBlank((String)JSON.parseObject((String)resData).getString("data"))) {
                standDeptInfoVO = (StandDeptInfoResVO)JSONObject.parseObject((String)JSON.parseObject((String)resData).getString("data"), StandDeptInfoResVO.class);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return standDeptInfoVO;
    }
}

