/*
 * Decompiled with CFR 0.152.
 */
package com.byh.remotecall.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.vo.consultation.req.DoctorIdReqVO;
import com.byh.pojo.vo.consultation.req.PatientIdReqVO;
import com.byh.pojo.vo.consultation.req.QueryPatientInfoListReqVO;
import com.byh.pojo.vo.consultation.req.UserCardReqVO;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.consultation.res.QueryPatientInfoListRespVO;
import com.byh.pojo.vo.consultation.res.UserCardResVO;
import com.byh.pojo.vo.consultation.res.UserInfoRespVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.ebaiyihui.card.common.vo.GetPatientInfoByCrednoAndTypeReqVO;
import com.ebaiyihui.card.common.vo.RegisterVirtualCardReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UserCenterRemoteImpl
implements UserCenterRemote {
    private static final Logger log = LoggerFactory.getLogger(UserCenterRemoteImpl.class);
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private HttpServletRequest request;

    public DoctorInfoRespVO getUserIdByDoctorId(Long doctorId) {
        Integer hospitalId = this.remoteManage.getDoctorDetailById(doctorId).getOrganId();
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(hospitalId);
        String code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        log.info("code:{}", (Object)code);
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/doctoruser/user/querydoctorbydoctorid").toString();
        DoctorIdReqVO doctorIdReqVO = new DoctorIdReqVO();
        doctorIdReqVO.setDoctorId(doctorId.toString());
        doctorIdReqVO.setAppCode(code);
        doctorIdReqVO.setHospitalId(hospitalId.toString());
        doctorIdReqVO.setChannelCode("PATIENT_IOS");
        DoctorInfoRespVO doctorInfoRespVO = new DoctorInfoRespVO();
        String userDataRes = "";
        try {
            userDataRes = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)doctorIdReqVO));
            log.info("\u6839\u636edoctorId:{}\u4ece\u7528\u6237\u4e2d\u5fc3\u53d6\u5230\u7684\u4fe1\u606f\u662f:{}", (Object)doctorId, (Object)userDataRes);
        }
        catch (IOException e) {
            log.error("getUserIdByDoctorId", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("getUserIdByDoctorId", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("getUserIdByDoctorId", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (StringUtil.isNotEmpty((String)userDataRes) && ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(JSONObject.parseObject((String)userDataRes).getString("code")) && JSONObject.parseObject((String)userDataRes).get((Object)"data") != null) {
            doctorInfoRespVO = (DoctorInfoRespVO)JSONObject.parseObject((String)JSONObject.parseObject((String)userDataRes).getString("data"), DoctorInfoRespVO.class);
            log.info("\u62ff\u5230\u7684\u7528\u6237userId\u662f:{}", (Object)doctorInfoRespVO.getUserId());
        }
        return doctorInfoRespVO;
    }

    public UserInfoRespVO getUserIdByPatientId(Long patientId, Long hospitalId) {
        UserInfoRespVO userInfoRespVO = null;
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        String code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(code).append("/").append("usercenter/user/querypatientbypatientid").toString();
        PatientIdReqVO patientIdReqVO = new PatientIdReqVO();
        patientIdReqVO.setPatientId(patientId.toString());
        patientIdReqVO.setAppCode(code);
        patientIdReqVO.setChannelCode("PATIENT_IOS");
        BaseResponse respVOBaseResponse = (BaseResponse)this.restTemplate.postForObject(url, (Object)patientIdReqVO, BaseResponse.class, new Object[0]);
        log.info("=====\u6839\u636e\u60a3\u8005id:{}=====\u966a\u8bca\u533b\u751fid:{}=====\u8c03\u53d6\u5230\u7684\u7528\u6237\u4fe1\u606fjson\u683c\u5f0f\u662f:{}", new Object[]{patientId, hospitalId, respVOBaseResponse.toString()});
        if (respVOBaseResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && respVOBaseResponse.getData() != null) {
            String dataStr = JSON.toJSONString((Object)respVOBaseResponse.getData());
            userInfoRespVO = (UserInfoRespVO)JSON.parseObject((String)dataStr, UserInfoRespVO.class);
        }
        return userInfoRespVO;
    }

    public List<QueryPatientInfoListRespVO> getUserPatientInfoList(String appCode, Long userId) {
        QueryPatientInfoListReqVO queryPatientInfoListReqVO = new QueryPatientInfoListReqVO();
        queryPatientInfoListReqVO.setUserId(userId.toString());
        queryPatientInfoListReqVO.setAppCode(appCode);
        queryPatientInfoListReqVO.setChannelCode("PATIENT_IOS");
        String url = this.remoteCallAddressConfig.getRemoteCallAddress() + appCode + "/usercenter/user/patientinfolist";
        String dataStr = "";
        try {
            dataStr = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)queryPatientInfoListReqVO));
        }
        catch (IOException e) {
            log.error("getUserPatientInfoList", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("getUserPatientInfoList", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("getUserPatientInfoList", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        log.info("====data:{}", (Object)dataStr);
        JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
        List listRespVOS = JSONArray.parseArray((String)jsonObject.getString("data"), QueryPatientInfoListRespVO.class);
        return listRespVOS;
    }

    public List<UserCardResVO> getUserBindPatientList(String appCode, String userId) {
        UserCardReqVO userCardReqVO = new UserCardReqVO();
        userCardReqVO.setUserId(userId);
        userCardReqVO.setAppCode(appCode);
        userCardReqVO.setChannelCode("PATIENT_IOS");
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/").append("usercenter/card/cardlist").toString();
        List userCardResVOS = null;
        try {
            log.info("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5c31\u8bca\u5361\u7684url\u662f:{}=====\u5165\u53c2\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)userCardReqVO));
            String dataStr = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)userCardReqVO));
            log.info("\u5c31\u8bca\u5361\u670d\u52a1\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)dataStr);
            JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
            if (StringUtil.isNotBlank((String)jsonObject.getString("data"))) {
                userCardResVOS = JSONArray.parseArray((String)jsonObject.getString("data"), UserCardResVO.class);
            }
        }
        catch (IOException e) {
            log.error("getUserBindPatientList", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("getUserBindPatientList", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("getUserBindPatientList", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return userCardResVOS;
    }

    public List<OssFileVO> saveFiles(MultipartFile[] flies) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("/cloud/doctoruser/oss/api/file/store/v1/saveFiles").toString();
        List ossFileVOS = null;
        try {
            log.info("\u6279\u91cf\u4e0a\u6b21\u56fe\u7247\u7684url\u662f=============:{}", (Object)url);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            for (MultipartFile multipartFile : flies) {
                params.add((Object)"files", (Object)this.convert(multipartFile));
            }
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, BaseResponse.class, new Object[0]);
            BaseResponse response = (BaseResponse)responseEntity.getBody();
            log.info("\u6279\u91cf\u4e0a\u6b21\u56fe\u7247\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)responseEntity);
            if (response.isSuccess()) {
                ossFileVOS = JSONArray.parseArray((String)JSONObject.toJSONString((Object)response.getData()), OssFileVO.class);
            }
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
        }
        return ossFileVOS;
    }

    public BaseResponse registervirtualcard(String patientName, String credNo, String appCode, String mobileNumber) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("/").append(appCode).append("/cardservice/card/registervirtualcard").toString();
        BaseResponse baseResponse = null;
        try {
            RegisterVirtualCardReqVO cardReqVO = new RegisterVirtualCardReqVO();
            cardReqVO.setAppCode(appCode);
            cardReqVO.setChannelCode("DOCTOR_WEB");
            cardReqVO.setCredNo(credNo);
            cardReqVO.setPatientName(patientName);
            cardReqVO.setCredTypeCode("01");
            cardReqVO.setCredTypeName("\u8eab\u4efd\u8bc1");
            cardReqVO.setTel(mobileNumber);
            log.info("\u6ce8\u518c\u60a3\u8005\u4fe1\u606f\u7684url\u662f=============:{}\uff0c\u5165\u53c2\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)cardReqVO));
            String result = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)cardReqVO), (String)this.request.getHeader("token"));
            log.info("\u6ce8\u518c\u60a3\u8005\u4fe1\u606f\u56de\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            baseResponse = (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
        }
        catch (Exception e) {
            log.error("\u6ce8\u518c\u60a3\u8005\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return baseResponse;
    }

    public BaseResponse getPatientInfoByCredNo(String appCode, String credNo, String hospitalId) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(appCode).append("/cardservice/getpatientinfobycrednoAndType").toString();
        BaseResponse baseResponse = null;
        try {
            GetPatientInfoByCrednoAndTypeReqVO cardReqVO = new GetPatientInfoByCrednoAndTypeReqVO();
            cardReqVO.setCredNo(credNo);
            cardReqVO.setCredTypeCode("01");
            log.info("\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u7684url\u662f=============:{}\uff0c\u5165\u53c2\uff1a{}", (Object)url, (Object)JSON.toJSONString((Object)cardReqVO));
            String result = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)cardReqVO), (String)this.request.getHeader("token"));
            log.info("\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u56de\u7684\u7ed3\u679c\u662f:{}", (Object)result);
            baseResponse = (BaseResponse)JSONObject.parseObject((String)result, BaseResponse.class);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return baseResponse;
    }

    private FileSystemResource convert(MultipartFile multipartFile) {
        File convFile = new File(multipartFile.getOriginalFilename());
        FileSystemResource resource = null;
        try (FileOutputStream fos = new FileOutputStream(convFile);){
            if (!convFile.createNewFile()) {
                log.error("convFile.createNewFile() fail");
            }
            fos.write(multipartFile.getBytes());
            resource = new FileSystemResource(convFile);
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25{}", (Throwable)e);
        }
        return resource;
    }
}

