/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.dashboard.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.excel.EasyExcel;
import com.byh.dao.dashboard.StatisticsMapper;
import com.byh.enums.OrderTypeEnum;
import com.byh.feign.ICloudDashBoardApiClient;
import com.byh.feign.IhospitalApiClient;
import com.byh.pojo.vo.dashboard.DashBoardData;
import com.byh.pojo.vo.dashboard.DashBoardReqVO;
import com.byh.pojo.vo.dashboard.DoctorActiveVO;
import com.byh.pojo.vo.dashboard.DoctorOrderVO;
import com.byh.pojo.vo.dashboard.DoctorReqVO;
import com.byh.pojo.vo.dashboard.OrderBarGraph;
import com.byh.pojo.vo.dashboard.OrderExcelVO;
import com.byh.pojo.vo.dashboard.OrderGraphReqVO;
import com.byh.pojo.vo.dashboard.OrderIncome;
import com.byh.pojo.vo.dashboard.OrderInfoVO;
import com.byh.pojo.vo.dashboard.OrderPriceReqVO;
import com.byh.pojo.vo.dashboard.OrderPriceRespVO;
import com.byh.pojo.vo.dashboard.OrderStatusVO;
import com.byh.pojo.vo.dashboard.OrderTransferInfo;
import com.byh.service.dashboard.StatisticsService;
import com.byh.util.CompleteUtils;
import com.byh.util.WeekUtils;
import com.doctoruser.api.pojo.vo.OrganBasicInfoReqVO;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Autowired
    private StatisticsMapper statisticsMapper;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private ICloudDashBoardApiClient iCloudAccountApiClient;

    public BaseResponse<OrderPriceRespVO> getPriceInfo(OrderPriceReqVO reqVO) {
        OrderPriceRespVO priceResp = new OrderPriceRespVO();
        List orderPriceList = this.statisticsMapper.listOrderPrice(reqVO);
        if (CollectionUtils.isEmpty((Collection)orderPriceList)) {
            return BaseResponse.success((Object)priceResp);
        }
        BigDecimal totalPrice = orderPriceList.stream().map(OrderPriceRespVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal vedioPrice = orderPriceList.stream().filter(x -> x.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue())).map(OrderPriceRespVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal imagePrice = orderPriceList.stream().filter(x -> x.getType().equals(OrderTypeEnum.TYPE_TUWEN.getValue())).map(OrderPriceRespVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (vedioPrice.compareTo(BigDecimal.ZERO) != 0) {
            double videoProportion = NumberUtil.div((double)vedioPrice.doubleValue(), (double)totalPrice.doubleValue(), (int)2);
            priceResp.setVideoProportion(NumberUtil.formatPercent((double)videoProportion, (int)2));
        }
        if (imagePrice.compareTo(BigDecimal.ZERO) != 0) {
            double imageProportion = NumberUtil.div((double)imagePrice.doubleValue(), (double)totalPrice.doubleValue(), (int)2);
            priceResp.setImageProportion(NumberUtil.formatPercent((double)imageProportion, (int)2));
        }
        priceResp.setVideoPrice(vedioPrice);
        priceResp.setImagePrice(imagePrice);
        priceResp.setTotalPrice(totalPrice);
        return BaseResponse.success((Object)priceResp);
    }

    public BaseResponse<OrderInfoVO> getOrderInfo(String appCode, Integer organId) {
        BaseResponse baseResponse = this.getOranIdList(appCode, organId);
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        List organIdList = (List)baseResponse.getData();
        OrderPriceReqVO orderPriceReqVO = new OrderPriceReqVO(organIdList);
        BaseResponse orderResponse = this.getPriceInfo(orderPriceReqVO);
        OrderTransferInfo transferInfo = this.getOrderTransfer(organIdList);
        OrderInfoVO result = new OrderInfoVO();
        result.setOrderPrice((OrderPriceRespVO)orderResponse.getData());
        result.setTransferInfo(transferInfo);
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<List<OrderBarGraph>> getOrderBarGraph(OrderGraphReqVO reqVO) {
        String beginTime = CompleteUtils.compleBeginTime((String)reqVO.getBeginTime());
        String endTime = CompleteUtils.compleEndTime((String)reqVO.getEndTime());
        BaseResponse baseResponse = this.getOranIdList(reqVO.getAppCode(), reqVO.getOrganId());
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        List organIdList = (List)baseResponse.getData();
        List orderBarGraphs = this.statisticsMapper.countOrder(organIdList, reqVO.getType(), beginTime, endTime);
        if (CollectionUtils.isNotEmpty((Collection)orderBarGraphs) && reqVO.getType().equals((short)1)) {
            orderBarGraphs.forEach(order -> {
                String[] dateTime = order.getDateTime().split("-");
                order.setDateTime(WeekUtils.getWeekBeginAndEnd((int)Integer.parseInt(dateTime[0]), (int)Integer.parseInt(dateTime[1])));
            });
        }
        return BaseResponse.success((Object)orderBarGraphs);
    }

    public BaseResponse<List<OrderIncome>> getOrderIncome(OrderGraphReqVO reqVO) {
        String beginTime = CompleteUtils.compleBeginTime((String)reqVO.getBeginTime());
        String endTime = CompleteUtils.compleEndTime((String)reqVO.getEndTime());
        BaseResponse baseResponse = this.getOranIdList(reqVO.getAppCode(), reqVO.getOrganId());
        if (!baseResponse.isSuccess()) {
            return baseResponse;
        }
        List organIdList = (List)baseResponse.getData();
        List orderIncomes = this.statisticsMapper.getOrderIncome(organIdList, reqVO.getType(), beginTime, endTime);
        this.processDate(orderIncomes, reqVO.getType());
        return BaseResponse.success((Object)orderIncomes);
    }

    public void exportOrderInfo(String appCode, Integer organId) {
        BaseResponse baseResponse = this.getOranIdList(appCode, organId);
        if (!baseResponse.isSuccess()) {
            log.error("\u83b7\u53d6\u533b\u9662\u4fe1\u606f\u5931\u8d25\uff01{}", (Object)baseResponse);
            return;
        }
        List organIdList = (List)baseResponse.getData();
        OrderExcelVO excelVO = new OrderExcelVO();
        OrderTransferInfo transferInfo = this.getOrderTransfer(organIdList);
        BeanUtils.copyProperties((Object)transferInfo, (Object)excelVO);
        excelVO.setDeadLineTime(FastDateFormat.getInstance((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(new Date()));
        DashBoardReqVO reqVO = new DashBoardReqVO(appCode, organId);
        BaseResponse activeBaseResponse = this.iCloudAccountApiClient.getDoctorActive(reqVO);
        log.info("\u67e5\u8be2\u533b\u751f\u6d3b\u8dc3\u6570\u8fd4\u56de\u7ed3\u679c{}", (Object)activeBaseResponse);
        if (activeBaseResponse.isSuccess()) {
            excelVO.setActiveDoctor(((DoctorActiveVO)activeBaseResponse.getData()).getTodayNum());
        }
        BaseResponse dashBoardResponse = this.iCloudAccountApiClient.getDashboard(reqVO);
        log.info("\u67e5\u8be2\u5e73\u53f0\u57fa\u7840\u6570\u636e\u8fd4\u56de\u7ed3\u679c{}", (Object)dashBoardResponse);
        if (dashBoardResponse.isSuccess()) {
            DashBoardData dashBoardData = (DashBoardData)dashBoardResponse.getData();
            BeanUtils.copyProperties((Object)dashBoardData, (Object)excelVO);
        }
        ArrayList<OrderExcelVO> list = new ArrayList<OrderExcelVO>();
        list.add(excelVO);
        this.noModelWrite(list);
    }

    public BaseResponse<DoctorOrderVO> getDoctorInfo(DoctorReqVO reqVO) {
        List orderAccept;
        DoctorOrderVO orderVO = new DoctorOrderVO();
        BigDecimal orderPrice = this.statisticsMapper.getDoctorPrice(reqVO.getDoctorId());
        if (orderPrice == null) {
            orderPrice = BigDecimal.ZERO;
        }
        orderVO.setOrderPrice(orderPrice);
        List orderApply = this.statisticsMapper.countApplyOrderNum(reqVO.getDoctorId());
        if (CollectionUtils.isNotEmpty((Collection)orderApply)) {
            long videoOrderApplyNum = orderApply.stream().filter(type -> Objects.nonNull(type) && type == 4).count();
            long imageOrderApplyNum = orderApply.stream().filter(type -> Objects.nonNull(type) && type == 5).count();
            orderVO.setVideoOrderApplyNum(Long.valueOf(videoOrderApplyNum));
            orderVO.setImageOrderApplyNum(Long.valueOf(imageOrderApplyNum));
        }
        if (CollectionUtils.isNotEmpty((Collection)(orderAccept = this.statisticsMapper.countAcceptOrderNum(reqVO.getDoctorId())))) {
            long videoOrderAcceptNum = orderAccept.stream().filter(type -> type == 4).count();
            long imageOrderAcceptNum = orderAccept.stream().filter(type -> type == 5).count();
            orderVO.setVideoOrderAcceptNum(Long.valueOf(videoOrderAcceptNum));
            orderVO.setImageOrderAcceptNum(Long.valueOf(imageOrderAcceptNum));
        }
        Long backlogOrder = this.statisticsMapper.countBacklogOrder(reqVO.getDoctorId());
        orderVO.setBacklogOrder(backlogOrder);
        return BaseResponse.success((Object)orderVO);
    }

    public BaseResponse<List<OrderIncome>> getDoctorPriceInfo(DoctorReqVO reqVO) {
        String beginTime = CompleteUtils.compleBeginTime((String)reqVO.getBeginTime());
        String endTime = CompleteUtils.compleEndTime((String)reqVO.getEndTime());
        List list = this.statisticsMapper.countDoctorPrice(reqVO.getDoctorId(), reqVO.getType(), beginTime, endTime);
        log.info("\u533b\u751f\u6536\u5165\u6298\u73b0\u56fe\u67e5\u8be2\u53c2\u6570doctorId:{},type:{},beginTime:{},endTime{},\u8fd4\u56de\u7ed3\u679c:{}", new Object[]{reqVO.getDoctorId(), reqVO.getType(), beginTime, endTime, list});
        this.processDate(list, reqVO.getType());
        return BaseResponse.success((Object)list);
    }

    private BaseResponse<List<Integer>> getOranIdList(String appCode, Integer organId) {
        OrganBasicInfoReqVO reqVO = new OrganBasicInfoReqVO();
        reqVO.setAppCode(appCode);
        if (Objects.nonNull(organId)) {
            reqVO.setHospitalId(Arrays.asList(organId));
        }
        BaseResponse baseResponse = this.ihospitalApiClient.queryOrganBasicInfo(reqVO);
        log.info("\u83b7\u53d6\u5e73\u53f0\u533b\u9662\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570{},\u8fd4\u56de\u503c{}", (Object)reqVO, (Object)baseResponse);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u83b7\u53d6\u5e73\u53f0\u533b\u9662\u4fe1\u606f\u5f02\u5e38!");
        }
        List organIdList = ((List)baseResponse.getData()).stream().map(OrganBasicInfoRespVO::getOrganId).distinct().collect(Collectors.toList());
        return BaseResponse.success(organIdList);
    }

    private OrderTransferInfo getOrderTransfer(List<Integer> organIdList) {
        BigDecimal yesterdayPayPrice;
        OrderTransferInfo transferInfo = new OrderTransferInfo();
        List toDayOrder = this.statisticsMapper.listOrderPriceStatus(organIdList, Integer.valueOf(0));
        List yesterdayOrder = this.statisticsMapper.listOrderPriceStatus(organIdList, Integer.valueOf(1));
        List toDayPayOrder = this.statisticsMapper.listOrderPricePay(organIdList, Integer.valueOf(0));
        List yesterdayPayOrder = this.statisticsMapper.listOrderPricePay(organIdList, Integer.valueOf(1));
        List toDayRefundOrder = this.statisticsMapper.listOrderPricePay(organIdList, Integer.valueOf(0));
        List yesterdayRefundOrder = this.statisticsMapper.listOrderPricePay(organIdList, Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)toDayOrder)) {
            transferInfo.setOrderTodayNum(Integer.valueOf(toDayOrder.size()));
        }
        if (CollectionUtils.isNotEmpty((Collection)yesterdayOrder)) {
            transferInfo.setOrderYesterdayNum(Integer.valueOf(yesterdayOrder.size()));
        }
        if (CollectionUtils.isNotEmpty((Collection)toDayPayOrder)) {
            transferInfo.setTodayPayNum(Integer.valueOf(toDayPayOrder.size()));
            BigDecimal todayPayPrice = toDayPayOrder.stream().map(OrderStatusVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            transferInfo.setTodayPayPrice(NumberUtil.round((BigDecimal)todayPayPrice, (int)2));
        }
        if (CollectionUtils.isNotEmpty((Collection)yesterdayPayOrder)) {
            transferInfo.setYesterdayPayNum(Integer.valueOf(yesterdayPayOrder.size()));
            yesterdayPayPrice = yesterdayPayOrder.stream().map(OrderStatusVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            transferInfo.setYesterdayPayPrice(NumberUtil.round((BigDecimal)yesterdayPayPrice, (int)2));
        }
        if (CollectionUtils.isNotEmpty((Collection)toDayRefundOrder)) {
            transferInfo.setTodayRefundNum(Integer.valueOf(toDayRefundOrder.size()));
            BigDecimal todayRefundPrice = toDayRefundOrder.stream().map(OrderStatusVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            transferInfo.setTodayRefundPrice(NumberUtil.round((BigDecimal)todayRefundPrice, (int)2));
        }
        if (CollectionUtils.isNotEmpty((Collection)yesterdayRefundOrder)) {
            transferInfo.setYesterdayRefundNum(Integer.valueOf(yesterdayRefundOrder.size()));
            yesterdayPayPrice = yesterdayRefundOrder.stream().map(OrderStatusVO::getPrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            transferInfo.setYesterdayPayPrice(NumberUtil.round((BigDecimal)yesterdayPayPrice, (int)2));
        }
        return transferInfo;
    }

    private void noModelWrite(List<OrderExcelVO> dataList) {
        try {
            String fileName = "\u6570\u636e\u62a5\u8868-" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + ".xlsx";
            fileName = URLEncoder.encode(fileName, "UTF-8");
            this.response.setContentType("application/vnd.ms-excel");
            this.response.setCharacterEncoding("utf-8");
            this.response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            log.info("\u57fa\u7840\u6570\u636e\u6587\u4ef6{},\u5bfc\u51fa\u6570\u636e{}", (Object)fileName, dataList);
            EasyExcel.write((OutputStream)this.response.getOutputStream(), OrderExcelVO.class).sheet("\u6570\u636e\u62a5\u8868").doWrite(dataList);
        }
        catch (IOException e) {
            log.error("\u5bfc\u51faexcel\u5931\u8d25{}", (Throwable)e);
        }
    }

    private void processDate(List<OrderIncome> orderIncomes, Short type) {
        if (CollectionUtils.isNotEmpty(orderIncomes) && type.equals((short)1)) {
            orderIncomes.forEach(order -> {
                String[] dateTime = order.getDateTime().split("-");
                order.setDateTime(WeekUtils.getWeekBeginAndEnd((int)Integer.parseInt(dateTime[0]), (int)Integer.parseInt(dateTime[1])));
            });
        }
    }
}

