/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.allocation;

import com.alibaba.fastjson.JSONObject;
import com.byh.config.RedisConfiguration;
import com.byh.dao.allocation.BillInfoMapper;
import com.byh.dao.allocation.IncomeModifyRecordMapper;
import com.byh.dao.allocation.MultipleSphereMapper;
import com.byh.dao.allocation.OtherBillInfoMapper;
import com.byh.dao.allocation.OtherPartakeMapper;
import com.byh.dao.consultation.ConsultationMapper;
import com.byh.enums.AccountTypeEnum;
import com.byh.enums.AllocationStatusEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.WhetherHandEnum;
import com.byh.feign.IDocBalanceOperateApiClient;
import com.byh.feign.IDoctorApiClient;
import com.byh.pojo.bo.allocation.ApplyRelatedInfo;
import com.byh.pojo.bo.allocation.ReceiveRelatedInfo;
import com.byh.pojo.bo.allocation.RelatedInfoBO;
import com.byh.pojo.bo.consultation.ConsulationEntityDownloadDto;
import com.byh.pojo.entity.allocation.BillInfo;
import com.byh.pojo.entity.allocation.IncomeModifyRecord;
import com.byh.pojo.entity.allocation.MultipleAccountRule;
import com.byh.pojo.entity.allocation.MultipleSphere;
import com.byh.pojo.entity.allocation.OtherBillInfo;
import com.byh.pojo.entity.allocation.OtherPartake;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.vo.allocation.req.BatchSettleReqVO;
import com.byh.pojo.vo.allocation.req.BatchUpdateIncomeReqVO;
import com.byh.pojo.vo.allocation.req.BillInfoReqVO;
import com.byh.pojo.vo.allocation.req.ExportExcelReqVO;
import com.byh.pojo.vo.allocation.req.ImmediateSettleReqVO;
import com.byh.pojo.vo.allocation.req.OtherPartakeIncomeReqVO;
import com.byh.pojo.vo.allocation.req.OverviewSettleReqVO;
import com.byh.pojo.vo.allocation.req.UpdateIncomeReqVO;
import com.byh.pojo.vo.allocation.resp.AllocationOverviewRespVO;
import com.byh.pojo.vo.allocation.resp.AllocationStatisticalInfoRespVO;
import com.byh.pojo.vo.allocation.resp.BillInfoRespVO;
import com.byh.pojo.vo.allocation.resp.BusinessTypeInfoRespVO;
import com.byh.pojo.vo.consultation.DoctorBillHxgyVo;
import com.byh.service.allocation.BillInfoService;
import com.byh.service.allocation.MultipleAccountRuleService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.task.allocation.BillAllocationHelper;
import com.byh.util.DateTimeUtil;
import com.byh.util.DateUtils;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctor.basedata.api.vo.ConsultationRemunerationReqVO;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorUserInfoVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.JedisCluster;

@Service
public class BillInfoServiceImpl
implements BillInfoService {
    private static final Logger log = LoggerFactory.getLogger(BillInfoServiceImpl.class);
    private static final String[] mHeader = new String[]{"\u5e8f\u53f7", "\u8ba2\u5355ID", "\u4e0a\u4f20\u62a5\u544a\u65f6\u95f4", "\u8ba2\u5355\u5b8c\u6210\u65f6\u95f4", "\u60a3\u8005\u59d3\u540d", "\u53d1\u8d77\u7c7b\u578b", "\u8ba2\u5355\u6536\u76ca\uff08\u5143\uff09", "\u4e0b\u7ea7\u533b\u9662", "\u4e0b\u7ea7\u533b\u751f", "\u5206\u8d26\u91d1\u989d\uff08\u4e0b\u7ea7\u533b\u751f\uff1a\u5143\uff09", "\u4e0a\u7ea7\u533b\u9662", "\u4e0a\u7ea7\u79d1\u5ba4", "\u4e0a\u7ea7\u4e13\u5bb6", "\u4e0a\u7ea7\u804c\u79f0", "\u5206\u8d26\u91d1\u989d\uff08\u4e0a\u7ea7\u533b\u751f\uff1a\u5143\uff09"};
    private static final Integer[] businessCodeArr = new Integer[]{101, 103, 105, 107};
    private static final String[] businessNameArr = new String[]{"\u533b\u8054\u4f53\u56fe\u6587\u4f1a\u8bca", "\u533b\u8054\u4f53\u89c6\u9891\u4f1a\u8bca", "\u4e13\u5bb6\u56fe\u6587\u4f1a\u8bca", "\u4e13\u5bb6\u89c6\u9891\u4f1a\u8bca"};
    @Autowired
    private IDocBalanceOperateApiClient balanceOperateApiClient;
    @Autowired
    private BillInfoMapper billInfoMapper;
    @Autowired
    private OtherBillInfoMapper otherBillInfoMapper;
    @Autowired
    private MultipleSphereMapper multipleSphereMapper;
    @Autowired
    private OtherPartakeMapper otherPartakeMapper;
    @Autowired
    private ConsultationMapper consultationMapper;
    @Autowired
    private IncomeModifyRecordMapper incomeModifyRecordMapper;
    @Autowired
    private MultipleAccountRuleService multipleAccountRuleService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private BillAllocationHelper billAllocationHelper;
    private String redisKey = "immediate_settle";

    public List<BusinessTypeInfoRespVO> findBusinessTypeInfoList() {
        ArrayList<BusinessTypeInfoRespVO> businessTypeInfoRespVOList = new ArrayList<BusinessTypeInfoRespVO>();
        for (int i = 0; i < 4; ++i) {
            BusinessTypeInfoRespVO businessTypeInfoRespVO = new BusinessTypeInfoRespVO();
            businessTypeInfoRespVO.setBusinessCode(businessCodeArr[i]);
            businessTypeInfoRespVO.setBusinessName(businessNameArr[i]);
            Integer multipleAccountRuleNum = this.billInfoMapper.getRuleNumByBusinessCode(businessCodeArr[i]);
            businessTypeInfoRespVO.setMultipleAccountRuleNum(multipleAccountRuleNum);
            long allocatedNum = this.billInfoMapper.getAllocatedNumByBusinessCode(businessCodeArr[i]);
            long totalNum = this.billInfoMapper.getNumByBusinessCode(businessCodeArr[i]);
            Double allocationPercentage = this.getAllocationPercentage(allocatedNum, totalNum);
            businessTypeInfoRespVO.setAllocatedNum(Long.valueOf(allocatedNum));
            businessTypeInfoRespVO.setTotalNum(Long.valueOf(totalNum));
            businessTypeInfoRespVO.setUnallocatedNum(Long.valueOf(totalNum - allocatedNum));
            businessTypeInfoRespVO.setAllocationPercentage(allocationPercentage);
            businessTypeInfoRespVOList.add(businessTypeInfoRespVO);
        }
        return businessTypeInfoRespVOList;
    }

    private Double getAllocationPercentage(long allocatedNum, long totalNum) {
        if (totalNum == 0L) {
            return 100.0;
        }
        double v = (double)allocatedNum * 1.0 / (double)totalNum * 100.0;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        String format = nf.format(v);
        return Double.valueOf(format);
    }

    public List<AllocationOverviewRespVO> findAllocationOverviewList(Integer businessCode, String allocationRuleName) {
        List allocationOverviewList = this.billInfoMapper.findAllocationOverviewList(businessCode, allocationRuleName);
        if (allocationOverviewList != null && allocationOverviewList.size() > 0) {
            for (AllocationOverviewRespVO allocationOverviewRespVO : allocationOverviewList) {
                Long multipleAccountRuleId = allocationOverviewRespVO.getMultipleAccountRuleId();
                if (multipleAccountRuleId == null) {
                    allocationOverviewRespVO.setName("\u65e0\u89c4\u5219");
                    allocationOverviewRespVO.setAllocationTypeName("\u4eba\u5de5\u7ed3\u7b97");
                }
                BigDecimal applyDoctorUnsettleTotalIncome = this.billInfoMapper.getApplyDoctorUnsettleTotalIncome(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setApplyDoctorUnsettleTotalIncome(applyDoctorUnsettleTotalIncome);
                BigDecimal receiveDoctorUnsettleTotalIncome = this.billInfoMapper.getReceiveDoctorUnsettleTotalIncome(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setReceiveDoctorUnsettleTotalIncome(receiveDoctorUnsettleTotalIncome);
                Long orderNum = this.billInfoMapper.getOrderNum(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setOrderNum(orderNum);
                Long unsettleOrderNum = this.billInfoMapper.getUnsettleOrderNum(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setUnsettleOrderNum(unsettleOrderNum);
                Long notProcessedNowOrderNum = this.billInfoMapper.getNotProcessedNowOrderNum(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setNotProcessedNowOrderNum(notProcessedNowOrderNum);
                BigDecimal totalIncome = this.billInfoMapper.getTotalIncome(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setTotalIncome(totalIncome);
                List otherPartakeTotalIncomeVOList = this.billInfoMapper.getOtherPartakeTotalIncomeVOList(businessCode, multipleAccountRuleId);
                allocationOverviewRespVO.setOtherPartakeTotalIncomeVOList(otherPartakeTotalIncomeVOList);
            }
        }
        return allocationOverviewList;
    }

    public Map<String, Object> findBillInfoDetail(BillInfoReqVO billInfoReqVO) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AllocationStatisticalInfoRespVO allocationStatisticalInfoRespVO = this.getAllocationStatisticalInfoRespVO(billInfoReqVO);
        ret.put("allocationStatisticalInfoRespVO", allocationStatisticalInfoRespVO);
        PageResult pageResult = this.getBillInfoRespVOPage(billInfoReqVO);
        List content = pageResult.getContent();
        allocationStatisticalInfoRespVO.setOrderNum(Long.valueOf(content.size()));
        HashMap<String, BigDecimal> mMap = new HashMap<String, BigDecimal>();
        if (content != null && content.size() > 0) {
            for (BillInfoRespVO billInfoRespVO : content) {
                String formatTime;
                ConsulationEntityDownloadDto entityById = this.consultationMapper.getConsultationEntityById(billInfoRespVO.getOrderId());
                if (null == entityById.getReportTime()) {
                    formatTime = null;
                } else {
                    Date reportTime = entityById.getReportTime();
                    formatTime = DateTimeUtil.formatTime((Date)reportTime, (String)"yyyy-MM-dd HH:mm:ss");
                }
                billInfoRespVO.setUploadReportTime(formatTime);
                List otherBillInfoList = billInfoRespVO.getOtherBillInfoList();
                if (otherBillInfoList == null || otherBillInfoList.size() <= 0) continue;
                for (OtherBillInfo otherBillInfo : otherBillInfoList) {
                    String partakeName = otherBillInfo.getPartakeName();
                    boolean containsKey = mMap.containsKey(partakeName);
                    if (containsKey) {
                        mMap.put(partakeName, ((BigDecimal)mMap.get(partakeName)).add(otherBillInfo.getPartakeIncome()));
                        continue;
                    }
                    mMap.put(partakeName, otherBillInfo.getPartakeIncome());
                }
            }
        }
        List thirdPartyList = this.otherPartakeMapper.findByMultipleAccountRuleId(billInfoReqVO.getMultipleAccountRuleId());
        ret.put("thirdPartyList", thirdPartyList);
        ret.put("otherPartakeList", mMap);
        ret.put("pageResult", pageResult);
        return ret;
    }

    private PageResult<BillInfoRespVO> getBillInfoRespVOPage(BillInfoReqVO billInfoReqVO) {
        PageHelper.startPage((int)billInfoReqVO.getPageNum(), (int)billInfoReqVO.getPageSize());
        List billInfoRespVOList = this.billInfoMapper.findBillInfoRespVOList(billInfoReqVO);
        if (billInfoRespVOList != null && billInfoRespVOList.size() > 0) {
            for (BillInfoRespVO billInfoRespVO : billInfoRespVOList) {
                List otherBillInfoList = this.otherBillInfoMapper.findByBillInfoId(billInfoRespVO.getId());
                billInfoRespVO.setOtherBillInfoList(otherBillInfoList);
                BigDecimal billOtherPartakeTotalIncome = new BigDecimal(0);
                if (otherBillInfoList != null && otherBillInfoList.size() > 0) {
                    for (OtherBillInfo otherBillInfo : otherBillInfoList) {
                        billOtherPartakeTotalIncome = billOtherPartakeTotalIncome.add(otherBillInfo.getPartakeIncome());
                    }
                }
                billInfoRespVO.setBillOtherPartakeTotalIncome(billOtherPartakeTotalIncome);
            }
        }
        PageInfo pageInfo = new PageInfo(billInfoRespVOList);
        PageResult pageResult = new PageResult();
        pageResult.setPageNum(pageInfo.getPageNum());
        pageResult.setPageSize(pageInfo.getPageSize());
        Long total = pageInfo.getTotal();
        pageResult.setTotal(total.intValue());
        pageResult.setTotalPages(pageInfo.getPages());
        pageResult.setContent(pageInfo.getList());
        return pageResult;
    }

    private AllocationStatisticalInfoRespVO getAllocationStatisticalInfoRespVO(BillInfoReqVO billInfoReqVO) {
        AllocationStatisticalInfoRespVO allocationStatisticalInfoRespVO = this.billInfoMapper.getAllocationStatisticalInfoRespVO(billInfoReqVO);
        if (allocationStatisticalInfoRespVO == null) {
            Long accountRuleId = billInfoReqVO.getMultipleAccountRuleId();
            MultipleAccountRule multipleAccountRule = this.multipleAccountRuleService.getById(accountRuleId);
            if (multipleAccountRule != null) {
                AllocationStatisticalInfoRespVO statisticalInfoRespVO = new AllocationStatisticalInfoRespVO();
                statisticalInfoRespVO.setMultipleAccountRuleId(multipleAccountRule.getId());
                statisticalInfoRespVO.setName(multipleAccountRule.getName());
                statisticalInfoRespVO.setAllocationTypeCode(multipleAccountRule.getAllocationTypeCode());
                statisticalInfoRespVO.setAllocationTypeName(multipleAccountRule.getAllocationTypeName());
                statisticalInfoRespVO.setTotalIncome(new BigDecimal(0));
                statisticalInfoRespVO.setApplyDoctorTotalIncome(new BigDecimal(0));
                statisticalInfoRespVO.setApplyDoctorUnsettleTotalIncome(new BigDecimal(0));
                statisticalInfoRespVO.setReceiveDoctorTotalIncome(new BigDecimal(0));
                statisticalInfoRespVO.setReceiveDoctorUnsettleTotalIncome(new BigDecimal(0));
                statisticalInfoRespVO.setOrderNum(Long.valueOf(0L));
                statisticalInfoRespVO.setUnsettleOrderNum(Long.valueOf(0L));
                statisticalInfoRespVO.setOtherPartakeTotalIncome(new BigDecimal(0));
                return statisticalInfoRespVO;
            }
            AllocationStatisticalInfoRespVO statisticalInfoRespVO = new AllocationStatisticalInfoRespVO();
            statisticalInfoRespVO.setMultipleAccountRuleId(null);
            statisticalInfoRespVO.setName("\u65e0\u89c4\u5219");
            statisticalInfoRespVO.setAllocationTypeCode(null);
            statisticalInfoRespVO.setAllocationTypeName("\u4eba\u5de5\u7ed3\u7b97");
            statisticalInfoRespVO.setTotalIncome(new BigDecimal(0));
            statisticalInfoRespVO.setApplyDoctorTotalIncome(new BigDecimal(0));
            statisticalInfoRespVO.setApplyDoctorUnsettleTotalIncome(new BigDecimal(0));
            statisticalInfoRespVO.setReceiveDoctorTotalIncome(new BigDecimal(0));
            statisticalInfoRespVO.setReceiveDoctorUnsettleTotalIncome(new BigDecimal(0));
            statisticalInfoRespVO.setOrderNum(Long.valueOf(0L));
            statisticalInfoRespVO.setUnsettleOrderNum(Long.valueOf(0L));
            statisticalInfoRespVO.setOtherPartakeTotalIncome(new BigDecimal(0));
            return statisticalInfoRespVO;
        }
        Long multipleAccountRuleId = allocationStatisticalInfoRespVO.getMultipleAccountRuleId();
        if (multipleAccountRuleId == null) {
            allocationStatisticalInfoRespVO.setName("\u65e0\u89c4\u5219");
            allocationStatisticalInfoRespVO.setAllocationTypeName("\u4eba\u5de5\u7ed3\u7b97");
        }
        BigDecimal applyDoctorUnsettleTotalIncome = this.billInfoMapper.getApplyDoctorUnsettleTotalIncomeEnhance(billInfoReqVO);
        allocationStatisticalInfoRespVO.setApplyDoctorUnsettleTotalIncome(applyDoctorUnsettleTotalIncome);
        BigDecimal receiveDoctorUnsettleTotalIncome = this.billInfoMapper.getReceiveDoctorUnsettleTotalIncomeEnhance(billInfoReqVO);
        allocationStatisticalInfoRespVO.setReceiveDoctorUnsettleTotalIncome(receiveDoctorUnsettleTotalIncome);
        Long unsettleOrderNum = this.billInfoMapper.getUnsettleOrderNumEnhance(billInfoReqVO);
        allocationStatisticalInfoRespVO.setUnsettleOrderNum(unsettleOrderNum);
        BigDecimal otherPartakeTotalIncome = this.billInfoMapper.getOtherPartakeTotalIncomeEnhance(billInfoReqVO);
        allocationStatisticalInfoRespVO.setOtherPartakeTotalIncome(otherPartakeTotalIncome);
        return allocationStatisticalInfoRespVO;
    }

    public Map<String, String> overviewImmediateSettle(OverviewSettleReqVO overviewSettleReqVO) {
        String overviewKey = "overview_immediate_settle";
        JedisCluster jedisCluster = RedisConfiguration.getJedisCluster();
        log.info("\u6982\u89c8\u5212\u62e8\u83b7\u53d6JedisCluster\u5bf9\u8c61={}", (Object)jedisCluster);
        jedisCluster.hset(overviewKey, overviewKey + System.currentTimeMillis(), overviewKey);
        jedisCluster.expire(overviewKey, 86400);
        HashMap<String, String> retMap = new HashMap<String, String>();
        List unsettleBillList = this.billInfoMapper.getUnsettleBillList(overviewSettleReqVO.getBusinessCode(), overviewSettleReqVO.getMultipleAccountRuleId());
        if (unsettleBillList != null && unsettleBillList.size() > 0) {
            for (BillInfo billInfo : unsettleBillList) {
                log.info("\u6982\u89c8\u7ed3\u7b97\u5212\u62e8\u8d26\u5355\u6570\u636e:{}", (Object)billInfo.toString());
                String orderId = billInfo.getOrderId().toString();
                boolean flag = jedisCluster.hexists(overviewKey, orderId);
                if (flag) continue;
                jedisCluster.hset(overviewKey, orderId, orderId);
                if (AllocationStatusEnum.HAVE_ALLOCATED.getValue().equals(billInfo.getAssignStatus())) {
                    log.info("\u8ba2\u5355\u5df2\u5212\u62e8");
                    continue;
                }
                if (WhetherHandEnum.UNTREATED.getValue().equals(billInfo.getWhetherHand())) continue;
                DoctorBillHxgyVo applyDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String applyAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getApplyHospitalId());
                if (applyAppCode == null || "".equals(applyAppCode)) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                    continue;
                }
                log.info("\u6982\u89c8\u5212\u62e8\u5f00\u59cb,\u5212\u62e8\u5355\u53f7{}", (Object)orderId);
                applyDoctorBillHxgyVo.setObjectId(billInfo.getApplyDoctorId().toString());
                applyDoctorBillHxgyVo.setOrganCode(billInfo.getApplyHospitalId().toString());
                applyDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                applyDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                applyDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                applyDoctorBillHxgyVo.setBillMoney(billInfo.getApplyDoctorIncome());
                applyDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setCreator(overviewSettleReqVO.getOperatorName());
                applyDoctorBillHxgyVo.setTransactionId(billInfo.getApplyDoctorId() + billInfo.getViewId());
                applyDoctorBillHxgyVo.setDeptName(billInfo.getApplySecondDeptName());
                applyDoctorBillHxgyVo.setDoctorName(billInfo.getApplyDoctorName());
                applyDoctorBillHxgyVo.setHospitalName(billInfo.getApplyHospitalName());
                applyDoctorBillHxgyVo.setAppCode(applyAppCode);
                DoctorBillHxgyVo receiveDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String receiveAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getReceiveHospitalId());
                if (receiveAppCode == null || "".equals(receiveAppCode)) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                    continue;
                }
                receiveDoctorBillHxgyVo.setObjectId(billInfo.getReceiveDoctorId().toString());
                receiveDoctorBillHxgyVo.setOrganCode(billInfo.getReceiveHospitalId().toString());
                receiveDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                receiveDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                receiveDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                receiveDoctorBillHxgyVo.setBillMoney(billInfo.getReceiveDoctorIncome());
                receiveDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setCreator(overviewSettleReqVO.getOperatorName());
                receiveDoctorBillHxgyVo.setTransactionId(billInfo.getReceiveDoctorId() + billInfo.getViewId());
                receiveDoctorBillHxgyVo.setDeptName(billInfo.getReceiveSecondDeptName());
                receiveDoctorBillHxgyVo.setDoctorName(billInfo.getReceiveDoctorName());
                receiveDoctorBillHxgyVo.setHospitalName(billInfo.getReceiveHospitalName());
                receiveDoctorBillHxgyVo.setAppCode(receiveAppCode);
                ConsultationRemunerationReqVO consultationVo = new ConsultationRemunerationReqVO();
                consultationVo.setAccompanyDoctorId(Long.valueOf(billInfo.getApplyDoctorId()));
                consultationVo.setAccompanyPrice(billInfo.getApplyDoctorIncome());
                consultationVo.setTreatmentDoctorId(Long.valueOf(billInfo.getReceiveDoctorId()));
                consultationVo.setServicePrice(billInfo.getReceiveDoctorIncome());
                consultationVo.setOrderNo(orderId);
                log.info("\u6982\u89c8,\u533b\u751f\u4f59\u989d\u4fee\u6539,\u5212\u62e8\u5355\u53f7{}", (Object)orderId);
                BaseResponse baseResponse = this.balanceOperateApiClient.transferConsultationRemuneration(consultationVo);
                if (!baseResponse.getCode().equals("1")) {
                    log.info("\u6982\u89c8\u5212\u62e8\u5355\u7b14\u5931\u8d25,\u8d26\u5355:{}", (Object)billInfo);
                    jedisCluster.hdel(overviewKey, new String[]{orderId});
                    continue;
                }
                Map applyErrorMap = this.billAllocationHelper.callAddBill(applyDoctorBillHxgyVo);
                if (applyErrorMap.size() > 0) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                }
                log.info("\u6982\u89c8\u8d26\u5355\u670d\u52a1\u5b58\u7533\u8bf7\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)applyDoctorBillHxgyVo.toString(), (Object)applyErrorMap);
                Map receiveErrorMap = this.billAllocationHelper.callAddBill(receiveDoctorBillHxgyVo);
                if (receiveErrorMap.size() > 0) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                }
                log.info("\u6982\u89c8\u8d26\u5355\u670d\u52a1\u5b58\u63a5\u8bca\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)receiveDoctorBillHxgyVo.toString(), (Object)receiveErrorMap);
                billInfo.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
                billInfo.setSettlementOperatorId(overviewSettleReqVO.getOperatorId());
                billInfo.setSettlementOperatorName(overviewSettleReqVO.getOperatorName());
                billInfo.setSettlingTime(new Date());
                this.billInfoMapper.updateByPrimaryKey(billInfo);
                jedisCluster.hdel(overviewKey, new String[]{orderId});
                log.info("\u6982\u89c8\u5212\u62e8\u6210\u529f,\u6982\u89c8\u8d26\u5355:{},\u5212\u62e8\u6210\u529f", (Object)billInfo);
            }
        }
        return retMap;
    }

    public Map<String, String> batchImmediateSettle(BatchSettleReqVO batchSettleReqVO) {
        String batchKey = "batch_immediate_settle";
        JedisCluster jedisCluster = RedisConfiguration.getJedisCluster();
        log.info("\u6279\u91cf\u5212\u62e8\u83b7\u53d6JedisCluster\u5bf9\u8c61={}", (Object)jedisCluster);
        jedisCluster.hset(batchKey, batchKey + System.currentTimeMillis(), batchKey);
        jedisCluster.expire(batchKey, 86400);
        HashMap<String, String> retMap = new HashMap<String, String>();
        List unsettleBillList = this.billInfoMapper.getUnsettleBillListByIds(batchSettleReqVO.getBillInfoIds());
        if (unsettleBillList != null && unsettleBillList.size() > 0) {
            this.redisPullImmediateSettlement(unsettleBillList);
            for (BillInfo billInfo : unsettleBillList) {
                String orderId = billInfo.getOrderId().toString();
                boolean flag = jedisCluster.hexists(batchKey, orderId);
                if (flag) continue;
                jedisCluster.hset(batchKey, orderId, orderId);
                log.info("\u6279\u91cf\u7ed3\u7b97\u5212\u62e8\u8d26\u5355\u6570\u636e:{}", (Object)billInfo.toString());
                if (AllocationStatusEnum.HAVE_ALLOCATED.getValue().equals(billInfo.getAssignStatus()) || WhetherHandEnum.UNTREATED.getValue().equals(billInfo.getWhetherHand())) continue;
                DoctorBillHxgyVo applyDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String applyAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getApplyHospitalId());
                if (applyAppCode == null || "".equals(applyAppCode)) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                    continue;
                }
                applyDoctorBillHxgyVo.setObjectId(billInfo.getApplyDoctorId().toString());
                applyDoctorBillHxgyVo.setOrganCode(billInfo.getApplyHospitalId().toString());
                applyDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                applyDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                applyDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                applyDoctorBillHxgyVo.setBillMoney(billInfo.getApplyDoctorIncome());
                applyDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setCreator(batchSettleReqVO.getOperatorName());
                applyDoctorBillHxgyVo.setTransactionId(billInfo.getApplyDoctorId() + billInfo.getViewId());
                applyDoctorBillHxgyVo.setDeptName(billInfo.getApplySecondDeptName());
                applyDoctorBillHxgyVo.setDoctorName(billInfo.getApplyDoctorName());
                applyDoctorBillHxgyVo.setHospitalName(billInfo.getApplyHospitalName());
                applyDoctorBillHxgyVo.setAppCode(applyAppCode);
                DoctorBillHxgyVo receiveDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String receiveAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getReceiveHospitalId());
                if (receiveAppCode == null || "".equals(receiveAppCode)) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                    continue;
                }
                receiveDoctorBillHxgyVo.setObjectId(billInfo.getReceiveDoctorId().toString());
                receiveDoctorBillHxgyVo.setOrganCode(billInfo.getReceiveHospitalId().toString());
                receiveDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                receiveDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                receiveDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                receiveDoctorBillHxgyVo.setBillMoney(billInfo.getReceiveDoctorIncome());
                receiveDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setCreator(batchSettleReqVO.getOperatorName());
                receiveDoctorBillHxgyVo.setTransactionId(billInfo.getReceiveDoctorId() + billInfo.getViewId());
                receiveDoctorBillHxgyVo.setDeptName(billInfo.getReceiveSecondDeptName());
                receiveDoctorBillHxgyVo.setDoctorName(billInfo.getReceiveDoctorName());
                receiveDoctorBillHxgyVo.setHospitalName(billInfo.getReceiveHospitalName());
                receiveDoctorBillHxgyVo.setAppCode(receiveAppCode);
                ConsultationRemunerationReqVO consultationVo = new ConsultationRemunerationReqVO();
                consultationVo.setAccompanyDoctorId(Long.valueOf(billInfo.getApplyDoctorId()));
                consultationVo.setAccompanyPrice(billInfo.getApplyDoctorIncome());
                consultationVo.setTreatmentDoctorId(Long.valueOf(billInfo.getReceiveDoctorId()));
                consultationVo.setServicePrice(billInfo.getReceiveDoctorIncome());
                consultationVo.setOrderNo(orderId);
                log.info("\u6279\u91cf,\u533b\u751f\u4f59\u989d\u4fee\u6539,\u5212\u62e8\u5355\u53f7{}", (Object)orderId);
                BaseResponse baseResponse = this.balanceOperateApiClient.transferConsultationRemuneration(consultationVo);
                if (!baseResponse.getCode().equals("1")) {
                    log.info("\u6279\u91cf\u5212\u62e8\u5355\u7b14\u5931\u8d25,\u8d26\u5355:{}", (Object)billInfo);
                    jedisCluster.hdel(batchKey, new String[]{orderId});
                    continue;
                }
                Map applyErrorMap = this.billAllocationHelper.callAddBill(applyDoctorBillHxgyVo);
                if (applyErrorMap.size() > 0) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                }
                log.info("\u6279\u91cf\u7ed3\u7b97,\u8d26\u5355\u670d\u52a1\u5b58\u7533\u8bf7\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)applyDoctorBillHxgyVo.toString(), (Object)applyErrorMap);
                Map receiveErrorMap = this.billAllocationHelper.callAddBill(receiveDoctorBillHxgyVo);
                if (receiveErrorMap.size() > 0) {
                    retMap.put("errorMsg", "\u90e8\u5206\u7ed3\u7b97\u5931\u8d25\uff01");
                }
                log.info("\u6279\u91cf\u7ed3\u7b97,\u8d26\u5355\u670d\u52a1\u5b58\u63a5\u8bca\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)receiveDoctorBillHxgyVo.toString(), (Object)receiveErrorMap);
                billInfo.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
                billInfo.setSettlementOperatorId(batchSettleReqVO.getOperatorId());
                billInfo.setSettlementOperatorName(batchSettleReqVO.getOperatorName());
                billInfo.setSettlingTime(new Date());
                this.billInfoMapper.updateByPrimaryKey(billInfo);
                jedisCluster.hdel(batchKey, new String[]{orderId});
                log.info("\u6279\u91cf\u8d26\u5355:{},\u5212\u62e8\u6210\u529f", (Object)billInfo);
            }
        }
        return retMap;
    }

    public void immediateSettle(ImmediateSettleReqVO immediateSettleReqVO) {
        JedisCluster jedisCluster = RedisConfiguration.getJedisCluster();
        log.info("\u5355\u4e2a\u5212\u62e8\u83b7\u53d6JedisCluster\u5bf9\u8c61={}", (Object)jedisCluster);
        BillInfo billInfo = this.billInfoMapper.selectByPrimaryKey(immediateSettleReqVO.getBillInfoId());
        ArrayList<BillInfo> unsettleBillList = new ArrayList<BillInfo>();
        unsettleBillList.add(billInfo);
        this.redisPullImmediateSettlement(unsettleBillList);
        String orderId = billInfo.getOrderId().toString();
        boolean flag = jedisCluster.hexists(this.redisKey, orderId);
        if (flag) {
            throw new RuntimeException("\u8ba2\u5355\u6b63\u5728\u5212\u62e8\u4e2d...");
        }
        log.info("\u6279\u91cf\u7ed3\u7b97\u5212\u62e8\u8d26\u5355\u6570\u636e:{}", (Object)billInfo.toString());
        if (WhetherHandEnum.UNTREATED.getValue().equals(billInfo.getWhetherHand())) {
            throw new RuntimeException("\u6682\u4e0d\u5904\u7406\u8ba2\u5355\u65e0\u6cd5\u7ed3\u7b97\uff01");
        }
        if (AllocationStatusEnum.HAVE_ALLOCATED.getValue().equals(billInfo.getAssignStatus())) {
            throw new RuntimeException("\u8ba2\u5355\u5df2\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97\uff01");
        }
        DoctorBillHxgyVo applyDoctorBillHxgyVo = new DoctorBillHxgyVo();
        String applyAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getApplyHospitalId());
        if (applyAppCode == null || "".equals(applyAppCode)) {
            throw new RuntimeException("\u901a\u8fc7ApplyHospitalId\u83b7\u53d6appCode\u4e3a\u7a7a\uff0c\u8c03\u7528\u8d26\u5355\u670d\u52a1\u5931\u8d25\uff01");
        }
        applyDoctorBillHxgyVo.setObjectId(billInfo.getApplyDoctorId().toString());
        applyDoctorBillHxgyVo.setOrganCode(billInfo.getApplyHospitalId().toString());
        applyDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
        applyDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
        applyDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
        applyDoctorBillHxgyVo.setBillMoney(billInfo.getApplyDoctorIncome());
        applyDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
        applyDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
        applyDoctorBillHxgyVo.setCreator(immediateSettleReqVO.getOperatorName());
        applyDoctorBillHxgyVo.setTransactionId(billInfo.getApplyDoctorId() + billInfo.getViewId());
        applyDoctorBillHxgyVo.setDeptName(billInfo.getApplySecondDeptName());
        applyDoctorBillHxgyVo.setDoctorName(billInfo.getApplyDoctorName());
        applyDoctorBillHxgyVo.setHospitalName(billInfo.getApplyHospitalName());
        applyDoctorBillHxgyVo.setAppCode(applyAppCode);
        DoctorBillHxgyVo receiveDoctorBillHxgyVo = new DoctorBillHxgyVo();
        String receiveAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getReceiveHospitalId());
        if (receiveAppCode == null || "".equals(receiveAppCode)) {
            throw new RuntimeException("\u901a\u8fc7ReceiveDoctorId\u83b7\u53d6appCode\u4e3a\u7a7a\uff0c\u8c03\u7528\u8d26\u5355\u670d\u52a1\u5931\u8d25\uff01");
        }
        receiveDoctorBillHxgyVo.setObjectId(billInfo.getReceiveDoctorId().toString());
        receiveDoctorBillHxgyVo.setOrganCode(billInfo.getReceiveHospitalId().toString());
        receiveDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
        receiveDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
        receiveDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
        receiveDoctorBillHxgyVo.setBillMoney(billInfo.getReceiveDoctorIncome());
        receiveDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
        receiveDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
        receiveDoctorBillHxgyVo.setCreator(immediateSettleReqVO.getOperatorName());
        receiveDoctorBillHxgyVo.setTransactionId(billInfo.getReceiveDoctorId() + billInfo.getViewId());
        receiveDoctorBillHxgyVo.setDeptName(billInfo.getReceiveSecondDeptName());
        receiveDoctorBillHxgyVo.setDoctorName(billInfo.getReceiveDoctorName());
        receiveDoctorBillHxgyVo.setHospitalName(billInfo.getReceiveHospitalName());
        receiveDoctorBillHxgyVo.setAppCode(receiveAppCode);
        ConsultationRemunerationReqVO consultationVo = new ConsultationRemunerationReqVO();
        consultationVo.setAccompanyDoctorId(Long.valueOf(billInfo.getApplyDoctorId()));
        consultationVo.setAccompanyPrice(billInfo.getApplyDoctorIncome());
        consultationVo.setTreatmentDoctorId(Long.valueOf(billInfo.getReceiveDoctorId()));
        consultationVo.setServicePrice(billInfo.getReceiveDoctorIncome());
        consultationVo.setOrderNo(orderId);
        log.info("\u5355\u4e2a,\u533b\u751f\u4f59\u989d\u4fee\u6539,\u5212\u62e8\u5355\u53f7{}", (Object)orderId);
        BaseResponse baseResponse = this.balanceOperateApiClient.transferConsultationRemuneration(consultationVo);
        if (!baseResponse.getCode().equals("1")) {
            log.info("\u5355\u4e2a\u5212\u62e8\u5355\u7b14\u5931\u8d25,\u8d26\u5355:{}", (Object)billInfo);
            throw new RuntimeException("\u8c03\u7528\u533b\u751f\u670d\u52a1\u4fee\u6539\u533b\u751f\u4f59\u989d\u5931\u8d25\uff01");
        }
        Map applyErrorMap = this.billAllocationHelper.callAddBill(applyDoctorBillHxgyVo);
        if (applyErrorMap.size() > 0) {
            throw new RuntimeException("\u8c03\u7528\u8d26\u5355\u670d\u52a1addBillDetail\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        log.info("\u8be6\u60c5\u8d26\u5355\u670d\u52a1\u5b58\u7533\u8bf7\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)applyDoctorBillHxgyVo.toString(), (Object)applyErrorMap);
        Map receiveErrorMap = this.billAllocationHelper.callAddBill(receiveDoctorBillHxgyVo);
        if (receiveErrorMap.size() > 0) {
            throw new RuntimeException("\u8c03\u7528\u8d26\u5355\u670d\u52a1addBillDetail\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        log.info("\u8be6\u60c5\u8d26\u5355\u670d\u52a1\u5b58\u63a5\u8bca\u533b\u751f:{},\u5b58\u6210\u529f\u8fd4\u56de:{}", (Object)receiveDoctorBillHxgyVo.toString(), (Object)receiveErrorMap);
        billInfo.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
        billInfo.setSettlementOperatorId(immediateSettleReqVO.getOperatorId());
        billInfo.setSettlementOperatorName(immediateSettleReqVO.getOperatorName());
        billInfo.setSettlingTime(new Date());
        this.billInfoMapper.updateByPrimaryKey(billInfo);
        jedisCluster.hdel(this.redisKey, new String[]{orderId});
        log.info("\u5355\u4e2a\u8d26\u5355:{},\u5212\u62e8\u6210\u529f", (Object)billInfo);
    }

    public void redisPullImmediateSettlement(List<BillInfo> list) {
        List orderIds = list.stream().map(BillInfo::getOrderId).collect(Collectors.toList());
        orderIds.stream().forEach(s -> RedisConfiguration.getJedisCluster().sadd(s.toString(), new String[]{s.toString()}));
    }

    @Transactional
    public boolean initBillInfoAndProcessImmediateSettlement(Long orderId) {
        if (orderId == null) {
            return false;
        }
        ConsultationEntity consultation = this.consultationService.queryConsultationEntityById(orderId);
        if (consultation == null) {
            return false;
        }
        ConsultationExtendEntity consultationExtend = this.consultationExtendService.queryByConsultationId(orderId);
        if (consultationExtend == null) {
            return false;
        }
        BillInfo mBillInfo = this.billInfoMapper.getByOrderId(orderId);
        if (mBillInfo != null) {
            return false;
        }
        RelatedInfoBO relatedInfoBO = this.getRelatedInfoBO(consultation, consultationExtend);
        log.info("\u7533\u8bf7\u533b\u751f\u548c\u63a5\u8bca\u533b\u751f\u548c\u89c4\u5219\u8fdb\u884c\u5173\u8054\u7684\u4fe1\u606f" + relatedInfoBO.toString());
        MultipleAccountRule multipleAccountRule = this.getMultipleAccountRule(relatedInfoBO, consultation.getServiceCode());
        if (multipleAccountRule != null) {
            Integer allocationTypeCode;
            BigDecimal receiveDoctorIncome;
            BigDecimal applyDoctorIncome;
            List otherPartakeList = this.otherPartakeMapper.findByMultipleAccountRuleId(multipleAccountRule.getId());
            BillInfo billInfo = new BillInfo();
            billInfo.setMultipleAccountRuleId(multipleAccountRule.getId());
            billInfo.setOrderId(consultation.getId());
            billInfo.setViewId(UuidUtils.generateUUID());
            billInfo.setStatus(Integer.valueOf(1));
            billInfo.setAssignStatus(AllocationStatusEnum.NOT_ALLOCATED.getValue());
            billInfo.setApplyDoctorId(consultation.getDoctorId());
            billInfo.setApplyDoctorName(consultation.getDoctorName());
            Integer applyAmountMethodCode = multipleAccountRule.getApplyAmountMethodCode();
            if (applyAmountMethodCode.equals(AccountTypeEnum.FIXED.getValue())) {
                applyDoctorIncome = multipleAccountRule.getApplyAmountStandard();
            } else {
                BigDecimal divide = multipleAccountRule.getApplyAmountStandard().divide(new BigDecimal(100), 2, 1);
                applyDoctorIncome = consultationExtend.getPrice().multiply(divide);
            }
            billInfo.setApplyDoctorIncome(applyDoctorIncome);
            billInfo.setApplyHospitalId(consultation.getDoctorHospitalId());
            billInfo.setApplyHospitalName(consultation.getDoctorHosName());
            billInfo.setApplyDeptId(consultation.getExpertDepId());
            billInfo.setApplyDeptName(consultation.getExpertDeptName());
            billInfo.setApplySecondDeptId(consultation.getDoctorSecondDeptId());
            billInfo.setApplySecondDeptName(consultation.getDoctorSecondDeptName());
            billInfo.setReceiveDoctorId(consultation.getExpertId());
            billInfo.setReceiveDoctorName(consultation.getExpertName());
            Integer receiveAmountMethodCode = multipleAccountRule.getReceiveAmountMethodCode();
            if (receiveAmountMethodCode.equals(AccountTypeEnum.FIXED.getValue())) {
                receiveDoctorIncome = multipleAccountRule.getReceiveAmountStandard();
            } else {
                BigDecimal divide = multipleAccountRule.getReceiveAmountStandard().divide(new BigDecimal(100), 2, 1);
                receiveDoctorIncome = consultationExtend.getPrice().multiply(divide);
            }
            billInfo.setReceiveDoctorIncome(receiveDoctorIncome);
            billInfo.setReceiveHospitalId(consultation.getExpertHospitalId());
            billInfo.setReceiveHospitalName(consultation.getExpertHosName());
            billInfo.setReceiveDeptId(consultation.getExpertDepId());
            billInfo.setReceiveDeptName(consultation.getExpertDeptName());
            billInfo.setReceiveSecondDeptId(consultation.getExpertSecondDeptId());
            billInfo.setReceiveSecondDeptName(consultation.getExpertSecondDeptName());
            billInfo.setWhetherHand(WhetherHandEnum.TREATED.getValue());
            billInfo.setPayAmount(consultationExtend.getPrice());
            billInfo.setBusinessCode(consultation.getServiceCode());
            billInfo.setBusinessName(this.getBusinessName(consultation.getServiceCode()));
            billInfo.setOrderViewId(consultation.getViewId());
            billInfo.setAccountRuleName(multipleAccountRule.getName());
            billInfo.setAllocationTypeCode(multipleAccountRule.getAllocationTypeCode());
            billInfo.setAllocationTypeName(multipleAccountRule.getAllocationTypeName());
            billInfo.setScheduleCode(multipleAccountRule.getScheduleCode());
            billInfo.setScheduleName(multipleAccountRule.getScheduleName());
            this.billInfoMapper.insert(billInfo);
            if (otherPartakeList != null && otherPartakeList.size() > 0) {
                for (OtherPartake otherPartake : otherPartakeList) {
                    OtherBillInfo otherBillInfo = new OtherBillInfo();
                    otherBillInfo.setBillInfoId(billInfo.getId());
                    otherBillInfo.setViewId(UuidUtils.generateUUID());
                    otherBillInfo.setStatus(Integer.valueOf(1));
                    otherBillInfo.setPartakeName(otherPartake.getName());
                    otherBillInfo.setOtherPartakeId(otherPartake.getId());
                    if (otherPartake.getAmountMethodCode().equals(AccountTypeEnum.FIXED.getValue())) {
                        otherBillInfo.setPartakeIncome(otherPartake.getAmountStandard());
                    } else {
                        BigDecimal divide = otherPartake.getAmountStandard().divide(new BigDecimal(100), 2, 1);
                        BigDecimal otherPartakeIncome = billInfo.getPayAmount().multiply(divide);
                        otherBillInfo.setPartakeIncome(otherPartakeIncome);
                    }
                    this.otherBillInfoMapper.insert(otherBillInfo);
                }
            }
            if ((allocationTypeCode = multipleAccountRule.getAllocationTypeCode()).equals(1)) {
                BillInfo billInfoNew = this.billInfoMapper.selectByPrimaryKey(billInfo.getId());
                DoctorBillHxgyVo applyDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String applyAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfoNew.getApplyHospitalId());
                if (applyAppCode == null || "".equals(applyAppCode)) {
                    throw new RuntimeException("\u901a\u8fc7ApplyHospitalId\u83b7\u53d6appCode\u4e3a\u7a7a\uff0c\u8c03\u7528\u8d26\u5355\u670d\u52a1\u5931\u8d25\uff01");
                }
                applyDoctorBillHxgyVo.setObjectId(billInfoNew.getApplyDoctorId().toString());
                applyDoctorBillHxgyVo.setOrganCode(billInfoNew.getApplyHospitalId().toString());
                applyDoctorBillHxgyVo.setServCode(billInfoNew.getBusinessCode().toString());
                applyDoctorBillHxgyVo.setOrderId(billInfoNew.getOrderId().toString());
                applyDoctorBillHxgyVo.setOrderMoney(billInfoNew.getPayAmount());
                applyDoctorBillHxgyVo.setBillMoney(billInfoNew.getApplyDoctorIncome());
                applyDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setCreator("\u7cfb\u7edf\u5b9e\u65f6\u7ed3\u7b97");
                applyDoctorBillHxgyVo.setTransactionId(billInfoNew.getApplyDoctorId() + billInfoNew.getViewId());
                applyDoctorBillHxgyVo.setDeptName(billInfoNew.getApplySecondDeptName());
                applyDoctorBillHxgyVo.setDoctorName(billInfoNew.getApplyDoctorName());
                applyDoctorBillHxgyVo.setHospitalName(billInfoNew.getApplyHospitalName());
                applyDoctorBillHxgyVo.setAppCode(applyAppCode);
                DoctorBillHxgyVo receiveDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String receiveAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfoNew.getReceiveHospitalId());
                if (receiveAppCode == null || "".equals(receiveAppCode)) {
                    throw new RuntimeException("\u901a\u8fc7ReceiveDoctorId\u83b7\u53d6appCode\u4e3a\u7a7a\uff0c\u8c03\u7528\u8d26\u5355\u670d\u52a1\u5931\u8d25\uff01");
                }
                receiveDoctorBillHxgyVo.setObjectId(billInfoNew.getReceiveDoctorId().toString());
                receiveDoctorBillHxgyVo.setOrganCode(billInfoNew.getReceiveHospitalId().toString());
                receiveDoctorBillHxgyVo.setServCode(billInfoNew.getBusinessCode().toString());
                receiveDoctorBillHxgyVo.setOrderId(billInfoNew.getOrderId().toString());
                receiveDoctorBillHxgyVo.setOrderMoney(billInfoNew.getPayAmount());
                receiveDoctorBillHxgyVo.setBillMoney(billInfoNew.getReceiveDoctorIncome());
                receiveDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setCreator("\u7cfb\u7edf\u5b9e\u65f6\u7ed3\u7b97");
                receiveDoctorBillHxgyVo.setTransactionId(billInfoNew.getReceiveDoctorId() + billInfoNew.getViewId());
                receiveDoctorBillHxgyVo.setDeptName(billInfoNew.getReceiveSecondDeptName());
                receiveDoctorBillHxgyVo.setDoctorName(billInfoNew.getReceiveDoctorName());
                receiveDoctorBillHxgyVo.setHospitalName(billInfoNew.getReceiveHospitalName());
                receiveDoctorBillHxgyVo.setAppCode(receiveAppCode);
                ConsultationRemunerationReqVO consultationVo = new ConsultationRemunerationReqVO();
                consultationVo.setAccompanyDoctorId(Long.valueOf(billInfo.getApplyDoctorId()));
                consultationVo.setAccompanyPrice(billInfo.getApplyDoctorIncome());
                consultationVo.setTreatmentDoctorId(Long.valueOf(billInfo.getReceiveDoctorId()));
                consultationVo.setServicePrice(billInfo.getReceiveDoctorIncome());
                BaseResponse baseResponse = this.balanceOperateApiClient.transferConsultationRemuneration(consultationVo);
                if (!baseResponse.getCode().equals("1")) {
                    log.info("\u5355\u4e2a\u5212\u62e8\u5355\u7b14\u5931\u8d25,\u8d26\u5355:{}", (Object)billInfo);
                    throw new RuntimeException("\u8c03\u7528\u533b\u751f\u670d\u52a1\u4fee\u6539\u533b\u751f\u4f59\u989d\u5931\u8d25\uff01");
                }
                Map applyErrorMap = this.billAllocationHelper.callAddBill(applyDoctorBillHxgyVo);
                if (applyErrorMap.size() > 0) {
                    throw new RuntimeException("\u8c03\u7528\u8d26\u5355\u670d\u52a1addBillDetail\u6dfb\u52a0\u5931\u8d25\uff01");
                }
                Map receiveErrorMap = this.billAllocationHelper.callAddBill(receiveDoctorBillHxgyVo);
                if (receiveErrorMap.size() > 0) {
                    throw new RuntimeException("\u8c03\u7528\u8d26\u5355\u670d\u52a1addBillDetail\u6dfb\u52a0\u5931\u8d25\uff01");
                }
                billInfoNew.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
                billInfoNew.setSettlingTime(new Date());
                this.billInfoMapper.updateByPrimaryKey(billInfoNew);
            }
        } else {
            BillInfo billInfo = new BillInfo();
            billInfo.setOrderId(consultation.getId());
            billInfo.setViewId(UuidUtils.generateUUID());
            billInfo.setStatus(Integer.valueOf(1));
            billInfo.setAssignStatus(AllocationStatusEnum.NOT_ALLOCATED.getValue());
            billInfo.setApplyDoctorId(consultation.getDoctorId());
            billInfo.setApplyDoctorName(consultation.getDoctorName());
            billInfo.setApplyDoctorIncome(new BigDecimal(0));
            billInfo.setApplyHospitalId(consultation.getDoctorHospitalId());
            billInfo.setApplyHospitalName(consultation.getDoctorHosName());
            billInfo.setApplyDeptId(consultation.getExpertDepId());
            billInfo.setApplyDeptName(consultation.getExpertDeptName());
            billInfo.setApplySecondDeptId(consultation.getDoctorSecondDeptId());
            billInfo.setApplySecondDeptName(consultation.getDoctorSecondDeptName());
            billInfo.setReceiveDoctorId(consultation.getExpertId());
            billInfo.setReceiveDoctorName(consultation.getExpertName());
            billInfo.setReceiveDoctorIncome(new BigDecimal(0));
            billInfo.setReceiveHospitalId(consultation.getExpertHospitalId());
            billInfo.setReceiveHospitalName(consultation.getExpertHosName());
            billInfo.setReceiveDeptId(consultation.getExpertDepId());
            billInfo.setReceiveDeptName(consultation.getExpertDeptName());
            billInfo.setReceiveSecondDeptId(consultation.getExpertSecondDeptId());
            billInfo.setReceiveSecondDeptName(consultation.getExpertSecondDeptName());
            billInfo.setWhetherHand(WhetherHandEnum.TREATED.getValue());
            billInfo.setPayAmount(consultationExtend.getPrice());
            billInfo.setBusinessCode(consultation.getServiceCode());
            billInfo.setBusinessName(this.getBusinessName(consultation.getServiceCode()));
            billInfo.setOrderViewId(consultation.getViewId());
            this.billInfoMapper.insert(billInfo);
        }
        return true;
    }

    @Transactional
    public boolean clearBillInfo(Long orderId) {
        BillInfo billInfo = this.billInfoMapper.getByOrderId(orderId);
        if (billInfo == null) {
            return true;
        }
        if (billInfo.getAssignStatus().equals(1)) {
            return false;
        }
        this.billInfoMapper.deleteByPrimaryKey(billInfo.getId());
        this.otherBillInfoMapper.deleteByBillInfoId(billInfo.getId());
        return true;
    }

    private String getBusinessName(Integer serviceCode) {
        if (DoctorServiceEnum.CONSULTATION_TUWEN_HOSPITAL.getValue().equals(serviceCode)) {
            return "\u533b\u8054\u4f53\u56fe\u6587\u4f1a\u8bca";
        }
        if (DoctorServiceEnum.CONSULTATION_TUWEN_PERSONAL.getValue().equals(serviceCode)) {
            return "\u8fdc\u7a0b\u56fe\u6587\u4f1a\u8bca";
        }
        if (DoctorServiceEnum.CONSULTATION_VEDIO_HOSPITAL.getValue().equals(serviceCode)) {
            return "\u533b\u8054\u4f53\u89c6\u9891\u4f1a\u8bca";
        }
        if (DoctorServiceEnum.CONSULTATION_VEDIO_PERSERNAL.getValue().equals(serviceCode)) {
            return "\u8fdc\u7a0b\u89c6\u9891\u4f1a\u8bca";
        }
        return "\u672a\u77e5\u4f1a\u8bca\u7c7b\u578b";
    }

    @Transactional
    public void updateIncome(UpdateIncomeReqVO updateIncomeReqVO) {
        BillInfo billInfo = new BillInfo();
        billInfo.setId(updateIncomeReqVO.getId());
        billInfo.setApplyDoctorIncome(updateIncomeReqVO.getApplyDoctorIncome());
        billInfo.setReceiveDoctorIncome(updateIncomeReqVO.getReceiveDoctorIncome());
        billInfo.setModifierId(updateIncomeReqVO.getOperatorId());
        billInfo.setModifierName(updateIncomeReqVO.getOperatorName());
        billInfo.setWhetherHand(updateIncomeReqVO.getWhetherHand());
        billInfo.setRemark(updateIncomeReqVO.getRemark());
        this.billInfoMapper.updateByPrimaryKeySelective(billInfo);
        List otherPartakeIncomeReqVOList = updateIncomeReqVO.getOtherPartakeIncomeReqVOList();
        if (otherPartakeIncomeReqVOList != null && otherPartakeIncomeReqVOList.size() > 0) {
            for (OtherPartakeIncomeReqVO otherPartakeIncomeReqVO : otherPartakeIncomeReqVOList) {
                OtherBillInfo otherBillInfo = new OtherBillInfo();
                otherBillInfo.setId(otherPartakeIncomeReqVO.getId());
                otherBillInfo.setPartakeIncome(otherPartakeIncomeReqVO.getPartakeIncome());
                this.otherBillInfoMapper.updateByPrimaryKeySelective(otherBillInfo);
            }
        }
        BillInfo tbBillInfo = this.billInfoMapper.selectByPrimaryKey(updateIncomeReqVO.getId());
        IncomeModifyRecord incomeModifyRecord = new IncomeModifyRecord();
        incomeModifyRecord.setBillInfoId(billInfo.getId());
        incomeModifyRecord.setViewId(UuidUtils.generateUUID());
        incomeModifyRecord.setStatus(Integer.valueOf(1));
        incomeModifyRecord.setApplyDoctorIncomeBak(tbBillInfo.getApplyDoctorIncome());
        incomeModifyRecord.setApplyDoctorIncomeAfter(updateIncomeReqVO.getApplyDoctorIncome());
        incomeModifyRecord.setReceiveDoctorIncomeBak(tbBillInfo.getReceiveDoctorIncome());
        incomeModifyRecord.setReceiveDoctorIncomeAfter(updateIncomeReqVO.getReceiveDoctorIncome());
        List otherBillInfos = this.otherBillInfoMapper.findByBillInfoId(billInfo.getId());
        incomeModifyRecord.setOtherPartakeIncomeBak(JSONObject.toJSONString((Object)otherBillInfos));
        incomeModifyRecord.setOtherPartakeIncomeAfter(JSONObject.toJSONString((Object)otherPartakeIncomeReqVOList));
        incomeModifyRecord.setModifierId(updateIncomeReqVO.getOperatorId());
        incomeModifyRecord.setModifierName(updateIncomeReqVO.getOperatorName());
        this.incomeModifyRecordMapper.insert(incomeModifyRecord);
    }

    public List<List<String>> getHead(ExportExcelReqVO exportExcelReqVO) {
        ArrayList<String> head;
        int i;
        Integer maxNum = this.billInfoMapper.getOtherPartakeMaxNum(exportExcelReqVO);
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (i = 0; i < mHeader.length; ++i) {
            head = new ArrayList<String>();
            head.add(mHeader[i]);
            list.add(head);
        }
        if (maxNum != null) {
            for (i = 0; i < maxNum; ++i) {
                head = new ArrayList();
                head.add("\u5176\u4ed6\u81ea\u5b9a\u4e49\u5206\u8d26" + i);
                list.add(head);
                ArrayList<String> head1 = new ArrayList<String>();
                head1.add("\u5206\u8d26\u91d1\u989d\uff08\u5176\u4ed6\u81ea\u5b9a\u4e49\u5206\u8d26" + i + "\uff09");
                list.add(head1);
            }
        }
        return list;
    }

    public List<List<Object>> getDataList(ExportExcelReqVO exportExcelReqVO) {
        String beginTime = exportExcelReqVO.getBeginTime();
        String endTime = exportExcelReqVO.getEndTime();
        beginTime = StringUtil.isNotBlank((String)beginTime) ? beginTime + " 00:00:00" : "";
        endTime = StringUtil.isNotBlank((String)endTime) ? endTime + " 23:59:59" : "";
        exportExcelReqVO.setBeginTime(beginTime);
        exportExcelReqVO.setEndTime(endTime);
        List billInfoList = this.billInfoMapper.findByExportExcelReqVO(exportExcelReqVO);
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        if (billInfoList != null && billInfoList.size() > 0) {
            for (int i = 0; i < billInfoList.size(); ++i) {
                BillInfo billInfo = (BillInfo)billInfoList.get(i);
                ConsulationEntityDownloadDto consultationEntity = this.consultationMapper.getConsultationEntityById(billInfo.getOrderId());
                ArrayList<Object> data = new ArrayList<Object>();
                String validDateStr = null == consultationEntity.getReportTime() ? null : DateUtils.getValidDateStr((Date)consultationEntity.getReportTime());
                data.add(i + 1);
                data.add(consultationEntity.getViewId());
                data.add(validDateStr);
                data.add(consultationEntity.getFinishTime());
                data.add(consultationEntity.getPatientName());
                String businessName = this.getBusinessName(consultationEntity.getServiceCode());
                data.add(businessName);
                data.add(billInfo.getPayAmount());
                data.add(billInfo.getApplyHospitalName());
                data.add(billInfo.getApplyDoctorName());
                data.add(billInfo.getApplyDoctorIncome());
                data.add(billInfo.getReceiveHospitalName());
                data.add(billInfo.getReceiveDeptName());
                data.add(billInfo.getReceiveDoctorName());
                BaseDTO baseDTO = new BaseDTO();
                baseDTO.setId(Integer.valueOf(billInfo.getApplyDoctorId().intValue()));
                BaseResponse doctorUserInfo = this.iDoctorApiClient.queryDoctorUserInfo(baseDTO);
                if (doctorUserInfo != null) {
                    DoctorUserInfoVO userInfoData = (DoctorUserInfoVO)doctorUserInfo.getData();
                    if (userInfoData != null) {
                        String profession = userInfoData.getProfession();
                        data.add("\u804c\u79f0\uff1a" + profession);
                    } else {
                        data.add("\u804c\u79f0\uff1a\u804c\u79f0\u4e3a\u7a7a");
                    }
                } else {
                    data.add("\u804c\u79f0\uff1a\u804c\u79f0\u4e3a\u7a7a");
                }
                data.add(billInfo.getReceiveDoctorIncome());
                List otherBillInfoList = this.otherBillInfoMapper.findByBillInfoId(billInfo.getId());
                if (otherBillInfoList != null && otherBillInfoList.size() > 0) {
                    for (OtherBillInfo otherBillInfo : otherBillInfoList) {
                        data.add(otherBillInfo.getPartakeName());
                        data.add(otherBillInfo.getPartakeIncome());
                    }
                }
                list.add(data);
            }
        }
        return list;
    }

    public BillInfo getByOrderId(Long orderId) {
        return this.billInfoMapper.getByOrderId(orderId);
    }

    public List<List<String>> getAllHead() {
        ExportExcelReqVO exq = new ExportExcelReqVO();
        exq.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
        List headList = this.getHead(exq);
        return headList;
    }

    public List<List<Object>> getAllDataList() {
        ExportExcelReqVO exq = new ExportExcelReqVO();
        exq.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
        List dataList = this.getDataList(exq);
        return dataList;
    }

    public BillInfo update(BillInfo mBillInfo) {
        this.billInfoMapper.update(mBillInfo);
        return this.getByOrderId(mBillInfo.getOrderId());
    }

    private MultipleAccountRule getMultipleAccountRule(RelatedInfoBO relatedInfoBO, Integer serviceCode) {
        ApplyRelatedInfo applyRelatedInfo = relatedInfoBO.getApplyRelatedInfo();
        ReceiveRelatedInfo receiveRelatedInfo = relatedInfoBO.getReceiveRelatedInfo();
        ArrayList<List> applyList = new ArrayList<List>();
        ArrayList<List> receiveList = new ArrayList<List>();
        for (int i = 0; i < 5; ++i) {
            List receiveMultipleSphereList;
            List applyMultipleSphereList;
            ApplyRelatedInfo mApplyRelatedInfo = new ApplyRelatedInfo();
            ReceiveRelatedInfo mReceiveRelatedInfo = new ReceiveRelatedInfo();
            if (i == 0) {
                applyMultipleSphereList = this.multipleSphereMapper.findByApplyRelatedInfo(applyRelatedInfo);
                if (applyMultipleSphereList != null) {
                    applyList.add(applyMultipleSphereList);
                }
                if ((receiveMultipleSphereList = this.multipleSphereMapper.findByReceiveRelatedInfo(receiveRelatedInfo)) == null) continue;
                receiveList.add(receiveMultipleSphereList);
                continue;
            }
            if (i == 1) {
                mApplyRelatedInfo.setApplyDoctorAppCode(applyRelatedInfo.getApplyDoctorAppCode());
                mApplyRelatedInfo.setApplyHospitalId(applyRelatedInfo.getApplyHospitalId());
                mApplyRelatedInfo.setApplySecondDeptId(applyRelatedInfo.getApplySecondDeptId());
                mApplyRelatedInfo.setApplyDoctorProfessionCode(applyRelatedInfo.getApplyDoctorProfessionCode());
                mApplyRelatedInfo.setApplyDoctorId(null);
                applyMultipleSphereList = this.multipleSphereMapper.findByApplyRelatedInfo(mApplyRelatedInfo);
                if (applyMultipleSphereList != null) {
                    applyList.add(applyMultipleSphereList);
                }
                mReceiveRelatedInfo.setReceiveDoctorAppCode(receiveRelatedInfo.getReceiveDoctorAppCode());
                mReceiveRelatedInfo.setReceiveHospitalId(receiveRelatedInfo.getReceiveHospitalId());
                mReceiveRelatedInfo.setReceiveSecondDeptId(receiveRelatedInfo.getReceiveSecondDeptId());
                mReceiveRelatedInfo.setReceiveDoctorProfessionCode(receiveRelatedInfo.getReceiveDoctorProfessionCode());
                mReceiveRelatedInfo.setReceiveDoctorId(null);
                receiveMultipleSphereList = this.multipleSphereMapper.findByReceiveRelatedInfo(mReceiveRelatedInfo);
                if (receiveMultipleSphereList == null) continue;
                receiveList.add(receiveMultipleSphereList);
                continue;
            }
            if (i == 2) {
                mApplyRelatedInfo.setApplyDoctorAppCode(applyRelatedInfo.getApplyDoctorAppCode());
                mApplyRelatedInfo.setApplyHospitalId(applyRelatedInfo.getApplyHospitalId());
                mApplyRelatedInfo.setApplySecondDeptId(applyRelatedInfo.getApplySecondDeptId());
                mApplyRelatedInfo.setApplyDoctorProfessionCode(null);
                mApplyRelatedInfo.setApplyDoctorId(null);
                applyMultipleSphereList = this.multipleSphereMapper.findByApplyRelatedInfo(mApplyRelatedInfo);
                if (applyMultipleSphereList != null) {
                    applyList.add(applyMultipleSphereList);
                }
                mReceiveRelatedInfo.setReceiveDoctorAppCode(receiveRelatedInfo.getReceiveDoctorAppCode());
                mReceiveRelatedInfo.setReceiveHospitalId(receiveRelatedInfo.getReceiveHospitalId());
                mReceiveRelatedInfo.setReceiveSecondDeptId(receiveRelatedInfo.getReceiveSecondDeptId());
                mReceiveRelatedInfo.setReceiveDoctorProfessionCode(null);
                mReceiveRelatedInfo.setReceiveDoctorId(null);
                receiveMultipleSphereList = this.multipleSphereMapper.findByReceiveRelatedInfo(mReceiveRelatedInfo);
                if (receiveMultipleSphereList == null) continue;
                receiveList.add(receiveMultipleSphereList);
                continue;
            }
            if (i == 3) {
                mApplyRelatedInfo.setApplyDoctorAppCode(applyRelatedInfo.getApplyDoctorAppCode());
                mApplyRelatedInfo.setApplyHospitalId(applyRelatedInfo.getApplyHospitalId());
                mApplyRelatedInfo.setApplySecondDeptId(null);
                mApplyRelatedInfo.setApplyDoctorProfessionCode(null);
                mApplyRelatedInfo.setApplyDoctorId(null);
                applyMultipleSphereList = this.multipleSphereMapper.findByApplyRelatedInfo(mApplyRelatedInfo);
                if (applyMultipleSphereList != null) {
                    applyList.add(applyMultipleSphereList);
                }
                mReceiveRelatedInfo.setReceiveDoctorAppCode(receiveRelatedInfo.getReceiveDoctorAppCode());
                mReceiveRelatedInfo.setReceiveHospitalId(receiveRelatedInfo.getReceiveHospitalId());
                mReceiveRelatedInfo.setReceiveSecondDeptId(null);
                mReceiveRelatedInfo.setReceiveDoctorProfessionCode(null);
                mReceiveRelatedInfo.setReceiveDoctorId(null);
                receiveMultipleSphereList = this.multipleSphereMapper.findByReceiveRelatedInfo(mReceiveRelatedInfo);
                if (receiveMultipleSphereList == null) continue;
                receiveList.add(receiveMultipleSphereList);
                continue;
            }
            if (i != 4) continue;
            mApplyRelatedInfo.setApplyDoctorAppCode(applyRelatedInfo.getApplyDoctorAppCode());
            mApplyRelatedInfo.setApplyHospitalId(null);
            mApplyRelatedInfo.setApplySecondDeptId(null);
            mApplyRelatedInfo.setApplyDoctorProfessionCode(null);
            mApplyRelatedInfo.setApplyDoctorId(null);
            applyMultipleSphereList = this.multipleSphereMapper.findByApplyRelatedInfo(mApplyRelatedInfo);
            if (applyMultipleSphereList != null) {
                applyList.add(applyMultipleSphereList);
            }
            mReceiveRelatedInfo.setReceiveDoctorAppCode(receiveRelatedInfo.getReceiveDoctorAppCode());
            mReceiveRelatedInfo.setReceiveHospitalId(null);
            mReceiveRelatedInfo.setReceiveSecondDeptId(null);
            mReceiveRelatedInfo.setReceiveDoctorProfessionCode(null);
            mReceiveRelatedInfo.setReceiveDoctorId(null);
            receiveMultipleSphereList = this.multipleSphereMapper.findByReceiveRelatedInfo(mReceiveRelatedInfo);
            if (receiveMultipleSphereList == null) continue;
            receiveList.add(receiveMultipleSphereList);
        }
        if (applyList != null && applyList.size() > 0 && receiveList != null && receiveList.size() > 0) {
            for (List applyMultipleSphereList : applyList) {
                for (List receiveMultipleSphereList : receiveList) {
                    MultipleAccountRule multipleAccountRule = this.getMultipleAccountRule(serviceCode, relatedInfoBO, applyMultipleSphereList, receiveMultipleSphereList);
                    if (multipleAccountRule == null) continue;
                    return multipleAccountRule;
                }
            }
        }
        return null;
    }

    private MultipleAccountRule getMultipleAccountRule(Integer serviceCode, RelatedInfoBO relatedInfoBO, List<MultipleSphere> applyMultipleSphereList, List<MultipleSphere> receiveMultipleSphereList) {
        if (applyMultipleSphereList != null && applyMultipleSphereList.size() > 0 && receiveMultipleSphereList != null && receiveMultipleSphereList.size() > 0) {
            for (MultipleSphere applyMultipleSphere : applyMultipleSphereList) {
                for (MultipleSphere receiveMultipleSphere : receiveMultipleSphereList) {
                    if (!applyMultipleSphere.getMultipleAccountRuleId().equals(receiveMultipleSphere.getMultipleAccountRuleId())) continue;
                    Long doctorId = applyMultipleSphere.getDoctorId();
                    if (doctorId != null && doctorId != 0L && !doctorId.equals(relatedInfoBO.getApplyRelatedInfo().getApplyDoctorId())) {
                        return null;
                    }
                    Long positionId = applyMultipleSphere.getPositionId();
                    if (positionId != null && positionId != 0L && !positionId.equals(Long.valueOf(relatedInfoBO.getApplyRelatedInfo().getApplyDoctorProfessionCode()))) {
                        return null;
                    }
                    Long secondDeptId = applyMultipleSphere.getSecondDeptId();
                    if (secondDeptId != null && secondDeptId != 0L && !secondDeptId.equals(relatedInfoBO.getApplyRelatedInfo().getApplySecondDeptId())) {
                        return null;
                    }
                    Long hospitalId = applyMultipleSphere.getHospitalId();
                    if (hospitalId != null && hospitalId != 0L && !hospitalId.equals(relatedInfoBO.getApplyRelatedInfo().getApplyHospitalId())) {
                        return null;
                    }
                    String appCode = applyMultipleSphere.getAppCode();
                    if (appCode != null && !"".equals(appCode) && !appCode.equals(relatedInfoBO.getApplyRelatedInfo().getApplyDoctorAppCode())) {
                        return null;
                    }
                    Long receiveDoctorId = receiveMultipleSphere.getDoctorId();
                    if (receiveDoctorId != null && receiveDoctorId != 0L && !receiveDoctorId.equals(relatedInfoBO.getReceiveRelatedInfo().getReceiveDoctorId())) {
                        return null;
                    }
                    Long receivePositionId = receiveMultipleSphere.getPositionId();
                    if (receivePositionId != null && receivePositionId != 0L && !receivePositionId.equals(Long.valueOf(relatedInfoBO.getReceiveRelatedInfo().getReceiveDoctorProfessionCode()))) {
                        return null;
                    }
                    Long receiveSecondDeptId = receiveMultipleSphere.getSecondDeptId();
                    if (receiveSecondDeptId != null && receiveSecondDeptId != 0L && !receiveSecondDeptId.equals(relatedInfoBO.getReceiveRelatedInfo().getReceiveSecondDeptId())) {
                        return null;
                    }
                    Long receiveHospitalId = receiveMultipleSphere.getHospitalId();
                    if (receiveHospitalId != null && receiveHospitalId != 0L && !receiveHospitalId.equals(relatedInfoBO.getReceiveRelatedInfo().getReceiveHospitalId())) {
                        return null;
                    }
                    String receiveAppCode = receiveMultipleSphere.getAppCode();
                    if (receiveAppCode != null && !"".equals(receiveAppCode) && !receiveAppCode.equals(relatedInfoBO.getReceiveRelatedInfo().getReceiveDoctorAppCode())) {
                        return null;
                    }
                    MultipleAccountRule multipleAccountRule = this.multipleAccountRuleService.getById(applyMultipleSphere.getMultipleAccountRuleId());
                    Integer businessCode = multipleAccountRule.getBusinessCode();
                    if (!serviceCode.equals(businessCode)) continue;
                    return multipleAccountRule;
                }
            }
        }
        return null;
    }

    private RelatedInfoBO getRelatedInfoBO(ConsultationEntity consultation, ConsultationExtendEntity consultationExtend) {
        String applyDoctorAppCode = consultation.getAccompanyAppCode();
        Long applyHospitalId = consultation.getDoctorHospitalId();
        Long applySecondDeptId = consultation.getDoctorSecondDeptId();
        Long applyDoctorId = consultation.getDoctorId();
        String applyDoctorProfessionCode = this.billAllocationHelper.getProfessionCode(applyDoctorId);
        String receiveDoctorAppCode = consultationExtend.getClinicalAppCode();
        Long receiveHospitalId = consultation.getExpertHospitalId();
        Long receiveSecondDeptId = consultation.getExpertSecondDeptId();
        Long receiveDoctorId = consultation.getExpertId();
        String receiveDoctorProfessionCode = this.billAllocationHelper.getProfessionCode(receiveDoctorId);
        ApplyRelatedInfo applyRelatedInfo = new ApplyRelatedInfo();
        applyRelatedInfo.setApplyDoctorAppCode(applyDoctorAppCode);
        applyRelatedInfo.setApplyHospitalId(applyHospitalId);
        applyRelatedInfo.setApplySecondDeptId(applySecondDeptId);
        applyRelatedInfo.setApplyDoctorId(applyDoctorId);
        applyRelatedInfo.setApplyDoctorProfessionCode(applyDoctorProfessionCode);
        ReceiveRelatedInfo receiveRelatedInfo = new ReceiveRelatedInfo();
        receiveRelatedInfo.setReceiveDoctorAppCode(receiveDoctorAppCode);
        receiveRelatedInfo.setReceiveHospitalId(receiveHospitalId);
        receiveRelatedInfo.setReceiveSecondDeptId(receiveSecondDeptId);
        receiveRelatedInfo.setReceiveDoctorId(receiveDoctorId);
        receiveRelatedInfo.setReceiveDoctorProfessionCode(receiveDoctorProfessionCode);
        RelatedInfoBO relatedInfoBO = new RelatedInfoBO();
        relatedInfoBO.setApplyRelatedInfo(applyRelatedInfo);
        relatedInfoBO.setReceiveRelatedInfo(receiveRelatedInfo);
        return relatedInfoBO;
    }

    @Transactional
    public void batchUpdateIncome(BatchUpdateIncomeReqVO batchUpdateIncomeReqVO) {
        log.info("\u6279\u91cf\u4fee\u6539\u6536\u76ca\u5165\u53c2:{}", (Object)batchUpdateIncomeReqVO);
        List billInfoIdList = batchUpdateIncomeReqVO.getBillInfoIdList();
        ArrayList<IncomeModifyRecord> incomeModifyRecordList = new ArrayList<IncomeModifyRecord>();
        BigDecimal applyDoctorIncome = batchUpdateIncomeReqVO.getApplyDoctorIncome();
        BigDecimal receiveDoctorIncome = batchUpdateIncomeReqVO.getReceiveDoctorIncome();
        List incomeReqVOList = batchUpdateIncomeReqVO.getOtherPartakeIncomeReqVOList();
        List areaPartakeIncomes = incomeReqVOList.stream().map(OtherPartakeIncomeReqVO::getPartakeIncome).filter(x -> x != null).collect(Collectors.toList());
        if (areaPartakeIncomes.size() > 0 || applyDoctorIncome != null || receiveDoctorIncome != null) {
            for (Long billInfoId : billInfoIdList) {
                BillInfo billInfo = this.billInfoMapper.selectByPrimaryKey(billInfoId);
                List otherBillInfoList = this.otherBillInfoMapper.findByBillInfoId(billInfo.getId());
                IncomeModifyRecord incomeModifyRecord = new IncomeModifyRecord();
                incomeModifyRecord.setBillInfoId(billInfo.getId());
                incomeModifyRecord.setViewId(UuidUtils.generateUUID());
                incomeModifyRecord.setStatus(Integer.valueOf(1));
                incomeModifyRecord.setApplyDoctorIncomeBak(billInfo.getApplyDoctorIncome());
                BigDecimal applyDoctor = batchUpdateIncomeReqVO.getApplyDoctorIncome();
                BigDecimal applyDoctorBigDecimal = applyDoctor != null ? applyDoctor : billInfo.getApplyDoctorIncome();
                incomeModifyRecord.setApplyDoctorIncomeAfter(applyDoctorBigDecimal);
                incomeModifyRecord.setReceiveDoctorIncomeBak(billInfo.getReceiveDoctorIncome());
                BigDecimal receiveDoctor = batchUpdateIncomeReqVO.getReceiveDoctorIncome();
                BigDecimal receiveDoctorBigDecimal = receiveDoctor != null ? receiveDoctor : billInfo.getReceiveDoctorIncome();
                incomeModifyRecord.setReceiveDoctorIncomeAfter(receiveDoctorBigDecimal);
                incomeModifyRecord.setOtherPartakeIncomeBak(JSONObject.toJSONString((Object)otherBillInfoList));
                List otherPartakeIncomeReqVOList = batchUpdateIncomeReqVO.getOtherPartakeIncomeReqVOList();
                incomeModifyRecord.setOtherPartakeIncomeAfter(JSONObject.toJSONString((Object)batchUpdateIncomeReqVO.getOtherPartakeIncomeReqVOList()));
                incomeModifyRecord.setModifierId(batchUpdateIncomeReqVO.getOperatorId());
                incomeModifyRecord.setModifierName(batchUpdateIncomeReqVO.getOperatorName());
                incomeModifyRecordList.add(incomeModifyRecord);
            }
            this.incomeModifyRecordMapper.insertForeach(incomeModifyRecordList);
        }
        this.billInfoMapper.batchUpdateIncome(batchUpdateIncomeReqVO);
        if (null != batchUpdateIncomeReqVO.getMultipleAccountRuleId()) {
            List otherPartakeIncomeReqVOList = batchUpdateIncomeReqVO.getOtherPartakeIncomeReqVOList();
            for (OtherPartakeIncomeReqVO partakeIncomeReqVO : otherPartakeIncomeReqVOList) {
                if (partakeIncomeReqVO.getPartakeIncome() == null) continue;
                this.otherBillInfoMapper.otherBillByOtherPartakeId(partakeIncomeReqVO.getId(), billInfoIdList, partakeIncomeReqVO.getPartakeIncome());
            }
        }
        log.info("-----------\u6279\u91cf\u4fee\u6539\u6536\u76ca\u5165\u53c2\u5b8c\u6210----------");
    }
}

