/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.allocation;

import com.alibaba.fastjson.JSONObject;
import com.byh.dao.allocation.MultipleAccountRuleMapper;
import com.byh.dao.allocation.MultipleSphereMapper;
import com.byh.dao.allocation.OtherPartakeMapper;
import com.byh.enums.OrderCategoryEnum;
import com.byh.pojo.entity.allocation.MultipleAccountRule;
import com.byh.pojo.entity.allocation.MultipleSphere;
import com.byh.pojo.entity.allocation.OtherPartake;
import com.byh.pojo.vo.allocation.resp.AddMultipleVO;
import com.byh.pojo.vo.allocation.resp.DoctorMultipleSphereDTO;
import com.byh.pojo.vo.allocation.resp.DoctorMultipleSphereVO;
import com.byh.pojo.vo.allocation.resp.ExpertDoctorMultipleSphereDTO;
import com.byh.pojo.vo.allocation.resp.ExpertDoctorMultipleSphereVO;
import com.byh.pojo.vo.allocation.resp.MultipleDTO;
import com.byh.pojo.vo.allocation.resp.OtherPartakeVO;
import com.byh.service.allocation.MultipleAccountRuleService;
import com.byh.util.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class MultipleAccountRuleServiceImpl
implements MultipleAccountRuleService {
    private static final Logger log = LoggerFactory.getLogger(MultipleAccountRuleServiceImpl.class);
    @Autowired
    private MultipleAccountRuleMapper multipleAccountRuleMapper;
    @Autowired
    private MultipleSphereMapper multipleSphereMapper;
    @Autowired
    private OtherPartakeMapper otherPartakeMapper;

    public Integer getRuleNumByBusinessCode(Integer businessCode) {
        Integer ruleNum = this.multipleAccountRuleMapper.getRuleNumByBusinessCode(businessCode);
        if (ruleNum == null) {
            return 0;
        }
        return ruleNum;
    }

    public MultipleAccountRule getById(Long id) {
        return this.multipleAccountRuleMapper.selectByPrimaryKey(id);
    }

    @Transactional
    public BaseResponse<String> addMultiple(AddMultipleVO addMultipleVO) {
        BaseResponse baseResponse;
        log.info("=======>\u524d\u7aef\u4f20\u53bb\u5b9e\u4f53----->{}" + JSONObject.toJSONString((Object)addMultipleVO));
        MultipleAccountRule multipleAccountRule = new MultipleAccountRule();
        multipleAccountRule.setName(addMultipleVO.getName());
        multipleAccountRule.setAllocationTypeCode(addMultipleVO.getAllocationTypeCode());
        multipleAccountRule.setAllocationTypeName(addMultipleVO.getAllocationTypeName());
        multipleAccountRule.setApplyAmountMethodCode(addMultipleVO.getApplyAmountMethodCode());
        multipleAccountRule.setApplyAmountMethodName(addMultipleVO.getApplyAmountMethodName());
        multipleAccountRule.setApplyAmountStandard(addMultipleVO.getApplyAmountStandard());
        multipleAccountRule.setReceiveAmountMethodCode(addMultipleVO.getReceiveAmountMethodCode());
        multipleAccountRule.setReceiveAmountMethodName(addMultipleVO.getReceiveAmountMethodName());
        multipleAccountRule.setReceiveAmountStandard(addMultipleVO.getReceiveAmountStandard());
        multipleAccountRule.setScheduleCode(addMultipleVO.getScheduleCode());
        multipleAccountRule.setScheduleName(addMultipleVO.getScheduleName());
        multipleAccountRule.setBusinessCode(addMultipleVO.getBusinessCode());
        multipleAccountRule.setBusinessCode(addMultipleVO.getBusinessCode());
        multipleAccountRule.setBusinessName(addMultipleVO.getBusinessName());
        multipleAccountRule.setWhetherEnable(addMultipleVO.getWhetherEnable());
        multipleAccountRule.setViewId(UniqueKeyGenerator.generateViewId().toString());
        multipleAccountRule.setStatus(Integer.valueOf(1));
        this.multipleAccountRuleMapper.insertSelective(multipleAccountRule);
        MultipleAccountRule multipleAccountRule2 = this.multipleAccountRuleMapper.getByViewId(multipleAccountRule.getViewId());
        List multipleSphereList = this.multipleSphereMapper.getDoctorAllByType(addMultipleVO.getBusinessCode());
        log.info("=======>\u5df2\u5b58\u5728\u7533\u8bf7\u533b\u751f\u7684\u4f5c\u7528\u8303\u56f4----->{}" + JSONObject.toJSONString((Object)multipleSphereList));
        List multipleSpheres = this.multipleSphereMapper.getExpertDoctorAllByType(addMultipleVO.getBusinessCode());
        log.info("=======>\u5df2\u5b58\u5728\u7684\u63a5\u8bca\u533b\u751f\u7684\u4f5c\u7528\u8303\u56f4----->{}" + JSONObject.toJSONString((Object)multipleSpheres));
        if (OrderCategoryEnum.TYPE_MEDICAL_VEDIO.getValue().equals(addMultipleVO.getBusinessCode())) {
            baseResponse = this.repeat(multipleSphereList, multipleSpheres, addMultipleVO, multipleAccountRule2);
            if (baseResponse.getCode().equals("0")) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseResponse.error((String)"\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        } else if (OrderCategoryEnum.TYPE_MEDICAL_TUWEN.getValue().equals(addMultipleVO.getBusinessCode())) {
            baseResponse = this.repeat(multipleSphereList, multipleSpheres, addMultipleVO, multipleAccountRule2);
            if (baseResponse.getCode().equals("0")) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseResponse.error((String)"\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        } else if (OrderCategoryEnum.TYPE_VEDIO.getValue().equals(addMultipleVO.getBusinessCode())) {
            baseResponse = this.repeat(multipleSphereList, multipleSpheres, addMultipleVO, multipleAccountRule2);
            if (baseResponse.getCode().equals("0")) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseResponse.error((String)"\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        } else {
            baseResponse = this.repeat(multipleSphereList, multipleSpheres, addMultipleVO, multipleAccountRule2);
            if (baseResponse.getCode().equals("0")) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return BaseResponse.error((String)"\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
            }
        }
        for (OtherPartakeVO otherPartakeVO : addMultipleVO.getOtherPartakeVO()) {
            OtherPartake otherPartake = new OtherPartake();
            otherPartake.setAmountMethodCode(otherPartakeVO.getAmountMethodCode());
            otherPartake.setAmountMethodName(otherPartakeVO.getAmountMethodName());
            otherPartake.setAmountStandard(otherPartakeVO.getAmountStandard());
            otherPartake.setMultipleAccountRuleId(multipleAccountRule2.getId());
            otherPartake.setViewId(UniqueKeyGenerator.generateViewId().toString());
            otherPartake.setStatus(Integer.valueOf(1));
            otherPartake.setName(otherPartakeVO.getName());
            this.otherPartakeMapper.insertSelective(otherPartake);
        }
        return BaseResponse.success();
    }

    @Transactional
    public BaseResponse<String> updateMultiple(AddMultipleVO addMultipleVO) {
        log.info("=======>\u524d\u7aef\u4f20\u53bb\u5b9e\u4f53----->{}" + JSONObject.toJSONString((Object)addMultipleVO));
        boolean b1 = true;
        boolean b2 = true;
        MultipleAccountRule multipleAccountRule = this.multipleAccountRuleMapper.selectByPrimaryKey(addMultipleVO.getMultipleAccountRuleId());
        if (multipleAccountRule != null) {
            multipleAccountRule.setName(addMultipleVO.getName());
            multipleAccountRule.setAllocationTypeCode(addMultipleVO.getAllocationTypeCode());
            multipleAccountRule.setAllocationTypeName(addMultipleVO.getAllocationTypeName());
            multipleAccountRule.setApplyAmountMethodCode(addMultipleVO.getApplyAmountMethodCode());
            multipleAccountRule.setApplyAmountMethodName(addMultipleVO.getApplyAmountMethodName());
            multipleAccountRule.setApplyAmountStandard(addMultipleVO.getApplyAmountStandard());
            multipleAccountRule.setReceiveAmountMethodCode(addMultipleVO.getReceiveAmountMethodCode());
            multipleAccountRule.setReceiveAmountMethodName(addMultipleVO.getReceiveAmountMethodName());
            multipleAccountRule.setReceiveAmountStandard(addMultipleVO.getReceiveAmountStandard());
            multipleAccountRule.setScheduleCode(addMultipleVO.getScheduleCode());
            multipleAccountRule.setScheduleName(addMultipleVO.getScheduleName());
            multipleAccountRule.setBusinessCode(addMultipleVO.getBusinessCode());
            multipleAccountRule.setBusinessCode(addMultipleVO.getBusinessCode());
            multipleAccountRule.setBusinessName(addMultipleVO.getBusinessName());
            multipleAccountRule.setWhetherEnable(addMultipleVO.getWhetherEnable());
            this.multipleAccountRuleMapper.updateByPrimaryKeySelective(multipleAccountRule);
            List list = this.multipleSphereMapper.getByMultipleAccountRuleId(addMultipleVO.getMultipleAccountRuleId());
            if (list.size() > 0) {
                this.multipleSphereMapper.updateByMultipleId(addMultipleVO.getMultipleAccountRuleId());
            }
            List multipleSphereList = this.multipleSphereMapper.getDoctorAllByType(addMultipleVO.getBusinessCode());
            log.info("=======>\u5df2\u5b58\u5728\u7533\u8bf7\u533b\u751f\u7684\u4f5c\u7528\u8303\u56f4----->{}" + JSONObject.toJSONString((Object)multipleSphereList));
            List multipleSpheres = this.multipleSphereMapper.getExpertDoctorAllByType(addMultipleVO.getBusinessCode());
            log.info("=======>\u5df2\u5b58\u5728\u7684\u63a5\u8bca\u533b\u751f\u7684\u4f5c\u7528\u8303\u56f4----->{}" + JSONObject.toJSONString((Object)multipleSpheres));
            if (multipleSphereList.size() > 0 && multipleSpheres.size() > 0) {
                for (DoctorMultipleSphereVO doctorMultipleSphereVO : addMultipleVO.getDoctorMultipleSphereVO()) {
                    for (MultipleSphere multipleSphere : multipleSphereList) {
                        if (!doctorMultipleSphereVO.getAppCode().equals(multipleSphere.getAppCode())) continue;
                        if (doctorMultipleSphereVO.getHospitalId() == 0L) {
                            b1 = false;
                            break;
                        }
                        if (!doctorMultipleSphereVO.getHospitalId().equals(multipleSphere.getHospitalId())) continue;
                        if (doctorMultipleSphereVO.getPositionId() == 0L) {
                            b1 = false;
                            break;
                        }
                        if (!doctorMultipleSphereVO.getPositionId().equals(multipleSphere.getPositionId())) continue;
                        if (doctorMultipleSphereVO.getDoctorId() == 0L) {
                            b1 = false;
                            break;
                        }
                        if (!doctorMultipleSphereVO.getDoctorId().equals(multipleSphere.getDoctorId())) continue;
                        b1 = false;
                        break;
                    }
                    if (b1) continue;
                    break;
                }
                for (ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO : addMultipleVO.getExpertDoctorMultipleSphereVO()) {
                    for (MultipleSphere multipleSphere1 : multipleSpheres) {
                        if (!expertDoctorMultipleSphereVO.getAppCode().equalsIgnoreCase(multipleSphere1.getAppCode())) continue;
                        if (expertDoctorMultipleSphereVO.getHospitalId() == 0L) {
                            b2 = false;
                            break;
                        }
                        if (!expertDoctorMultipleSphereVO.getHospitalId().equals(multipleSphere1.getHospitalId())) continue;
                        if (expertDoctorMultipleSphereVO.getPositionId() == 0L) {
                            b2 = false;
                            break;
                        }
                        if (!expertDoctorMultipleSphereVO.getPositionId().equals(multipleSphere1.getPositionId())) continue;
                        if (expertDoctorMultipleSphereVO.getDoctorId() == 0L) {
                            b2 = false;
                            break;
                        }
                        if (!expertDoctorMultipleSphereVO.getDoctorId().equals(multipleSphere1.getDoctorId())) continue;
                        b2 = false;
                        break;
                    }
                    if (b2) continue;
                    break;
                }
            }
        }
        if (!b1 && !b2) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return BaseResponse.error((String)"\u6dfb\u52a0\u7684\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        for (DoctorMultipleSphereVO doctorMultipleSphereVO : addMultipleVO.getDoctorMultipleSphereVO()) {
            int multipleSpheres = this.savaMultiple(doctorMultipleSphereVO, multipleAccountRule);
        }
        for (ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO : addMultipleVO.getExpertDoctorMultipleSphereVO()) {
            int multipleSpheres = this.savaMultipleY(expertDoctorMultipleSphereVO, multipleAccountRule);
        }
        List otherPartakeList = this.otherPartakeMapper.findByMultipleAccountRuleId(addMultipleVO.getMultipleAccountRuleId());
        if (otherPartakeList.size() > 0) {
            this.otherPartakeMapper.updateByMultipleId(addMultipleVO.getMultipleAccountRuleId());
        }
        for (OtherPartakeVO otherPartakeVO : addMultipleVO.getOtherPartakeVO()) {
            OtherPartake otherPartake = new OtherPartake();
            otherPartake.setAmountMethodCode(otherPartakeVO.getAmountMethodCode());
            otherPartake.setAmountMethodName(otherPartakeVO.getAmountMethodName());
            otherPartake.setAmountStandard(otherPartakeVO.getAmountStandard());
            otherPartake.setStatus(Integer.valueOf(1));
            otherPartake.setName(otherPartakeVO.getName());
            otherPartake.setViewId(UniqueKeyGenerator.generateViewId().toString());
            otherPartake.setMultipleAccountRuleId(addMultipleVO.getMultipleAccountRuleId());
            this.otherPartakeMapper.insertSelective(otherPartake);
        }
        return BaseResponse.success();
    }

    public BaseResponse<List<MultipleDTO>> getList(Integer pageIndex, Integer pageSize, String search, Integer type) {
        int total = 0;
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List multipleAccountRuleList = this.multipleAccountRuleMapper.getList(search, type);
        total = this.multipleAccountRuleMapper.getNumber(search, type);
        ArrayList<MultipleDTO> multipleDTOList = new ArrayList<MultipleDTO>();
        for (MultipleAccountRule multipleAccountRule : multipleAccountRuleList) {
            Object multipleSphere2;
            MultipleDTO multipleDTO = new MultipleDTO();
            multipleDTO.setId(multipleAccountRule.getId());
            multipleDTO.setAllocationTypeCode(multipleAccountRule.getAllocationTypeCode());
            multipleDTO.setAllocationTypeName(multipleAccountRule.getAllocationTypeName());
            multipleDTO.setApplyAmountStandard(multipleAccountRule.getApplyAmountStandard());
            multipleDTO.setApplyAmountMethodCode(multipleAccountRule.getApplyAmountMethodCode());
            multipleDTO.setApplyAmountMethodName(multipleAccountRule.getApplyAmountMethodName());
            multipleDTO.setName(multipleAccountRule.getName());
            multipleDTO.setReceiveAmountMethodCode(multipleAccountRule.getReceiveAmountMethodCode());
            multipleDTO.setReceiveAmountMethodName(multipleAccountRule.getReceiveAmountMethodName());
            multipleDTO.setReceiveAmountStandard(multipleAccountRule.getReceiveAmountStandard());
            multipleDTO.setWhetherEnable(multipleAccountRule.getWhetherEnable());
            multipleDTO.setStatus(multipleAccountRule.getStatus());
            multipleDTO.setScheduleCode(multipleAccountRule.getScheduleCode());
            multipleDTO.setScheduleName(multipleAccountRule.getScheduleName());
            ArrayList<DoctorMultipleSphereDTO> list = new ArrayList<DoctorMultipleSphereDTO>();
            ArrayList<ExpertDoctorMultipleSphereDTO> dtoList = new ArrayList<ExpertDoctorMultipleSphereDTO>();
            ArrayList<OtherPartakeVO> voList = new ArrayList<OtherPartakeVO>();
            List multipleSphereList = this.multipleSphereMapper.getByMultipleAccountRuleId(multipleAccountRule.getId());
            for (Object multipleSphere2 : multipleSphereList) {
                DoctorMultipleSphereDTO doctorMultipleSphereDTO = new DoctorMultipleSphereDTO();
                doctorMultipleSphereDTO.setId(multipleSphere2.getId());
                doctorMultipleSphereDTO.setAppCode(multipleSphere2.getAppCode());
                doctorMultipleSphereDTO.setAppName(multipleSphere2.getAppName());
                doctorMultipleSphereDTO.setHospitalId(multipleSphere2.getHospitalId());
                doctorMultipleSphereDTO.setHospitalName(multipleSphere2.getHospitalName());
                doctorMultipleSphereDTO.setPositionId(multipleSphere2.getPositionId());
                doctorMultipleSphereDTO.setPositionName(multipleSphere2.getPositionName());
                doctorMultipleSphereDTO.setDoctorId(multipleSphere2.getDoctorId());
                doctorMultipleSphereDTO.setDoctorName(multipleSphere2.getDoctorName());
                doctorMultipleSphereDTO.setActionScope(multipleSphere2.getAppName() + " " + multipleSphere2.getHospitalName() + " " + multipleSphere2.getPositionName() + " " + multipleSphere2.getDoctorName());
                list.add(doctorMultipleSphereDTO);
            }
            List multipleSpheres = this.multipleSphereMapper.getByMultipleAccountRuleIdExpert(multipleAccountRule.getId());
            multipleSphere2 = multipleSpheres.iterator();
            while (multipleSphere2.hasNext()) {
                MultipleSphere multipleSphere3 = (MultipleSphere)multipleSphere2.next();
                ExpertDoctorMultipleSphereDTO expertDoctorMultipleSphereDTO = new ExpertDoctorMultipleSphereDTO();
                expertDoctorMultipleSphereDTO.setId(multipleSphere3.getId());
                expertDoctorMultipleSphereDTO.setAppCode(multipleSphere3.getAppCode());
                expertDoctorMultipleSphereDTO.setAppName(multipleSphere3.getAppName());
                expertDoctorMultipleSphereDTO.setHospitalId(multipleSphere3.getHospitalId());
                expertDoctorMultipleSphereDTO.setHospitalName(multipleSphere3.getHospitalName());
                expertDoctorMultipleSphereDTO.setPositionId(multipleSphere3.getPositionId());
                expertDoctorMultipleSphereDTO.setPositionName(multipleSphere3.getPositionName());
                expertDoctorMultipleSphereDTO.setDoctorId(multipleSphere3.getDoctorId());
                expertDoctorMultipleSphereDTO.setDoctorName(multipleSphere3.getDoctorName());
                expertDoctorMultipleSphereDTO.setActionScope(multipleSphere3.getAppName() + " " + multipleSphere3.getHospitalName() + " " + multipleSphere3.getPositionName() + " " + multipleSphere3.getDoctorName());
                dtoList.add(expertDoctorMultipleSphereDTO);
            }
            List otherPartakeList = this.otherPartakeMapper.findByMultipleAccountRuleId(multipleAccountRule.getId());
            for (OtherPartake otherPartake : otherPartakeList) {
                OtherPartakeVO otherPartakeVO = new OtherPartakeVO();
                otherPartakeVO.setAmountMethodCode(otherPartake.getAmountMethodCode());
                otherPartakeVO.setAmountMethodName(otherPartake.getAmountMethodName());
                otherPartakeVO.setAmountStandard(otherPartake.getAmountStandard());
                otherPartakeVO.setName(otherPartake.getName());
                voList.add(otherPartakeVO);
            }
            multipleDTO.setDoctorMultipleSphereDTOList(list);
            multipleDTO.setExpertDoctorMultipleSphereDTOList(dtoList);
            multipleDTO.setTotal(Integer.valueOf(total));
            multipleDTO.setOtherPartakeVOS(voList);
            multipleDTOList.add(multipleDTO);
        }
        return BaseResponse.success(multipleDTOList);
    }

    public BaseResponse<String> deleteMultiple(Long multipleId) {
        MultipleAccountRule multipleAccountRule = this.multipleAccountRuleMapper.selectByPrimaryKey(multipleId);
        if (multipleAccountRule != null) {
            this.multipleAccountRuleMapper.deleteMultiple(multipleId);
            this.multipleSphereMapper.updateByMultipleId(multipleId);
            this.otherPartakeMapper.updateByMultipleId(multipleId);
        }
        return BaseResponse.success();
    }

    public Integer savaMultiple(DoctorMultipleSphereVO doctorMultipleSphereVO, MultipleAccountRule multipleAccountRule) {
        MultipleSphere multipleSphere1 = new MultipleSphere();
        multipleSphere1.setAppCode(doctorMultipleSphereVO.getAppCode());
        multipleSphere1.setAppName(doctorMultipleSphereVO.getAppName());
        multipleSphere1.setHospitalId(doctorMultipleSphereVO.getHospitalId());
        multipleSphere1.setHospitalName(doctorMultipleSphereVO.getHospitalName());
        multipleSphere1.setPositionId(doctorMultipleSphereVO.getPositionId());
        multipleSphere1.setPositionName(doctorMultipleSphereVO.getPositionName());
        multipleSphere1.setDoctorId(doctorMultipleSphereVO.getDoctorId());
        multipleSphere1.setDoctorName(doctorMultipleSphereVO.getDoctorName());
        multipleSphere1.setMultipleAccountRuleId(multipleAccountRule.getId());
        multipleSphere1.setStatus(Integer.valueOf(1));
        multipleSphere1.setViewId(UniqueKeyGenerator.generateViewId().toString());
        multipleSphere1.setType(doctorMultipleSphereVO.getType());
        return this.multipleSphereMapper.insertSelective(multipleSphere1);
    }

    public Integer savaMultipleY(ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO, MultipleAccountRule multipleAccountRule) {
        MultipleSphere multipleSphere1 = new MultipleSphere();
        multipleSphere1.setAppCode(expertDoctorMultipleSphereVO.getAppCode());
        multipleSphere1.setAppName(expertDoctorMultipleSphereVO.getAppName());
        multipleSphere1.setHospitalId(expertDoctorMultipleSphereVO.getHospitalId());
        multipleSphere1.setHospitalName(expertDoctorMultipleSphereVO.getHospitalName());
        multipleSphere1.setPositionId(expertDoctorMultipleSphereVO.getPositionId());
        multipleSphere1.setPositionName(expertDoctorMultipleSphereVO.getPositionName());
        multipleSphere1.setDoctorId(expertDoctorMultipleSphereVO.getDoctorId());
        multipleSphere1.setDoctorName(expertDoctorMultipleSphereVO.getDoctorName());
        multipleSphere1.setMultipleAccountRuleId(multipleAccountRule.getId());
        multipleSphere1.setStatus(Integer.valueOf(1));
        multipleSphere1.setViewId(UniqueKeyGenerator.generateViewId().toString());
        multipleSphere1.setType(expertDoctorMultipleSphereVO.getType());
        return this.multipleSphereMapper.insertSelective(multipleSphere1);
    }

    public Integer updateMultipleA(DoctorMultipleSphereVO doctorMultipleSphereVO, MultipleAccountRule multipleAccountRule) {
        MultipleSphere multipleSphere1 = this.multipleSphereMapper.selectByPrimaryKey(doctorMultipleSphereVO.getId());
        multipleSphere1.setAppCode(doctorMultipleSphereVO.getAppCode());
        multipleSphere1.setAppName(doctorMultipleSphereVO.getAppName());
        multipleSphere1.setHospitalId(doctorMultipleSphereVO.getHospitalId());
        multipleSphere1.setHospitalName(doctorMultipleSphereVO.getHospitalName());
        multipleSphere1.setPositionId(doctorMultipleSphereVO.getPositionId());
        multipleSphere1.setPositionName(doctorMultipleSphereVO.getPositionName());
        multipleSphere1.setDoctorId(doctorMultipleSphereVO.getDoctorId());
        multipleSphere1.setDoctorName(doctorMultipleSphereVO.getDoctorName());
        multipleSphere1.setMultipleAccountRuleId(multipleAccountRule.getId());
        multipleSphere1.setType(doctorMultipleSphereVO.getType());
        return this.multipleSphereMapper.updateByPrimaryKeySelective(multipleSphere1);
    }

    public Integer updateMultipleY(ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO, MultipleAccountRule multipleAccountRule) {
        MultipleSphere multipleSphere1 = this.multipleSphereMapper.selectByPrimaryKey(expertDoctorMultipleSphereVO.getId());
        multipleSphere1.setAppCode(expertDoctorMultipleSphereVO.getAppCode());
        multipleSphere1.setAppName(expertDoctorMultipleSphereVO.getAppName());
        multipleSphere1.setHospitalId(expertDoctorMultipleSphereVO.getHospitalId());
        multipleSphere1.setHospitalName(expertDoctorMultipleSphereVO.getHospitalName());
        multipleSphere1.setPositionId(expertDoctorMultipleSphereVO.getPositionId());
        multipleSphere1.setPositionName(expertDoctorMultipleSphereVO.getPositionName());
        multipleSphere1.setDoctorId(expertDoctorMultipleSphereVO.getDoctorId());
        multipleSphere1.setDoctorName(expertDoctorMultipleSphereVO.getDoctorName());
        multipleSphere1.setMultipleAccountRuleId(multipleAccountRule.getId());
        multipleSphere1.setType(expertDoctorMultipleSphereVO.getType());
        return this.multipleSphereMapper.updateByPrimaryKeySelective(multipleSphere1);
    }

    public BaseResponse<Object> repeat(List<MultipleSphere> multipleSphereList, List<MultipleSphere> multipleSpheres, AddMultipleVO addMultipleVO, MultipleAccountRule multipleAccountRule2) {
        boolean b1 = true;
        boolean b2 = true;
        if (multipleSphereList.size() > 0 && multipleSpheres.size() > 0) {
            for (DoctorMultipleSphereVO doctorMultipleSphereVO : addMultipleVO.getDoctorMultipleSphereVO()) {
                for (MultipleSphere multipleSphere : multipleSphereList) {
                    if (!doctorMultipleSphereVO.getAppCode().equals(multipleSphere.getAppCode())) continue;
                    if (doctorMultipleSphereVO.getHospitalId() == 0L) {
                        b1 = false;
                        break;
                    }
                    System.out.println("========" + doctorMultipleSphereVO.getHospitalId());
                    System.out.println("========" + multipleSphere.getHospitalId());
                    if (doctorMultipleSphereVO.getHospitalId().longValue() != multipleSphere.getHospitalId().longValue()) continue;
                    if (doctorMultipleSphereVO.getPositionId() == 0L) {
                        b1 = false;
                        break;
                    }
                    if (doctorMultipleSphereVO.getPositionId().longValue() != multipleSphere.getPositionId().longValue()) continue;
                    if (doctorMultipleSphereVO.getDoctorId() == 0L) {
                        b1 = false;
                        break;
                    }
                    if (doctorMultipleSphereVO.getDoctorId().longValue() != multipleSphere.getDoctorId().longValue()) continue;
                    b1 = false;
                    break;
                }
                if (b1) continue;
                break;
            }
            for (ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO : addMultipleVO.getExpertDoctorMultipleSphereVO()) {
                for (MultipleSphere multipleSphere1 : multipleSpheres) {
                    if (!expertDoctorMultipleSphereVO.getAppCode().equalsIgnoreCase(multipleSphere1.getAppCode())) continue;
                    if (expertDoctorMultipleSphereVO.getHospitalId() == 0L) {
                        b2 = false;
                        break;
                    }
                    if (expertDoctorMultipleSphereVO.getHospitalId().longValue() != multipleSphere1.getHospitalId().longValue()) continue;
                    if (expertDoctorMultipleSphereVO.getPositionId() == 0L) {
                        b2 = false;
                        break;
                    }
                    if (expertDoctorMultipleSphereVO.getPositionId().longValue() != multipleSphere1.getPositionId().longValue()) continue;
                    if (expertDoctorMultipleSphereVO.getDoctorId() == 0L) {
                        b2 = false;
                        break;
                    }
                    if (expertDoctorMultipleSphereVO.getDoctorId().longValue() != multipleSphere1.getDoctorId().longValue()) continue;
                    b2 = false;
                    break;
                }
                if (b2) continue;
                break;
            }
        }
        if (!b1 && !b2) {
            return BaseResponse.error((String)"\u6dfb\u52a0\u7684\u89c4\u5219\u91cd\u590d\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        for (DoctorMultipleSphereVO doctorMultipleSphereVO : addMultipleVO.getDoctorMultipleSphereVO()) {
            int n = this.savaMultiple(doctorMultipleSphereVO, multipleAccountRule2);
        }
        for (ExpertDoctorMultipleSphereVO expertDoctorMultipleSphereVO : addMultipleVO.getExpertDoctorMultipleSphereVO()) {
            int n = this.savaMultipleY(expertDoctorMultipleSphereVO, multipleAccountRule2);
        }
        return BaseResponse.success();
    }
}

