/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.consultation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.chat.api.pojo.UserRongCloudAssociationEntity;
import com.byh.chat.api.vo.RongCloudOrderGroupVo;
import com.byh.chat.api.vo.RongCloudUserIdVo;
import com.byh.constants.ConsultationConstant;
import com.byh.enums.HxgyPushCenterEnum;
import com.byh.enums.HxgyPushCodeIntegerEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.feign.IMGroupApiClient;
import com.byh.feign.IMPushMsgApiClient;
import com.byh.feign.IRongCloudGroupInfoClient;
import com.byh.feign.IRongUserClient;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.bo.YouMengPushDataBo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.ImMessageVo;
import com.byh.pojo.vo.consultation.res.DoctorInfoRespVO;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.JSONUtil;
import com.byh.util.PushInfoManagerUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import com.hxgy.im.pojo.IMGroupDestroyVO;
import com.hxgy.im.pojo.vo.AccountVO;
import com.hxgy.im.pojo.vo.IMCreatGroupMemVO;
import com.hxgy.im.pojo.vo.IMCreatGroupReqVO;
import com.hxgy.im.pojo.vo.IMCreateGroupRspVO;
import com.hxgy.im.pojo.vo.ImGroup;
import com.hxgy.im.pojo.vo.PushGroupMsgDataVO;
import com.hxgy.im.pojo.vo.PushGroupMsgReqVO;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements CommonService {
    private static final Logger log = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private IRongUserClient iRongUserClient;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private IRongCloudGroupInfoClient iRongCloudGroupInfoClient;
    @Autowired
    private IMGroupApiClient imGroupApiClient;
    @Autowired
    private IMPushMsgApiClient imPushMsgApiClient;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    private static final String YEAR_FORMAT = "yyyy-MM-dd";

    public Map<String, String> creatRongCloudGroup(Long orderId) {
        HashMap<String, String> map = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        if (consultationEntity == null) {
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            return map;
        }
        RongCloudOrderGroupVo rongCloudOrderGroupVo = new RongCloudOrderGroupVo();
        rongCloudOrderGroupVo.setOrderUuid(consultationEntity.getViewId());
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_VEDIO.getDisplay();
            }
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_TUWEN.getDisplay();
            }
        }
        ArrayList<RongCloudUserIdVo> list = new ArrayList<RongCloudUserIdVo>();
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            String medicalDetail = "";
            String mainSuit = "";
            String primaryDiagno = "";
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                if (str.equals("mainSuit")) {
                    mainSuit = json.get((Object)str).toString();
                }
                if (!str.equals("primaryDiagno")) continue;
                primaryDiagno = json.get((Object)str).toString();
            }
            JSONObject jsonObject = new JSONObject();
            String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            String patientBir = patientInfoRespVO.getBirthdate();
            Long age = 0L;
            if (StringUtil.isNotEmpty((String)patientBir)) {
                LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                LocalDate today = LocalDate.now();
                age = ChronoUnit.YEARS.between(birthday, today);
            }
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
            jsonObject.put("pDiaTimeChieCom", (Object)mainSuit);
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
            rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
        } else {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientInfoRespVO != null || patientCaseInfoEntity != null) {
                JSONObject jsonObject = new JSONObject();
                String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
                jsonObject.put("pDiaName", (Object)pDiaName);
                Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
                jsonObject.put("pDiaSex", (Object)pDiaSex);
                String patientBir = patientInfoRespVO.getBirthdate();
                Long age = 0L;
                if (StringUtil.isNotEmpty((String)patientBir)) {
                    LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                    LocalDate today = LocalDate.now();
                    age = ChronoUnit.YEARS.between(birthday, today);
                }
                jsonObject.put("pDiaAge", (Object)age);
                jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
                String pDiaTimeChieCom = patientCaseInfoEntity.getMainSuit() == null ? "" : patientCaseInfoEntity.getMainSuit();
                jsonObject.put("pDiaTimeChieCom", (Object)pDiaTimeChieCom);
                String primaryDiagno1 = patientCaseInfoEntity.getPrimaryDiagno() == null ? "" : patientCaseInfoEntity.getPrimaryDiagno();
                jsonObject.put("pDiaDesc", (Object)primaryDiagno1);
                rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
            }
        }
        RongCloudUserIdVo expertRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
        UserRongCloudAssociationEntity expertRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getExpertId()).getData();
        if (expertRongCloudAssociationEntity != null) {
            expertRongCloudUserIdVo.setUserType(expertDetailInfoEntity.getDoctorType());
            expertRongCloudUserIdVo.setRongCloudId(expertRongCloudAssociationEntity.getRongCloudId());
            expertRongCloudUserIdVo.setUserId(expertDetailInfoEntity.getId().toString());
            expertRongCloudUserIdVo.setHeadImageUrl(expertDetailInfoEntity.getHeadPortrait());
            expertRongCloudUserIdVo.setUserName(expertDetailInfoEntity.getName());
        }
        list.add(expertRongCloudUserIdVo);
        RongCloudUserIdVo doctorRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorDetailInfoEntity != null) {
            rongCloudOrderGroupVo.setLoginUserId(doctorDetailInfoEntity.getId().toString());
            rongCloudOrderGroupVo.setLoginUserType(doctorDetailInfoEntity.getDoctorType());
            UserRongCloudAssociationEntity doctorRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getDoctorId()).getData();
            log.info("=====\u53d6\u5230\u5ba1\u6838\u7684\u878d\u4e91id====doctorRongCloudId\uff1a" + doctorRongCloudAssociationEntity.getRongCloudId());
            rongCloudOrderGroupVo.setRongLoginUserId(doctorRongCloudAssociationEntity.getRongCloudId());
            String name = doctorDetailInfoEntity.getName() + "\u548c" + expertDetailInfoEntity.getName() + "\u7684" + orderTypeName + "\u4f1a\u8bca\u5ba4";
            if (name.length() > 15) {
                name = name.substring(0, 15);
            }
            rongCloudOrderGroupVo.setName(name);
            rongCloudOrderGroupVo.setInviteMessage(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
            doctorRongCloudUserIdVo.setUserId(doctorDetailInfoEntity.getId().toString());
            doctorRongCloudUserIdVo.setHeadImageUrl(doctorDetailInfoEntity.getHeadPortrait());
            doctorRongCloudUserIdVo.setUserType(doctorDetailInfoEntity.getDoctorType());
            doctorRongCloudUserIdVo.setRongCloudId(doctorRongCloudAssociationEntity.getRongCloudId());
            doctorRongCloudUserIdVo.setUserName(doctorDetailInfoEntity.getName());
        }
        list.add(doctorRongCloudUserIdVo);
        rongCloudOrderGroupVo.setRongCloudUserIdVoList(list);
        log.info("\u521b\u5efa\u65f6\u4f20\u5165\u7684\u503c\u662f:" + rongCloudOrderGroupVo.toString());
        BaseResponse baseResponse = this.iRongCloudGroupInfoClient.createOrderGroup(rongCloudOrderGroupVo);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            return map;
        }
        String groupId = (String)baseResponse.getData();
        int i = this.consultationService.saveConsultationGroupIdByOrderId(orderId, groupId);
        if (i > 0) {
            map.put("groupId", groupId);
            map.put("msg", "success");
            return map;
        }
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + orderId);
        return map;
    }

    public Map<String, String> creatRongCloudGroupTwo(ConsultationEntity consultationEntity, PatientCaseInfoVO patientCaseInfoVO) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (consultationEntity == null) {
            map.put("msg", "\u8ba2\u5355\u4e0d\u5b58\u5728");
            return map;
        }
        RongCloudOrderGroupVo rongCloudOrderGroupVo = new RongCloudOrderGroupVo();
        rongCloudOrderGroupVo.setOrderUuid(consultationEntity.getViewId());
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_VEDIO.getDisplay();
            }
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_TUWEN.getDisplay();
            }
        }
        ArrayList<RongCloudUserIdVo> list = new ArrayList<RongCloudUserIdVo>();
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        String medicalDetail = "";
        String mainSuit = "";
        String primaryDiagno = "";
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
                JSONObject json = JSONObject.parseObject((String)medicalDetail);
                Set sets = json.keySet();
                for (String str : sets) {
                    if (str.equals("mainSuit")) {
                        mainSuit = json.get((Object)str).toString();
                    }
                    if (!str.equals("primaryDiagno")) continue;
                    primaryDiagno = json.get((Object)str).toString();
                }
            }
            JSONObject jsonObject = new JSONObject();
            String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            String patientBir = patientInfoRespVO.getBirthdate();
            Long age = 0L;
            if (StringUtil.isNotEmpty((String)patientBir)) {
                LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                LocalDate today = LocalDate.now();
                age = ChronoUnit.YEARS.between(birthday, today);
            }
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
            jsonObject.put("pDiaTimeChieCom", (Object)mainSuit);
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
            rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
        } else {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientInfoRespVO != null || patientCaseInfoEntity != null) {
                JSONObject jsonObject = new JSONObject();
                String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
                jsonObject.put("pDiaName", (Object)pDiaName);
                Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
                jsonObject.put("pDiaSex", (Object)pDiaSex);
                String patientBir = patientInfoRespVO.getBirthdate();
                Long age = 0L;
                if (StringUtil.isNotEmpty((String)patientBir)) {
                    LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                    LocalDate today = LocalDate.now();
                    age = ChronoUnit.YEARS.between(birthday, today);
                }
                jsonObject.put("pDiaAge", (Object)age);
                jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
                String pDiaTimeChieCom = patientCaseInfoEntity.getMainSuit() == null ? "" : patientCaseInfoEntity.getMainSuit();
                jsonObject.put("pDiaTimeChieCom", (Object)pDiaTimeChieCom);
                String primaryDiagno1 = patientCaseInfoEntity.getPrimaryDiagno() == null ? "" : patientCaseInfoEntity.getPrimaryDiagno();
                jsonObject.put("pDiaDesc", (Object)primaryDiagno1);
                rongCloudOrderGroupVo.setDiagMessage(jsonObject.toJSONString());
            }
        }
        RongCloudUserIdVo expertRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
        UserRongCloudAssociationEntity expertRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getExpertId()).getData();
        if (expertRongCloudAssociationEntity != null) {
            expertRongCloudUserIdVo.setUserType(expertDetailInfoEntity.getDoctorType());
            expertRongCloudUserIdVo.setRongCloudId(expertRongCloudAssociationEntity.getRongCloudId());
            expertRongCloudUserIdVo.setUserId(expertDetailInfoEntity.getId().toString());
            expertRongCloudUserIdVo.setHeadImageUrl(expertDetailInfoEntity.getHeadPortrait());
            expertRongCloudUserIdVo.setUserName(expertDetailInfoEntity.getName());
        }
        list.add(expertRongCloudUserIdVo);
        RongCloudUserIdVo doctorRongCloudUserIdVo = new RongCloudUserIdVo();
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorDetailInfoEntity != null) {
            rongCloudOrderGroupVo.setLoginUserId(doctorDetailInfoEntity.getId().toString());
            rongCloudOrderGroupVo.setLoginUserType(doctorDetailInfoEntity.getDoctorType());
            UserRongCloudAssociationEntity doctorRongCloudAssociationEntity = (UserRongCloudAssociationEntity)this.iRongUserClient.getUserRongCloudAssociationListByUserId(consultationEntity.getDoctorId()).getData();
            rongCloudOrderGroupVo.setRongLoginUserId(doctorRongCloudAssociationEntity.getRongCloudId());
            String name = doctorDetailInfoEntity.getName() + "\u548c" + expertDetailInfoEntity.getName() + "\u7684" + orderTypeName + "\u4f1a\u8bca\u5ba4";
            if (name.length() > 15) {
                name = name.substring(0, 15);
            }
            rongCloudOrderGroupVo.setName(name);
            rongCloudOrderGroupVo.setInviteMessage(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
            doctorRongCloudUserIdVo.setUserId(doctorDetailInfoEntity.getId().toString());
            doctorRongCloudUserIdVo.setHeadImageUrl(doctorDetailInfoEntity.getHeadPortrait());
            doctorRongCloudUserIdVo.setUserType(doctorDetailInfoEntity.getDoctorType());
            doctorRongCloudUserIdVo.setRongCloudId(doctorRongCloudAssociationEntity.getRongCloudId());
            doctorRongCloudUserIdVo.setUserName(doctorDetailInfoEntity.getName());
        }
        list.add(doctorRongCloudUserIdVo);
        rongCloudOrderGroupVo.setRongCloudUserIdVoList(list);
        BaseResponse baseResponse = this.iRongCloudGroupInfoClient.createOrderGroup(rongCloudOrderGroupVo);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            return map;
        }
        String groupId = (String)baseResponse.getData();
        int i = this.consultationService.saveConsultationGroupIdByOrderId(consultationEntity.getId(), groupId);
        if (i > 0) {
            map.put("groupId", groupId);
            map.put("msg", "success");
            return map;
        }
        log.error("\u4fdd\u5b58groupId\u5931\u8d25=========\u8ba2\u5355id:" + consultationEntity.getId());
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + consultationEntity.getId());
        return map;
    }

    public Map<String, String> tencentCreatRongCloudGroup(ConsultationEntity consultationEntity) {
        log.info("==================\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4====================");
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorInfoRespVO doctorInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getDoctorId(), consultationEntity.getDoctorHospitalId());
        DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getExpertId(), consultationEntity.getExpertHospitalId());
        ArrayList<IMCreatGroupMemVO> list = new ArrayList<IMCreatGroupMemVO>();
        IMCreatGroupMemVO doctorMermber = new IMCreatGroupMemVO();
        doctorMermber.setUserId(doctorInfo.getUserId());
        doctorMermber.setAppCode("EHOS_DOCTOR");
        doctorMermber.setPerName(consultationEntity.getDoctorName());
        list.add(doctorMermber);
        IMCreatGroupMemVO expertMermber = new IMCreatGroupMemVO();
        expertMermber.setUserId(expertInfo.getUserId());
        expertMermber.setAppCode("EHOS_DOCTOR");
        expertMermber.setPerName(consultationEntity.getExpertName());
        list.add(expertMermber);
        IMCreatGroupReqVO imCreatGroupReqVO = new IMCreatGroupReqVO();
        imCreatGroupReqVO.setBusiCode("ychz");
        imCreatGroupReqVO.setCreateUser(consultationEntity.getDoctorName());
        imCreatGroupReqVO.setTreatmentId(consultationEntity.getViewId());
        imCreatGroupReqVO.setMembers(list);
        ImGroup imGroup = new ImGroup();
        imGroup.setAppCode("EHOS_DOCTOR");
        imGroup.setGroupType("Private");
        imGroup.setGroupName("\u804a\u5929\u5ba4");
        imCreatGroupReqVO.setImGroup(imGroup);
        log.info("\u817e\u8bafIM\u8bf7\u6c42\u53c2\u6570imCreatGroupReqVO\uff1a{}", (Object)imCreatGroupReqVO);
        BaseResponse baseResponse = this.imGroupApiClient.creatGroup(imCreatGroupReqVO);
        log.info("\u817e\u8bafIM baseResponse:{}", (Object)baseResponse);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            return map;
        }
        String logurl = "http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/25/1548382195565_a8f889794b454136ac0de6341fc1f52d.png";
        String groupId = ((IMCreateGroupRspVO)baseResponse.getData()).getGroupId();
        int i = this.consultationService.saveConsultationGroupIdAndUrlByOrderId(consultationEntity.getId(), groupId, logurl);
        if (i > 0) {
            log.info("\u4fdd\u5b58groupId\u6210\u529f=========");
            map.put("msg", "success");
            map.put("groupId", groupId);
            return map;
        }
        log.error("\u4fdd\u5b58groupId\u5931\u8d25=========\u8ba2\u5355id:" + consultationEntity.getId());
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + consultationEntity.getId());
        return map;
    }

    public void tencentPushGroupMsg(ConsultationEntity consultationEntity) {
        log.info("=========================\u817e\u8bafIM\u7fa4\u7ec4\u521b\u5efa\u540e\u6d88\u606f\u63a8\u9001=========================");
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        DoctorInfoRespVO doctorInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getDoctorId(), consultationEntity.getDoctorHospitalId());
        log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1adoctorInfo:{}", (Object)doctorInfo);
        DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getExpertId(), consultationEntity.getExpertHospitalId());
        log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertInfo:{}", (Object)expertInfo);
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        JSONObject jsonObject = new JSONObject();
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            String medicalDetail = "";
            String mainSuit = "";
            String primaryDiagno = "";
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                if (str.equals("mainSuit")) {
                    mainSuit = json.get((Object)str).toString();
                }
                if (!str.equals("primaryDiagno")) continue;
                primaryDiagno = json.get((Object)str).toString();
            }
            String pDiaName = consultationEntity.getPatientName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = consultationExtendEntity.getPatientSex();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            Long age = (long)consultationExtendEntity.getPatientAge();
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getUpdateTime());
            jsonObject.put("pDiaTimeChieCom", (Object)mainSuit);
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
        } else {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientInfoRespVO != null || patientCaseInfoEntity != null) {
                String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
                jsonObject.put("pDiaName", (Object)pDiaName);
                Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
                jsonObject.put("pDiaSex", (Object)pDiaSex);
                String patientBir = patientInfoRespVO.getBirthdate();
                Long age = 0L;
                if (StringUtil.isNotEmpty((String)patientBir)) {
                    LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                    LocalDate today = LocalDate.now();
                    age = ChronoUnit.YEARS.between(birthday, today);
                }
                jsonObject.put("pDiaAge", (Object)age);
                jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
                String pDiaTimeChieCom = patientCaseInfoEntity.getMainSuit() == null ? "" : patientCaseInfoEntity.getMainSuit();
                jsonObject.put("pDiaTimeChieCom", (Object)pDiaTimeChieCom);
                String primaryDiagno1 = patientCaseInfoEntity.getPrimaryDiagno() == null ? "" : patientCaseInfoEntity.getPrimaryDiagno();
                jsonObject.put("pDiaDesc", (Object)primaryDiagno1);
            }
        }
        ImMessageVo imMessageVo = new ImMessageVo();
        imMessageVo.setApplicationCode("ychz");
        imMessageVo.setBusinessCode("hzkp");
        imMessageVo.setData(jsonObject.toJSONString());
        imMessageVo.setTreatmentId(consultationEntity.getViewId());
        String msg = JSONUtil.toJSONString((Object)imMessageVo);
        ArrayList<PushGroupMsgDataVO> list = new ArrayList<PushGroupMsgDataVO>();
        PushGroupMsgDataVO pushGroupMsgDataVO = new PushGroupMsgDataVO();
        pushGroupMsgDataVO.setActionType("system");
        pushGroupMsgDataVO.setMessage(msg);
        AccountVO docAccountVO = new AccountVO();
        docAccountVO.setAppCode("EHOS_DOCTOR");
        docAccountVO.setUserId(doctorInfo.getUserId());
        pushGroupMsgDataVO.setFromAccount(docAccountVO);
        log.info("\u53d1\u9001\u8005\u8d26\u53f7docAccountVO\uff1a{}", (Object)docAccountVO.toString());
        ArrayList<AccountVO> accountList = new ArrayList<AccountVO>();
        AccountVO expertAccountVO = new AccountVO();
        expertAccountVO.setAppCode("EHOS_DOCTOR");
        expertAccountVO.setUserId(expertInfo.getUserId());
        accountList.add(docAccountVO);
        accountList.add(expertAccountVO);
        pushGroupMsgDataVO.setToAccount(accountList);
        log.info("\u63a5\u53d7\u8005\u8d26\u53f7accountList\uff1a{}", accountList);
        list.add(pushGroupMsgDataVO);
        log.info("pushGroupMsgDataVO\uff1a{}", (Object)pushGroupMsgDataVO);
        PushGroupMsgReqVO pushGroupMsgReqVO = new PushGroupMsgReqVO();
        pushGroupMsgReqVO.setBusiCode("ychz");
        pushGroupMsgReqVO.setTreatmentId(consultationEntity.getViewId());
        pushGroupMsgReqVO.setMsgData(list);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001pushGroupMsgReqVO\uff1a{}", (Object)pushGroupMsgReqVO.toString());
        BaseResponse baseResponse = this.imPushMsgApiClient.pushGroupMsg(pushGroupMsgReqVO);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001\u8fd4\u56de baseResponse:{}", (Object)baseResponse);
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_VEDIO.getDisplay();
            }
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_TUWEN.getDisplay();
            }
        }
        ImMessageVo imMessageExpert = new ImMessageVo();
        imMessageExpert.setApplicationCode("ychz");
        imMessageExpert.setBusinessCode("cjdd");
        imMessageExpert.setData(consultationEntity.getDoctorName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
        imMessageExpert.setTreatmentId(consultationEntity.getViewId());
        String msgExpert = JSONUtil.toJSONString((Object)imMessageExpert);
        ArrayList<PushGroupMsgDataVO> listEx = new ArrayList<PushGroupMsgDataVO>();
        PushGroupMsgDataVO pushGroupMsgDataVOEx = new PushGroupMsgDataVO();
        pushGroupMsgDataVOEx.setActionType("system");
        pushGroupMsgDataVOEx.setMessage(msgExpert);
        AccountVO docAccountVOEx = new AccountVO();
        docAccountVOEx.setAppCode("EHOS_DOCTOR");
        docAccountVOEx.setUserId(doctorInfo.getUserId());
        pushGroupMsgDataVOEx.setFromAccount(docAccountVOEx);
        log.info("\u53d1\u9001\u8005\u8d26\u53f7docAccountVOEx\uff1a{}", (Object)docAccountVOEx);
        ArrayList<AccountVO> accountListEx = new ArrayList<AccountVO>();
        AccountVO expertAccountVOEx = new AccountVO();
        expertAccountVOEx.setAppCode("EHOS_DOCTOR");
        expertAccountVOEx.setUserId(expertInfo.getUserId());
        accountListEx.add(expertAccountVOEx);
        pushGroupMsgDataVOEx.setToAccount(accountListEx);
        log.info("\u63a5\u53d7\u8005\u8d26\u53f7accountListEx\uff1a{}", accountListEx);
        listEx.add(pushGroupMsgDataVOEx);
        log.info("pushGroupMsgDataVOEx\uff1a{}", (Object)pushGroupMsgDataVOEx);
        PushGroupMsgReqVO pushGroupMsgReqVOEx = new PushGroupMsgReqVO();
        pushGroupMsgReqVOEx.setBusiCode("ychz");
        pushGroupMsgReqVOEx.setTreatmentId(consultationEntity.getViewId());
        pushGroupMsgReqVOEx.setMsgData(listEx);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001pushGroupMsgReqVOEx\uff1a{}", (Object)pushGroupMsgReqVOEx);
        BaseResponse baseResponseEx = this.imPushMsgApiClient.pushGroupMsg(pushGroupMsgReqVOEx);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001\u8fd4\u56debaseResponseEx:{}", (Object)baseResponseEx);
        log.info("=================App\u63a8\u9001\u5f00\u59cb \u4e13\u5bb6 \u4f1a\u8bca\u540c\u610f=================");
        DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId());
        String expertVideoAppCode = this.getAppCode(consultationEntity.getExpertHospitalId());
        HashMap<String, String> map = new HashMap<String, String>();
        YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
        youMengPushDataBo.setText(consultationEntity.getDoctorName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
        youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.YC_TO_TREAT.getValue());
        youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
        youMengPushDataBo.setDescription("");
        youMengPushDataBo.setPlayAction("");
        youMengPushDataBo.setTitle(HxgyPushCenterEnum.YC_TO_TREAT.getDisplay());
        youMengPushDataBo.setTicker("");
        youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
        map.put("pushCode", HxgyPushCodeIntegerEnum.YC_TO_TREAT.getCode().toString());
        this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
        youMengPushDataBo.setExtra(map);
        youMengPushDataBo.setCustom(JSON.toJSONString(map));
        log.info("\u8bf7\u6c42\u53c2\u6570youMengPushDataBo\uff1a{}", (Object)youMengPushDataBo);
        this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo);
        log.info("=================App\u63a8\u9001\u7ed3\u675f \u4e13\u5bb6 \u4f1a\u8bca\u540c\u610f=================");
        log.info("=================App\u63a8\u9001\u5f00\u59cb \u4e13\u5bb6 \u60a3\u8005\u5361\u7247=================");
        HashMap<String, String> map1 = new HashMap<String, String>();
        YouMengPushDataBo youMengPushDataBo1 = new YouMengPushDataBo();
        youMengPushDataBo1.setText(jsonObject.toJSONString());
        youMengPushDataBo1.setBusiCode(HxgyPushCenterEnum.YC_TO_TREAT.getValue());
        youMengPushDataBo1.setBusiStyle(youMengPushDataBo1.getText());
        youMengPushDataBo1.setDescription("");
        youMengPushDataBo1.setPlayAction("");
        youMengPushDataBo1.setTitle(HxgyPushCenterEnum.YC_TO_TREAT.getDisplay());
        youMengPushDataBo1.setTicker("");
        youMengPushDataBo1.setUserId(expertInfoRespVO.getUserId());
        map1.put("pushCode", HxgyPushCodeIntegerEnum.YC_TO_TREAT.getCode().toString());
        this.fillExtraMap(map1, youMengPushDataBo1, consultationEntity);
        youMengPushDataBo1.setExtra(map1);
        youMengPushDataBo1.setCustom(JSON.toJSONString(map1));
        log.info("\u8bf7\u6c42\u53c2\u6570youMengPushDataBo1\uff1a{}", (Object)youMengPushDataBo1);
        this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo1);
        log.info("=================App\u63a8\u9001\u7ed3\u675f \u4e13\u5bb6 \u60a3\u8005\u5361\u7247=================");
    }

    public Map<String, String> tencentMdtGroup(ConsultationEntity consultationEntity) {
        log.info("==================\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4====================");
        log.info("consultationEntity:{}", (Object)consultationEntity);
        HashMap<String, String> map = new HashMap<String, String>();
        DoctorInfoRespVO doctorInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getDoctorId(), consultationEntity.getDoctorHospitalId());
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\uff1adoctorInfo:{}", (Object)doctorInfo);
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\uff1adoctorDetailInfoEntity:{}", (Object)doctorDetailInfoEntity);
        ArrayList<IMCreatGroupMemVO> list = new ArrayList<IMCreatGroupMemVO>();
        IMCreatGroupMemVO doctorMermber = new IMCreatGroupMemVO();
        doctorMermber.setUserId(doctorInfo.getUserId());
        doctorMermber.setAppCode("EHOS_DOCTOR");
        doctorMermber.setPerName(doctorDetailInfoEntity.getName());
        list.add(doctorMermber);
        List mdtConsultationEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
        for (ConsultationMdtEntity mdtConsultationEntity : mdtConsultationEntityList) {
            log.info("groupId \u521b\u5efa\u5b50\u8ba2\u5355\u4fe1\u606fmdtConsultationEntity\uff1a{}", (Object)mdtConsultationEntity);
            DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(mdtConsultationEntity.getExpertId(), mdtConsultationEntity.getExpertHospitalId());
            log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertInfo:{}", (Object)expertInfo);
            DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(mdtConsultationEntity.getExpertId());
            log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertDetailInfoEntity:{}", (Object)expertDetailInfoEntity);
            IMCreatGroupMemVO expertMermber = new IMCreatGroupMemVO();
            expertMermber.setUserId(expertInfo.getUserId());
            expertMermber.setAppCode("EHOS_DOCTOR");
            expertMermber.setPerName(expertDetailInfoEntity.getName());
            list.add(expertMermber);
        }
        IMCreatGroupReqVO imCreatGroupReqVO = new IMCreatGroupReqVO();
        imCreatGroupReqVO.setBusiCode("ychz");
        imCreatGroupReqVO.setCreateUser(doctorDetailInfoEntity.getName());
        imCreatGroupReqVO.setTreatmentId(consultationEntity.getViewId());
        imCreatGroupReqVO.setMembers(list);
        ImGroup imGroup = new ImGroup();
        imGroup.setAppCode("EHOS_DOCTOR");
        imGroup.setGroupType("Private");
        imGroup.setGroupName("\u804a\u5929\u5ba4");
        imCreatGroupReqVO.setImGroup(imGroup);
        log.info("\u817e\u8bafIM\u8bf7\u6c42\u53c2\u6570imCreatGroupReqVO\uff1a{}", (Object)imCreatGroupReqVO.toString());
        BaseResponse baseResponse = this.imGroupApiClient.creatGroup(imCreatGroupReqVO);
        log.info("\u817e\u8bafIM baseResponse:{}", (Object)baseResponse);
        if (baseResponse == null || !baseResponse.getCode().equals("1")) {
            return map;
        }
        String logurl = "http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/25/1548382195565_a8f889794b454136ac0de6341fc1f52d.png";
        String groupId = ((IMCreateGroupRspVO)baseResponse.getData()).getGroupId();
        int i = this.consultationService.saveConsultationGroupIdAndUrlByOrderId(consultationEntity.getId(), groupId, logurl);
        if (i > 0) {
            log.info("\u4fdd\u5b58groupId\u6210\u529f=========");
            map.put("msg", "success");
            map.put("groupId", groupId);
            return map;
        }
        log.error("\u4fdd\u5b58groupId\u5931\u8d25=========\u8ba2\u5355id:" + consultationEntity.getId());
        map.put("msg", "\u8ba2\u5355\u670d\u52a1\u9519\u8bef:\u4fdd\u5b58groupId\u5931\u8d25,\u8ba2\u5355id" + consultationEntity.getId());
        return map;
    }

    public void tencentPushGroupMdtMsg(ConsultationEntity consultationEntity) {
        log.info("=========================MDT \u817e\u8bafIM\u7fa4\u7ec4\u521b\u5efa\u540e\u6d88\u606f\u63a8\u9001=========================");
        DoctorInfoRespVO doctorInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationEntity.getDoctorId(), consultationEntity.getDoctorHospitalId());
        log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1adoctorInfo:{}", (Object)doctorInfo);
        DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\uff1adoctorDetailInfoEntity:{}", (Object)doctorDetailInfoEntity);
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        JSONObject jsonObject = new JSONObject();
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            String medicalDetail = "";
            String mainSuit = "";
            String primaryDiagno = "";
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            String mainSuitCase = patientCaseInfoEntity.getMainSuit();
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                if (str.equals("mainSuit")) {
                    mainSuit = json.get((Object)str).toString();
                }
                if (!str.equals("primaryDiagno")) continue;
                primaryDiagno = json.get((Object)str).toString();
            }
            String pDiaName = patientInfoRespVO.getName() == null ? "" : patientInfoRespVO.getName();
            jsonObject.put("pDiaName", (Object)pDiaName);
            Integer pDiaSex = patientInfoRespVO.getGender() == null ? 0 : patientInfoRespVO.getGender().intValue();
            jsonObject.put("pDiaSex", (Object)pDiaSex);
            String patientBir = patientInfoRespVO.getBirthdate();
            Long age = 0L;
            if (StringUtil.isNotEmpty((String)patientBir)) {
                LocalDate birthday = LocalDate.from(DateTimeFormatter.ofPattern(YEAR_FORMAT).parse(patientInfoRespVO.getBirthdate()));
                LocalDate today = LocalDate.now();
                age = ChronoUnit.YEARS.between(birthday, today);
            }
            jsonObject.put("pDiaAge", (Object)age);
            jsonObject.put("pDiaTime", (Object)consultationEntity.getCreateTime());
            jsonObject.put("pDiaTimeChieCom", (Object)(StringUtil.isEmpty((String)mainSuit) ? mainSuitCase : mainSuit));
            jsonObject.put("pDiaDesc", (Object)primaryDiagno);
        }
        ImMessageVo imMessageVo = new ImMessageVo();
        imMessageVo.setApplicationCode("ychz");
        imMessageVo.setBusinessCode("hzkp");
        imMessageVo.setData(jsonObject.toJSONString());
        imMessageVo.setTreatmentId(consultationEntity.getViewId());
        String msg = JSONUtil.toJSONString((Object)imMessageVo);
        ArrayList<PushGroupMsgDataVO> list = new ArrayList<PushGroupMsgDataVO>();
        PushGroupMsgDataVO pushGroupMsgDataVO = new PushGroupMsgDataVO();
        pushGroupMsgDataVO.setActionType("system");
        pushGroupMsgDataVO.setMessage(msg);
        ArrayList<AccountVO> accountList = new ArrayList<AccountVO>();
        AccountVO docAccountVO = new AccountVO();
        docAccountVO.setAppCode("EHOS_DOCTOR");
        docAccountVO.setUserId(doctorInfo.getUserId());
        pushGroupMsgDataVO.setFromAccount(docAccountVO);
        accountList.add(docAccountVO);
        log.info("\u53d1\u9001\u8005\u8d26\u53f7docAccountVO\uff1a{}", (Object)docAccountVO.toString());
        List consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
        for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
            DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationMdtEntity.getExpertId(), consultationMdtEntity.getExpertHospitalId());
            log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertInfo:{}", (Object)expertInfo);
            AccountVO expertAccountVO = new AccountVO();
            expertAccountVO.setAppCode("EHOS_DOCTOR");
            expertAccountVO.setUserId(expertInfo.getUserId());
            accountList.add(expertAccountVO);
        }
        pushGroupMsgDataVO.setToAccount(accountList);
        log.info("\u63a5\u53d7\u8005\u8d26\u53f7accountList\uff1a{}", accountList);
        list.add(pushGroupMsgDataVO);
        log.info("pushGroupMsgDataVO\uff1a{}", (Object)pushGroupMsgDataVO);
        PushGroupMsgReqVO pushGroupMsgReqVO = new PushGroupMsgReqVO();
        pushGroupMsgReqVO.setBusiCode("ychz");
        pushGroupMsgReqVO.setTreatmentId(consultationEntity.getViewId());
        pushGroupMsgReqVO.setMsgData(list);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001pushGroupMsgReqVO\uff1a{}", (Object)pushGroupMsgReqVO);
        BaseResponse baseResponse = this.imPushMsgApiClient.pushGroupMsg(pushGroupMsgReqVO);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001\u8fd4\u56de baseResponse:{}", (Object)baseResponse);
        Integer orderType = consultationEntity.getType();
        String orderTypeName = "";
        if (orderType.intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_VEDIO.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_VEDIO.getDisplay();
            }
        } else if (orderType.intValue() == OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            orderTypeName = OrderTypeEnum.TYPE_TUWEN.getDisplay();
            if (consultationEntity.getApplicationChannels().intValue() == ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue()) {
                orderTypeName = OrderTypeEnum.TYPE_TWO_TUWEN.getDisplay();
            }
        }
        ImMessageVo imMessageExpert = new ImMessageVo();
        imMessageExpert.setApplicationCode("ychz");
        imMessageExpert.setBusinessCode("cjdd");
        imMessageExpert.setData(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
        imMessageExpert.setTreatmentId(consultationEntity.getViewId());
        String msgExpert = JSONUtil.toJSONString((Object)imMessageExpert);
        ArrayList<PushGroupMsgDataVO> listEx = new ArrayList<PushGroupMsgDataVO>();
        PushGroupMsgDataVO pushGroupMsgDataVOEx = new PushGroupMsgDataVO();
        pushGroupMsgDataVOEx.setActionType("system");
        pushGroupMsgDataVOEx.setMessage(msgExpert);
        AccountVO docAccountVOEx = new AccountVO();
        docAccountVOEx.setAppCode("EHOS_DOCTOR");
        docAccountVOEx.setUserId(doctorInfo.getUserId());
        pushGroupMsgDataVOEx.setFromAccount(docAccountVOEx);
        log.info("\u53d1\u9001\u8005\u8d26\u53f7docAccountVOEx\uff1a{}", (Object)docAccountVOEx.toString());
        ArrayList<AccountVO> accountListEx = new ArrayList<AccountVO>();
        for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
            DoctorInfoRespVO expertInfo = this.remoteManage.getDoctorDetailByIdAndHosId(consultationMdtEntity.getExpertId(), consultationMdtEntity.getExpertHospitalId());
            log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertInfo:{}", (Object)expertInfo);
            AccountVO expertAccountVOEx = new AccountVO();
            expertAccountVOEx.setAppCode("EHOS_DOCTOR");
            expertAccountVOEx.setUserId(expertInfo.getUserId());
            accountListEx.add(expertAccountVOEx);
        }
        pushGroupMsgDataVOEx.setToAccount(accountListEx);
        log.info("\u63a5\u53d7\u8005\u8d26\u53f7accountListEx\uff1a{}", accountListEx);
        listEx.add(pushGroupMsgDataVOEx);
        log.info("pushGroupMsgDataVOEx\uff1a{}", (Object)pushGroupMsgDataVOEx);
        PushGroupMsgReqVO pushGroupMsgReqVOEx = new PushGroupMsgReqVO();
        pushGroupMsgReqVOEx.setBusiCode("ychz");
        pushGroupMsgReqVOEx.setTreatmentId(consultationEntity.getViewId());
        pushGroupMsgReqVOEx.setMsgData(listEx);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001pushGroupMsgReqVOEx\uff1a{}", (Object)pushGroupMsgReqVOEx);
        BaseResponse baseResponseEx = this.imPushMsgApiClient.pushGroupMsg(pushGroupMsgReqVOEx);
        log.info("\u817e\u8bafIM\u521b\u5efa\u7fa4\u7ec4\u540e\u6d88\u606f\u63a8\u9001\u8fd4\u56debaseResponseEx:{}", (Object)baseResponseEx);
        log.info("=================App\u63a8\u9001\u5f00\u59cb \u4e13\u5bb6 \u4f1a\u8bca\u540c\u610f=================");
        HashMap<String, String> map = new HashMap<String, String>();
        YouMengPushDataBo youMengPushDataBo = new YouMengPushDataBo();
        youMengPushDataBo.setText(doctorDetailInfoEntity.getName() + "\u533b\u751f\u9080\u8bf7\u60a8\u53c2\u4e0e\u672c\u6b21" + orderTypeName + "\u60a8\u662f\u5426\u540c\u610f?");
        youMengPushDataBo.setBusiCode(HxgyPushCenterEnum.YC_TO_TREAT.getValue());
        youMengPushDataBo.setBusiStyle(youMengPushDataBo.getText());
        youMengPushDataBo.setDescription("");
        youMengPushDataBo.setPlayAction("");
        youMengPushDataBo.setTitle(HxgyPushCenterEnum.YC_TO_TREAT.getDisplay());
        youMengPushDataBo.setTicker("");
        map.put("pushCode", HxgyPushCodeIntegerEnum.YC_TO_TREAT.getCode().toString());
        for (ConsultationMdtEntity mdtEntity : consultationMdtEntityList) {
            DoctorInfoRespVO expertInfoRespVO = this.userCenterRemote.getUserIdByDoctorId(mdtEntity.getExpertId());
            String expertVideoAppCode = this.getAppCode(mdtEntity.getExpertHospitalId());
            youMengPushDataBo.setUserId(expertInfoRespVO.getUserId());
            this.fillExtraMap(map, youMengPushDataBo, consultationEntity);
            youMengPushDataBo.setExtra(map);
            youMengPushDataBo.setCustom(JSON.toJSONString(map));
            log.info("\u8bf7\u6c42\u53c2\u6570youMengPushDataBo\uff1a{}", (Object)youMengPushDataBo);
            this.pushInfoManagerUtils.youmengPushDataByUserId(expertVideoAppCode, youMengPushDataBo);
        }
    }

    public void tencentDestroyGroupMsg(ConsultationEntity consultationEntity) {
        String groupId = consultationEntity.getGroupId();
        if (StringUtils.isNotEmpty((CharSequence)groupId)) {
            IMGroupDestroyVO imGroupDestroyVO = new IMGroupDestroyVO();
            imGroupDestroyVO.setGroupId(groupId);
            imGroupDestroyVO.setAppCode("EHOS_DOCTOR");
            log.info("\u817e\u8bafIM\u89e3\u6563\u7fa4\u7ec4\u8bf7\u6c42\u53c2\u6570imGroupDestroyVO\uff1a{}", (Object)imGroupDestroyVO);
            BaseResponse baseResponse = this.imGroupApiClient.destroyGroup(imGroupDestroyVO);
            log.info("\u817e\u8bafIM\u89e3\u6563\u7fa4\u7ec4\u8fd4\u53c2 baseResponse:{}", (Object)baseResponse);
        }
    }

    private void fillExtraMap(Map<String, String> map, YouMengPushDataBo youMengPushDataBo, ConsultationEntity consultationEntity1) {
        map.put("content", youMengPushDataBo.getText());
        map.put("orderViewId", consultationEntity1.getViewId());
        map.put("orderStatus", consultationEntity1.getStatus().toString());
        map.put("orderType", consultationEntity1.getType().toString());
        map.put("orderId", consultationEntity1.getId().toString());
    }

    public String getAppCode(Long hospitalId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        return (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
    }
}

