/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.mdtconsultation;

import com.byh.dao.consultation.ConsultationMdtMapper;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.MdtConsultationEntity;
import com.byh.pojo.vo.mdtconsultation.MdtConsultationDataInfoVO;
import com.byh.pojo.vo.mdtconsultation.MdtOrderDataVO;
import com.byh.service.mdtconsultation.MdtConsultationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdtConsultationServiceImpl
implements MdtConsultationService {
    @Autowired
    private ConsultationMdtMapper consultationMdtMapper;

    public List<ConsultationEntity> queryConsultationEntityByPatientId(Long patientId) {
        return this.consultationMdtMapper.queryConsultationEntityByPatientId(patientId);
    }

    public List<ConsultationEntity> queryConsultationListByDocIdAndType(Long doctorId, Integer type, String search) {
        return this.consultationMdtMapper.queryConsultationListByDocIdAndType(doctorId, type, search);
    }

    public List<MdtConsultationEntity> getListByPatientId(Long patientId, String appCode) {
        return this.consultationMdtMapper.getListByPatientId(patientId, appCode);
    }

    public List<MdtConsultationEntity> getListByPatientIds(List<Long> patientIds, String appCode) {
        return this.consultationMdtMapper.getListByPatientIds(patientIds, appCode);
    }

    public Integer getOrderCount(Integer timeType, String beginTime, String endTime, String search, Integer orderType, Integer orderStatus, Integer qualifiedType, Integer qualified, List<Long> hosList, Integer applicationChannels) {
        return this.consultationMdtMapper.getOrderCount(timeType, beginTime, endTime, search, orderType, orderStatus, qualifiedType, qualified, hosList, applicationChannels);
    }

    public List<MdtOrderDataVO> getOrderData(Integer timeType, String beginTime, String endTime, String search, Integer orderType, Integer orderStatus, Integer qualified, List<Long> hosList, Integer applicationChannels, Integer pageIndex, Integer pageSize) {
        if (pageIndex != null) {
            pageIndex = (pageIndex - 1) * pageSize;
        }
        return this.consultationMdtMapper.getOrderData(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, hosList, applicationChannels, pageIndex, pageSize);
    }

    public Integer getOrderDataCount(Integer timeType, String beginTime, String endTime, String search, Integer orderType, Integer orderStatus, Integer qualified, List<Long> hosList, Integer applicationChannels) {
        return this.consultationMdtMapper.getOrderDataCount(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, hosList, applicationChannels);
    }

    public List<MdtConsultationDataInfoVO> getExcelOrderData(Integer timeType, String beginTime, String endTime, String search, Integer orderType, Integer orderStatus, Integer qualified, List<Long> hosList, List<Long> orderIds, Integer applicationChannels) {
        return this.consultationMdtMapper.getExcelOrderData(timeType, beginTime, endTime, search, orderType, orderStatus, qualified, hosList, orderIds, applicationChannels);
    }

    public List<MdtConsultationEntity> queryConsultationListCount(String beginTime, String endTime, Integer status, String depName, String search, List hosList, Integer type, Integer reportStatus, Integer timeType, Integer applicationChannels, Integer pageIndex, Integer pageSize) {
        return this.consultationMdtMapper.queryConsultationListCount(beginTime, endTime, status, depName, search, hosList, type, reportStatus, timeType, applicationChannels, pageIndex, pageSize);
    }

    public ConsultationMdtEntity getConsultationMdtEntity(String orderViewId, Long doctorId) {
        return this.consultationMdtMapper.queryConsultationMdtList(orderViewId, doctorId);
    }

    public void insertMore(List<ConsultationMdtEntity> list) {
        this.consultationMdtMapper.insertMore(list);
    }

    public List<ConsultationMdtEntity> queryMdtConsultationEntityByOrderViewId(String viewId) {
        return this.consultationMdtMapper.queryMdtConsultationEntityByOrderViewId(viewId);
    }

    public List<ConsultationEntity> getAppOrderList(Long doctorId, Integer doctorType, List<Integer> orderStatus, List<Integer> orderTypes, String searchParam, List<Integer> reportStatus) {
        return this.consultationMdtMapper.getMdtAppOrderList(doctorId, doctorType, orderStatus, orderTypes, searchParam, reportStatus);
    }

    public int updateConsultationMdtForAccept(String orderViewId, Long doctorId, Integer status, String acceptTime) {
        return this.consultationMdtMapper.updateConsultationMdtForAccept(orderViewId, doctorId, status, acceptTime);
    }

    public List<ConsultationMdtEntity> getConsultationMdtListByOrderViewId(String orderViewId) {
        return this.consultationMdtMapper.getConsultationMdtListByOrderViewId(orderViewId);
    }

    public int deleteConsultationMdtByOrderViewId(String orderViewId) {
        return this.consultationMdtMapper.deleteConsultationMdtByOrderViewId(orderViewId);
    }

    public int updateOrderBeginTimeById(Long orderId, String startTime) {
        return this.consultationMdtMapper.updateOrderBeginTimeById(orderId, startTime);
    }

    public int updateOrderFinishTimeById(Long orderId, String formatTime, Integer status) {
        return this.consultationMdtMapper.updateOrderFinishTimeById(orderId, formatTime, status);
    }

    public ConsultationMdtEntity selectByViewId(String mdtViewId) {
        return this.consultationMdtMapper.selectByViewId(mdtViewId);
    }

    public ConsultationMdtEntity update(ConsultationMdtEntity consultationMdtEntity) {
        this.consultationMdtMapper.update(consultationMdtEntity);
        return this.consultationMdtMapper.selectByViewId(consultationMdtEntity.getViewId());
    }

    public ConsultationMdtEntity selectByOrderviewIdDoctorId(String orderViewId, Long doctorId) {
        return this.consultationMdtMapper.selectByOrderviewIdDoctorId(orderViewId, doctorId);
    }

    public List<ConsultationMdtEntity> selectByViewIdList(String mdtViewId) {
        return this.consultationMdtMapper.selectByViewIdList(mdtViewId);
    }
}

