/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.patient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.dao.patient.PatientCaseInfoMapper;
import com.byh.feign.IOssApiClient;
import com.byh.pojo.bo.NormalImage;
import com.byh.pojo.bo.PatientCaseInfoBO;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.patient.CaseVO;
import com.byh.pojo.vo.patient.CtPatientCaseVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.pojo.vo.patient.PatientCaseReqVO;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PatientCaseInfoServiceImpl
implements PatientCaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(PatientCaseInfoServiceImpl.class);
    @Autowired
    private PatientCaseInfoMapper patientCaseInfoMapper;
    @Autowired
    private IOssApiClient ossApiClient;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;
    @Autowired
    private IOssApiClient iOssApiClient;

    public int deletePatientCaseInfoById(Long id) {
        return this.patientCaseInfoMapper.deleteById(id, Integer.valueOf(-1));
    }

    @Transactional(rollbackFor={Exception.class})
    public PatientCaseInfoVO insertPatientCaseInfo(PatientCaseInfoVO patientCaseInfoVO) {
        patientCaseInfoVO.setStatus(Integer.valueOf(1));
        patientCaseInfoVO.setViewId(UuidUtils.generateUUID());
        this.patientCaseInfoMapper.insert(patientCaseInfoVO);
        return patientCaseInfoVO;
    }

    public PatientCaseInfoEntity selectPatientCaseInfoById(Long id) {
        return this.patientCaseInfoMapper.selectById(id);
    }

    public List<PatientCaseInfoEntity> selectPatientCaseInfoByStatus(Integer status) {
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.selectByStatus(status);
        return this.getNewPatientCaseInfoDTO(patientCaseInfoDTOList);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updatePatientCaseInfoByIdSelective(PatientCaseInfoVO patientCaseInfoVO) {
        return this.patientCaseInfoMapper.updateByIdSelective(patientCaseInfoVO);
    }

    public List<PatientCaseInfoEntity> findPatientCaseInfoListByIds(List<Long> ids) {
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.findPatientCaseInfoListByIds(ids, Integer.valueOf(1));
        return this.getNewPatientCaseInfoDTO(patientCaseInfoDTOList);
    }

    public List<CaseVO> findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(String patientViewId, Long deptId, Integer caseType, String startTime, String endTime) {
        ArrayList<CaseVO> list = new ArrayList<CaseVO>();
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(patientViewId, deptId, caseType, startTime, endTime, 1);
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOList) {
            CaseVO caseVO = new CaseVO();
            BeanUtils.copyProperties((Object)patientCaseInfoDTO, (Object)caseVO);
            caseVO.setNormalImagesPath(this.newPath(patientCaseInfoDTO.getNormalImages()));
            caseVO.setRadioGraphFilmImagesPath(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
            caseVO.setCheckReportImagesPath(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
            list.add(caseVO);
        }
        return list;
    }

    public PatientCaseInfoEntity findPatientCaseInfoById(Long id) {
        PatientCaseInfoEntity patientCaseInfoDTO = this.patientCaseInfoMapper.selectById(id);
        patientCaseInfoDTO.setNormalImages(this.newPath(patientCaseInfoDTO.getNormalImages()));
        patientCaseInfoDTO.setCheckReportImages(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
        patientCaseInfoDTO.setRadioGraphFilmImages(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
        return patientCaseInfoDTO;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<String> savePuctPatientCase(CtPatientCaseVO infoVO) {
        MultipartFile[] flies = infoVO.getFlies();
        List ossFileVOS = null;
        if (flies != null && flies.length > 0) {
            ossFileVOS = this.userCenterRemote.saveFiles(flies);
            log.info("\u56fe\u7247\u4e0a\u4f20\u8fd4\u56de\u7ed3\u679c{}", (Object)ossFileVOS);
        }
        PatientCaseInfoEntity entity = new PatientCaseInfoEntity();
        BeanUtils.copyProperties((Object)infoVO, (Object)entity);
        entity.setStatus(Integer.valueOf(1));
        entity.setViewId(UuidUtils.generateUUID());
        if (CollectionUtils.isNotEmpty((Collection)ossFileVOS)) {
            String normalImages = ossFileVOS.stream().map(OssFileVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            entity.setNormalImages(normalImages);
        }
        entity.setPatientId(Long.valueOf(0L));
        entity.setHospitalId(Long.valueOf(-1L));
        Integer caseId = this.patientCaseInfoMapper.save(entity);
        if (caseId == null || caseId <= 0) {
            return BaseResponse.error((String)"\u65b0\u589e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u65b0\u589e\u6210\u529f");
    }

    public BaseResponse<List<PatientCaseInfoBO>> listPatientCase(PatientCaseReqVO reqVO) {
        List patientCaseInfoEntities;
        List normalPatientCaseList;
        BaseResponse response = this.userCenterRemote.getPatientInfoByCredNo(reqVO.getAppCode(), reqVO.getIdCard(), reqVO.getOrganId());
        List patientCaseList = new ArrayList(16);
        if (response.isSuccess()) {
            PatientInfoRespVO patientInfo = (PatientInfoRespVO)JSON.parseObject((String)JSON.toJSONString((Object)response.getData()), PatientInfoRespVO.class);
            String patientViewId = patientInfo.getPatientId();
            List patientCaseInfoEntities2 = this.patientCaseInfoMapper.selectByPatientViewId(patientViewId);
            List normalPatientCaseList2 = this.getNormalPatientCase(patientCaseInfoEntities2);
            patientCaseList = this.getDynamicPatientCaseList(patientViewId, patientInfo.getName(), reqVO.getAppCode());
            if (CollectionUtils.isNotEmpty((Collection)normalPatientCaseList2)) {
                patientCaseList.addAll(normalPatientCaseList2);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVO.getPatientName()) && CollectionUtils.isNotEmpty((Collection)(normalPatientCaseList = this.getNormalPatientCase(patientCaseInfoEntities = this.patientCaseInfoMapper.selectByPatientName(reqVO.getPatientName(), reqVO.getIdCard()))))) {
            patientCaseList.addAll(normalPatientCaseList);
        }
        return BaseResponse.success(patientCaseList);
    }

    private List<PatientCaseInfoBO> getNormalPatientCase(List<PatientCaseInfoEntity> patientCaseInfoEntities) {
        ArrayList<PatientCaseInfoBO> caseInfoBOS = new ArrayList<PatientCaseInfoBO>();
        if (CollectionUtils.isEmpty(patientCaseInfoEntities)) {
            return new ArrayList<PatientCaseInfoBO>();
        }
        for (PatientCaseInfoEntity entity : patientCaseInfoEntities) {
            String normalImages = entity.getNormalImages();
            if (StringUtil.isEmpty((String)normalImages)) continue;
            ArrayList<String> normalImageUrls = new ArrayList<String>();
            List<String> normalImageList = Arrays.asList(normalImages.split(","));
            for (String normalImage : normalImageList) {
                BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(normalImage)));
                if (!ossFileVOBaseResponse.isSuccess() || ossFileVOBaseResponse.getData() == null) {
                    log.info("\u83b7\u53d6oss\u6587\u4ef6\u5f02\u5e38{}", (Object)ossFileVOBaseResponse);
                    continue;
                }
                OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                normalImageUrls.add(ossFileEntity.getUrl());
            }
            entity.setNormalImages(normalImageUrls.stream().collect(Collectors.joining(",")));
            PatientCaseInfoBO infoBO = new PatientCaseInfoBO();
            BeanUtils.copyProperties((Object)entity, (Object)infoBO);
            infoBO.setSymptomsSize(String.valueOf(entity.getSymptomsSize()));
            caseInfoBOS.add(infoBO);
        }
        return caseInfoBOS;
    }

    private List<PatientCaseInfoBO> getDynamicPatientCaseList(String patientViewId, String patientName, String appCode) {
        ArrayList<PatientCaseInfoBO> dynamicCaseInfoList = new ArrayList<PatientCaseInfoBO>();
        List list = this.patientCaseInfoMapper.selectDynamicMedical(patientViewId, appCode);
        log.info("\u67e5\u8be2\u52a8\u6001\u75c5\u5386\u53c2\u6570:{},\u8fd4\u56de\u503c:{}", (Object)patientViewId, (Object)list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return dynamicCaseInfoList;
        }
        list.forEach(medicalResVo -> {
            String medicalUserFills = medicalResVo.getMedicalUserFills();
            PatientCaseInfoBO entity = (PatientCaseInfoBO)JSON.parseObject((String)medicalUserFills, PatientCaseInfoBO.class);
            String normalImages = entity.getNormalImages();
            if (StringUtils.isNotEmpty((String)normalImages)) {
                ArrayList imageUrls = new ArrayList();
                List images = JSONArray.parseArray((String)normalImages, NormalImage.class);
                images.forEach(image -> imageUrls.add(image.getUrl()));
                entity.setNormalImages(imageUrls.stream().collect(Collectors.joining(",")));
            }
            entity.setPatientId(Long.valueOf(Long.parseLong(patientViewId)));
            entity.setPatientName(patientName);
            entity.setCreateTime(medicalResVo.getXUpdateTime());
            dynamicCaseInfoList.add(entity);
        });
        return dynamicCaseInfoList;
    }

    public String newPath(String path) {
        StringBuffer filePath = new StringBuffer();
        if (path == null || path.trim().equals("")) {
            return null;
        }
        BaseResponse baseResponse = this.ossApiClient.getListByOssFileIds(path);
        if (baseResponse.getCode().equals("1") && ((List)baseResponse.getData()).size() > 0) {
            for (OssFileVO ossFileEntity : (List)baseResponse.getData()) {
                filePath.append(ossFileEntity.getUrl() + ",");
            }
            return filePath.substring(0, filePath.length() - 1);
        }
        return null;
    }

    public List<PatientCaseInfoEntity> getNewPatientCaseInfoDTO(List<PatientCaseInfoEntity> patientCaseInfoDTOList) {
        ArrayList<PatientCaseInfoEntity> list = new ArrayList<PatientCaseInfoEntity>();
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOList) {
            patientCaseInfoDTO.setNormalImages(this.newPath(patientCaseInfoDTO.getNormalImages()));
            patientCaseInfoDTO.setCheckReportImages(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
            patientCaseInfoDTO.setRadioGraphFilmImages(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
            list.add(patientCaseInfoDTO);
        }
        return list;
    }

    public static void main(String[] args) {
        String test = "{\n    \"consultAim\":\"\u6d4b\u8bd5\",\n    \"mainSuit\":\"\u6d4b\u8bd5\",\n    \"primaryDiagno\":\"\u6d4b\u8bd5\",\n    \"pastHistory\":\"\",\n    \"familyHistory\":\"\",\n    \"medicationHistory\":\"\",\n    \"presentHistory\":\"\",\n    \"normalImages\":[\n        {\n            \"url\":\"http://tupian201805.oss-cn-beijing.aliyuncs.com/2021/7/17/1629184334222_396622d576ff4dc698a4f43b85d6bde2.jpeg\",\n            \"uid\":1629184333826\n        }\n    ],\n    \"dcmFileUrl\":[\n\n    ],\n    \"dcmPackUrl\":\"\",\n    \"allergy\":\"\",\n    \"diagnosisLocation\":\"\",\n    \"symptomsSize\":\"\",\n    \"changesColor\":\"\",\n    \"palpability\":\"\",\n    \"probability\":\"\",\n    \"patientsAddress\":\"\",\n    \"vitiligoPatches\":\"\"\n}";
        JSONObject jsonObject = JSON.parseObject((String)test);
        String patientsAddress = jsonObject.get((Object)"patientsAddress").toString();
        System.out.println(patientsAddress);
    }
}

