/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.allocation;

import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.feign.IDoctorApiClient;
import com.byh.feign.IOrganizationApiClient;
import com.byh.pojo.vo.consultation.DoctorBillHxgyVo;
import com.byh.util.HttpUtils;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillAllocationHelper {
    private static final Logger log = LoggerFactory.getLogger(BillAllocationHelper.class);
    public static final String M_STR = "\u7cfb\u7edf\u81ea\u52a8\u5212\u62e8";
    @Autowired
    private IDoctorApiClient iDoctorApiClient;
    @Autowired
    private IOrganizationApiClient organizationApiClient;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;

    public DoctorEntityInfoVO getDoctorEntityInfoVO(Long doctorId) {
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(doctorId.intValue()));
        BaseResponse doctorEntityInfoVOBaseResponse = this.iDoctorApiClient.endQueryDoctorDetailInfo(baseDTO);
        DoctorEntityInfoVO doctorEntityInfoVO = (DoctorEntityInfoVO)doctorEntityInfoVOBaseResponse.getData();
        return doctorEntityInfoVO;
    }

    public String getProfessionCode(Long doctorId) {
        DoctorEntityInfoVO doctorEntityInfoVO = this.getDoctorEntityInfoVO(doctorId);
        return doctorEntityInfoVO.getProfessionCode();
    }

    public String getAppCodeByHospitalId(Long hospitalId) {
        log.info("============================\u901a\u8fc7hospitalId\u83b7\u53d6appCode\u5f00\u59cb============================");
        log.info("hospitalId = " + hospitalId);
        if (hospitalId == null) {
            return null;
        }
        BaseDTO baseDTO = new BaseDTO();
        baseDTO.setId(Integer.valueOf(hospitalId.intValue()));
        BaseResponse stringBaseResponse = this.organizationApiClient.queryAppCodeByHospitalId(baseDTO);
        String appCode = (String)stringBaseResponse.getData();
        log.info("============================\u901a\u8fc7hospitalId\u83b7\u53d6appCode\u7ed3\u675f============================");
        return appCode;
    }

    public Map<String, Object> callAddBill(DoctorBillHxgyVo doctorBillHxgyVo) {
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        log.info("===================\u8c03\u7528\u8d26\u5355\u670d\u52a1\u5f00\u59cb===================");
        String URL2 = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/bill/addBillDetail").toString();
        log.info("\u8c03\u7528\u7684url\uff1a" + URL2);
        log.info("\u4f20\u9012\u7684\u53c2\u6570\uff1a" + doctorBillHxgyVo.toString());
        String applyDoctorBillHxgyVoJsonString = JSONObject.toJSONString((Object)doctorBillHxgyVo);
        try {
            String baseResponseStr = HttpUtils.post((String)URL2, (String)applyDoctorBillHxgyVoJsonString);
            BaseResponse baseResponse = (BaseResponse)JSONObject.parseObject((String)baseResponseStr, BaseResponse.class);
            log.info("\u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + baseResponseStr);
            log.info("===================\u8c03\u7528\u8d26\u5355\u670d\u52a1\u7ed3\u675f===================");
            if (!"1".equals(baseResponse.getCode())) {
                errorMap.put("error", "\u8d26\u5355\u8c03\u7528\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("\u8d26\u5355\u8c03\u7528\u629b\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            errorMap.put("error", "\u8d26\u5355\u8c03\u7528\u629b\u51fa\u5f02\u5e38");
        }
        return errorMap;
    }
}

