/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.allocation;

import com.byh.dao.allocation.BillInfoMapper;
import com.byh.enums.AllocationStatusEnum;
import com.byh.feign.IDoctorApiClient;
import com.byh.pojo.entity.allocation.BillInfo;
import com.byh.pojo.vo.consultation.DoctorBillHxgyVo;
import com.byh.task.allocation.BillAllocationHelper;
import com.doctoruser.api.pojo.dto.doctor.UpdateBalanceDTO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="billAllocationWeeklyTask")
@Component
public class BillAllocationWeeklyTask
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(BillAllocationWeeklyTask.class);
    @Autowired
    private BillInfoMapper billInfoMapper;
    @Autowired
    private BillAllocationHelper billAllocationHelper;
    @Autowired
    private IDoctorApiClient iDoctorApiClient;

    public ReturnT<String> execute(String s) throws Exception {
        List billInfoList = null;
        do {
            if ((billInfoList = this.billInfoMapper.findWeeklyUnallocatedBillList()) == null || billInfoList.size() <= 0) continue;
            for (BillInfo billInfo : billInfoList) {
                log.info("===========\u5f00\u59cb\u5904\u7406\u5212\u62e8===========");
                log.info("\u5212\u62e8\u8d26\u5355\u4fe1\u606f\uff1a" + billInfo.toString());
                DoctorBillHxgyVo applyDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String applyAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getApplyHospitalId());
                if (applyAppCode == null || "".equals(applyAppCode)) {
                    log.error("\u83b7\u53d6applyAppCode\u4e3a\u7a7a\uff0c\u5212\u62e8\u5931\u8d25\uff01");
                    continue;
                }
                applyDoctorBillHxgyVo.setObjectId(billInfo.getApplyDoctorId().toString());
                applyDoctorBillHxgyVo.setOrganCode(billInfo.getApplyHospitalId().toString());
                applyDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                applyDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                applyDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                applyDoctorBillHxgyVo.setBillMoney(billInfo.getApplyDoctorIncome());
                applyDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                applyDoctorBillHxgyVo.setCreator("\u7cfb\u7edf\u81ea\u52a8\u5212\u62e8");
                applyDoctorBillHxgyVo.setTransactionId(billInfo.getApplyDoctorId() + billInfo.getViewId());
                applyDoctorBillHxgyVo.setDeptName(billInfo.getApplySecondDeptName());
                applyDoctorBillHxgyVo.setDoctorName(billInfo.getApplyDoctorName());
                applyDoctorBillHxgyVo.setHospitalName(billInfo.getApplyHospitalName());
                applyDoctorBillHxgyVo.setAppCode(applyAppCode);
                DoctorBillHxgyVo receiveDoctorBillHxgyVo = new DoctorBillHxgyVo();
                String receiveAppCode = this.billAllocationHelper.getAppCodeByHospitalId(billInfo.getReceiveHospitalId());
                if (receiveAppCode == null || "".equals(receiveAppCode)) {
                    log.error("\u83b7\u53d6receiveAppCode\u4e3a\u7a7a\uff0c\u5212\u62e8\u5931\u8d25\uff01");
                    continue;
                }
                receiveDoctorBillHxgyVo.setObjectId(billInfo.getReceiveDoctorId().toString());
                receiveDoctorBillHxgyVo.setOrganCode(billInfo.getReceiveHospitalId().toString());
                receiveDoctorBillHxgyVo.setServCode(billInfo.getBusinessCode().toString());
                receiveDoctorBillHxgyVo.setOrderId(billInfo.getOrderId().toString());
                receiveDoctorBillHxgyVo.setOrderMoney(billInfo.getPayAmount());
                receiveDoctorBillHxgyVo.setBillMoney(billInfo.getReceiveDoctorIncome());
                receiveDoctorBillHxgyVo.setBillType(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setBillStatus(Integer.valueOf(1));
                receiveDoctorBillHxgyVo.setCreator("\u7cfb\u7edf\u81ea\u52a8\u5212\u62e8");
                receiveDoctorBillHxgyVo.setTransactionId(billInfo.getReceiveDoctorId() + billInfo.getViewId());
                receiveDoctorBillHxgyVo.setDeptName(billInfo.getReceiveSecondDeptName());
                receiveDoctorBillHxgyVo.setDoctorName(billInfo.getReceiveDoctorName());
                receiveDoctorBillHxgyVo.setHospitalName(billInfo.getReceiveHospitalName());
                receiveDoctorBillHxgyVo.setAppCode(receiveAppCode);
                Map applyErrorMap = this.billAllocationHelper.callAddBill(applyDoctorBillHxgyVo);
                if (applyErrorMap.size() > 0) continue;
                DoctorEntityInfoVO applyDoctorEntityInfoVO = this.billAllocationHelper.getDoctorEntityInfoVO(billInfo.getApplyDoctorId());
                BigDecimal applyBalance = applyDoctorEntityInfoVO.getBalance() == null ? BigDecimal.ZERO : applyDoctorEntityInfoVO.getBalance();
                UpdateBalanceDTO applyUpdateBalanceDTO = new UpdateBalanceDTO();
                applyUpdateBalanceDTO.setBalance(applyBalance.add(billInfo.getApplyDoctorIncome()));
                applyUpdateBalanceDTO.setDoctorId(Integer.valueOf(billInfo.getApplyDoctorId().intValue()));
                this.iDoctorApiClient.updateDoctorBalance(applyUpdateBalanceDTO);
                Map receiveErrorMap = this.billAllocationHelper.callAddBill(receiveDoctorBillHxgyVo);
                if (receiveErrorMap.size() > 0) continue;
                DoctorEntityInfoVO receiveDoctorEntityInfoVO = this.billAllocationHelper.getDoctorEntityInfoVO(billInfo.getReceiveDoctorId());
                BigDecimal receiveBalance = receiveDoctorEntityInfoVO.getBalance() == null ? BigDecimal.ZERO : receiveDoctorEntityInfoVO.getBalance();
                UpdateBalanceDTO receiveUpdateBalanceDTO = new UpdateBalanceDTO();
                receiveUpdateBalanceDTO.setBalance(receiveBalance.add(billInfo.getReceiveDoctorIncome()));
                receiveUpdateBalanceDTO.setDoctorId(Integer.valueOf(billInfo.getReceiveDoctorId().intValue()));
                this.iDoctorApiClient.updateDoctorBalance(receiveUpdateBalanceDTO);
                billInfo.setAssignStatus(AllocationStatusEnum.HAVE_ALLOCATED.getValue());
                billInfo.setSettlingTime(new Date());
                this.billInfoMapper.updateByPrimaryKey(billInfo);
            }
        } while (billInfoList != null && billInfoList.size() > 0);
        return ReturnT.SUCCESS;
    }
}

