/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.consultation;

import com.byh.enums.BaseStatusEnum;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.ConsultationReportManager;
import com.byh.pojo.entity.allocation.BillInfo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.service.allocation.BillInfoService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="checkOrderQualified")
@Component
public class CheckOrderTask
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(CheckOrderTask.class);
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationReportManager consultationReportManager;
    @Autowired
    private BillInfoService billInfoService;

    public ReturnT<String> execute(String s) throws Exception {
        List consultationEntityList = this.consultationService.checkOrderIsQualified();
        if (CollectionUtils.isNotEmpty((Collection)consultationEntityList)) {
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                try {
                    if (!this.consultationManager.detailElementCheck(consultationEntity, extendEntity).booleanValue()) continue;
                    if (!this.billInfoService.initBillInfoAndProcessImmediateSettlement(extendEntity.getConsultationId())) {
                        BillInfo mBillInfo = this.billInfoService.getByOrderId(extendEntity.getConsultationId());
                        if (mBillInfo != null) {
                            mBillInfo.setStatus(Integer.valueOf(-1));
                            this.billInfoService.update(mBillInfo);
                            if (!this.billInfoService.initBillInfoAndProcessImmediateSettlement(extendEntity.getConsultationId())) {
                                log.info("=====\u4f1a\u8bca\u8ba2\u5355{}=====\u521d\u59cb\u5316\u8d26\u5355\u5931\u8d25", (Object)extendEntity.getConsultationId());
                                return ReturnT.FAIL;
                            }
                        } else {
                            log.info("=====\u4f1a\u8bca\u8ba2\u5355{}=====\u521d\u59cb\u5316\u8d26\u5355\u5931\u8d25", (Object)extendEntity.getConsultationId());
                            return ReturnT.FAIL;
                        }
                    }
                    log.info("=====\u4f1a\u8bca\u8ba2\u5355{}=====\u521d\u59cb\u5316\u8d26\u5355\u6210\u529f", (Object)extendEntity.getConsultationId());
                    extendEntity.setQualified(BaseStatusEnum.STATUS_VALID.getValue());
                    this.consultationExtendService.update(extendEntity);
                }
                catch (Exception e) {
                    log.error("\u5b9a\u65f6\u68c0\u67e5\u8ba2\u5355\u662f\u5426\u5408\u683c\uff0c\u51fa\u9519\u7684\u8ba2\u5355\u7f16\u53f7\u662f:{}", (Object)consultationEntity.getId(), (Object)e);
                }
            }
        }
        return ReturnT.SUCCESS;
    }
}

