/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.consultation;

import com.byh.constants.ConsultationConstant;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationStatusLogEntity;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationStatusLogService;
import com.byh.util.DateTimeUtil;
import com.byh.util.UuidUtils;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="updateTuwenOrderStatus")
@Component
public class OrderTask
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(OrderTask.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationStatusLogService consultationStatusLogService;
    @Autowired
    private ConsultationExtendService consultationExtendService;

    public int saveConsultationStatusLog(ConsultationEntity consultationEntity, int toStatus) {
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        ConsultationStatusLogEntity consultationStatusLogEntity = new ConsultationStatusLogEntity();
        consultationStatusLogEntity.setViewId(UuidUtils.generateUUID());
        consultationStatusLogEntity.setConsultationId(consultationEntity.getId().longValue());
        consultationStatusLogEntity.setExpertId(consultationEntity.getExpertId().longValue());
        consultationStatusLogEntity.setFromStatus(consultationEntity.getStatus().intValue());
        consultationStatusLogEntity.setPayType(consultationExtendEntity.getPayType().intValue());
        consultationStatusLogEntity.setPrice(consultationExtendEntity.getPrice());
        consultationStatusLogEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
        consultationStatusLogEntity.setToStatus(toStatus);
        return this.consultationStatusLogService.saveConsultationStatusLogEntity(consultationStatusLogEntity);
    }

    @Deprecated
    public ConsultationEntity closeConsultationEntity(ConsultationEntity consultationEntity) {
        String closeTime = LocalDateTime.now().plusHours(-24L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        consultationEntity.setClosedTime(closeTime);
        return consultationEntity;
    }

    public ReturnT<String> execute(String s) throws Exception {
        log.info("======\u56fe\u6587\u4f1a\u8bca\u8ba2\u5355\u5b9a\u65f6\u5904\u7406\u5f00\u59cb=======");
        String startTime = LocalDateTime.now().plusHours(-24L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        List list = this.consultationService.listGetByTypeAndStatusAndBeginTime(ConsultationConstant.TYPE_ORDER_TUWEN, OrderStatusEnum.RUNNING.getValue(), startTime);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ConsultationEntity consultationEntity : list) {
                int value = this.saveConsultationStatusLog(consultationEntity, OrderStatusEnum.FINISH.getValue().intValue());
                if (value == 0) {
                    throw new RuntimeException("\u63d2\u5165\u8ba2\u5355\u72b6\u6001\u4fee\u6539\u65e5\u5fd7\u8868\u5931\u8d25");
                }
                consultationEntity.setStatus(OrderStatusEnum.FINISH.getValue());
                consultationEntity.setFinishTime(DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.consultationService.updateConsultationEntity(consultationEntity);
            }
        }
        return ReturnT.SUCCESS;
    }
}

