/*
 * Decompiled with CFR 0.152.
 */
package com.byh.task.consultation;

import com.byh.dao.consultation.ConsultationMdtMapper;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.service.cosultation.ConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.MdtUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@JobHandler(value="pushInfoBeforeAcceptOrder")
@Component
public class PushTask
extends IJobHandler {
    private static final Logger log = LoggerFactory.getLogger(PushTask.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ConsultationMdtMapper consultationMdtMapper;

    public ReturnT<String> execute(String s) throws Exception {
        String thisDate = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd");
        Date preDate = DateTimeUtil.addHour((Date)new Date(), (int)1);
        String startTime = DateTimeUtil.formatTime((Date)preDate, (String)"HH:mm:ss");
        String endTime = DateTimeUtil.formatTime((Date)DateTimeUtil.addMinute((Date)preDate, (int)5), (String)"HH:mm:ss");
        log.info("\u4f1a\u8bca\u524d\u4e00\u5c0f\u65f6\u63a8\u9001\u67e5\u8be2\u53c2\u6570:thisDate={},startTime={},endTime={}", new Object[]{thisDate, startTime, endTime});
        List list = this.consultationService.seletConsultationByDateAndTimeAndStatus(thisDate, startTime, endTime);
        log.info("\u4f1a\u8bca\u524d\u4e00\u5c0f\u65f6\u63a8\u9001\u67e5\u8be2\u6570\u636e\uff1a{}", (Object)list);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (ConsultationEntity entity : list) {
                Integer isMDT = MdtUtil.decideMdtDataType((Integer)entity.getApplicationChannels());
                List mdtList = this.consultationMdtMapper.selectByViewIdList(entity.getViewId());
                String expertName = "";
                if (isMDT == 1 && CollectionUtils.isNotEmpty((Collection)mdtList)) {
                    expertName = mdtList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.joining("\u3001"));
                } else if (isMDT == 0) {
                    expertName = entity.getExpertName();
                }
                this.shortMessageManager.consultationStartToDoctor(entity, expertName);
                this.shortMessageManager.consultationStartToExpert(entity, mdtList);
            }
        }
        log.info("======\u4f1a\u8bca\u524d\u4e00\u5c0f\u65f6\u63a8\u9001\u7ed3\u675f=====");
        return ReturnT.SUCCESS;
    }
}

