/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);

    public static LocalDate convertDateToLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date convertLocalDateToDate(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDate.atStartOfDay(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static LocalDate convertStringToLocalDate(String str) {
        LocalDate localDate = LocalDate.parse(str, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        return localDate;
    }

    public static Date convertStringToDate(String string) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = sdf.parse(string);
        }
        catch (ParseException var4) {
            LOGGER.error("ParseException", (Throwable)var4);
        }
        return date;
    }

    public static String convertDateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(date);
        return str;
    }

    public static Date convertStringToDate(String format, String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException var5) {
            LOGGER.error("ParseException", (Throwable)var5);
        }
        return date;
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String str = sdf.format(date);
        return str;
    }

    public static Date localDateToUTC(Date localDate) {
        long localTimeInMillis = localDate.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        Date utcDate = new Date(calendar.getTimeInMillis());
        return utcDate;
    }

    public static String getValidDateStr(Date data) {
        String sDate = "";
        SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.UK);
        try {
            Date date = sdf1.parse(sdf1.format(data));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sDate = sdf.format(date);
        }
        catch (ParseException e) {
            LOGGER.error("ParseException", (Throwable)e);
        }
        return sDate;
    }

    public static String dateBeforeDay(Date date, int day) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (day > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, -day);
            date = calendar.getTime();
        }
        return sdf.format(date);
    }

    public static void main(String[] args) {
        String validDateStr = DateUtils.getValidDateStr((Date)new Date());
        System.out.println(validDateStr);
    }
}

