/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(JSONUtil.class);
    public static final JSONObject EMPTY_JSONOBJECT = new JSONObject();
    public static final JSONArray EMPTY_JSONARRAY = new JSONArray();

    public static <T> List<T> parseList(String content, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return Collections.emptyList();
        }
        List results = null;
        try {
            results = JSON.parseArray((String)content, clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return results == null ? Collections.EMPTY_LIST : results;
    }

    public static <T> T parse(String content, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        Object result = null;
        try {
            result = JSON.parseObject((String)content, clazz);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return (T)result;
    }

    public static JSONObject parseObject(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return EMPTY_JSONOBJECT;
        }
        JSONObject result = null;
        try {
            result = JSON.parseObject((String)content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == null ? EMPTY_JSONOBJECT : result;
    }

    public static JSONArray parseArray(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return EMPTY_JSONARRAY;
        }
        JSONArray result = null;
        try {
            result = JSON.parseArray((String)content);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == null ? EMPTY_JSONARRAY : result;
    }

    public static String toJSONString(Object object) {
        if (object == null) {
            return EMPTY_JSONOBJECT.toJSONString();
        }
        String result = null;
        try {
            result = JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == null ? EMPTY_JSONOBJECT.toJSONString() : result;
    }

    public static JSONObject toJSON(Object object) {
        if (object == null) {
            return null;
        }
        JSONObject result = null;
        try {
            result = (JSONObject)JSON.toJSON((Object)object);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result = null;
        }
        return result;
    }

    public static JSONObject createNew() {
        return new JSONObject();
    }

    public static void main(String[] args) {
    }
}

