/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.enums.DeviceTypeEnum;
import com.byh.enums.UserCenterTypeEnum;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.pojo.bo.GoEasyPushDataBo;
import com.byh.pojo.bo.YouMengPushDataBo;
import com.byh.pojo.vo.consultation.req.BaseAliSmsReqVO;
import com.byh.pojo.vo.consultation.req.UcConfigurationReqVO;
import com.byh.pojo.vo.consultation.req.UserDeviceReqVO;
import com.byh.pojo.vo.consultation.res.UserDeviceResVO;
import com.byh.pojo.vo.consultation.res.YmClientCode;
import com.byh.pojo.vo.consultation.res.YoumengClientCodeVO;
import com.byh.pojo.vo.consultation.res.YoumengConfigurationResVO;
import com.byh.util.HttpUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class PushInfoManagerUtils {
    private static final Logger log = LoggerFactory.getLogger(PushInfoManagerUtils.class);
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ProgramMessageManager programMessageManager;

    public void youmengPushDataByUserId(String appCode, YouMengPushDataBo youMengPushDataBo) {
        try {
            String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("cloud/doctoruser/cloudaccount/getLastLoginDevice").toString();
            UserDeviceReqVO userDeviceReqVO = new UserDeviceReqVO();
            userDeviceReqVO.setUserId(youMengPushDataBo.getUserId());
            userDeviceReqVO.setUserType(UserCenterTypeEnum.DOCTOR.getValue());
            userDeviceReqVO.setAccoutId("");
            String userDeviceResStr = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)userDeviceReqVO));
            log.info("\u83b7\u53d6\u7528\u6237\u767b\u5f55\u8bbe\u5907\u53ca\u8bbe\u5907\u53f7\u8bf7\u6c42\u5730\u5740\u662f:{}========\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)url, (Object)userDeviceResStr);
            UserDeviceResVO userDeviceResVO = (UserDeviceResVO)JSONObject.parseObject((String)JSON.parseObject((String)userDeviceResStr).getString("data"), UserDeviceResVO.class);
            if (userDeviceResVO != null && StringUtil.isNotBlank((String)userDeviceResVO.getDeviceNumber()) && StringUtil.isNotBlank((String)userDeviceResVO.getDeviceType())) {
                String pushInfoUrl = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append(DeviceTypeEnum.IOS.getValue().equalsIgnoreCase(userDeviceResVO.getDeviceType()) ? "cloud/push/umapi/pushiosunicast" : "cloud/push/umapi/pushandroidunicast").toString();
                youMengPushDataBo.setDeviceTokens(userDeviceResVO.getDeviceNumber());
                if (DeviceTypeEnum.IOS.getValue().equalsIgnoreCase(userDeviceResVO.getDeviceType())) {
                    youMengPushDataBo.setBody(youMengPushDataBo.getBusiStyle());
                    youMengPushDataBo.setSubTitle(youMengPushDataBo.getTitle());
                    youMengPushDataBo.setUserType("1");
                }
                String clientCode = "";
                List codeList = this.getClientCode(appCode);
                for (YmClientCode code : codeList) {
                    if (!"doctor".equals(code.getUserType()) || !userDeviceResVO.getDeviceType().toLowerCase().equals(code.getDeviceType().toLowerCase())) continue;
                    clientCode = code.getClientCode();
                }
                youMengPushDataBo.setClientCode(clientCode);
                log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001\u53cb\u76df\u8bf7\u6c42\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)pushInfoUrl, (Object)JSON.toJSONString((Object)youMengPushDataBo));
                String pushResStr = HttpUtils.post((String)pushInfoUrl, (String)JSON.toJSONString((Object)youMengPushDataBo));
                log.info("\u8c03\u7528\u63a8\u9001\u63a8\u9001\u53cb\u76df\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)pushResStr);
            } else {
                log.error("\u63a8\u9001\u672a\u77e5\u8bbe\u5907\u7c7b\u578b!!");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void goEasyPushData(String appCode, GoEasyPushDataBo goEasyPushDataBo) {
        StringBuffer url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress());
        try {
            url = url.append("cloud/push/goeasy/pushgoeasyuserid");
            log.info("\u8c03\u7528\u63a8\u9001\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url.toString(), (Object)JSON.toJSONString((Object)goEasyPushDataBo));
            String pushResStr = HttpUtils.post((String)url.toString(), (String)JSON.toJSONString((Object)goEasyPushDataBo));
            log.info("\u8c03\u7528\u63a8\u9001\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)pushResStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void aliSmsPush(String appCode, BaseAliSmsReqVO baseAliSmsReqVO, String signCode) {
        if (Objects.equals("SDFYY", appCode)) {
            return;
        }
        StringBuffer url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress());
        try {
            url = url.append("cloud/push/alismsapi/sendAuthCodeWithPhone");
            baseAliSmsReqVO.setAppCode(appCode);
            baseAliSmsReqVO.setSignCode(signCode);
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001\u77ed\u4fe1\u7684url\u662f:{}=====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)baseAliSmsReqVO));
            String pushResStr = HttpUtils.post((String)url.toString(), (String)JSON.toJSONString((Object)baseAliSmsReqVO));
            log.info("\u8c03\u7528\u63a8\u9001\u53d1\u9001\u77ed\u4fe1\u540e\u8fd4\u56de\u7684\u4fe1\u606f\u662f:{}", (Object)pushResStr);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getDeviceTypeClientCode(String appCode, String userType, String deviceType) {
        String clientCode;
        block3: {
            StringBuffer url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress());
            clientCode = "";
            try {
                YoumengConfigurationResVO youmengConfigurationResVO;
                String clientCodeStr;
                List youmengClientCodeVOList;
                url = url.append("cloud/doctoruser/configuration/getdetail");
                UcConfigurationReqVO ucConfigurationReqVO = new UcConfigurationReqVO();
                ucConfigurationReqVO.setAppCode(appCode);
                ucConfigurationReqVO.setType("youmengPush");
                log.info("\u83b7\u53d6clientCode\u7684\u8bf7\u6c42url\u662f:{}====\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)ucConfigurationReqVO));
                String resData = HttpUtils.post((String)url.toString(), (String)JSON.toJSONString((Object)ucConfigurationReqVO));
                log.info("\u8c03\u7528\u4e91\u7aef\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u7684clientCode\u662f:{}", (Object)resData);
                if (!StringUtil.isNotBlank((String)JSONObject.parseObject((String)resData).getString("data")) || !CollectionUtils.isNotEmpty((Collection)(youmengClientCodeVOList = JSONArray.parseArray((String)(clientCodeStr = (youmengConfigurationResVO = (YoumengConfigurationResVO)JSONObject.parseObject((String)JSONObject.parseObject((String)resData).getString("data"), YoumengConfigurationResVO.class)).getClientCode()), YoumengClientCodeVO.class)))) break block3;
                for (YoumengClientCodeVO youmengClientCodeVO : youmengClientCodeVOList) {
                    if (!userType.equalsIgnoreCase(youmengClientCodeVO.getUserType()) || !deviceType.equalsIgnoreCase(youmengClientCodeVO.getDeviceType())) continue;
                    clientCode = youmengClientCodeVO.getClientCode();
                    break;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return clientCode;
    }

    public List<YmClientCode> getClientCode(String appCode) {
        List codeList = null;
        UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(appCode, "youmengPush");
        String code = configurationVO.getClientCode();
        codeList = JSONArray.parseArray((String)code, YmClientCode.class);
        return codeList;
    }
}

