/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import com.byh.exception.LoginException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static String createJWT(String userViewId, Long hospitalId, String account_type, String uuid, String secret, long TTLMillis) {
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        JwtBuilder builder = Jwts.builder().setHeaderParam("jwt", (Object)"HS512").claim("unique_name", (Object)userViewId).claim("hospital_id", (Object)hospitalId).claim("uuid", (Object)uuid).claim("account_type", (Object)account_type).signWith(SignatureAlgorithm.HS512, secret);
        if (TTLMillis >= 0L) {
            long expMillis = nowMillis + TTLMillis;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp).setNotBefore(now);
        }
        return "Bearer " + builder.compact();
    }

    public static Claims parseJWT(String jsonWebToken, String secret) throws LoginException {
        Claims claims = null;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(jsonWebToken.replace("Bearer ", "")).getBody();
        }
        catch (Exception e) {
            log.error("\u65e0\u6548\u7684token: " + e.getMessage());
            throw new LoginException("\u65e0\u6548\u7684\u7b7e\u540d");
        }
        return claims;
    }
}

