/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.byh.config.RemoteCallAddressConfig;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
public class WordUtils {
    private static final Logger log = LoggerFactory.getLogger(WordUtils.class);
    @Autowired
    private static RemoteCallAddressConfig remoteCallAddressConfig;
    private static final String ENCODING = "UTF-8";
    private static Configuration cfg;

    public static Template getTemplate(String templateFileName) throws IOException {
        return cfg.getTemplate(templateFileName, "UTF-8");
    }

    private WordUtils() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportMillCertificateWord(HttpServletResponse response, Map<String, String> dataMap, String temlateFileName, String exportFileName) throws IOException {
        Template freemarkerTemplate = WordUtils.getTemplate((String)temlateFileName);
        File file = null;
        InputStream fin = null;
        ServletOutputStream out = null;
        try {
            file = WordUtils.createDoc(dataMap, (Template)freemarkerTemplate);
            fin = new FileInputStream(file);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/msword");
            String fileName = exportFileName + ".doc";
            response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(fileName, "UTF-8"))));
            out = response.getOutputStream();
            byte[] buffer = new byte[512];
            int bytesToRead = -1;
            while ((bytesToRead = fin.read(buffer)) != -1) {
                out.write(buffer, 0, bytesToRead);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (out != null) {
                out.close();
            }
            if (file != null && !file.delete()) {
                log.error("file delete fail");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportMillCertificateReportWord(Map<String, String> dataMap, String temlateFileName, String exportFileName) throws IOException {
        Template freemarkerTemplate = WordUtils.getTemplate((String)temlateFileName);
        File file = null;
        String ossUrl = "";
        try {
            file = WordUtils.createDoc(dataMap, (Template)freemarkerTemplate);
            HashMap<String, File> paramMap = new HashMap<String, File>();
            paramMap.put("file", file);
            String baseResposne = HttpUtil.post((String)"https://testapi.chinachdu.com/cloud/doctoruser/oss/api/file/store/v1/uploadLargerFile", paramMap);
            log.info("baseResposne = " + baseResposne);
            JSONObject jsonObject = JSONObject.parseObject((String)baseResposne);
            Object ossFileVO = jsonObject.get((Object)"data");
            JSONObject json = JSONObject.parseObject((String)ossFileVO.toString());
            ossUrl = json.get((Object)"url").toString();
            log.info("ossUrl = " + ossUrl);
        }
        finally {
            if (file != null && !file.delete()) {
                log.error("file delete fail");
            }
        }
        return ossUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportWordToPath(Map<String, String> dataMap, String temlateFileName, String targetPath, String fileName) throws IOException {
        File file = new File(targetPath + "/" + fileName + ".doc");
        Template freemarkerTemplate = WordUtils.getTemplate((String)temlateFileName);
        try (Writer out = null;){
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            freemarkerTemplate.process(dataMap, out);
        }
    }

    private static File createDoc(Map<?, ?> dataMap, Template template) {
        String name = "test.doc";
        File f = new File(name);
        Template t = template;
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            t.process(dataMap, (Writer)w);
            ((Writer)w).close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImgUrlToBase64(String imgUrl) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] buffer = null;
        try {
            URL url = new URL(imgUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(HttpMethod.GET.name());
            conn.setConnectTimeout(5000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            inputStream = conn.getInputStream();
            outputStream = new ByteArrayOutputStream();
            buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            buffer = outputStream.toByteArray();
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("IOException", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error("IOException", (Throwable)e);
                }
            }
        }
        return new BASE64Encoder().encode(buffer);
    }

    static {
        cfg = new Configuration(Configuration.getVersion());
        cfg.setClassForTemplateLoading(WordUtils.class, "/template/ftl");
        cfg.setEncoding(Locale.getDefault(), "UTF-8");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
    }
}

