/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util.oss;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;

public class BASE64DecodedMultipartFile
implements MultipartFile {
    private final byte[] imgContent;
    private final String header;

    public BASE64DecodedMultipartFile(byte[] imgContent, String header) {
        this.imgContent = imgContent;
        this.header = header.split(";")[0];
    }

    public String getName() {
        return (double)System.currentTimeMillis() + Math.random() + "." + this.header.split("/")[1];
    }

    public String getOriginalFilename() {
        return System.currentTimeMillis() + (long)((int)Math.random() * 10000) + "." + this.header.split("/")[1];
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        try (FileOutputStream outputStream = new FileOutputStream(dest);){
            outputStream.write(this.imgContent);
        }
    }
}

