/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqConfig {
    public static final String EXCHANGE_NAME = "sms.delayed_exchange.dev";
    public static final String SMS_QUEUE_NAME = "sms.queue.dev";
    public static final String SMS_ROUTING_KEY = "sms.routing.key.dev";

    @Bean
    public Queue scheduledTaskScanning() {
        return new Queue(SMS_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding bindingScheduledTaskScanning() {
        return BindingBuilder.bind((Queue)this.scheduledTaskScanning()).to((Exchange)this.customExchange()).with(SMS_ROUTING_KEY).noargs();
    }
}

