/*
 * Decompiled with CFR 0.152.
 */
package com.byh.gateway.entity;

import com.byh.gateway.entity.ResponseData;

public class ResponseData<T> {
    private String code;
    private String msg;

    public ResponseData(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ResponseData(String msg) {
        this.msg = msg;
    }

    public static ResponseData success() {
        return new ResponseData(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getCodeName());
    }

    public static ResponseData error(String code, String msg) {
        return new ResponseData(code, msg);
    }

    public static ResponseData tp() {
        ResponseData response = new ResponseData();
        response.setCode("0");
        return response;
    }

    public ResponseData code(String code) {
        this.setCode(code);
        return this;
    }

    public ResponseData msg(String msg) {
        this.setMsg(msg);
        return this;
    }

    public static ResponseData customResult(String code, String msg) {
        return new ResponseData(code, msg);
    }

    public static ResponseData serviceError() {
        return new ResponseData(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_ERROR.getCodeName());
    }

    public static ResponseData noAuthen() {
        return new ResponseData(ResponseEnum.NO_AUTH.getCode(), ResponseEnum.NO_AUTH.getCodeName());
    }

    public static ResponseData timeOut() {
        return new ResponseData(ResponseEnum.TIME_OUT.getCode(), ResponseEnum.NO_AUTH.getCodeName());
    }

    public static ResponseData serviceRefuse() {
        return new ResponseData(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_REFUSE.getCodeName());
    }

    public ResponseData() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

