/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util.encryption;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.byh.hs.api.util.encryption.CommonUtil;
import com.byh.hs.api.util.encryption.FuncRetCode;
import com.byh.hs.api.util.encryption.SM2Util;
import com.byh.hs.api.util.encryption.SM4Util;
import com.byh.hs.api.util.encryption.ServerException;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class DataHandler {
    private static final Logger log = LoggerFactory.getLogger(DataHandler.class);
    private static volatile DataHandler INSTANCE;
    private final byte[] encryptKeys;
    private final String publicKeys;
    private final String privateKeys;
    private final String appID;
    private final String secret;
    private String version = "2.0.0";
    BASE64Decoder decoder = new BASE64Decoder();
    SM2Util sm2 = new SM2Util();
    private static final Log LOG;

    private DataHandler(String appID, String secret, String publicKey, String privateKey) throws IOException {
        this.appID = appID;
        this.secret = secret;
        this.encryptKeys = SM4Util.encryptEcb(CommonUtil.stringToHexString(appID.substring(0, 16)), secret).substring(0, 16).toUpperCase().getBytes();
        this.publicKeys = CommonUtil.byteArrayToHex(this.decoder.decodeBuffer(publicKey));
        this.privateKeys = CommonUtil.byteArrayToHex(this.decoder.decodeBuffer(privateKey));
    }

    public static DataHandler newInstance(String appID, String secret, String publicKey, String privateKey) throws IOException {
        INSTANCE = new DataHandler(appID, secret, publicKey, privateKey);
        return INSTANCE;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String buildReqData(JSONObject objData) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry entry : objData.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        String reqData = this.buildReqData(map);
        return reqData;
    }

    public String buildReqData(Object objData) throws Exception {
        SortedMap<String, Object> map = CommonUtil.objectToMap(objData);
        LOG.debug((Object)("buildReqData\u53c2\u6570\u8f6c\u6362map\u7ed3\u679c\uff1a" + map));
        String reqData = this.buildReqData(map);
        return reqData;
    }

    public String buildReqData(Map<String, Object> mapData) throws Exception {
        String str = JSON.toJSONString(mapData);
        org.json.JSONObject jsonObject = new org.json.JSONObject(str);
        String jsonStr = CommonUtil.valueToString(jsonObject);
        JSONObject dataMap = JSON.parseObject((String)jsonStr);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("version", this.version);
        treeMap.put("encType", "SM4");
        treeMap.put("signType", "SM2");
        treeMap.put("appId", this.appID);
        treeMap.put("timestamp", new Date().getTime());
        treeMap.put("extra", null);
        treeMap.put("data", JSON.toJSON((Object)dataMap));
        String signStr = CommonUtil.getSignStr(this.secret, treeMap);
        String signData = this.sm2.sign(signStr, this.privateKeys);
        treeMap.put("signData", signData);
        LOG.debug((Object)("\u7b7e\u540d\u7ed3\u679c\uff1a" + signData));
        byte[] encDataBye = SM4Util.encrypt_Ecb_Padding(this.encryptKeys, treeMap.get("data").toString().getBytes());
        String encData = ByteUtils.toHexString((byte[])encDataBye);
        treeMap.put("encData", encData);
        LOG.debug((Object)("\u52a0\u5bc6\u7ed3\u679c\uff1a" + encData));
        treeMap.keySet().removeIf(key -> Objects.equals(key, "data"));
        return JSON.toJSONString(treeMap);
    }

    public String processRspDataNew(String rspData) throws Exception {
        Map treeMap = (Map)JSON.parseObject((String)rspData, TreeMap.class);
        Integer codeObj = new Integer(treeMap.get("code").toString());
        if (codeObj != null && codeObj == 0) {
            String encData = treeMap.get("encData").toString();
            String jsonStr = null;
            try {
                byte[] cipherData = ByteUtils.fromHexString((String)encData);
                byte[] cipherByte = SM4Util.decrypt_Ecb_Padding(this.encryptKeys, cipherData);
                String dEncData = new String(cipherByte, "UTF-8");
                org.json.JSONObject jsonObject = new org.json.JSONObject(dEncData);
                jsonStr = CommonUtil.valueToString(jsonObject);
            }
            catch (Exception var10) {
                throw new ServerException(FuncRetCode.ERROR_CODE_ENCRYPT_ERROR);
            }
            return jsonStr;
        }
        return "";
    }

    public String processRspData(String rspData) throws Exception {
        Map treeMap = (Map)JSON.parseObject((String)rspData, TreeMap.class);
        Integer codeObj = (Integer)treeMap.get("code");
        if (codeObj != null && codeObj == 0) {
            String encData = treeMap.get("encData").toString();
            String jsonStr = null;
            try {
                byte[] cipherData = ByteUtils.fromHexString((String)encData);
                byte[] cipherByte = SM4Util.decrypt_Ecb_Padding(this.encryptKeys, cipherData);
                String dEncData = new String(cipherByte, "UTF-8");
                org.json.JSONObject jsonObject = new org.json.JSONObject(dEncData);
                jsonStr = CommonUtil.valueToString(jsonObject);
            }
            catch (Exception var10) {
                throw new ServerException(FuncRetCode.ERROR_CODE_ENCRYPT_ERROR);
            }
            Map dataMap = (Map)JSON.parseObject((String)jsonStr, TreeMap.class);
            treeMap.put("data", dataMap);
            String signStr = CommonUtil.getSignStr(this.secret, treeMap);
            if (!this.sm2.verify(signStr, treeMap.get("signData").toString(), this.publicKeys)) {
                throw new ServerException(FuncRetCode.ERROR_CODE_SIGN_ERROR);
            }
            treeMap.keySet().removeIf(key -> Objects.equals(key, "encData") || Objects.equals(key, "signData"));
        }
        return JSON.toJSONString((Object)treeMap);
    }

    static {
        LOG = LogFactory.getLog(DataHandler.class);
    }
}

