/*
 * Decompiled with CFR 0.152.
 */
package com.byh.hs.api.util.encryption;

import cn.hutool.core.util.HexUtil;
import com.byh.hs.api.util.encryption.FuncRetCode;
import com.byh.hs.api.util.encryption.SMUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import sun.misc.BASE64Decoder;

public class SM2Util {
    private BouncyCastleProvider provider;
    private X9ECParameters parameters;
    private ECParameterSpec ecParameterSpec;
    private KeyFactory keyFactory;
    BASE64Decoder decoder = new BASE64Decoder();

    public SM2Util() {
        try {
            this.provider = new BouncyCastleProvider();
            this.parameters = GMNamedCurves.getByName((String)"sm2p256v1");
            this.ecParameterSpec = new ECParameterSpec(this.parameters.getCurve(), this.parameters.getG(), this.parameters.getN(), this.parameters.getH());
            this.keyFactory = KeyFactory.getInstance("EC", (Provider)this.provider);
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
    }

    public String sign(String plainText, String prvKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, IOException {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)this.provider);
        BigInteger bigInteger = new BigInteger(prvKey, 16);
        BCECPrivateKey privateKey = (BCECPrivateKey)this.keyFactory.generatePrivate((KeySpec)new ECPrivateKeySpec(bigInteger, this.ecParameterSpec));
        signature.initSign((PrivateKey)privateKey);
        signature.update(plainText.getBytes());
        String signStr = Base64.getEncoder().encodeToString(signature.sign());
        signStr = new BigInteger(this.decoder.decodeBuffer(signStr)).toString(16);
        String derStr = SM2SignAsn1.parseSm2SignAsn1Object(signStr);
        byte[] hexStr = HexUtil.decodeHex((String)derStr);
        String signData = Base64.getEncoder().encodeToString(hexStr);
        return signData;
    }

    public boolean verify(String plainText, String signatureValue, String pubKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(GMObjectIdentifiers.sm2sign_with_sm3.toString(), (Provider)this.provider);
        ECPoint ecPoint = this.parameters.getCurve().decodePoint(Hex.decode((String)pubKey));
        BCECPublicKey key = (BCECPublicKey)this.keyFactory.generatePublic((KeySpec)new ECPublicKeySpec(ecPoint, this.ecParameterSpec));
        signature.initVerify((PublicKey)key);
        signature.update(plainText.getBytes());
        byte[] signDataByte = Base64.getDecoder().decode(signatureValue);
        String sigDataHex = HexUtil.encodeHexStr((byte[])signDataByte);
        List<String> list = SMUtil.getStrList(sigDataHex, 64, 2);
        String sm2SignAsn1 = SM2SignAsn1.buildSm2SignAsn1Object(new BigInteger(list.get(0), 16), new BigInteger(list.get(1), 16));
        byte[] sm2SignAsn1Byte = HexUtil.decodeHex((String)sm2SignAsn1);
        String sm2SignAsn1ByteText = Base64.getEncoder().encodeToString(sm2SignAsn1Byte);
        return signature.verify(Base64.getDecoder().decode(sm2SignAsn1ByteText));
    }

    public static class SM2SignAsn1
    extends ASN1Object {
        private ASN1Integer int1;
        private ASN1Integer int2;

        public ASN1Integer getInt1() {
            return this.int1;
        }

        public void setInt1(ASN1Integer int1) {
            this.int1 = int1;
        }

        public ASN1Integer getInt2() {
            return this.int2;
        }

        public void setInt2(ASN1Integer int2) {
            this.int2 = int2;
        }

        public SM2SignAsn1(ASN1Integer int1, ASN1Integer int2) {
            this.int1 = int1;
            this.int2 = int2;
        }

        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)this.int1);
            vector.add((ASN1Encodable)this.int2);
            return new DERSequence(vector);
        }

        public static String buildSm2SignAsn1Object(BigInteger int1, BigInteger int2) {
            String res = null;
            try {
                SM2SignAsn1 sm2SignAsn1 = new SM2SignAsn1(new ASN1Integer(int1), new ASN1Integer(int2));
                byte[] encoded = sm2SignAsn1.getEncoded();
                res = SMUtil.byteToHex(encoded);
            }
            catch (Exception var5) {
                var5.printStackTrace();
            }
            return res;
        }

        /*
         * Unable to fully structure code
         */
        public static String parseSm2SignAsn1Object(String hexStr) {
            hextByte = HexUtil.decodeHex((String)hexStr);
            encodedText = Base64.getEncoder().encodeToString(hextByte);
            sb = new StringBuilder();
            data = org.bouncycastle.util.encoders.Base64.decode((String)encodedText);
            ais = new ASN1InputStream(data);
            try {
                block2: while (true) {
                    if ((primitive = ais.readObject()) == null) {
                        return sb.toString().replace("#", "");
                    }
                    if (!(primitive instanceof ASN1Sequence)) continue;
                    sequence = (ASN1Sequence)primitive;
                    parser = sequence.parser();
                    while (true) {
                        if ((encodable = parser.readObject()) != null) ** break;
                        continue block2;
                        primitive = encodable.toASN1Primitive();
                        temp = String.valueOf(primitive);
                        s = String.format("%064x", new Object[]{new BigInteger(temp)});
                        sb.append(s);
                    }
                    break;
                }
            }
            catch (Exception var12) {
                throw new SecurityException(FuncRetCode.ERROR_CODE_ASN1_ERROR.getMessage());
            }
        }
    }
}

