/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.ListUtils;
import com.byh.inpatient.api.excel.CommonExcel;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExcelListener<T>
implements ReadListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ImportExcelListener.class);
    private static final int BATCH_COUNT = 1000;
    private List<T> cachedDataList = ListUtils.newArrayListWithExpectedSize((int)1000);
    private final List<String> errorMsgList;
    private final Consumer<List<T>> consumer;

    public ImportExcelListener(Consumer<List<T>> consumer, List<String> errorMsgList) {
        this.consumer = consumer;
        this.errorMsgList = errorMsgList;
    }

    public void invoke(T data, AnalysisContext context) {
        if (data instanceof CommonExcel) {
            ReadRowHolder readRowHolder = context.readRowHolder();
            ((CommonExcel)data).setRowIndex(readRowHolder.getRowIndex() + 1);
        }
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 1000) {
            this.consumer.accept(this.cachedDataList);
            this.cachedDataList = ListUtils.newArrayListWithExpectedSize((int)1000);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (CollectionUtils.isNotEmpty(this.cachedDataList)) {
            this.consumer.accept(this.cachedDataList);
        }
    }

    public void onException(Exception exception, AnalysisContext context) {
        String errorMsg = String.format("%s\uff0c \u7b2c%d\u884c\u89e3\u6790\u5f02\u5e38", context.readSheetHolder().getReadSheet().getSheetName(), context.readRowHolder().getRowIndex() + 1);
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException excelDataConvertException = (ExcelDataConvertException)exception;
            errorMsg = String.format("\u7b2c%d\u884c\uff0c\u7b2c%d\u5217\u6570\u636e\u89e3\u6790\u5f02\u5e38", excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1);
            log.error("{}\uff0c \u7b2c{}\u884c\uff0c\u7b2c{}\u5217\u89e3\u6790\u5f02\u5e38\uff0c\u6570\u636e\u4e3a:{}", new Object[]{context.readSheetHolder().getReadSheet().getSheetName(), excelDataConvertException.getRowIndex() + 1, excelDataConvertException.getColumnIndex() + 1, excelDataConvertException.getCause().getMessage()});
        } else {
            log.error(errorMsg + exception.getMessage());
        }
        this.errorMsgList.add(errorMsg);
    }
}

