/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public final class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);
    private static Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void copy(Object src, Object target) {
        Map<Object, Object> srcMap = BeanUtil.getObjMap(src);
        BeanUtil.setObjVal(target, srcMap);
    }

    public static <T> T copy(Object src, Class<T> clazz) {
        Object to = null;
        Map<Object, Object> srcMap = BeanUtil.getObjMap(src);
        try {
            to = BeanUtil.setObjVal(clazz.newInstance(), srcMap);
            return (T)to;
        }
        catch (Exception e) {
            logger.error("\u6267\u884ccopy\u64cd\u4f5c\u5f02\u5e38");
            return (T)to;
        }
    }

    public static <T, S> List<S> copyList(List<T> list, Class<S> clazz) {
        ArrayList<S> newList = new ArrayList<S>();
        for (T t : list) {
            S s = BeanUtil.copy(t, clazz);
            newList.add(s);
        }
        return newList;
    }

    public static Map<Object, Object> getObjMap(Object src) {
        HashMap<Object, Object> targetMap = new HashMap<Object, Object>(20);
        Class<?> srcClz = src.getClass();
        Field[] fields = srcClz.getDeclaredFields();
        BeanUtil.getObjMapSon(fields, src, targetMap);
        Class<?> superclass = srcClz.getSuperclass();
        BeanUtil.getObjMapSupper(superclass, src, targetMap);
        return targetMap;
    }

    public static <E, T, S> List<E> mapToObject(List<Map<T, S>> list, Class<E> clazz) {
        ArrayList<E> resultList = new ArrayList<E>();
        for (Map<T, S> tsMap : list) {
            E e = BeanUtil.mapToObject(tsMap, clazz);
            resultList.add(e);
        }
        return resultList;
    }

    public static <E, T, S> E mapListToObject(List<Map<T, S>> list, Class<E> clazz) {
        HashMap<S, S> map = new HashMap<S, S>();
        for (Map<T, S> tsMap : list) {
            map.put(tsMap.get("name"), tsMap.get("value"));
        }
        return BeanUtil.mapToObject(map, clazz);
    }

    public static <E, T, S> E mapToObject(Map<T, S> map, Class<E> clazz) {
        E es = null;
        try {
            es = clazz.newInstance();
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u5b9e\u4f8b\u5316\u62a5\u9519\uff1a" + e.getMessage());
        }
        Iterator<Map.Entry<T, S>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, S> entry = iterator.next();
            try {
                Field field = clazz.getDeclaredField(entry.getKey().toString());
                field.setAccessible(true);
                field.set(es, entry.getValue());
                iterator.remove();
            }
            catch (Exception e) {
                logger.warn("\u8bbe\u7f6e\u5c5e\u6027\uff08" + entry.getKey() + "\uff09\u62a5\u9519\uff1a" + e.getMessage());
            }
        }
        Class<E> Superclass = clazz.getSuperclass();
        if (Superclass.getDeclaredFields().length != 0) {
            BeanUtil.setObjValSupper(clazz.getSuperclass(), es, map);
        }
        return es;
    }

    public static <T> List<Map<Object, Object>> objectListToMapList(List<T> list) {
        ArrayList<Map<Object, Object>> mapList = new ArrayList<Map<Object, Object>>(10);
        for (T t : list) {
            mapList.add(BeanUtil.getObjMap(t));
        }
        return mapList;
    }

    private static void getObjMapSon(Field[] fields, Object src, HashMap<Object, Object> srcMap) {
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(src);
                if (null == value) continue;
                srcMap.put(field.getName(), value);
            }
            catch (Exception e) {
                logger.error("\u65b9\u6cd5\u672a\u627e\u5230:" + e.getMessage());
            }
        }
    }

    private static int getObjMapSupper(Class superclass, Object src, HashMap<Object, Object> srcMap) {
        if (superclass.getDeclaredFields().length != 0) {
            Field[] fs = superclass.getDeclaredFields();
            BeanUtil.getObjMapSon(fs, src, srcMap);
            superclass = superclass.getSuperclass();
            if (superclass.getDeclaredFields().length != 0) {
                BeanUtil.getObjMapSupper(superclass, src, srcMap);
            } else {
                return 0;
            }
        }
        return 0;
    }

    private static Object setObjVal(Object target, Map<Object, Object> srcMap) {
        Class<?> targetClz = target.getClass();
        Field[] tarField = targetClz.getDeclaredFields();
        BeanUtil.setObjValSon(tarField, target, srcMap);
        Class<?> superclass = targetClz.getSuperclass();
        BeanUtil.setObjValSupper(superclass, target, srcMap);
        return target;
    }

    private static <T, S> void setObjValSon(Field[] fields, Object target, Map<T, S> srcMap) {
        String fieldName = "";
        for (Field field : fields) {
            try {
                fieldName = field.getName();
                S value = srcMap.get(fieldName);
                if (value == null) continue;
                field.setAccessible(true);
                field.set(target, value);
            }
            catch (Exception e) {
                if ("serialVersionUID".equals(fieldName)) continue;
                logger.warn("copy\u5bf9\u8c61:" + fieldName + "\u5c5e\u6027\u6709\u672a\u8d4b\u4e0a\u503c\u7684\u5c5e\u6027");
            }
        }
    }

    private static <T, S> int setObjValSupper(Class superclass, Object target, Map<T, S> srcMap) {
        if (superclass.getDeclaredFields().length != 0) {
            Field[] fs = superclass.getDeclaredFields();
            BeanUtil.setObjValSon(fs, target, srcMap);
            superclass = superclass.getSuperclass();
            if (superclass.getDeclaredFields().length != 0) {
                BeanUtil.setObjValSupper(superclass, target, srcMap);
            } else {
                return 0;
            }
        }
        return 0;
    }

    public static <T> T convert(Object source, Class<T> clazz) {
        try {
            T target = clazz.newInstance();
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38:{}", (Throwable)e);
            throw new RuntimeException("\u5bf9\u8c61\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

