/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.util;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.inpatient.api.annotation.WrapperNotBlank;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetWrapperUtil {
    private static Logger logger = LoggerFactory.getLogger(SetWrapperUtil.class);
    private static final StringBuilder field = new StringBuilder("serialVersionUID,current,size");

    public static <T> void setWrapper(QueryWrapper<T> wrapper, Object dto) {
        Class<?> dtoClass = dto.getClass();
        Field[] dtoFields = dtoClass.getDeclaredFields();
        SetWrapperUtil.getParent(dtoClass.getSuperclass(), dtoFields, dto, wrapper);
    }

    public static <T> void setWrapperLike(QueryWrapper<T> wrapper, Object dto, String ... likes) {
        Class<?> dtoClass = dto.getClass();
        Field[] dtoFields = dtoClass.getDeclaredFields();
        SetWrapperUtil.getParent(dtoClass.getSuperclass(), dtoFields, dto, wrapper);
    }

    public static <T> void getParent(Class<?> superClass, Field[] dtoFields, Object dto, QueryWrapper<T> wrapper) {
        try {
            for (Field f : dtoFields) {
                f.setAccessible(true);
                if (null == f.get(dto) || field.indexOf(f.getName()) != -1) continue;
                String fieldName = SetWrapperUtil.recoverHump(f.getName());
                boolean isAnno = f.isAnnotationPresent(WrapperNotBlank.class);
                if (isAnno && f.getAnnotation(WrapperNotBlank.class).value() && "".equals(f.get(dto))) continue;
                if ("startTime".equals(f.getName())) {
                    wrapper.ge((Object)"create_time", (Object)(f.get(dto) + " 00:00:00"));
                } else if ("endTime".equals(f.getName())) {
                    wrapper.le((Object)"create_time", (Object)(f.get(dto) + " 23:59:59"));
                } else {
                    wrapper.eq((Object)fieldName, f.get(dto));
                }
                logger.info("\u5b57\u6bb5{}\u5df2\u6dfb\u52a0\u81f3Wrapper", (Object)fieldName);
            }
            Field[] ids = superClass.getDeclaredFields();
            if (ids.length == 0) {
                wrapper.eq((Object)"del_flag", (Object)"0");
                return;
            }
            SetWrapperUtil.getParent(superClass.getClass().getSuperclass(), ids, dto, wrapper);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String recoverHump(String f) {
        StringBuilder builder = new StringBuilder(f);
        char[] a = builder.toString().toCharArray();
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] < 'A' || a[i] > 'Z') continue;
            builder.replace(i, i + 1, "_" + String.valueOf(a[i]).toLowerCase());
        }
        return builder.toString();
    }
}

