/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.util;

import cn.hutool.core.io.resource.ResourceUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.data.ImageData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.byh.inpatient.api.excel.CustomMergeStrategy;
import com.byh.inpatient.api.excel.ExcelMergeStrategy;
import com.byh.inpatient.api.excel.ImportExcelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class EasyExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(EasyExcelUtil.class);

    public static <T> List<T> importExcel(MultipartFile file, Object entity, Object listener) throws IOException {
        List objects = ((ExcelReaderBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)file.getInputStream()).head(entity.getClass())).registerReadListener((ReadListener)listener)).sheet().doReadSync();
        return objects;
    }

    public static void exportExcel(HttpServletResponse response, String excelName, String sheetName, List<?> list, Object data) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
        String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(data.getClass())).excelType(ExcelTypeEnum.XLSX).sheet(sheetName).doWrite(list);
    }

    public static void exportExcel(HttpServletResponse response, String excelName, String sheetName, List<?> list, Class<?> pojoClass) {
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = null;
            fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).head(pojoClass)).registerWriteHandler((WriteHandler)new ExcelMergeStrategy(pojoClass))).excelType(ExcelTypeEnum.XLSX).sheet(sheetName).doWrite(list);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51faexcel\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    public static String importExcelMerge(MultipartFile file, Object dataVo) throws IOException {
        String object_str = null;
        AtomicReference<Object> ar = new AtomicReference<Object>(new Object());
        try (ExcelReader excelReader = EasyExcelFactory.read((InputStream)file.getInputStream()).build();){
            ReadSheet dealerSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)0).head(dataVo.getClass())).registerReadListener(new ImportExcelListener(data -> {
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e----------------------------------------------");
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e\uff1a" + JSON.toJSONString((Object)data));
                ar.set(data);
                log.info("\u516c\u53f8\u4fe1\u606f\u6570\u636e----------------------------------------------");
            }, null))).headRowNumber(Integer.valueOf(2))).build();
            excelReader.read(new ReadSheet[]{dealerSheet});
            object_str = JSON.toJSON((Object)ar.get()).toString();
        }
        catch (IOException e) {
            log.error("\u5904\u7406excel\u5931\u8d25\uff0c" + e.getMessage());
        }
        return object_str;
    }

    public static void exportExcelMerge(HttpServletResponse response, String excelName, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelUtil.handleExcel((OutputStream)out, sheetName, data, companyList, contactList);
            out.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private static void handleExcel(OutputStream out, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
            WriteSheet medicineSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)sheetName).head(data.getClass())).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 0))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 6))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(companyList.size(), 7))).build();
            excelWriter.write(companyList, medicineSheet);
        }
    }

    public static void exportExcelSheet(HttpServletResponse response, String excelName, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
            String format = LocalDateTime.now(ZoneOffset.ofHours(8)).format(dateTimeFormatter);
            String fileName = URLEncoder.encode(excelName + format, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            EasyExcelUtil.handleExcelSheet((OutputStream)out, sheetName, data, companyList, contactList);
            out.flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private static void handleExcelSheet(OutputStream out, String sheetName, Object data, List<?> companyList, List<?> contactList) {
        try (ExcelWriter excelWriter = EasyExcelFactory.write((OutputStream)out).build();){
            WriteSheet medicineSheet = ((ExcelWriterSheetBuilder)EasyExcelFactory.writerSheet((Integer)0, (String)sheetName).head(data.getClass())).build();
            excelWriter.write(companyList, medicineSheet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void customTemplateExport(HttpServletResponse response, String excelName, List<?> excels, List<?> ps) {
        InputStream is = null;
        try {
            is = ResourceUtil.getStream((String)"classpath:template/sysDrugPharmacyCheck.xlsx");
            String fileName = excelName + ".xlsx";
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)EasyExcelUtil.getOutputStream(fileName, response)).withTemplate(is).excelType(ExcelTypeEnum.XLSX).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            excelWriter.fill(excels, writeSheet);
            excelWriter.fill(ps, writeSheet);
            excelWriter.finish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static WriteCellData<Void> imageCells(byte[] bytes) throws IOException {
        WriteCellData writeCellData = new WriteCellData();
        ArrayList<ImageData> imageDataList = new ArrayList<ImageData>();
        writeCellData.setImageDataList(imageDataList);
        ImageData imageData = new ImageData();
        imageDataList.add(imageData);
        imageData.setImage(bytes);
        imageData.setTop(Integer.valueOf(10));
        imageData.setRight(Integer.valueOf(10));
        imageData.setBottom(Integer.valueOf(10));
        imageData.setLeft(Integer.valueOf(10));
        imageData.setRelativeFirstRowIndex(Integer.valueOf(0));
        imageData.setRelativeFirstColumnIndex(Integer.valueOf(0));
        imageData.setRelativeLastRowIndex(Integer.valueOf(20));
        imageData.setRelativeLastColumnIndex(Integer.valueOf(5));
        return writeCellData;
    }

    public static OutputStream getOutputStream(String fileName, HttpServletResponse response) throws Exception {
        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf8");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setHeader("Pragma", "public");
            response.setHeader("Cache-Control", "no-store");
            response.addHeader("Cache-Control", "max-age=0");
            return response.getOutputStream();
        }
        catch (IOException e) {
            throw new Exception("\u5bfc\u51faexcel\u8868\u683c\u5931\u8d25!", e);
        }
    }
}

