/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.enums;

public enum OrderTypeEnum {
    REGISTERED_ORDINARY_ORDERS("\u95e8\u8bca\u6302\u53f7\u8d39", "10", "\u95e8\u8bca\u6302\u53f7\u8d39", "\u6302\u53f7\u8d39", "\u7ebf\u4e0b"),
    DIAGNOSIS_TREATMENT_ORDERS("\u8bca\u7597\u8d39", "11", "\u8bca\u7597\u8d39", "\u8bca\u7597\u8d39", "\u7ebf\u4e0b"),
    OONLINE_REGISTERED_ORDINARY_ORDERS("\u7ebf\u4e0a\u95e8\u8bca\u6302\u53f7\u8d39", "15", "\u7ebf\u4e0a\u8bca\u7597", "\u7ebf\u4e0a\u8bca\u7597", "\u7ebf\u4e0a"),
    PRESCRIPTION_WESTERN_MEDICINE_ORDERS("\u897f\u836f\u5904\u65b9\u8ba2\u5355", "20", "\u897f\u836f", "\u897f\u836f\u8d39", "\u7ebf\u4e0b"),
    CLOUD_PRESCRIPTION_WESTERN_MEDICINE_ORDERS("\u4e91\u836f\u623f\u897f\u836f\u5904\u65b9\u8ba2\u5355", "21", "\u4e91\u836f\u623f\u897f\u836f", "\u4e91\u836f\u623f\u897f\u836f\u8d39", "\u7ebf\u4e0b"),
    REGISTERED_TRADITIONAL_ORDERS("\u4e2d\u836f\u996e\u7247\u5904\u65b9\u8ba2\u5355", "30", "\u4e2d\u836f\u996e\u7247", "\u4e2d\u836f\u996e\u7247", "\u7ebf\u4e0b"),
    CLOUD_REGISTERED_TRADITIONAL_ORDERS("\u4e91\u836f\u623f\u4e2d\u8349\u836f\u5904\u65b9\u8ba2\u5355", "31", "\u4e91\u836f\u623f\u4e2d\u8349\u836f", "\u4e91\u836f\u623f\u4e2d\u8349\u836f", "\u7ebf\u4e0b"),
    CLOUD_REGISTERED_PREPARED_TRADITIONAL_ORDERS("\u4e91\u836f\u623f\u4e2d\u836f\u996e\u7247\u5904\u65b9\u8ba2\u5355", "32", "\u4e91\u836f\u623f\u4e2d\u836f\u996e\u7247", "\u4e91\u836f\u4e2d\u836f\u996e\u7247", "\u7ebf\u4e0b"),
    REGISTERED_CHINESE_PATENT_DRUG_ORDERS("\u4e2d\u6210\u836f\u8ba2\u5355", "40", "\u4e2d\u6210\u836f", "\u4e2d\u6210\u836f", "\u7ebf\u4e0b"),
    CLOUD_REGISTERED_CHINESE_PATENT_DRUG_ORDERS("\u4e91\u836f\u623f\u4e2d\u6210\u836f\u8ba2\u5355", "41", "\u4e91\u836f\u623f\u4e2d\u6210\u836f", "\u4e91\u836f\u623f\u4e2d\u6210\u836f", "\u7ebf\u4e0b"),
    REGISTERED_INSPECTION_ORDERS("\u68c0\u9a8c\u8ba2\u5355", "50", "\u68c0\u9a8c", "\u9879\u76ee-\u68c0\u9a8c", "\u7ebf\u4e0b"),
    REGISTERED_INSPECT_ORDERS("\u68c0\u67e5\u8ba2\u5355", "51", "\u68c0\u67e5", "\u9879\u76ee-\u68c0\u67e5", "\u7ebf\u4e0b"),
    REGISTERED_TREATMENT_ORDERS("\u6cbb\u7597\u8ba2\u5355", "53", "\u6cbb\u7597", "\u9879\u76ee-\u6cbb\u7597", "\u7ebf\u4e0b"),
    REGISTERED_OPERATION_ORDERS("\u624b\u672f\u8ba2\u5355", "54", "\u624b\u672f", "\u9879\u76ee-\u624b\u672f", "\u7ebf\u4e0b"),
    REGISTERED_ANAESTHESIA_ORDERS("\u9ebb\u9189\u8ba2\u5355", "55", "\u9ebb\u9189", "\u9879\u76ee-\u9ebb\u9189", "\u7ebf\u4e0b"),
    REGISTERED_NURSING_ORDERS("\u62a4\u7406\u8ba2\u5355", "56", "\u62a4\u7406", "\u9879\u76ee-\u62a4\u7406", "\u7ebf\u4e0b"),
    REGISTERED_DIET_ORDERS("\u996e\u98df\u8ba2\u5355", "57", "\u996e\u98df", "\u9879\u76ee-\u996e\u98df", "\u7ebf\u4e0b"),
    REGISTERED_OXYGEN_THERAPY_ORDERS("\u8f93\u6c27\u8ba2\u5355", "58", "\u8f93\u6c27", "\u9879\u76ee-\u8f93\u6c27", "\u7ebf\u4e0b"),
    REGISTERED_MATERIAL_ORDERS("\u6750\u6599\u8ba2\u5355", "59", "\u6750\u6599", "\u9879\u76ee-\u6750\u6599", "\u7ebf\u4e0b"),
    REGISTERED_PATROL_VEHICLE_ORDERS("\u5de1\u8bca\u8f66\u8ba2\u5355", "60", "\u5de1\u8bca\u8f66", "\u9879\u76ee-\u5de1\u8bca\u8f66", "\u7ebf\u4e0b"),
    REGISTERED_BLOOD_TRANSFUSION_ORDERS("\u8f93\u8840\u8ba2\u5355", "61", "\u8f93\u8840", "\u9879\u76ee-\u8f93\u8840", "\u7ebf\u4e0b"),
    REGISTERED_SERVICER_ORDERS("\u670d\u52a1\u8ba2\u5355", "62", "\u670d\u52a1", "\u9879\u76ee-\u670d\u52a1", "\u7ebf\u4e0b"),
    REGISTERED_MATERIAL_PROJECTS_ORDERS("\u536b\u6750\u8ba2\u5355", "63", "\u536b\u6750", "\u9879\u76ee-\u536b\u6750", "\u7ebf\u4e0b"),
    ZT_PROJECTS_ORDERS("\u5631\u6258\u8ba2\u5355", "64", "\u5631\u6258", "\u9879\u76ee-\u5631\u6258", "\u7ebf\u4e0b"),
    REGISTERED_OTHER_PROJECTS_ORDERS("\u5176\u4ed6\u8ba2\u5355", "70", "\u5176\u4ed6", "\u9879\u76ee-\u5176\u4ed6", "\u7ebf\u4e0b");

    private String desc;
    private String value;
    private String name;
    private String remark;
    private String source;

    public String getSource() {
        return this.source;
    }

    private OrderTypeEnum(String desc, String value, String name, String remark, String source) {
        this.desc = desc;
        this.value = value;
        this.name = name;
        this.remark = remark;
        this.source = source;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getValue() {
        return this.value;
    }

    public static String getDesc(String value) {
        if (value == null) {
            return null;
        }
        for (OrderTypeEnum orderStatusEnum : OrderTypeEnum.values()) {
            if (!value.equals(orderStatusEnum.getValue())) continue;
            return orderStatusEnum.getDesc();
        }
        return null;
    }

    public static OrderTypeEnum getEnum(String value) {
        if (value == null) {
            return null;
        }
        for (OrderTypeEnum orderStatusEnum : OrderTypeEnum.values()) {
            if (!value.equals(orderStatusEnum.getValue())) continue;
            return orderStatusEnum;
        }
        return null;
    }

    public static OrderTypeEnum getEnumByDrugType(String drugType) {
        if (drugType == null) {
            return null;
        }
        if ("1".equals(drugType)) {
            return REGISTERED_CHINESE_PATENT_DRUG_ORDERS;
        }
        if ("2".equals(drugType)) {
            return PRESCRIPTION_WESTERN_MEDICINE_ORDERS;
        }
        if ("3".equals(drugType)) {
            return REGISTERED_TRADITIONAL_ORDERS;
        }
        return null;
    }

    public static OrderTypeEnum getEnumByProjectType(String projectType) {
        if (projectType == null) {
            return null;
        }
        switch (projectType) {
            case "2": {
                return REGISTERED_INSPECTION_ORDERS;
            }
            case "1": {
                return REGISTERED_INSPECT_ORDERS;
            }
            case "3": {
                return REGISTERED_TREATMENT_ORDERS;
            }
            case "4": {
                return REGISTERED_OPERATION_ORDERS;
            }
            case "5": {
                return REGISTERED_ANAESTHESIA_ORDERS;
            }
            case "6": {
                return REGISTERED_NURSING_ORDERS;
            }
            case "7": {
                return REGISTERED_DIET_ORDERS;
            }
            case "8": {
                return REGISTERED_OXYGEN_THERAPY_ORDERS;
            }
            case "9": {
                return REGISTERED_MATERIAL_ORDERS;
            }
            case "10": {
                return REGISTERED_PATROL_VEHICLE_ORDERS;
            }
            case "11": {
                return REGISTERED_OTHER_PROJECTS_ORDERS;
            }
            case "15": {
                return REGISTERED_MATERIAL_PROJECTS_ORDERS;
            }
            case "16": {
                return ZT_PROJECTS_ORDERS;
            }
        }
        return REGISTERED_OTHER_PROJECTS_ORDERS;
    }
}

