/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.util;

import java.io.Serializable;
import java.util.Objects;

public class ResponseData<T>
implements Serializable {
    private String code;
    private String msg;
    private T data;

    public ResponseData(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> ResponseData<T> success() {
        return new ResponseData<Object>(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getCodeName(), null);
    }

    public static <T> ResponseData<T> success(T data) {
        return new ResponseData<T>(ResponseEnum.SUCCESS.getCode(), ResponseEnum.SUCCESS.getCodeName(), data);
    }

    public static <T> ResponseData<T> success(String msg, T data) {
        return new ResponseData<T>(ResponseEnum.SUCCESS.getCode(), msg, data);
    }

    public static <T> ResponseData<T> success(String msg) {
        return new ResponseData<Object>(ResponseEnum.SUCCESS.getCode(), msg, null);
    }

    public ResponseData<T> alreadyUpdateStatus() {
        this.msg("\u72b6\u6001\u5df2\u66f4\u6539");
        return this;
    }

    public ResponseData<T> save() {
        this.msg("\u4fdd\u5b58\u6210\u529f");
        return this;
    }

    public ResponseData<T> update() {
        this.msg("\u4fee\u6539\u6210\u529f");
        return this;
    }

    public ResponseData<T> delete() {
        this.msg("\u5220\u9664\u6210\u529f");
        return this;
    }

    public ResponseData<T> saveUpdate() {
        this.msg("\u4fdd\u5b58\u6216\u4fee\u6539\u6210\u529f");
        return this;
    }

    public ResponseData<T> confirm() {
        this.msg("\u72b6\u6001\u5df2\u786e\u8ba4");
        return this;
    }

    public ResponseData<T> notQuery() {
        this.msg("\u8fd4\u56de\u5bf9\u8c61\u4e3a\u7a7a");
        return this;
    }

    public static <T> ResponseData<T> error() {
        return new ResponseData<Object>(ResponseEnum.BAD_REQUEST.code, ResponseEnum.BAD_REQUEST.codeName, null);
    }

    public static <T> ResponseData<T> error(String code, String msg) {
        return new ResponseData<Object>(code, msg, null);
    }

    public static <T> ResponseData<T> error(String msg) {
        return new ResponseData<Object>(ResponseEnum.BAD_REQUEST.code, msg, null);
    }

    public static <T> ResponseData<T> tp() {
        ResponseData<T> response = new ResponseData<T>();
        response.setCode("0");
        return response;
    }

    public ResponseData<T> code(String code) {
        this.setCode(code);
        return this;
    }

    public ResponseData<T> data(T data) {
        this.setData(data);
        return this;
    }

    public ResponseData<T> msg(String msg) {
        this.setMsg(msg);
        return this;
    }

    public static <T> ResponseData<T> customResult(String code, String msg) {
        return new ResponseData<Object>(code, msg, null);
    }

    public static <T> ResponseData<T> serviceError() {
        return new ResponseData<Object>(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_ERROR.getCodeName(), null);
    }

    public static <T> ResponseData<T> noAuthen() {
        return new ResponseData<Object>(ResponseEnum.NO_AUTH.getCode(), ResponseEnum.NO_AUTH.getCodeName(), null);
    }

    public static <T> ResponseData<T> timeOut() {
        return new ResponseData<Object>(ResponseEnum.TIME_OUT.getCode(), ResponseEnum.NO_AUTH.getCodeName(), null);
    }

    public static <T> ResponseData<T> serviceRefuse() {
        return new ResponseData<Object>(ResponseEnum.SERVICE_REFUSE.getCode(), ResponseEnum.SERVICE_REFUSE.getCodeName(), null);
    }

    public boolean isSuccess() {
        return Objects.equals(this.code, "200");
    }

    public boolean isError() {
        return !Objects.equals(this.code, "200");
    }

    public ResponseData() {
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseData)) {
            return false;
        }
        ResponseData other = (ResponseData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public T getData() {
        return this.data;
    }

    public static enum ResponseEnum {
        SUCCESS("200", "\u64cd\u4f5c\u6210\u529f"),
        BAD_REQUEST("400", "\u64cd\u4f5c\u5931\u8d25"),
        SERVICE_ERROR("500", "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef"),
        NO_AUTH("401", "\u672a\u6388\u6743"),
        TIME_OUT("408", "\u670d\u8bf7\u6c42\u8d85\u65f6"),
        NULL_POINTER_EXCEPTION("500", "\u51fa\u73b0\u7a7a\u6307\u9488\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5"),
        MY_BATIS_SYSTEM_EXCEPTION("500", "\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38"),
        RUN_TIME_EXCEPTION("500", "\u8fd0\u884c\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38"),
        SERVICE_REFUSE("403", "\u670d\u52a1\u5668\u62d2\u7edd\u8bbf\u95ee\uff08\u65e0\u6743\u9650\uff09");

        private String code;
        private String codeName;

        private ResponseEnum() {
        }

        private ResponseEnum(String code, String codeName) {
            this.code = code;
            this.codeName = codeName;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public void setCodeName(String codeName) {
            this.codeName = codeName;
        }
    }
}

