/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.api.util;

import com.byh.inpatient.api.util.DateUtils;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class UUIDUtils {
    private static LocalDateTime pay_lastDateTime = LocalDateTime.now();
    private static final AtomicInteger pay_sequence = new AtomicInteger(0);
    private static String[] allLetter = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "l", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "L", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] number = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static String[] letter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "l", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "L", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static String[] symbol = new String[]{"!", "~", "@", "#", "$", "%", "^", "&", "*", "-", "_", "=", "+", "/", "<", ">"};

    public static String getAllLetterRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom(61, 0);
            str = str + allLetter[index];
        }
        return str;
    }

    public static String getLetterRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom(letter.length, 0);
            str = str + letter[index];
        }
        return str;
    }

    public static String getNumberRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom(number.length, 0);
            str = str + number[index];
        }
        return str;
    }

    public static String getSymbolRandom(int digit) {
        String str = "";
        for (int i = 0; i < digit; ++i) {
            int index = UUIDUtils.getRangeRandom(symbol.length, 0);
            str = str + symbol[index];
        }
        return str;
    }

    public static String getRandom(int digit, boolean bool) {
        String id = "";
        if (digit == 0) {
            digit = 10;
        }
        if (bool) {
            id = id + DateUtils.dateFormat(new Date(), "YYYYMMddHHmmss");
        }
        Random random = new Random();
        for (int i = 0; i < digit; ++i) {
            int a = random.nextInt(10);
            if (i == 0 && a == 0) {
                a = 1;
            }
            id = id + a;
        }
        return id;
    }

    public static String getUuidString(int digit, boolean bool) {
        String uuid = UUID.randomUUID().toString();
        if (digit > 0 && digit <= uuid.length()) {
            uuid.substring(0, digit);
        }
        if (!bool) {
            uuid.replaceAll("-", "");
        }
        return uuid;
    }

    public static int getRangeRandom(int max, int min) {
        Random random = new Random();
        int i = random.nextInt(max - min) + min;
        return i;
    }

    public static Long getLongRangeRandom(int max, int min) {
        Random random = new Random();
        int i = random.nextInt(max - min) + min;
        return Long.parseLong(i + "");
    }

    public static synchronized String getPayOrderNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(pay_lastDateTime)) {
            pay_sequence.set(1);
            pay_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom(3);
        int currentSequence = pay_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = "PAY" + epochMilli + sequenceNum + randomNumeric;
        return orderNum;
    }

    public static synchronized String getOutHospPayOrderNo() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        if (!currentDateTime.isEqual(pay_lastDateTime)) {
            pay_sequence.set(1);
            pay_lastDateTime = currentDateTime;
        }
        long epochMilli = currentDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String randomNumeric = UUIDUtils.getNumberRandom(3);
        int currentSequence = pay_sequence.getAndIncrement();
        String sequenceNum = String.format("%04d", currentSequence);
        String orderNum = "E" + epochMilli + sequenceNum + randomNumeric;
        return orderNum;
    }
}

