/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.annotation.UserOptLogger;
import com.byh.inpatient.api.dto.inpatOrderDrug.ApplyReturnDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.CancelApplyDispenseDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.CancelReturnDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.DispensedDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetApplyPageDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetApplyReturnListDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetDetailListDto;
import com.byh.inpatient.api.dto.inpatOrderDrug.GetDispensePageDto;
import com.byh.inpatient.api.model.InpatOrderDrugEntity;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.InpatOrderDrugService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatOrderDrug"})
public class InpatOrderDrugController {
    @Autowired
    private CommonRequest commonRequest;
    @Autowired
    private InpatOrderDrugService inpatOrderDrugService;

    @ApiOperation(value="\u53d1\u836f/\u9000\u836f\uff08\u9000\u836f\u672a\u5b8c\u6210\uff09")
    @PostMapping(value={"/dispensedOrReturned"})
    @UserOptLogger(operation="\u53d1\u836f/\u9000\u836f")
    public ResponseData dispensedOrReturned(@RequestBody @Valid DispensedDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.inpatOrderDrugService.dispensedOrReturned(dto);
        return ResponseData.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u53d1\u836f\u8be6\u60c5")
    @PostMapping(value={"/selectDetailList"})
    public ResponseData selectDetailList(@RequestBody @Valid GetDetailListDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatOrderDrugService.selectDetailList(dto));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f4f\u9662\u836f\u623f\u53d1\u836f\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/selectPageList"})
    public ResponseData selectPageList(@RequestBody @Valid GetDispensePageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatOrderDrugService.selectPageList(dto));
    }

    @ApiOperation(value="\u53d6\u6d88\u7533\u8bf7\u9000\u836f")
    @PostMapping(value={"/cancelReturn"})
    @UserOptLogger(operation="\u53d6\u6d88\u7533\u8bf7\u9000\u836f")
    public ResponseData cancelReturn(@RequestBody @Valid CancelReturnDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.inpatOrderDrugService.cancelReturn(dto);
        return ResponseData.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5f85\u9000\u836f\u5217\u8868\u4fe1\u606f\u5e76\u643a\u5e26\u5bf9\u5e94\u7684\u53ef\u7533\u8bf7\u9000\u836f\u6570\u91cf")
    @PostMapping(value={"/selectApplyReturnWithAllowBackNum"})
    public ResponseData selectApplyReturnWithAllowBackNum(@RequestBody @Valid GetApplyReturnListDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatOrderDrugService.selectApplyReturnWithAllowBackNum(dto));
    }

    @ApiOperation(value="\u7533\u8bf7\u9000\u836f")
    @PostMapping(value={"/applyReturn"})
    @UserOptLogger(operation="\u7533\u8bf7\u9000\u836f")
    public ResponseData applyReturn(@RequestBody @Valid ApplyReturnDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setOperatorId(this.commonRequest.getUserId());
        dto.setOperatorName(this.commonRequest.getUserName());
        this.inpatOrderDrugService.applyReturn(dto);
        return ResponseData.ok();
    }

    @ApiOperation(value="\u53d6\u6d88\u7533\u8bf7\u6446\u836f")
    @PostMapping(value={"/cancelApplyDispense"})
    @UserOptLogger(operation="\u53d6\u6d88\u7533\u8bf7\u6446\u836f")
    public ResponseData cancelApplyDispense(@RequestBody @Valid CancelApplyDispenseDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        this.inpatOrderDrugService.cancelApplyDispense(dto);
        return ResponseData.ok();
    }

    @ApiOperation(value="\u7533\u8bf7\u6446\u836f")
    @PostMapping(value={"/applyDispense"})
    @UserOptLogger(operation="\u7533\u8bf7\u6446\u836f")
    public ResponseData applyDispense(@RequestBody List<InpatOrderDrugEntity> list) {
        this.inpatOrderDrugService.applyDispense(list, this.commonRequest.getTenant(), this.commonRequest.getUserId(), this.commonRequest.getUserName());
        return ResponseData.ok();
    }

    @ApiOperation(value="\u836f\u54c1\u8bf7\u9886\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/selectApplyPageList"})
    public ResponseData selectApplyPageList(@RequestBody GetApplyPageDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setDoctorId(this.commonRequest.getUserId());
        return ResponseData.success((Object)this.inpatOrderDrugService.selectApplyPageList(dto));
    }
}

