/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.annotation.UserOptLogger;
import com.byh.inpatient.api.model.dto.prepay.PrepayDto;
import com.byh.inpatient.api.model.dto.prepay.QueryDetailDto;
import com.byh.inpatient.api.model.dto.prepay.QueryPrepayDto;
import com.byh.inpatient.api.model.dto.prepay.QueryPrintDataDto;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatPrepayService;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatient/inpatPrepay"})
public class InpatPrepayController {
    @Autowired
    private IInpatPrepayService inpatPrepayService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/selectPrintDate"})
    @ApiOperation(value="\u67e5\u8be2\u7f34\u8d39\u51ed\u8bc1\u6253\u5370\u6570\u636e")
    public ResponseData selectPrintDate(@RequestBody @Valid QueryPrintDataDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatPrepayService.selectPrintDate(dto));
    }

    @PostMapping(value={"/selectDetailList"})
    @ApiOperation(value="\u6839\u636e\u4f4f\u9662\u767b\u8bb0\u7f16\u53f7\u67e5\u8be2\u5bf9\u5e94\u7684\u9884\u4ea4\u91d1\u7f34\u7eb3\u660e\u7ec6")
    public ResponseData selectDetailList(@RequestBody @Valid QueryDetailDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatPrepayService.selectDetailList(dto));
    }

    @PostMapping(value={"/selectPageList"})
    @ApiOperation(value="\u9884\u4ea4\u91d1\u5206\u9875\u67e5\u8be2")
    public ResponseData selectPageList(@RequestBody @Valid QueryPrepayDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        return ResponseData.success((Object)this.inpatPrepayService.selectPageList(dto));
    }

    @PostMapping(value={"/prepay"})
    @ApiOperation(value="\u7f34\u7eb3\u9884\u4ea4\u91d1")
    @UserOptLogger(operation="\u7f34\u7eb3\u9884\u4ea4\u91d1")
    public ResponseData prepay(@RequestBody @Valid PrepayDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setChargeEmpId(this.commonRequest.getUserId());
        dto.setChargeEmpName(this.commonRequest.getUserName());
        return ResponseData.success((Object)this.inpatPrepayService.prepay(dto));
    }
}

