/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.ApplyForInpatDTO;
import com.byh.inpatient.api.model.dto.ApplyForInpatListDTO;
import com.byh.inpatient.api.model.dto.InpatRegistDTO;
import com.byh.inpatient.api.model.dto.InpatRegistListDTO;
import com.byh.inpatient.api.model.dto.QueryInpatPageListDTO;
import com.byh.inpatient.api.model.vo.RegInfoByTranferVO;
import com.byh.inpatient.api.model.vo.WardBedAndDiagAndCardVO;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatRegistService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatRegist"})
public class InpatRegistController {
    @Autowired
    private IInpatRegistService inpatRegistService;
    @Autowired
    CommonRequest commonRequest;

    @PostMapping(value={"/applyForInpat"})
    @ApiOperation(value="\u7533\u8bf7\u5165\u9662", notes="\u529e\u7406\u4f4f\u9662\u8bc1")
    public ResponseData<InpatRegist> applyForInpat(@Valid @RequestBody ApplyForInpatDTO param) {
        InpatRegist inpatRegist = this.inpatRegistService.doApplyForInpat(param);
        return ResponseData.success((Object)inpatRegist);
    }

    @PostMapping(value={"/applyForInpat/list"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u7533\u8bf7\u5165\u9662\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5df2\u7ecf\u529e\u7406\u4f4f\u9662\u8bc1\u7684\u4eba")
    public ResponseData<Page<InpatRegist>> getApplyForInpatList(@RequestBody ApplyForInpatListDTO param) {
        Page inpatRegistPageInfo = this.inpatRegistService.selectApplyForInpatList(param);
        return ResponseData.success((Object)inpatRegistPageInfo);
    }

    @PostMapping(value={"/regist"})
    @ApiOperation(value="\u4f4f\u9662\u767b\u8bb0", notes="\u767b\u8bb0")
    public ResponseData<InpatRegist> regist(@Valid @RequestBody InpatRegistDTO param) {
        InpatRegist inpatRegist = this.inpatRegistService.doRegist(param);
        return ResponseData.success((Object)inpatRegist);
    }

    @PostMapping(value={"/updateAssessmentForm"})
    @ApiOperation(value="\u66f4\u65b0\u4f4f\u9662\u4fe1\u606f+\u5165\u9662\u62a4\u7406\u8bc4\u4f30\u5355", notes="\u8be5\u63a5\u53e3\u76ee\u524d\u7528\u4e8e\u66f4\u65b0\u5165\u9662\u62a4\u7406\u8bc4\u4f30\u5355")
    public ResponseData<String> updateAssessmentForm(@Valid @RequestBody InpatRegist param) {
        ResponseData s = this.inpatRegistService.updateAssessmentForm(param);
        return s;
    }

    @PostMapping(value={"/regist/list"})
    @ApiOperation(value="\u5165\u9662\u767b\u8bb0\u5217\u8868")
    public ResponseData<Page<InpatRegist>> getRegistList(@Valid @RequestBody InpatRegistListDTO param) {
        Page inpatRegistPage = this.inpatRegistService.selectInpatRegistList(param);
        return ResponseData.success((Object)inpatRegistPage);
    }

    @PostMapping(value={"/regist/queryByInpatNo"})
    @ApiOperation(value="\u67e5\u8be2\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f", notes="\u6839\u636e\u4f4f\u9662\u53f7\u67e5\u8be2\u767b\u8bb0\u4fe1\u606f")
    public ResponseData<InpatRegist> getRegistInfo(@RequestParam(value="InpatNo") String inpatNo) {
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(inpatNo);
        return ResponseData.success((Object)inpatRegist);
    }

    @ApiOperation(value="\u6302\u724c\u5361\u83b7\u53d6\u6570\u636e\u96c6\u5408\u9700\u6c42\u63a5\u53e3")
    @GetMapping(value={"list/withWardBedAndDiagAndCardStatus"})
    public ResponseData<List<WardBedAndDiagAndCardVO>> selectListWithWardBedAndDiagAndCardStatus(Integer wardId, Integer deptId, String search) {
        return ResponseData.success((Object)this.inpatRegistService.selectListWithWardBedAndDiagAndCardStatus(wardId, deptId, search));
    }

    @ApiOperation(value="\u5f85\u5165\u79d1\u5217\u8868", notes="\u6839\u636e\u75c5\u533a\u53f7\u67e5\u8be2\u5f85\u5165\u79d1\u7684\u5217\u8868\u5e76\u6839\u636e\u5f02\u52a8\u4fe1\u606f\u5206\u7c7b")
    @GetMapping(value={"/select/waitIntoDept/{wardId}"})
    public ResponseData<List<RegInfoByTranferVO>> selectListWithWardBedAndDiagAndCardStatus(@PathVariable Integer wardId) {
        return ResponseData.success((Object)this.inpatRegistService.selectWaitIntoDept(wardId));
    }

    @ApiOperation(value="\u5f85\u5165\u79d1\u8f6c\u79d1", notes="\u8fd8\u6ca1\u5165\u79d1\u5c31\u8f6c\u79d1")
    @PostMapping(value={"/toAnotherDepartment"})
    public ResponseData<Integer> toAnotherDepartment(@RequestBody InpatRegist inpatRegist) {
        return ResponseData.success((String)"\u8f6c\u79d1\u6210\u529f\uff01", (Object)this.inpatRegistService.toAnotherDepartment(inpatRegist));
    }

    @PostMapping(value={"/queryInpatPageList"})
    @ApiOperation(value="\u4f4f\u9662\u60a3\u8005\u67e5\u8be2(\u5728\u9662\u6216\u5386\u53f2\u60a3\u8005)")
    public ResponseData<Page<InpatRegist>> queryInpatPageList(@RequestBody QueryInpatPageListDTO param) {
        Page inpatRegistPage = this.inpatRegistService.queryInpatPageList(param);
        return ResponseData.success((Object)inpatRegistPage);
    }
}

