/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.model.InpatWardBed;
import com.byh.inpatient.api.model.dto.InpatWardBedDTO;
import com.byh.inpatient.api.model.vo.InpatWardBedFeeInfoVO;
import com.byh.inpatient.api.model.vo.WristbandCardPrintVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.web.service.IInpatWardBedService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inpatWardBed"})
public class InpatWardBedController {
    @Autowired
    private IInpatWardBedService inpatWardBedService;

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u5e8a\u4f4d")
    public ResponseData<InpatWardBed> save(@Valid @RequestBody InpatWardBedDTO param) {
        InpatWardBed inpatWardBed = this.inpatWardBedService.saveWardBed(param);
        return ResponseData.success((Object)inpatWardBed);
    }

    @ApiOperation(value="\u4fee\u6539\u5e8a\u4f4d\u4fe1\u606f")
    @PostMapping(value={"/updateWardBedInfo"})
    public ResponseData<InpatWardBed> updateWardBedInfo(@RequestBody InpatWardBed inpatWardBed) {
        return ResponseData.success((String)"\u4fee\u6539\u5e8a\u4f4d\u4fe1\u606f\u6210\u529f", (Object)this.inpatWardBedService.updateWardBedInfo(inpatWardBed));
    }

    @ApiOperation(value="\u83b7\u53d6\u5e8a\u4f4d\u5217\u8868")
    @GetMapping(value={"/list"})
    public ResponseData<List<InpatWardBed>> updateWardBedInfo(@RequestParam(value="wardId") Integer wardId) {
        return ResponseData.success((Object)this.inpatWardBedService.selectWardBedByWardId(wardId));
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u5e8a\u4f4d")
    public ResponseData delete(@PathVariable Integer id) {
        try {
            boolean inpatWardBed = this.inpatWardBedService.removeById((Serializable)id);
            Assert.isTrue((boolean)inpatWardBed, (String)"\u5220\u9664\u5931\u8d25!");
            return ResponseData.success();
        }
        catch (Exception ex) {
            return ResponseData.error((String)ex.getMessage());
        }
    }

    @ApiOperation(value="\u4f4f\u9662\u5e8a\u4f4d\u8d39\u7528\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3", notes="\u4f4f\u9662\u5e8a\u4f4d\u8d39\u7528\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3")
    @PostMapping(value={"/list/withOrderItemAndChargeItem"})
    public ResponseData<List<InpatWardBedFeeInfoVO>> selectListWithOrderItemAndChargeItem(@RequestParam(value="inpatWardbedId") String inpatWardbedId) {
        List t = this.inpatWardBedService.selectListWithOrderItemAndChargeItem(inpatWardbedId);
        return ResponseData.success((Object)t);
    }

    @ApiOperation(value="\u8155\u5e26\u6253\u5370")
    @GetMapping(value={"/wristbandCardPrint"})
    public ResponseData<WristbandCardPrintVo> wristbandCardPrint(@RequestParam(value="inpatNo") String inpatNo) {
        return ResponseData.success((Object)this.inpatWardBedService.wristbandCardPrint(inpatNo));
    }
}

