/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.controller;

import com.byh.inpatient.api.model.treatment.QueryInspectDetailResVo;
import com.byh.inpatient.api.model.vo.order.QueryFeeDetailsListVo;
import com.byh.inpatient.api.treatment.QueryItemsDto;
import com.byh.inpatient.api.treatment.SaveTreatmentItemsDto;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.vo.treatment.QueryItemsVo;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.TreatmentItemsService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/treatmentItems"})
public class TreatmentItemsController {
    @Autowired
    private TreatmentItemsService treatmentItemsService;
    @Autowired
    private CommonRequest commonRequest;

    @PostMapping(value={"/v1/queryItems"})
    @Operation(description="\u4f4f\u9662\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @ApiOperation(value="\u4f4f\u9662\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868", httpMethod="POST", notes="\u4f4f\u9662\u53f7\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    public ResponseData<List<QueryItemsVo>> queryItems(@RequestBody @Valid QueryItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItems(parameter);
    }

    @PostMapping(value={"/v1/queryItemsDetails"})
    @Operation(description="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    @ApiOperation(value="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5", httpMethod="POST", notes="\u9879\u76eeid\u67e5\u8be2\u8be6\u60c5")
    public ResponseData<List<QueryFeeDetailsListVo>> queryItemsDetails(@RequestBody @Valid QueryItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryItemsDetails(parameter);
    }

    @PostMapping(value={"/v1/saveTreatmentItems"})
    @Operation(description="\u4fdd\u5b58\u6cbb\u7597\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee")
    @ApiOperation(value="\u4fdd\u5b58\u6cbb\u7597\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee", httpMethod="POST", notes="\u4fdd\u5b58\u6cbb\u7597\u68c0\u9a8c\u68c0\u67e5\u9879\u76ee")
    public ResponseData<String> saveTreatmentItems(@RequestBody @Valid SaveTreatmentItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        parameter.setOperatorId(this.commonRequest.getUserId());
        parameter.setOperatorName(this.commonRequest.getUserName());
        return this.treatmentItemsService.saveTreatmentItems(parameter);
    }

    @PostMapping(value={"/v1/voidItems"})
    @Operation(description="\u9879\u76eeid\u4f5c\u5e9f")
    @ApiOperation(value="\u9879\u76eeid\u4f5c\u5e9f", httpMethod="POST", notes="\u9879\u76eeid\u4f5c\u5e9f")
    public ResponseData<String> voidItems(@RequestBody @Valid QueryItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.voidItems(parameter);
    }

    @PostMapping(value={"/v1/queryInspectDetail"})
    @Operation(description="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868")
    @ApiOperation(value="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868", httpMethod="POST", notes="\u5386\u53f2\u68c0\u6d4b\u68c0\u9a8c\u5217\u8868")
    public ResponseData<QueryInspectDetailResVo> queryInspectDetail(@RequestBody @Valid QueryItemsDto parameter) {
        parameter.setTenantId(this.commonRequest.getTenant());
        return this.treatmentItemsService.queryInspectDetail(parameter);
    }
}

