/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.mvc.redis;

import com.byh.inpatient.api.exception.BusinessException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisInpatNoGenerator {
    private static final Logger log = LoggerFactory.getLogger(RedisInpatNoGenerator.class);
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public String generateInpatNo() {
        RLock inpatNoLock = this.redissonClient.getLock("inpatNoLock");
        boolean isLock = false;
        try {
            inpatNoLock.lock();
            isLock = true;
            LocalDateTime now = LocalDateTime.now();
            String key = new SimpleDateFormat("yyyyMMdd").format(new Date());
            if (this.redisTemplate.opsForValue().get((Object)key) == null) {
                LocalDateTime nextMidnight = now.toLocalDate().plusDays(1L).atStartOfDay();
                long secondsUntilMidnight = Duration.between(now, nextMidnight).getSeconds();
                this.redisTemplate.opsForValue().set((Object)key, (Object)0, secondsUntilMidnight, TimeUnit.SECONDS);
            }
            Long num = this.redisTemplate.opsForValue().increment((Object)key, 1L);
            String string = String.format("%s%04d", key, num);
            return string;
        }
        catch (Exception e) {
            throw new BusinessException("\u751f\u6210\u4f4f\u9662\u53f7\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (isLock) {
                inpatNoLock.unlock();
            }
        }
    }
}

