/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.model.InpatMedicalRecord;
import com.byh.inpatient.api.model.InpatMedicalRecordDiag;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.HistoricalDiagDTO;
import com.byh.inpatient.api.model.dto.InpatDiagnosisDto;
import com.byh.inpatient.api.model.dto.InpatMedicalRecordDTO;
import com.byh.inpatient.api.model.vo.AdmissionDiagListVO;
import com.byh.inpatient.api.model.vo.AdmissionDiagVO;
import com.byh.inpatient.api.model.vo.HistoryDiagVO;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.api.util.ExceptionUtils;
import com.byh.inpatient.data.repository.InpatMedicalRecordDiagMapper;
import com.byh.inpatient.data.repository.InpatMedicalRecordMapper;
import com.byh.inpatient.web.service.IInpatMedicalRecordService;
import com.byh.inpatient.web.service.IInpatRegistService;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatMedicalRecordServiceImpl
extends ServiceImpl<InpatMedicalRecordMapper, InpatMedicalRecord>
implements IInpatMedicalRecordService {
    @Autowired
    InpatMedicalRecordMapper inpatMedicalRecordMapper;
    @Autowired
    InpatMedicalRecordDiagMapper inpatMedicalRecordDiagMapper;
    @Autowired
    IInpatRegistService iInpatRegistService;
    private Logger logger = LoggerFactory.getLogger(InpatMedicalRecordServiceImpl.class);

    public List<AdmissionDiagListVO> getAdmissionDiagList(Integer doctorId, String search, String inHospFlag) {
        Assert.notNull((Object)doctorId, (String)"\u5f53\u524d\u533b\u751f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.inpatMedicalRecordMapper.queryAdmissionDiagList(doctorId, search, inHospFlag);
    }

    @Transactional(rollbackFor={BusinessException.class})
    public void saveOrUpdateAdmissionDiag(InpatMedicalRecordDTO inpatMedicalRecordDTO) {
        Integer mainDiagCount;
        List diagnosisDtoList;
        List dbDiagList;
        String inpatNo = inpatMedicalRecordDTO.getInpatNo();
        Integer tenantId = inpatMedicalRecordDTO.getTenantId();
        Integer createId = inpatMedicalRecordDTO.getCreateId();
        String createName = inpatMedicalRecordDTO.getCreateName();
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(inpatMedicalRecordDTO.getInpatNo());
        if (inpatRegist == null) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4fdd\u5b58\u5165\u9662\u8bca\u65ad\u65f6\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f\uff01");
        }
        if (!(dbDiagList = (diagnosisDtoList = inpatMedicalRecordDTO.getDiagnosis()).stream().collect(Collectors.groupingBy(InpatDiagnosisDto::getDiagCode, Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                return ((InpatDiagnosisDto)list.get(0)).getDiagName();
            }
            return null;
        }))).entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("diagCode", entry.getKey());
            map.put("diagName", entry.getValue());
            return map;
        }).collect(Collectors.toList())).isEmpty()) {
            String errorDetails = dbDiagList.stream().map(errorMap -> String.format("\uff08%s\u3001%s\uff09", errorMap.get("diagCode"), errorMap.get("diagName"))).collect(Collectors.joining());
            String errorMessage = "\u4fdd\u5b58\u5165\u9662\u8bca\u65ad\u65f6\uff0c\u5b58\u5728\u91cd\u590d\u7684\u8bca\u65ad\uff01" + errorDetails;
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)errorMessage);
        }
        if ((mainDiagCount = Integer.valueOf(diagnosisDtoList.stream().mapToInt(dto -> Integer.valueOf(1).equals(dto.getIsMainDiag()) ? 1 : 0).sum())) == 0) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4fdd\u5b58\u5165\u9662\u8bca\u65ad\u65f6\uff0c\u7f3a\u5c11\u4e3b\u8bca\u65ad\uff01");
        }
        if (mainDiagCount > 1) {
            ExceptionUtils.createException((Logger)this.logger, (boolean)true, (String)"500", (String)"\u4fdd\u5b58\u5165\u9662\u8bca\u65ad\u65f6\uff0c\u5b58\u5728\u591a\u4e2a\u4e3b\u8bca\u65ad\uff01");
        }
        InpatMedicalRecord inpatMedicalRecord = new InpatMedicalRecord();
        BeanUtil.copy((Object)inpatMedicalRecordDTO, (Object)inpatMedicalRecord);
        inpatMedicalRecord.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
        inpatMedicalRecord.setStatus("1");
        inpatMedicalRecord.setDoctorId(inpatRegist.getInpatDoctorId());
        inpatMedicalRecord.setDoctorName(inpatRegist.getInpatDoctorName());
        inpatMedicalRecord.setDeptId(inpatRegist.getDeptId());
        inpatMedicalRecord.setDeptName(inpatRegist.getDeptName());
        inpatMedicalRecord.setPatientName(inpatRegist.getPatientName());
        inpatMedicalRecord.setPatientCardNo(inpatRegist.getCardNo());
        if (inpatMedicalRecordDTO.getId() == null) {
            this.inpatMedicalRecordMapper.insert((Object)inpatMedicalRecord);
        } else {
            this.inpatMedicalRecordMapper.updateById((Object)inpatMedicalRecord);
            this.inpatMedicalRecordDiagMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecordDiag::getInpatMedicalRecordId, (Object)inpatMedicalRecord.getId()));
        }
        List inpatMedicalRecordDiagList = diagnosisDtoList.stream().map(entity -> {
            InpatMedicalRecordDiag medicalRecordDiag = new InpatMedicalRecordDiag();
            BeanUtil.copy((Object)entity, (Object)medicalRecordDiag);
            medicalRecordDiag.setInpatMedicalRecordId(inpatMedicalRecord.getId());
            medicalRecordDiag.setInpatNo(inpatNo);
            medicalRecordDiag.setTenantId(tenantId);
            medicalRecordDiag.setCreateId(createId);
            medicalRecordDiag.setCreateName(createName);
            return medicalRecordDiag;
        }).collect(Collectors.toList());
        this.inpatMedicalRecordDiagMapper.insertList(inpatMedicalRecordDiagList);
    }

    public AdmissionDiagVO getAdmissionDiagByInpatNo(String inpatNo) {
        Assert.hasText((String)inpatNo, (String)"\u4f4f\u9662\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AdmissionDiagVO admissionDiagVO = new AdmissionDiagVO();
        try {
            InpatMedicalRecord inpatMedicalRecord = (InpatMedicalRecord)this.inpatMedicalRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecord::getInpatNo, (Object)inpatNo)).eq(InpatMedicalRecord::getStatus, (Object)"1"));
            BeanUtil.copy((Object)inpatMedicalRecord, (Object)admissionDiagVO);
            List inpatMedicalRecordDiag = this.inpatMedicalRecordDiagMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatMedicalRecordDiag::getInpatNo, (Object)inpatNo)).eq(InpatMedicalRecordDiag::getInpatMedicalRecordId, (Object)inpatMedicalRecord.getId()));
            admissionDiagVO.setDiagnosis(inpatMedicalRecordDiag);
        }
        catch (Exception e) {
            return admissionDiagVO;
        }
        return admissionDiagVO;
    }

    public Page<HistoryDiagVO> getHistoryDiagList(HistoricalDiagDTO param) {
        Assert.hasText((String)param.getPatientName(), (String)"\u60a3\u8005\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasText((String)param.getCardNo(), (String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Page page = new Page((long)param.getCurrent().intValue(), (long)param.getSize().intValue());
        return this.inpatMedicalRecordMapper.getHIsDiagList(page, param);
    }
}

