/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.dto.medicalRecord.OutpatientInfomationDto;
import com.byh.inpatient.api.dto.order.SaveOrderDto;
import com.byh.inpatient.api.dto.prescription.InpatPrescriptionDto;
import com.byh.inpatient.api.dto.prescription.InpatPrescriptionRecordDto;
import com.byh.inpatient.api.dto.prescription.SavePrescriptionDrugsDto;
import com.byh.inpatient.api.dto.prescription.SavePrescriptionDto;
import com.byh.inpatient.api.enums.ApplyStatusEnum;
import com.byh.inpatient.api.enums.ApplyTypeEnum;
import com.byh.inpatient.api.enums.GenderEnum;
import com.byh.inpatient.api.enums.InpatpatientDataStatusEnum;
import com.byh.inpatient.api.enums.MedicalInsuranceTypeEnum;
import com.byh.inpatient.api.enums.NarratorEnum;
import com.byh.inpatient.api.enums.OrderStatusEnum;
import com.byh.inpatient.api.enums.OrderTypeEnum;
import com.byh.inpatient.api.enums.PrescriptionTypeEnum;
import com.byh.inpatient.api.enums.ProjectDetailsStatusEnum;
import com.byh.inpatient.api.enums.RationalDrugUseEnum;
import com.byh.inpatient.api.enums.YesNoEnum;
import com.byh.inpatient.api.model.InpatMedicalRecordDiag;
import com.byh.inpatient.api.model.InpatOrderDrugEntity;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.PatientEntity;
import com.byh.inpatient.api.model.order.InpatOrder;
import com.byh.inpatient.api.model.prescription.InpatPrescription;
import com.byh.inpatient.api.model.prescription.InpatPrescriptionDrug;
import com.byh.inpatient.api.model.vo.AdmissionDiagVO;
import com.byh.inpatient.api.model.vo.prescription.QueryPrescriptionsVo;
import com.byh.inpatient.api.model.vo.prescription.QueryWesternMedicinePrescriptionsVo;
import com.byh.inpatient.api.model.vo.prescription.WesternMedicinePrescriptionsVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.AdviceVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.CheckInputVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.DataInfo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.DiagnosisesVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.DoctorVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.PatientVo;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.RationDrugUseResponse;
import com.byh.inpatient.api.model.vo.thirdUseDrugVerify.RationDrugUseVo;
import com.byh.inpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.inpatient.api.sysModel.request.SysDoctorDto;
import com.byh.inpatient.api.sysModel.request.SysEasyEntity;
import com.byh.inpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.inpatient.api.sysModel.respones.SysDoctorIdVo;
import com.byh.inpatient.api.sysModel.respones.SysDrugPharmacySimpleVo;
import com.byh.inpatient.api.util.DateUtils;
import com.byh.inpatient.api.util.ExceptionUtils;
import com.byh.inpatient.api.util.HttpUtils;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.data.repository.InpatOrderDrugMapper;
import com.byh.inpatient.data.repository.InpatOrderMapper;
import com.byh.inpatient.data.repository.InpatPrescriptionMapper;
import com.byh.inpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.inpatient.data.repository.PatientMapper;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.DrugPropertiesEnum;
import com.byh.inpatient.web.mvc.enums.InpatPrescriptionRecordEnum;
import com.byh.inpatient.web.mvc.enums.InsurancePrescriptionTypeEnum;
import com.byh.inpatient.web.mvc.enums.PrescriptionStatusEnum;
import com.byh.inpatient.web.mvc.exception.RunDisplayException;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.mvc.utils.UUIDUtils;
import com.byh.inpatient.web.service.IInpatMedicalRecordService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.InpatOrderService;
import com.byh.inpatient.web.service.InpatPrescriptionService;
import com.byh.inpatient.web.service.OutPrescriptionDrugService;
import com.byh.inpatient.web.service.OutPrescriptionRecordService;
import com.ebaiyihui.framework.utils.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InpatPrescriptionServiceImpl
implements InpatPrescriptionService {
    public static final int ZERO = 0;
    @Autowired
    private InpatPrescriptionMapper inpatPrescriptionMapper;
    @Autowired
    IInpatRegistService iInpatRegistService;
    @Autowired
    private InpatOrderMapper inpatOrderMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    PatientMapper patientMapper;
    @Autowired
    CommonRequest commonRequest;
    @Autowired
    IInpatMedicalRecordService inpatMedicalRecordService;
    @Autowired
    private OutPrescriptionDrugService outPrescriptionDrugService;
    @Autowired
    private OutPrescriptionRecordService outPrescriptionRecordService;
    @Autowired
    private InpatOrderService inpatOrderService;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Resource
    private InpatOrderDrugMapper inpatOrderDrugMapper;
    @Value(value="${remote.rationalDrugUseUrl}")
    private String rationalDrugUseUrl;
    private static Logger log = LoggerFactory.getLogger(InpatPrescriptionServiceImpl.class);

    public ResponseData<QueryWesternMedicinePrescriptionsVo> queryPrescriptions(OutpatientInfomationDto parameter) {
        QueryWesternMedicinePrescriptionsVo query = new QueryWesternMedicinePrescriptionsVo();
        List prescriptionsVos = this.inpatPrescriptionMapper.queryWesternMedicinePrescriptions(parameter.getDeliveryStatus(), parameter.getTenantId(), parameter.getInpatNo(), parameter.getPrescriptionType(), null, null, null);
        if (CollectionUtils.isEmpty((Collection)prescriptionsVos)) {
            return ResponseData.success((Object)query);
        }
        List prescriptionNos = prescriptionsVos.stream().map(WesternMedicinePrescriptionsVo::getPrescriptionNo).collect(Collectors.toList());
        ArrayList<String> orderType = new ArrayList<String>();
        orderType.add(OrderTypeEnum.PRESCRIPTION_WESTERN_MEDICINE_ORDERS.getValue());
        orderType.add(OrderTypeEnum.REGISTERED_TRADITIONAL_ORDERS.getValue());
        orderType.add(OrderTypeEnum.REGISTERED_CHINESE_PATENT_DRUG_ORDERS.getValue());
        List orderListByPrescriptionNos = this.inpatOrderService.getOrderListByPrescriptionNos(orderType, prescriptionNos);
        Map orderListByPrescription = orderListByPrescriptionNos.stream().collect(Collectors.toMap(InpatOrder::getPrescriptionNo, Function.identity()));
        for (WesternMedicinePrescriptionsVo prescriptions : prescriptionsVos) {
            InpatOrder order = (InpatOrder)orderListByPrescription.get(prescriptions.getPrescriptionNo());
            if (Objects.isNull(order)) {
                return ResponseData.error((String)"\u5904\u65b9\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38\uff01");
            }
            prescriptions.setMedicationTabooList(JSON.parseArray((String)prescriptions.getMedicationTaboo(), String.class));
            prescriptions.setMedicationTabooCodeList(JSON.parseArray((String)prescriptions.getMedicationTabooCode(), String.class));
            prescriptions.setMedicationTaboo(null);
            prescriptions.setMedicationTabooCode(null);
        }
        BigDecimal totalPrescription = prescriptionsVos.stream().map(WesternMedicinePrescriptionsVo::getTotalPrescriptionAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalDrugs = prescriptionsVos.stream().map(WesternMedicinePrescriptionsVo::getTotalDrugsAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalDecoction = prescriptionsVos.stream().map(WesternMedicinePrescriptionsVo::getTotalDecoctionAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        query.setTotalPrescriptionAmount(totalPrescription);
        query.setTotalDrugsAmount(totalDrugs);
        query.setTotalDecoctionAmount(totalDecoction);
        query.setPrescriptionList(prescriptionsVos);
        return ResponseData.success((Object)query);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<RationDrugUseVo> savePrescription(SavePrescriptionDto parameter) {
        ResponseData responseData;
        log.info("\u4fdd\u5b58\u5904\u65b9-->\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)parameter));
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(parameter.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        Boolean inventoryFlag = Boolean.TRUE;
        this.obtainingDrugInformation(parameter, inventoryFlag);
        ResponseData stringResponseData = this.buildPrescriptionParameter(parameter, inpatRegist);
        if (!ResponseData.ResponseEnum.SUCCESS.getCode().equals(stringResponseData.getCode())) {
            log.info("\u5408\u7406\u7528\u836f\u63a5\u53e3\u53c2\u6570\u7ec4\u88c5\u5931\u8d25:{}", (Object)stringResponseData);
            return ResponseData.error((String)stringResponseData.getCode(), (String)stringResponseData.getMsg());
        }
        if (RationalDrugUseEnum.CHECK.getValue().equals(parameter.getTag()) && !(responseData = this.rationalDrugUse((String)stringResponseData.getData(), parameter.getTag())).isSuccess()) {
            return responseData;
        }
        Map<String, List<SavePrescriptionDrugsDto>> groupedByType = parameter.getDrugList().stream().collect(Collectors.groupingBy(SavePrescriptionDrugsDto::getDrugsType));
        boolean isFirst = true;
        for (Map.Entry<String, List<SavePrescriptionDrugsDto>> entry : groupedByType.entrySet()) {
            parameter.setDrugList(entry.getValue());
            if (isFirst && !StringUtils.isEmpty((CharSequence)parameter.getPrescriptionNo())) {
                this.updatePrescription(entry.getKey(), parameter, inpatRegist);
            } else {
                this.insertPrescription(entry.getKey(), parameter, inpatRegist);
            }
            isFirst = false;
        }
        String submitData = this.buildSubmitParameter(parameter, (String)stringResponseData.getData(), RationalDrugUseEnum.SUBMIT.getValue());
        ResponseData responseData2 = this.rationalDrugUse(submitData, parameter.getTag());
        if (responseData2.isSuccess()) {
            String rationalCode = ((RationDrugUseVo)responseData2.getData()).getData();
            rationalCode = StringUtil.isEmpty((String)rationalCode) ? "-1" : rationalCode;
            this.inpatPrescriptionMapper.updateRationCodeById(parameter.getPrescriptionNo(), YesNoEnum.YES.getValue(), rationalCode);
            return ResponseData.success((String)parameter.getPrescriptionNo(), (Object)responseData2.getData());
        }
        log.error("\u5408\u7406\u7528\u836f\u63d0\u4ea4\u5931\u8d25:{}", (Object)responseData2);
        return ResponseData.success((String)parameter.getPrescriptionNo(), (Object)responseData2.getData());
    }

    private void saveInpatOrderDrug(Integer tenantId, String inpatNo, String prescNo, Integer operatorId, String operatorName, Integer operatorDeptId, String operatorDeptName, Integer operatorWardId, String operatorWardName, String prescriptionType, List<SavePrescriptionDrugsDto> prescDrugList, boolean operateFlag) {
        List oldOrderDrugList;
        String errorStatusCode;
        if (prescDrugList != null && prescDrugList.isEmpty() && operateFlag) {
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)"\u4f4f\u9662\u5904\u65b9\u5f00\u7acb\u65f6\uff0c\u4f20\u9012\u7684\u836f\u54c1\u96c6\u5408\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StrUtil.isNotEmpty((CharSequence)(errorStatusCode = (oldOrderDrugList = this.inpatOrderDrugMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getInpatNo, (Object)inpatNo)).eq(InpatOrderDrugEntity::getPrescriptionNo, (Object)prescNo))).stream().map(InpatOrderDrugEntity::getStatusCode).filter(statusCode -> !ApplyStatusEnum.PRIMED_MEDICINE.getValue().equals(statusCode)).findFirst().orElse("")))) {
            String errorStatusName = Optional.ofNullable(ApplyStatusEnum.getEnumLabel((String)errorStatusCode)).map(ApplyStatusEnum::getLabel).orElse("");
            String errorInfo = String.format("\u4f4f\u9662\u5904\u65b9\u5f00\u7acb\u65f6\uff0c\u8be5\u5904\u65b9\u72b6\u6001\u7f16\u7801\u5f02\u5e38\uff01\u5e94\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff01\u5b9e\u9645\u4e3a\uff1a\uff08%s\u3001%s\uff09\uff01", ApplyStatusEnum.PRIMED_MEDICINE.getValue(), ApplyStatusEnum.PRIMED_MEDICINE.getLabel(), errorStatusCode, errorStatusName);
            ExceptionUtils.createException((Logger)log, (boolean)true, (String)"500", (String)errorInfo);
        }
        this.inpatOrderDrugMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(InpatOrderDrugEntity::getTenantId, (Object)tenantId)).eq(InpatOrderDrugEntity::getInpatNo, (Object)inpatNo)).eq(InpatOrderDrugEntity::getPrescriptionNo, (Object)prescNo));
        if (operateFlag) {
            ArrayList<InpatOrderDrugEntity> orderDrugList = new ArrayList<InpatOrderDrugEntity>();
            for (SavePrescriptionDrugsDto drug : prescDrugList) {
                InpatOrderDrugEntity orderDrug = new InpatOrderDrugEntity();
                orderDrug.setTenantId(tenantId);
                orderDrug.setCreateId(operatorId);
                orderDrug.setCreateName(operatorName);
                orderDrug.setInpatNo(inpatNo);
                orderDrug.setDeptId(operatorDeptId);
                orderDrug.setDeptName(operatorDeptName);
                orderDrug.setWardId(operatorWardId);
                orderDrug.setWardName(operatorWardName);
                orderDrug.setApplyTypeCode(ApplyTypeEnum.DISPENSE_MEDICINE.getValue());
                orderDrug.setApplyTypeName(ApplyTypeEnum.DISPENSE_MEDICINE.getLabel());
                orderDrug.setDrugNo(drug.getDrugNo());
                orderDrug.setDrugName(drug.getDrugName());
                orderDrug.setDrugSpec(drug.getSpecification());
                BigDecimal applyBackNum = drug.getQuantity();
                orderDrug.setApplyBackNum(applyBackNum);
                orderDrug.setApplyBackUnit(drug.getQuantityUnitCode());
                BigDecimal drugPrice = drug.getRetailPrice();
                orderDrug.setDrugPrice(drugPrice);
                BigDecimal drugAmount = drugPrice.multiply(applyBackNum);
                orderDrug.setDrugAmount(drugAmount);
                orderDrug.setWarehouseId(drug.getPharmacyId());
                orderDrug.setWarehouseName(drug.getPharmacyName());
                orderDrug.setStatusCode(ApplyStatusEnum.PRIMED_MEDICINE.getValue());
                orderDrug.setStatusName(ApplyStatusEnum.PRIMED_MEDICINE.getLabel());
                orderDrug.setLongTempFlag(drug.getPrescriptionType());
                orderDrug.setType(prescriptionType);
                orderDrug.setPrescriptionNo(prescNo);
                orderDrugList.add(orderDrug);
            }
            this.inpatOrderDrugMapper.insertList(orderDrugList);
        }
    }

    public ResponseData<String> buildPrescriptionParameter(SavePrescriptionDto parameter, InpatRegist inpatRegist) {
        SysDoctorDto sysDoctorDto = new SysDoctorDto();
        sysDoctorDto.setId(parameter.getPrescribingDoctorId());
        ResponseData sysDoctorIdVoResponseData = this.sysServiceFeign.doctorById(sysDoctorDto);
        if (Objects.isNull(sysDoctorIdVoResponseData) || !sysDoctorIdVoResponseData.isSuccess()) {
            return ResponseData.error((String)"\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u5931\u8d25{}", (String)JSONObject.toJSONString((Object)sysDoctorIdVoResponseData));
        }
        SysDoctorIdVo sysDoctorIdVo = (SysDoctorIdVo)sysDoctorIdVoResponseData.getData();
        DoctorVo doctorVo = new DoctorVo();
        doctorVo.setPosition(sysDoctorIdVo.getDoctorTitle());
        doctorVo.setName(sysDoctorIdVo.getUserName());
        doctorVo.setUser_id(parameter.getOperatorId() + "");
        doctorVo.setDept_code(sysDoctorIdVo.getDepartmentId());
        doctorVo.setDept_name(sysDoctorIdVo.getDepartmentName());
        PatientEntity patientEntity = this.patientMapper.queryPatientByCardNoAndTenantId(inpatRegist.getCardNo(), this.commonRequest.getTenant());
        if (ObjectUtil.isNull((Object)patientEntity)) {
            return ResponseData.error((String)"\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u5931\u8d25");
        }
        AdmissionDiagVO admissionDiagByInpatNo = this.inpatMedicalRecordService.getAdmissionDiagByInpatNo(inpatRegist.getInpatNo());
        if (Objects.isNull(admissionDiagByInpatNo)) {
            return ResponseData.error((String)"\u8bf7\u5148\u5f00\u75c5\u5386\uff0c\u518d\u6dfb\u52a0\u5904\u65b9\u4fe1\u606f");
        }
        String allergyHistoryStr = "";
        if (!StringUtils.isEmpty((CharSequence)admissionDiagByInpatNo.getAllergyHistory())) {
            allergyHistoryStr = admissionDiagByInpatNo.getAllergyHistory();
        }
        PatientVo patientVo = new PatientVo();
        patientVo.setName(patientEntity.getName());
        patientVo.setId(patientEntity.getId() + "");
        patientVo.setGender(GenderEnum.getEnum((Integer)Integer.valueOf(patientEntity.getSex())).getDesc());
        patientVo.setBirth(patientEntity.getBirthday().replace("-", ""));
        patientVo.setHeight("");
        patientVo.setWeight("");
        patientVo.setAlergy_drugs(allergyHistoryStr);
        patientVo.setPatient_pres_id(parameter.getPrescriptionNo());
        if (RationalDrugUseEnum.CHECK.getValue().equals(parameter.getTag()) && StringUtils.isEmpty((CharSequence)parameter.getPrescriptionNo())) {
            patientVo.setPatient_pres_id(inpatRegist.getOutpatientNo());
        }
        patientVo.setIdentity_type(Objects.nonNull(admissionDiagByInpatNo.getNarratorTypeCode()) ? NarratorEnum.getEnum((Integer)admissionDiagByInpatNo.getNarratorTypeCode()).getDesc() : "");
        patientVo.setFee_type("\u81ea\u8d39");
        if (StringUtils.isNotEmpty((CharSequence)inpatRegist.getPatientType())) {
            patientVo.setFee_type(MedicalInsuranceTypeEnum.getEnum((Integer)new Integer(inpatRegist.getPatientType())).getDesc());
        }
        patientVo.setDrug_history(admissionDiagByInpatNo.getPresentMedicalHistory());
        patientVo.setVisit_id(inpatRegist.getOutpatientNo());
        DiagnosisesVo diagnosisesVo = new DiagnosisesVo();
        if (CollectionUtils.isEmpty((Collection)admissionDiagByInpatNo.getDiagnosis())) {
            return ResponseData.error((String)"\u8bca\u65ad\u4fe1\u606f\u4e3a\u7a7a");
        }
        String result = admissionDiagByInpatNo.getDiagnosis().stream().map(InpatMedicalRecordDiag::getDiagName).collect(Collectors.joining(","));
        diagnosisesVo.setDiagnosises(result);
        List drugList = parameter.getDrugList();
        ArrayList<AdviceVo> adviceVos = new ArrayList<AdviceVo>(drugList.size());
        Map<Object, Object> sysDrugDoseFormMap = new HashMap();
        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
        sysDictValueDTO.setType("we_dosage_form");
        sysDictValueDTO.setCurrent(1);
        sysDictValueDTO.setSize(-1);
        ResponseData sysDictValueVoResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, String.valueOf(parameter.getTenantId()));
        if (Objects.isNull(sysDictValueVoResponseData) || !sysDictValueVoResponseData.isSuccess()) {
            log.error("\u5242\u578b\u67e5\u8be2\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)sysDictValueVoResponseData));
            throw new RunDisplayException("\u836f\u54c1\u5242\u578b\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        List dictValueVoList = ((Page)sysDictValueVoResponseData.getData()).getRecords();
        if (CollectionUtils.isEmpty((Collection)dictValueVoList)) {
            log.error("\u5242\u578b\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)dictValueVoList));
            throw new RunDisplayException("\u836f\u54c1\u5242\u578b\u4fe1\u606f\u67e5\u8be2\u7f3a\u5931\uff01");
        }
        sysDrugDoseFormMap = dictValueVoList.stream().collect(Collectors.toMap(SysDictValueVo::getValue, Function.identity()));
        int i = 1;
        for (SavePrescriptionDrugsDto savePrescriptionDrugsDto : drugList) {
            AdviceVo adviceVo = new AdviceVo();
            adviceVo.setDrug_lo_name(savePrescriptionDrugsDto.getDrugName());
            adviceVo.setDrug_lo_id(savePrescriptionDrugsDto.getInternalCode());
            adviceVo.setAdministration(savePrescriptionDrugsDto.getDrugUsage());
            adviceVo.setDosage(savePrescriptionDrugsDto.getSingleDose() + "");
            adviceVo.setDosage_unit(savePrescriptionDrugsDto.getDoseUnit() + "");
            adviceVo.setFreq_count(savePrescriptionDrugsDto.getFrequencyCode());
            adviceVo.setCourse(String.valueOf(savePrescriptionDrugsDto.getMedicationDays()));
            adviceVo.setPkg_unit(savePrescriptionDrugsDto.getQuantityUnit());
            adviceVo.setDrug_remark(savePrescriptionDrugsDto.getSpecialNotes());
            adviceVo.setGroup_id(Objects.isNull(savePrescriptionDrugsDto.getGroupNo()) ? "" : savePrescriptionDrugsDto.getGroupNo() + "");
            if (!PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(parameter.getPrescriptionType())) {
                adviceVo.setFreq_count("\u6bcf\u65e5" + parameter.getDailyFrequency() + "\u6b21");
                adviceVo.setAdministration(parameter.getUsageName());
                adviceVo.setCourse(parameter.getDosage() + "");
                adviceVo.setDosage(savePrescriptionDrugsDto.getQuantity() + "");
                adviceVo.setDosage_unit(savePrescriptionDrugsDto.getPackSmallUnitsLabel());
                adviceVo.setPkg_unit("\u5242");
                adviceVo.setGroup_id("1");
                adviceVo.setDrug_remark(parameter.getMedicationTime());
            }
            adviceVo.setStart_day(DateUtils.dateFormat((Date)new Date(), (String)"yyyyMMdd"));
            adviceVo.setDept_code(String.valueOf(inpatRegist.getDeptId()));
            adviceVo.setUser_id(doctorVo.getUser_id());
            adviceVo.setDoctor_name(doctorVo.getName());
            adviceVo.setTitle(doctorVo.getPosition());
            adviceVo.setOrder_no(String.valueOf(i));
            adviceVo.setOrder_sub_no(String.valueOf(i));
            adviceVo.setPres_id(patientVo.getPatient_pres_id());
            adviceVo.setPres_date(DateUtils.dateFormat((Date)new Date(), (String)"yyyyMMdd"));
            adviceVo.setPres_seq_id(patientVo.getPatient_pres_id());
            adviceVo.setPkg_count(savePrescriptionDrugsDto.getQuantity() + "");
            adviceVo.setBak_02(YesNoEnum.NO.getName());
            SysDictValueVo sysDictValueVo = (SysDictValueVo)sysDrugDoseFormMap.get(savePrescriptionDrugsDto.getDosageForm());
            adviceVo.setBak_03(Objects.nonNull(sysDictValueVo) ? sysDictValueVo.getLabel() : "");
            adviceVo.setBak_04(savePrescriptionDrugsDto.getSpecification());
            adviceVo.setBak_05(savePrescriptionDrugsDto.getManufacturer());
            adviceVo.setSkin_test("\u5426");
            if (!Objects.isNull(savePrescriptionDrugsDto.getIsSkinTest()) && YesNoEnum.YES.getValue() != savePrescriptionDrugsDto.getIsSkinTest().intValue()) {
                adviceVo.setSkin_test("\u662f");
            }
            adviceVo.setSkin_test_result(Objects.isNull(savePrescriptionDrugsDto.getSkinTestResult()) ? "" : savePrescriptionDrugsDto.getSkinTestResult());
            adviceVo.setPk_order_no(patientVo.getPatient_pres_id());
            adviceVos.add(adviceVo);
            ++i;
        }
        String presType = "0";
        if (!PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(parameter.getPrescriptionType())) {
            presType = "1";
        }
        CheckInputVo checkInputVo = new CheckInputVo();
        checkInputVo.setTag(parameter.getTag());
        checkInputVo.setInpatient(YesNoEnum.NO.getName());
        checkInputVo.setHospital_id(String.valueOf(parameter.getTenantId()));
        checkInputVo.setBranch_id(String.valueOf(parameter.getTenantId()));
        checkInputVo.setPresc_source("3");
        checkInputVo.setPresc_remark(Objects.isNull(parameter.getAdditionalNotes()) ? "" : parameter.getAdditionalNotes());
        checkInputVo.setPresc_type(presType);
        checkInputVo.setDoctor(doctorVo);
        checkInputVo.setPatient(patientVo);
        checkInputVo.setDiagnosis(diagnosisesVo);
        checkInputVo.setAdvices(adviceVos);
        SerializeConfig config = new SerializeConfig();
        String checkInputVoStr = JSON.toJSONString((Object)checkInputVo, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        log.info("\u5408\u7406\u7528\u836f\u51fa\u53c2:{}", (Object)checkInputVoStr);
        return ResponseData.success((String)"", (Object)checkInputVoStr);
    }

    private String buildSubmitParameter(SavePrescriptionDto parameter, String data, String tag) {
        parameter.setTag(tag);
        CheckInputVo checkInputVo = (CheckInputVo)JSON.parseObject((String)data, CheckInputVo.class);
        checkInputVo.setTag(parameter.getTag());
        List advices = checkInputVo.getAdvices();
        for (AdviceVo advice : advices) {
            advice.setPres_id(parameter.getPrescriptionNo());
            advice.setPres_seq_id(parameter.getPrescriptionNo());
            advice.setPk_order_no(parameter.getPrescriptionNo());
        }
        PatientVo patientVo = checkInputVo.getPatient();
        patientVo.setPatient_pres_id(parameter.getPrescriptionNo());
        checkInputVo.setAdvices(advices);
        checkInputVo.setPatient(patientVo);
        String submitData = JSON.toJSONString((Object)checkInputVo);
        return submitData;
    }

    private ResponseData<RationDrugUseVo> rationalDrugUse(String data, String tag) {
        try {
            RationDrugUseVo rationDrugUseVo = new RationDrugUseVo();
            log.info("\u5408\u7406\u7528\u836f\u5165\u53c2 url:{},data:{}", (Object)this.rationalDrugUseUrl, (Object)data);
            String responseStr = HttpUtils.post((String)this.rationalDrugUseUrl, (String)data);
            log.info("\u5408\u7406\u7528\u836f\u51fa\u53c2:{}", (Object)responseStr);
            if (RationalDrugUseEnum.CHECK.getValue().equals(tag)) {
                RationDrugUseResponse rationDrugUseResponse = (RationDrugUseResponse)JSON.parseObject((String)responseStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                if (!rationDrugUseResponse.isFlag()) {
                    return ResponseData.error((String)"\u5408\u7406\u7528\u836f\u5ba1\u6838\u5931\u8d25");
                }
                List list = ((DataInfo)rationDrugUseResponse.getData()).getList();
                ArrayList dataListInfoList = new ArrayList();
                list.forEach(dataListInfo -> {
                    if (!CollectionUtils.isEmpty((Collection)dataListInfo.getCheck_info_list())) {
                        dataListInfoList.add(dataListInfo);
                    }
                });
                if (!CollectionUtils.isEmpty(dataListInfoList)) {
                    rationDrugUseVo.setDataListInfoList(dataListInfoList);
                    return new ResponseData(ResponseData.ResponseEnum.BAD_REQUEST.getCode(), "\u5408\u7406\u7528\u836f\u5ba1\u6838\u4e0d\u901a\u8fc7", (Object)rationDrugUseVo);
                }
                return ResponseData.success((String)"\u5408\u7406\u7528\u836f\u5ba1\u6838\u6210\u529f", (Object)rationDrugUseVo);
            }
            if (RationalDrugUseEnum.SUBMIT.getValue().equals(tag)) {
                RationDrugUseResponse rationDrugUseResponse = (RationDrugUseResponse)JSON.parseObject((String)responseStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                if (!rationDrugUseResponse.isFlag()) {
                    log.error("\u5408\u7406\u7528\u836f\u63d0\u4ea4\u5931\u8d25:{}", (Object)responseStr);
                    return ResponseData.error((String)responseStr);
                }
                rationDrugUseVo.setData((String)rationDrugUseResponse.getData());
                return ResponseData.success((Object)rationDrugUseVo);
            }
            return ResponseData.success((Object)rationDrugUseVo);
        }
        catch (Exception e) {
            log.error("\u5408\u7406\u7528\u836f\u8c03\u7528\u5f02\u5e38:{}", (Object)e.getMessage());
            return ResponseData.error((String)e.getMessage());
        }
    }

    private void insertPrescription(String drugsType, SavePrescriptionDto parameter, InpatRegist inpatRegist) {
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9[\u5f00\u59cb]");
        String prescriptionNo = UUIDUtils.getPrescriptionNo();
        String lnventoryNumber = "";
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u751f\u6210\u7684\u5904\u65b9\u7f16\u53f7:{}", (Object)prescriptionNo);
        parameter.setPrescriptionNo(prescriptionNo);
        List outPrescriptionDrugs = this.outPrescriptionDrugService.updatePrescriptionDrugs(parameter);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u5904\u65b9\u836f\u54c1\u66f4\u65b0\u5b8c\u6210-\u5220\u9664\u65e7\u6570\u91cf{}-->>\u5904\u65b9\u7f16\u53f7:{}", (Object)outPrescriptionDrugs.size(), (Object)prescriptionNo);
        lnventoryNumber = this.outPrescriptionDrugService.deductionOfDrugInventoryQuantity(parameter);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9-->>\u6263\u9664\u5e93\u5b58ID{}", (Object)lnventoryNumber);
        InpatPrescription prescription = InpatPrescriptionServiceImpl.assembleInsertPrescription((SavePrescriptionDto)parameter, (InpatRegist)inpatRegist, (String)prescriptionNo, (String)lnventoryNumber);
        int size = this.inpatPrescriptionMapper.insert((Object)prescription);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9[\u7ed3\u675f]=\u6570\u91cf{}", (Object)size);
        SaveOrderDto saveOrderDto = InpatPrescriptionServiceImpl.getSaveOrderDto((SavePrescriptionDto)parameter, (InpatRegist)inpatRegist, (InpatPrescription)prescription);
        this.inpatOrderService.saveOrder(OrderTypeEnum.getEnumByDrugType((String)drugsType), saveOrderDto);
        log.debug("\u4fdd\u5b58\u5904\u65b9-->\u65b0\u589e\u5904\u65b9[\u8ba2\u5355]\u5b8c\u6210");
        this.insertInpatPrescriptionRecord(parameter.getPrescriptionNo(), InpatPrescriptionRecordEnum.PRESCRIPTION_ISSUANCE, parameter.getTenantId(), parameter.getOperatorName(), parameter.getOperatorId());
    }

    private void updatePrescription(String drugsType, SavePrescriptionDto parameter, InpatRegist inpatRegist) {
        log.info("\u66f4\u65b0\u5904\u65b9-->\u5904\u65b9\u4fee\u6539-->>\u67e5\u8be2\u5904\u65b9\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)parameter));
        String lnventoryNumber = "";
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        query.eq((Object)"prescription_no", (Object)parameter.getPrescriptionNo());
        query.eq((Object)"prescription_status", (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
        InpatPrescription prescription = (InpatPrescription)this.inpatPrescriptionMapper.selectOne((Wrapper)query);
        if (prescription == null) {
            throw new RunDisplayException("\u67e5\u8be2\u4e0d\u5230\u5904\u65b9\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue())).eq((Object)"prescription_no", (Object)prescription.getPrescriptionNo());
        InpatOrder order = (InpatOrder)this.inpatOrderMapper.selectOne((Wrapper)queryWrapper);
        if (order == null) {
            throw new RunDisplayException("\u627e\u4e0d\u5230\u8ba2\u5355!");
        }
        log.debug("\u66f4\u65b0\u5904\u65b9-->\u67e5\u8be2\u5230\u5904\u65b9-->>\u4fdd\u5b58\u5904\u65b9\u836f\u54c1-\u83b7\u53d6\u5220\u9664\u7684\u836f\u54c1");
        List outPrescriptionDrugs = this.outPrescriptionDrugService.updatePrescriptionDrugs(parameter);
        log.info("\u66f4\u65b0\u5904\u65b9-->\u66f4\u65b0\u5904\u65b9-->>\u5904\u65b9\u836f\u54c1\u66f4\u65b0\u5b8c\u6210-\u5220\u9664\u65e7\u6570\u91cf{}-->>\u5904\u65b9\u7f16\u53f7:{}", (Object)outPrescriptionDrugs.size(), (Object)prescription.getPrescriptionNo());
        parameter.setPrescriptionNo(prescription.getPrescriptionNo());
        this.outPrescriptionDrugService.returnOfDrugInventoryQuantity(parameter.getPrescriptionNo(), ((SavePrescriptionDrugsDto)parameter.getDrugList().get(0)).getPharmacyId(), parameter.getTenantId());
        log.debug("\u66f4\u65b0\u5904\u65b9-->\u66f4\u65b0\u5904\u65b9-->>\u56de\u9000\u836f\u54c1\u5e93\u5b58\u7ed3\u675f");
        lnventoryNumber = this.outPrescriptionDrugService.deductionOfDrugInventoryQuantity(parameter);
        log.debug("\u66f4\u65b0\u5904\u65b9-->\u66f4\u65b0\u5904\u65b9-->>\u6263\u9664\u5e93\u5b58ID{}", (Object)lnventoryNumber);
        InpatPrescriptionServiceImpl.assembleUpdatePrescription((SavePrescriptionDto)parameter, (InpatPrescription)prescription, (String)lnventoryNumber);
        int size = this.inpatPrescriptionMapper.update((Object)prescription, (Wrapper)query);
        log.info("\u66f4\u65b0\u5904\u65b9-->\u66f4\u65b0\u5904\u65b9[\u7ed3\u675f]=\u6570\u91cf{}", (Object)size);
        SaveOrderDto saveOrderDto = InpatPrescriptionServiceImpl.getSaveOrderDto((SavePrescriptionDto)parameter, (InpatRegist)inpatRegist, (InpatPrescription)prescription);
        this.inpatOrderService.saveOrder(OrderTypeEnum.getEnumByDrugType((String)drugsType), saveOrderDto);
        log.debug("\u66f4\u65b0\u5904\u65b9-->\u66f4\u65b0\u5904\u65b9[\u8ba2\u5355]\u5b8c\u6210");
        this.insertInpatPrescriptionRecord(prescription.getPrescriptionNo(), InpatPrescriptionRecordEnum.PRESCRIPTION_MODIFICATION, parameter.getTenantId(), parameter.getOperatorName(), parameter.getOperatorId());
    }

    private static SaveOrderDto getSaveOrderDto(SavePrescriptionDto parameter, InpatRegist inpatRegist, InpatPrescription prescription) {
        SaveOrderDto saveOrderDto = new SaveOrderDto();
        saveOrderDto.setOperatorId(parameter.getOperatorId());
        saveOrderDto.setCreateName(parameter.getOperatorName());
        saveOrderDto.setTenantId(parameter.getTenantId());
        saveOrderDto.setPrescriptionNo(prescription.getPrescriptionNo());
        saveOrderDto.setInpatNo(parameter.getInpatNo());
        saveOrderDto.setPatientName(inpatRegist.getPatientName());
        saveOrderDto.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
        saveOrderDto.setOrderAmount(prescription.getTotalPrescriptionAmount());
        saveOrderDto.setActualOtherPayment(new BigDecimal(0));
        saveOrderDto.setRegTime(DateUtil.formatDateTime((Date)new Date()));
        saveOrderDto.setPatientCardNo(inpatRegist.getCardNo());
        return saveOrderDto;
    }

    public ResponseData<QueryPrescriptionsVo> queryPrescriptionsByNo(InpatPrescriptionDto parameter) {
        QueryPrescriptionsVo prescriptionsVos = this.inpatPrescriptionMapper.queryPrescriptionsByNo(parameter);
        prescriptionsVos.setMedicationTabooList(JSON.parseArray((String)prescriptionsVos.getMedicationTaboo(), String.class));
        prescriptionsVos.setMedicationTabooCodeList(JSON.parseArray((String)prescriptionsVos.getMedicationTabooCode(), String.class));
        prescriptionsVos.setMedicationTaboo(null);
        prescriptionsVos.setMedicationTabooCode(null);
        return ResponseData.success((Object)prescriptionsVos);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public ResponseData<String> deletePrescriptionsByNo(InpatPrescriptionDto parameter) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)parameter.getTenantId());
        query.eq((Object)"prescription_no", (Object)parameter.getPrescriptionNo());
        query.eq((Object)"prescription_status", (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
        InpatPrescription prescription = (InpatPrescription)this.inpatPrescriptionMapper.selectOne((Wrapper)query);
        if (prescription == null) {
            return ResponseData.error((String)"\u67e5\u8be2\u4e0d\u5230\u5904\u65b9\uff01");
        }
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(parameter.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        if (ObjectUtils.isEmpty((Object)inpatRegist)) {
            throw new RunDisplayException("\u4f4f\u9662\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue())).eq((Object)"prescription_no", (Object)prescription.getPrescriptionNo());
        InpatOrder order = (InpatOrder)this.inpatOrderMapper.selectOne((Wrapper)queryWrapper);
        if (order == null) {
            return ResponseData.error((String)"\u627e\u4e0d\u5230\u8ba2\u5355!");
        }
        if (order.getOrderStatus() > OrderStatusEnum.PAYMENT_OVERTIME_UNPAID.getValue()) {
            return ResponseData.error((String)"\u8be5\u72b6\u6001\u8ba2\u5355\u4e0d\u80fd\u64a4\u9500!");
        }
        order.setStatus(InpatpatientDataStatusEnum.STATUS_VOID.getValue());
        this.inpatOrderMapper.updateById((Object)order);
        InpatPrescription outPrescription = new InpatPrescription();
        outPrescription.setId(prescription.getId());
        outPrescription.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_DELETE.getValue());
        outPrescription.setUpdateId(parameter.getOperatorId());
        int size = this.inpatPrescriptionMapper.updateById((Object)outPrescription);
        log.debug("\u5220\u9664\u5904\u65b9:{}\u5220\u9664\u6570\u91cf{}", (Object)parameter.getPrescriptionNo(), (Object)size);
        parameter.setPrescriptionNo(prescription.getPrescriptionNo());
        List outPrescriptionDrugs = this.outPrescriptionDrugService.queryPrescriptionDrugsByPresNo(prescription.getTenantId(), parameter.getPrescriptionNo());
        if (CollectionUtils.isEmpty((Collection)outPrescriptionDrugs)) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u5904\u65b9\u836f\u54c1\u4fe1\u606f");
        }
        for (InpatPrescriptionDrug inpatPrescriptionDrug : outPrescriptionDrugs) {
            if (inpatPrescriptionDrug.getStatus() <= ProjectDetailsStatusEnum.PENDING_EXECUTION.getValue()) continue;
            return ResponseData.error((String)"\u8be5\u5904\u65b9\u4e2d\u6709\u836f\u54c1\u5728\u4e0d\u53ef\u64a4\u9500\u72b6\u6001!");
        }
        for (InpatPrescriptionDrug inpatPrescriptionDrug : outPrescriptionDrugs) {
            inpatPrescriptionDrug.setStatus(ProjectDetailsStatusEnum.INVALID.getValue());
            this.outPrescriptionDrugMapper.updateById((Object)inpatPrescriptionDrug);
        }
        this.outPrescriptionDrugService.returnOfDrugInventoryQuantity(parameter.getPrescriptionNo(), ((InpatPrescriptionDrug)outPrescriptionDrugs.get(0)).getPharmacyId(), parameter.getTenantId());
        log.debug("\u5220\u9664\u5904\u65b9-->\u56de\u9000\u836f\u54c1\u5e93\u5b58\u7ed3\u675f");
        this.insertInpatPrescriptionRecord(prescription.getPrescriptionNo(), InpatPrescriptionRecordEnum.PRESCRIPTION_DELETION, parameter.getTenantId(), parameter.getOperatorName(), parameter.getOperatorId());
        this.deleteRationDrugUse(prescription, outPrescriptionDrugs, inpatRegist);
        return ResponseData.success((String)"\u5220\u9664\u5b8c\u6210!", (Object)"\u5220\u9664\u5b8c\u6210!");
    }

    public ResponseData deleteRationDrugUse(InpatPrescription prescription, List<InpatPrescriptionDrug> outPrescriptionDrugs, InpatRegist inpatRegist) {
        try {
            String rationalCode;
            ResponseData responseData;
            SavePrescriptionDto savePrescriptionDto = new SavePrescriptionDto();
            BeanUtils.copyProperties((Object)prescription, (Object)savePrescriptionDto);
            ArrayList drugList = new ArrayList(outPrescriptionDrugs.size());
            BeanUtils.copyProperties(drugList, outPrescriptionDrugs);
            savePrescriptionDto.setDrugList(drugList);
            savePrescriptionDto.setTag(RationalDrugUseEnum.SUBMIT.getValue());
            ResponseData stringResponseData = this.buildPrescriptionParameter(savePrescriptionDto, inpatRegist);
            if (!ResponseData.ResponseEnum.SUCCESS.getCode().equals(stringResponseData.getCode())) {
                log.info("\u4f5c\u5e9f\u5904\u65b9=>\u5408\u7406\u7528\u836f\u63a5\u53e3\u53c2\u6570\u7ec4\u88c5\u5931\u8d25:{}", (Object)stringResponseData);
            }
            if (!(responseData = this.rationalDrugUse((String)stringResponseData.getData(), savePrescriptionDto.getTag())).isSuccess()) {
                log.error("\u4f5c\u5e9f\u5904\u65b9=>\u5408\u7406\u7528\u836f\u5f02\u5e38:{}", (Object)JSON.toJSONString((Object)responseData));
            }
            rationalCode = StringUtil.isEmpty((String)(rationalCode = ((RationDrugUseVo)responseData.getData()).getData())) ? "-2" : rationalCode;
            this.inpatPrescriptionMapper.updateRationCodeById(prescription.getPrescriptionNo(), YesNoEnum.DELETE.getValue(), rationalCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4f5c\u5e9f\u5904\u65b9\u5f02\u5e38=>\u5408\u7406\u7528\u836f\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return null;
    }

    @Async
    public void insertInpatPrescriptionRecord(String prescriptionNo, InpatPrescriptionRecordEnum inpatPrescriptionRecordEnum, Integer tenantId, String operator, Integer operatorId) {
        InpatPrescriptionRecordDto outPrescriptionRecordDto = new InpatPrescriptionRecordDto();
        outPrescriptionRecordDto.setOperationRemark(inpatPrescriptionRecordEnum.getOperationDescription());
        outPrescriptionRecordDto.setInspect(operator);
        outPrescriptionRecordDto.setInspectId(operatorId);
        outPrescriptionRecordDto.setOperationCode(inpatPrescriptionRecordEnum.getValue());
        outPrescriptionRecordDto.setTenantId(tenantId);
        outPrescriptionRecordDto.setPrescriptionNo(prescriptionNo);
        outPrescriptionRecordDto.setOperator(operator);
        outPrescriptionRecordDto.setOperatorId(operatorId);
        outPrescriptionRecordDto.setOperationDescription(inpatPrescriptionRecordEnum.getDesc());
        outPrescriptionRecordDto.setOperationResult(inpatPrescriptionRecordEnum.getOperationDescription());
        this.outPrescriptionRecordService.insertOutPrescriptionRecord(outPrescriptionRecordDto);
    }

    private void obtainingDrugInformation(SavePrescriptionDto parameter, Boolean inventoryFlag) {
        ResponseData responseData = new ResponseData();
        List<String> ids = parameter.getDrugList().stream().map(SavePrescriptionDrugsDto::getDrugNo).distinct().collect(Collectors.toList());
        SysEasyEntity entity = new SysEasyEntity();
        entity.setIds(ids.toArray(new String[ids.size()]));
        entity.setWarehouse(((SavePrescriptionDrugsDto)parameter.getDrugList().get(0)).getPharmacyId());
        responseData = this.sysServiceFeign.sysDrugPharmacyOutSearchByIds(entity, String.valueOf(parameter.getTenantId()));
        if (responseData == null || !responseData.isSuccess()) {
            log.error("\u67e5\u8be2\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", ids, (Object)JSON.toJSONString((Object)responseData));
            throw new RunDisplayException("\u836f\u54c1\u670d\u52a1\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff01");
        }
        List data = JSON.parseArray((String)JSON.toJSONString((Object)responseData.getData()), SysDrugPharmacySimpleVo.class);
        if (ids.size() != data.size()) {
            log.error("\u67e5\u8be2\u6570\u91cf\u4e0e\u8fd4\u56de\u6570\u636e\u91cf\u4e0d\u5339\u914d\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", ids, (Object)JSON.toJSONString((Object)responseData));
            throw new RunDisplayException("\u90e8\u5206\u836f\u54c1\u670d\u52a1\u4fe1\u606f\u7f3a\u5931\uff01");
        }
        this.checkDrugProperties(data);
        Map<Object, Object> sysDrugFrequencyMap = new HashMap();
        if (PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(parameter.getPrescriptionType())) {
            SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
            sysDictValueDTO.setType("we_medicine_frequency");
            sysDictValueDTO.setCurrent(1);
            sysDictValueDTO.setSize(-1);
            ResponseData sysDictValueVoResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, String.valueOf(parameter.getTenantId()));
            if (Objects.isNull(sysDictValueVoResponseData) || !sysDictValueVoResponseData.isSuccess()) {
                log.error("\u9891\u6b21\u67e5\u8be2\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)sysDictValueVoResponseData));
                throw new RunDisplayException("\u836f\u54c1\u9891\u6b21\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff01");
            }
            List dictValueVoList = ((Page)sysDictValueVoResponseData.getData()).getRecords();
            if (CollectionUtils.isEmpty((Collection)dictValueVoList)) {
                log.error("\u9891\u6b21\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u5f02\u5e38\uff0c\u67e5\u8be2:{},\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)sysDictValueDTO), (Object)JSON.toJSONString((Object)dictValueVoList));
                throw new RunDisplayException("\u836f\u54c1\u9891\u6b21\u4fe1\u606f\u67e5\u8be2\u7f3a\u5931\uff01");
            }
            sysDrugFrequencyMap = dictValueVoList.stream().collect(Collectors.toMap(SysDictValueVo::getValue, Function.identity()));
        }
        Map sysDrugMap = data.stream().collect(Collectors.toMap(SysDrugPharmacySimpleVo::getDrugsId, Function.identity()));
        List drugList = parameter.getDrugList();
        Map<String, List<SavePrescriptionDrugsDto>> drugMap = drugList.stream().collect(Collectors.groupingBy(x -> x.getDrugNo()));
        for (SavePrescriptionDrugsDto drugsDto : parameter.getDrugList()) {
            SysDrugPharmacySimpleVo sysDrugPharmacySimpleVo = (SysDrugPharmacySimpleVo)sysDrugMap.get(drugsDto.getDrugNo());
            if (sysDrugPharmacySimpleVo == null) {
                throw new RunDisplayException("\u836f\u54c1\u4fe1\u606f\u7f3a\u5931\uff01");
            }
            List<SavePrescriptionDrugsDto> savePrescriptionDrugsDtos = drugMap.get(drugsDto.getDrugNo());
            long quantity = savePrescriptionDrugsDtos.stream().mapToInt(n -> Objects.nonNull(n.getQuantity()) ? n.getQuantity().intValue() : 0).summaryStatistics().getSum();
            if (inventoryFlag.booleanValue() && (long)sysDrugPharmacySimpleVo.getActualInventory().intValue() < quantity) {
                throw new RunDisplayException("\u836f\u54c1:" + sysDrugPharmacySimpleVo.getDrugsName() + "\u5e93\u5b58\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u5f00\u5177\uff01");
            }
            if (ObjectUtils.isEmpty((Object)sysDrugPharmacySimpleVo.getDrugsType())) {
                throw new RunDisplayException("\u836f\u54c1:" + sysDrugPharmacySimpleVo.getDrugsName() + "\u7c7b\u578b\u7f3a\u5931,\u8bf7\u91cd\u65b0\u5f00\u5177\uff01");
            }
            drugsDto.setManufacturer(sysDrugPharmacySimpleVo.getManufacturer());
            drugsDto.setFrequencyRate(Objects.nonNull(sysDrugFrequencyMap.get(drugsDto.getFrequencyCode())) ? ((SysDictValueVo)sysDrugFrequencyMap.get(drugsDto.getFrequencyCode())).getRemarks() : null);
            drugsDto.setInsuranceDrugCode(sysDrugPharmacySimpleVo.getMedicalInsuranceCode());
            drugsDto.setSpecification(sysDrugPharmacySimpleVo.getSpecifications());
            drugsDto.setDrugPriceAmount(sysDrugPharmacySimpleVo.getRetailPrice());
            drugsDto.setTotalDrugAmount(sysDrugPharmacySimpleVo.getRetailPrice().multiply(drugsDto.getQuantity()));
            if (PrescriptionTypeEnum.TRADITIONAL_CHINESEMEDICINEDRINK.getValue().equals(parameter.getPrescriptionType())) {
                drugsDto.setTotalDrugAmount(sysDrugPharmacySimpleVo.getRetailPrice().multiply(drugsDto.getQuantity()).multiply(new BigDecimal(parameter.getDosage())));
            }
            drugsDto.setPurchasePrice(sysDrugPharmacySimpleVo.getPurchasePrice());
            drugsDto.setInventoryQuantity(sysDrugPharmacySimpleVo.getActualInventory());
            drugsDto.setMedicalInsuranceCode(sysDrugPharmacySimpleVo.getMedicalInsuranceCode());
            drugsDto.setLevel(sysDrugPharmacySimpleVo.getLevel());
            drugsDto.setDrugsType(sysDrugPharmacySimpleVo.getDrugsType());
            drugsDto.setInternalCode(sysDrugPharmacySimpleVo.getInternalCode());
        }
    }

    private void checkDrugProperties(List<SysDrugPharmacySimpleVo> remoteDrugList) {
        List drugProperties = remoteDrugList.stream().map(SysDrugPharmacySimpleVo::getDrugProperties).distinct().collect(Collectors.toList());
        if (drugProperties.contains(DrugPropertiesEnum.TWO_SPIRIT.getValue()) && drugProperties.size() > 1) {
            throw new RunDisplayException("\u836f\u54c1\u6027\u8d28\u3010" + DrugPropertiesEnum.TWO_SPIRIT.getDesc() + "\u3011,\u4e0d\u80fd\u4e0e\u5176\u4ed6\u6027\u8d28\u7684\u836f\u54c1\u540c\u65f6\u6dfb\u52a0,\u8bf7\u91cd\u65b0\u5f00\u5177\uff01");
        }
        List<String> typeList = Arrays.asList(DrugPropertiesEnum.ONE_SPIRIT.getValue(), DrugPropertiesEnum.NARCOTIZE.getValue());
        List intersection = drugProperties.stream().filter(typeList::contains).collect(Collectors.toList());
        List subtract = drugProperties.stream().filter(s -> !typeList.contains(s)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(intersection) && !CollectionUtils.isEmpty(subtract)) {
            throw new RunDisplayException("\u5176\u4ed6\u6027\u8d28\u7684\u836f\u54c1\u4e0d\u80fd\u4e0e\u836f\u54c1\u6027\u8d28\u4e3a\u3010" + DrugPropertiesEnum.ONE_SPIRIT.getDesc() + "," + DrugPropertiesEnum.NARCOTIZE.getDesc() + "\u3011\u7684\u836f\u54c1\u540c\u65f6\u5f00\u5177!");
        }
    }

    private static void assembleUpdatePrescription(SavePrescriptionDto parameter, InpatPrescription prescription, String lnventoryNumber) {
        prescription.setUpdateId(parameter.getOperatorId());
        prescription.setPharmacy(parameter.getPharmacy());
        prescription.setPrescribingDoctorId(parameter.getPrescribingDoctorId());
        prescription.setPrescribingDoctorName(parameter.getPrescribingDoctorName());
        prescription.setPrescribingDepartmentId(parameter.getPrescribingDepartmentId());
        prescription.setPrescribingDepartmentName(parameter.getPrescribingDepartmentName());
        prescription.setLnventoryNumber(lnventoryNumber);
        InpatPrescriptionServiceImpl.assemblyPrescriptionVariableParameters((SavePrescriptionDto)parameter, (InpatPrescription)prescription);
    }

    private static InpatPrescription assembleInsertPrescription(SavePrescriptionDto parameter, InpatRegist inpatRegist, String prescriptionNo, String lnventoryNumber) {
        InpatPrescription prescription = new InpatPrescription();
        prescription.setCreateId(parameter.getOperatorId());
        prescription.setUpdateId(parameter.getOperatorId());
        prescription.setTenantId(parameter.getTenantId());
        prescription.setInpatNo(parameter.getInpatNo());
        prescription.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
        prescription.setPrescriptionNo(prescriptionNo);
        prescription.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_NORMAL.getValue());
        prescription.setRationalMedicationStatus(null);
        prescription.setPrescriptionAuditStatus(null);
        prescription.setPharmacy(parameter.getPharmacy());
        prescription.setPatientName(inpatRegist.getPatientName());
        prescription.setPatientIdentificationNumber(inpatRegist.getCardNo());
        prescription.setPrescribingDoctorId(parameter.getPrescribingDoctorId());
        prescription.setPrescribingDoctorName(parameter.getPrescribingDoctorName());
        prescription.setPrescribingDoctorSignature(null);
        prescription.setPrescribingDepartmentId(parameter.getPrescribingDepartmentId());
        prescription.setPrescribingDepartmentName(parameter.getPrescribingDepartmentName());
        prescription.setReviewerId(null);
        prescription.setReviewerName(null);
        prescription.setReviewerSignature(null);
        prescription.setReviewerTime(null);
        prescription.setIssueTime(new Date());
        prescription.setLnventoryNumber(lnventoryNumber);
        prescription.setSource(parameter.getSource());
        InpatPrescriptionServiceImpl.assemblyPrescriptionVariableParameters((SavePrescriptionDto)parameter, (InpatPrescription)prescription);
        return prescription;
    }

    private static void assemblyPrescriptionVariableParameters(SavePrescriptionDto parameter, InpatPrescription prescription) {
        BigDecimal totalDrugAmount = parameter.getDrugList().stream().map(SavePrescriptionDrugsDto::getTotalDrugAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal drugSize = PrescriptionTypeEnum.WESTERN_MEDICINE.getValue().equals(parameter.getPrescriptionType()) ? parameter.getDrugList().stream().map(SavePrescriptionDrugsDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add) : new BigDecimal(parameter.getDrugList().size());
        prescription.setTotalDrugCategories(Integer.valueOf(parameter.getDrugList().size()));
        prescription.setTotalDrugQuantity(drugSize);
        prescription.setIsDecoction(parameter.getIsDecoction());
        prescription.setTotalDecoctionAmount(new BigDecimal(0));
        prescription.setTotalPrescriptionAmount(prescription.getTotalDecoctionAmount() == null ? totalDrugAmount : totalDrugAmount.add(prescription.getTotalDecoctionAmount()));
        prescription.setTotalDrugsAmount(totalDrugAmount);
        prescription.setPrintCount(Integer.valueOf(0));
        prescription.setIsInsurancePrescription(null);
        prescription.setInsurancePrescriptionType(InsurancePrescriptionTypeEnum.REGULAR_PRESCRIPTION.getValue());
        prescription.setPrescriptionType(parameter.getPrescriptionType());
        prescription.setAdditionalNotes(parameter.getAdditionalNotes());
        prescription.setSingleDoseAmount(totalDrugAmount);
        prescription.setMedicationTime(parameter.getMedicationTime());
        prescription.setMedicationTimeId(parameter.getMedicationTimeId());
        prescription.setDailyDosage(parameter.getDailyDosage());
        prescription.setSingleDoseUsage(parameter.getSingleDoseUsage());
        prescription.setSingleDoseUsageId(parameter.getSingleDoseUsageId());
        prescription.setDailyFrequency(parameter.getDailyFrequency());
        prescription.setUsageId(parameter.getUsageId());
        prescription.setUsageName(parameter.getUsageName());
        prescription.setDosage(parameter.getDosage());
        prescription.setMedicationTaboo(JSON.toJSONString((Object)parameter.getMedicationTaboo()));
        prescription.setMedicationTabooCode(JSON.toJSONString((Object)parameter.getMedicationTabooCode()));
    }

    public List<Integer> selectPrescriptionList(List<String> inpatNoList) {
        return this.inpatPrescriptionMapper.selectPrescriptionList(inpatNoList);
    }
}

