/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatSettleTypeEnum;
import com.byh.inpatient.api.enums.SettleFeeStatus;
import com.byh.inpatient.api.exception.BusinessException;
import com.byh.inpatient.api.hsModel.CzRequest;
import com.byh.inpatient.api.hsModel.HsSettlementInfoEntity;
import com.byh.inpatient.api.hsModel.InpatInsurSettleRequest;
import com.byh.inpatient.api.hsModel.InpatPreSettleRequest;
import com.byh.inpatient.api.hsModel.InsurFeeDetail;
import com.byh.inpatient.api.hsModel.InsurRegist;
import com.byh.inpatient.api.hsModel.OutHsSettlementInfoDetaiEntity;
import com.byh.inpatient.api.hsModel.PaymentResponse;
import com.byh.inpatient.api.hsModel.RegistrationEntity;
import com.byh.inpatient.api.model.InpatFee;
import com.byh.inpatient.api.model.InpatPrepay;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatSettle;
import com.byh.inpatient.api.model.InpatSettleFee;
import com.byh.inpatient.api.model.dto.InpatSettleDTO;
import com.byh.inpatient.api.model.dto.InsurPreSettleDTO;
import com.byh.inpatient.api.model.dto.InsurSettleDTO;
import com.byh.inpatient.api.sysModel.request.SysDictValueDTO;
import com.byh.inpatient.api.sysModel.respones.SysDictValueVo;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.util.UUIDUtils;
import com.byh.inpatient.data.repository.InpatSettleMapper;
import com.byh.inpatient.web.feign.HsServiceFeign;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.enums.InHospEnum;
import com.byh.inpatient.web.mvc.enums.InpatDeptTransferStatus;
import com.byh.inpatient.web.mvc.utils.CommonRequest;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatPrepayService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.IInpatSettleFeeService;
import com.byh.inpatient.web.service.IInpatSettleService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class InpatSettleServiceImpl
extends ServiceImpl<InpatSettleMapper, InpatSettle>
implements IInpatSettleService {
    private static final Logger log = LoggerFactory.getLogger(InpatSettleServiceImpl.class);
    @Autowired
    IInpatRegistService iInpatRegistService;
    @Autowired
    IInpatPrepayService iInpatPrepayService;
    @Autowired
    IInpatFeeService inpatFeeService;
    @Autowired
    IInpatSettleFeeService iInpatSettleFeeService;
    @Autowired
    HsServiceFeign hsServiceFeign;
    @Autowired
    CommonRequest commonRequest;
    @Autowired
    NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    @Autowired
    SysServiceFeign sysServiceFeign;

    @Transactional(rollbackFor={Exception.class})
    public InpatSettle doSettle(InpatSettleDTO param) {
        BigDecimal expectedAmount;
        List babyInpatRegistList;
        Assert.notNull((Object)param.getInpatRegId(), (String)"\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)param.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((param.getTotalAmount() != null && param.getTotalAmount().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u8d39\u7528\u4e0d\u53ef\u4e3a\u7a7a");
        InpatRegist inpatRegist = (InpatRegist)this.iInpatRegistService.getById((Serializable)param.getInpatRegId());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
        Assert.isTrue((boolean)InHospEnum.IN_HOSPITAL.iohospCode.equals(inpatRegist.getInHospCode()), (String)"\u60a3\u8005\u51fa\u5165\u9662\u72b6\u6001\u4e0d\u662f\u5165\u9662");
        Assert.isTrue((boolean)inpatRegist.getPatientName().equals(param.getPatientName()), (String)"\u4f4f\u9662\u767b\u8bb0\u4eba\u5458\u59d3\u540d\u4e0e\u51fa\u9662\u7ed3\u7b97\u4eba\u5458\u59d3\u540d\u4e0d\u540c\uff01\uff01\uff01");
        if (this.checkInpatSettle(SettleFeeStatus.SETTLE.statusCode, param.getInpatRegId()) > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u7ed3\u7b97\u4fe1\u606f");
        }
        ArrayList<InpatRegist> inpatRegistList = new ArrayList<InpatRegist>();
        inpatRegistList.add(inpatRegist);
        if (param.getBabyTogetherSettle() != null && 1 == param.getBabyTogetherSettle() && (babyInpatRegistList = this.iInpatRegistService.list((Wrapper)Wrappers.lambdaQuery().eq(InpatRegist::getMotherRegId, (Object)inpatRegist.getId()))) != null && !babyInpatRegistList.isEmpty()) {
            inpatRegistList.addAll(babyInpatRegistList);
        }
        List inpatRegistIdList = inpatRegistList.stream().map(InpatRegist::getId).collect(Collectors.toList());
        String payOrderNo = UUIDUtils.getOutHospPayOrderNo();
        List inpatPrepayList = this.iInpatPrepayService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatPrepay::getInpatRegId, inpatRegistIdList)).isNull(InpatPrepay::getSettleNo));
        for (InpatPrepay prepay : inpatPrepayList) {
            prepay.setSettleNo(payOrderNo);
            if (!this.iInpatPrepayService.updateById((Object)prepay)) continue;
            throw new BusinessException("\u66f4\u65b0\u4f4f\u9662\u60a3\u8005\u9884\u4ea4\u6b3e\u4fe1\u606f\u5931\u8d25");
        }
        if (InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(param.getSettleTypeCode())) {
            for (Integer registId : inpatRegistIdList) {
                InpatRegist regist = (InpatRegist)this.iInpatRegistService.getById((Serializable)registId);
                Assert.isTrue((boolean)InpatDeptTransferStatus.DISCHARGED.getStatusCode().equals(regist.getInDeptStatusCode()), (String)"\u60a3\u8005\u60a3\u8005\u79d1\u5ba4\u7684\u72b6\u6001\u72b6\u6001\u4e0d\u662f\u5df2\u51fa\u9662");
                InpatRegist itemInpatR = new InpatRegist();
                itemInpatR.setId(registId);
                itemInpatR.setInHospCode(InHospEnum.DISCHARGED_HOSPITAL.iohospCode);
                itemInpatR.setInHospName(InHospEnum.DISCHARGED_HOSPITAL.iohospName);
                this.iInpatRegistService.updateById((Object)itemInpatR);
            }
        }
        LambdaQueryWrapper inpatFeeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(InpatFee::getInpatRegId, inpatRegistIdList)).isNull(InpatFee::getPayOrderNo);
        BigDecimal settleFee = this.inpatFeeService.selectAmount((Wrapper)inpatFeeWrapper);
        Assert.isTrue((param.getTotalAmount().compareTo(settleFee) == 0 ? 1 : 0) != 0, (String)"\u5b9e\u9645\u8d39\u7528\u91d1\u989d\u4e0e\u754c\u9762\u91d1\u989d\u4e0d\u7b26\u5408");
        boolean isSelfPay = StrUtil.isBlank((CharSequence)param.getInsurSettleId());
        if (isSelfPay) {
            expectedAmount = param.getRecvBackCode() == 0 ? settleFee.subtract(inpatRegist.getTotPrepaymentAmount()) : inpatRegist.getTotPrepaymentAmount().subtract(settleFee);
        } else {
            BigDecimal totalInsurAmount = param.getTotalInsurAmount();
            expectedAmount = param.getRecvBackCode() == 0 ? settleFee.subtract(totalInsurAmount).subtract(inpatRegist.getTotPrepaymentAmount()) : inpatRegist.getTotPrepaymentAmount().subtract(settleFee.subtract(totalInsurAmount));
        }
        String errorMessage = param.getRecvBackCode() == 0 ? "\u5b9e\u9645\u6536\u6b3e\u91d1\u989d\u6709\u8bef\uff01" : "\u5b9e\u9645\u9000\u6b3e\u91d1\u989d\u6709\u8bef\uff01";
        Assert.isTrue((expectedAmount.compareTo(param.getRecvBackAmount()) == 0 ? 1 : 0) != 0, (String)errorMessage);
        Date settleTime = new Date();
        InpatSettle inpatSettle = new InpatSettle();
        inpatSettle.setInpatRegId(param.getInpatRegId());
        inpatSettle.setInpatNo(inpatRegist.getInpatNo());
        inpatSettle.setPatientName(inpatRegist.getPatientName());
        inpatSettle.setPayOrderNo(payOrderNo);
        inpatSettle.setSettleTime(settleTime);
        inpatSettle.setTotalAmount(param.getTotalAmount());
        inpatSettle.setTotalInsurAmount(param.getTotalInsurAmount());
        inpatSettle.setTotalPrepayAmount(param.getTotalPrepayAmount());
        inpatSettle.setRecvBackAmount(param.getRecvBackAmount());
        inpatSettle.setBabyTogetherSettle(param.getBabyTogetherSettle());
        inpatSettle.setIsOwed(param.getIsOwed());
        inpatSettle.setRecvBackCode(param.getRecvBackCode());
        inpatSettle.setRecvBackName(param.getRecvBackName());
        inpatSettle.setPaymentTransactionNo(param.getPaymentTransactionNo());
        inpatSettle.setSettleTypeCode(param.getSettleTypeCode());
        inpatSettle.setSettleTypeName(param.getSettleTypeName());
        inpatSettle.setPaymentTypeCode(param.getPaymentTypeCode());
        inpatSettle.setPaymentTypeName(param.getPaymentTypeName());
        inpatSettle.setPaymentTypeFlag(param.getPaymentTypeFlag());
        inpatSettle.setStatusCode(SettleFeeStatus.SETTLE.statusCode);
        inpatSettle.setStatusName(SettleFeeStatus.SETTLE.statusName);
        inpatSettle.setSettlePersonId(this.commonRequest.getUserId());
        inpatSettle.setSettlePersonName(this.commonRequest.getUserName());
        inpatSettle.setPsnNo(param.getPsnNo());
        inpatSettle.setInsurSettleId(param.getInsurSettleId());
        inpatSettle.setInsuplcAdmdvs(param.getInsuplcAdmdvs());
        inpatSettle.setInsurTypeCode(param.getInsurTypeCode());
        inpatSettle.setInsurTypeName(param.getInsurTypeName());
        inpatSettle.setMdtrtId(param.getMdtrtId());
        ((InpatSettleMapper)this.baseMapper).insert((Object)inpatSettle);
        long count = this.inpatFeeService.count((Wrapper)inpatFeeWrapper);
        List inpatFeeList = new ArrayList();
        if (count > 30000L) {
            long l = count / 29999L + 1L;
            int i = 1;
            while ((long)i <= l) {
                Page page = new Page((long)i, 29999L);
                Page inpatFeePage = (Page)this.inpatFeeService.page((IPage)page, (Wrapper)inpatFeeWrapper);
                List rows = inpatFeePage.getRecords();
                inpatFeeList.addAll(rows);
                ++i;
            }
        } else {
            inpatFeeList = this.inpatFeeService.list((Wrapper)inpatFeeWrapper);
        }
        this.inpatFeeService.updateSettleInfoByInpatRegId(inpatRegistIdList, inpatFeeList, inpatSettle);
        for (InpatFee inpatFee : inpatFeeList) {
            InpatSettleFee inpatSettleFee = new InpatSettleFee();
            inpatSettleFee.setInpatSettleId(inpatSettle.getId());
            inpatSettleFee.setInpatFeeId(inpatFee.getId());
            inpatSettleFee.setStatusCode(SettleFeeStatus.SETTLE.statusCode);
            inpatSettleFee.setStatusName(SettleFeeStatus.SETTLE.statusName);
            inpatSettleFee.setSettleTime(settleTime);
            this.iInpatSettleFeeService.save((Object)inpatSettleFee);
        }
        return inpatSettle;
    }

    public PaymentResponse doInsurPreSettle(InsurPreSettleDTO inParam) {
        Assert.notNull((Object)inParam.getInpatRegId(), (String)"\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((inParam.getTotalAmount() != null && inParam.getTotalAmount().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u8d39\u7528\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getInsurTypeCode(), (String)"\u9669\u79cd\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getAcctUsedFlag(), (String)"\u8d26\u6237\u4f7f\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getPsnSetlway(), (String)"\u4e2a\u4eba\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        InpatRegist inpatRegist = (InpatRegist)this.iInpatRegistService.getById((Serializable)inParam.getInpatRegId());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
        InsurRegist inInsurRegist = new InsurRegist();
        inInsurRegist.setRegType("2");
        inInsurRegist.setIptOtpNo(inpatRegist.getInpatNo());
        inInsurRegist.setValidFlag("1");
        inInsurRegist.setWriteOffFlag("0");
        ResponseData listResponseData = this.hsServiceFeign.selectInsurRegistByCondition(inInsurRegist);
        if (listResponseData.getData() == null || StrUtil.isBlank((CharSequence)((InsurRegist)listResponseData.getData()).getMdtrtId())) {
            log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
        }
        InsurRegist insurRegist = (InsurRegist)listResponseData.getData();
        String mdtrtId = insurRegist.getMdtrtId();
        String psnNo = insurRegist.getPsnNo();
        if (!psnNo.equals(inParam.getPsnNo())) {
            log.error("\u5f53\u524d\u5361\u4eba\u5458\u4fe1\u606f\u4e0e\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u6838\u5bf9");
            throw new BusinessException("\u5f53\u524d\u5361\u4eba\u5458\u4fe1\u606f\u4e0e\u533b\u4fdd\u767b\u8bb0\u4fe1\u606f\u4e0d\u7b26\uff0c\u8bf7\u6838\u5bf9");
        }
        int countHsSettle = ((InpatSettleMapper)this.baseMapper).countHsSettle(mdtrtId);
        if (countHsSettle > 0) {
            log.info("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
            throw new BusinessException("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
        }
        InsurFeeDetail insurFeeDetail = new InsurFeeDetail();
        insurFeeDetail.setIptOtpNo(inpatRegist.getInpatNo());
        ResponseData insurFeeList = this.hsServiceFeign.selectInsurFeeByCondition(insurFeeDetail);
        if (insurFeeList.getData() == null || ((List)insurFeeList.getData()).isEmpty()) {
            log.info("\u8d39\u7528\u660e\u7ec6\u672a\u4e0a\u4f20\u65e0\u6cd5\u9884\u7ed3\u7b97\uff01");
            throw new BusinessException("\u8d39\u7528\u660e\u7ec6\u672a\u4e0a\u4f20\u65e0\u6cd5\u9884\u7ed3\u7b97\uff01");
        }
        BigDecimal feeUploadAmt = ((List)insurFeeList.getData()).stream().map(item -> item.getPric().multiply(item.getCnt())).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (inParam.getTotalAmount().subtract(feeUploadAmt).abs().compareTo(new BigDecimal("1.00")) > 0) {
            log.error("\u4f4f\u9662\u8d39\u7528\u4e0a\u4f20\u5931\u8d25;\u4e0a\u4f20\u8d39\u7528\u4e0e\u603b\u8d39\u7528\u76f8\u5dee:{},\u8bf7\u786e\u8ba4;", (Object)inParam.getTotalAmount().subtract(feeUploadAmt));
            throw new BusinessException("\u4f4f\u9662\u8d39\u7528\u4e0a\u4f20\u5931\u8d25;\u4e0a\u4f20\u8d39\u7528\u4e0e\u603b\u8d39\u7528\u76f8\u5dee:" + inParam.getTotalAmount().subtract(feeUploadAmt) + ",\u8bf7\u786e\u8ba4;");
        }
        InpatPreSettleRequest inpatPreSettleRequest = new InpatPreSettleRequest();
        inpatPreSettleRequest.setPsn_no(inParam.getPsnNo());
        inpatPreSettleRequest.setMdtrt_cert_type(inParam.getMdtrtCertType());
        inpatPreSettleRequest.setMdtrt_cert_no(inParam.getMdtrtCertNo());
        inpatPreSettleRequest.setMedfee_sumamt(inParam.getTotalAmount());
        inpatPreSettleRequest.setPsn_setlway(inParam.getPsnSetlway());
        inpatPreSettleRequest.setMdtrt_id(mdtrtId);
        inpatPreSettleRequest.setAcct_used_flag(inParam.getAcctUsedFlag());
        inpatPreSettleRequest.setInsutype(inParam.getInsurTypeCode());
        inpatPreSettleRequest.setInsuplc_admdvs(inParam.getInsuplcAdmdvs());
        String midSetlFlag = InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(inParam.getSettleTypeCode()) ? "0" : "1";
        inpatPreSettleRequest.setMid_setl_flag(midSetlFlag);
        inpatPreSettleRequest.setDscgTime(DateUtil.now());
        inpatPreSettleRequest.setSign_no(this.commonRequest.getSignNo());
        inpatPreSettleRequest.setTenantId(this.commonRequest.getTenant());
        inpatPreSettleRequest.setOpter(String.valueOf(this.commonRequest.getUserId()));
        inpatPreSettleRequest.setOpter_name(this.commonRequest.getUserName());
        inpatPreSettleRequest.setOpter_type("1");
        ResponseData preSettleRes = this.hsServiceFeign.inpatPreSettle(inpatPreSettleRequest);
        Assert.isTrue((boolean)preSettleRes.isSuccess(), (String)preSettleRes.getMsg());
        return (PaymentResponse)preSettleRes.getData();
    }

    @Transactional(rollbackFor={Exception.class})
    public PaymentResponse doInsurSettle(InsurSettleDTO inParam) {
        Assert.notNull((Object)inParam.getInpatRegId(), (String)"\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getSettleTypeCode(), (String)"\u7ed3\u7b97\u7c7b\u578b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((inParam.getTotalAmount() != null && inParam.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u60a3\u8005\u4f4f\u9662\u8d39\u7528\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getAcctUsedFlag(), (String)"\u8d26\u6237\u4f7f\u7528\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)inParam.getPsnSetlway(), (String)"\u4e2a\u4eba\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        int iGoto = 0;
        String mdtrtId = "";
        String psnNo = "";
        String insuplcAdmdvs = "";
        String setlId = "";
        String msgid = "";
        PaymentResponse settleInfo = null;
        try {
            InpatRegist inpatRegist = (InpatRegist)this.iInpatRegistService.getById((Serializable)inParam.getInpatRegId());
            Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u60a3\u8005\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f");
            InsurRegist inInsurRegist = new InsurRegist();
            inInsurRegist.setRegType("2");
            inInsurRegist.setIptOtpNo(inpatRegist.getInpatNo());
            inInsurRegist.setValidFlag("1");
            inInsurRegist.setWriteOffFlag("0");
            ResponseData listResponseData = this.hsServiceFeign.selectInsurRegistByCondition(inInsurRegist);
            if (listResponseData.getData() == null || StrUtil.isBlank((CharSequence)((InsurRegist)listResponseData.getData()).getMdtrtId())) {
                log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u533b\u4fdd\u5165\u9662\u529e\u7406,\u8bf7\u786e\u8ba4");
            }
            InsurRegist insurRegist = (InsurRegist)listResponseData.getData();
            insuplcAdmdvs = insurRegist.getInsuplcAdmdvs();
            mdtrtId = insurRegist.getMdtrtId();
            psnNo = insurRegist.getPsnNo();
            int countHsSettle = ((InpatSettleMapper)this.baseMapper).countHsSettle(mdtrtId);
            if (countHsSettle > 0) {
                log.info("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
                throw new BusinessException("\u60a3\u8005\u5df2\u8fdb\u884c\u533b\u4fdd\u7ed3\u7b97,\u4e0d\u80fd\u91cd\u590d\u7ed3\u7b97");
            }
            if (this.checkInpatSettle(SettleFeeStatus.SETTLE.statusCode, inParam.getInpatRegId()) > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7ed3\u7b97\u4fe1\u606f");
            }
            RegistrationEntity registrationEntity = new RegistrationEntity();
            registrationEntity.setMethod_code("2303");
            registrationEntity.setMdtrt_id(mdtrtId);
            ResponseData insurPreLogRes = this.hsServiceFeign.selectLogByMethondCode(registrationEntity);
            if (insurPreLogRes.getData() == null || ((List)insurPreLogRes.getData()).isEmpty()) {
                log.info("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u9884\u7ed3\u7b97\u4fe1\u606f,\u8bf7\u786e\u8ba4");
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u9884\u7ed3\u7b97\u4fe1\u606f,\u8bf7\u786e\u8ba4");
            }
            RegistrationEntity insurPre = (RegistrationEntity)((List)insurPreLogRes.getData()).get(0);
            JSONObject insurPreParam = JSON.parseObject((String)insurPre.getParam());
            JSONObject insurPreRes = JSON.parseObject((String)insurPre.getResult());
            JSONObject output = JSON.parseObject((String)insurPreRes.getString("output")).getJSONObject("setlinfo");
            InpatInsurSettleRequest insurSettleRequest = new InpatInsurSettleRequest();
            insurSettleRequest.setPsn_no(psnNo);
            insurSettleRequest.setMdtrt_cert_type(insurPreParam.getString("mdtrt_cert_type"));
            insurSettleRequest.setMdtrt_cert_no(insurPreParam.getString("mdtrt_cert_no"));
            insurSettleRequest.setMedfee_sumamt(output.getBigDecimal("medfee_sumamt"));
            insurSettleRequest.setPsn_setlway(insurPreParam.getString("psn_setlway"));
            insurSettleRequest.setMdtrt_id(mdtrtId);
            insurSettleRequest.setAcct_used_flag(insurPreParam.getString("acct_used_flag"));
            insurSettleRequest.setInsutype(insurPreParam.getString("insutype"));
            insurSettleRequest.setInsuplc_admdvs(insuplcAdmdvs);
            String midSetlFlag = InpatSettleTypeEnum.OUT_HOSP_SETTLE.getCode().equals(inParam.getSettleTypeCode()) ? "0" : "1";
            insurSettleRequest.setMid_setl_flag(midSetlFlag);
            insurSettleRequest.setFulamt_ownpay_amt(output.getBigDecimal("fulamt_ownpay_amt"));
            insurSettleRequest.setOverlmt_selfpay(output.getBigDecimal("overlmt_selfpay"));
            insurSettleRequest.setPreselfpay_amt(output.getBigDecimal("preselfpay_amt"));
            insurSettleRequest.setInscp_scp_amt(output.getBigDecimal("inscp_scp_amt"));
            insurSettleRequest.setSign_no(this.commonRequest.getSignNo());
            insurSettleRequest.setTenantId(this.commonRequest.getTenant());
            insurSettleRequest.setOpter(String.valueOf(this.commonRequest.getUserId()));
            insurSettleRequest.setOpter_name(this.commonRequest.getUserName());
            insurSettleRequest.setOpter_type("1");
            ResponseData insurSettleRes = this.hsServiceFeign.inpatInsurSettle(insurSettleRequest);
            Assert.isTrue((boolean)insurSettleRes.isSuccess(), (String)("\u4f4f\u9662\u533b\u4fdd\u7ed3\u7b97\u5931\u8d25: " + insurSettleRes.getMsg()));
            iGoto = 1;
            settleInfo = (PaymentResponse)insurSettleRes.getData();
            HsSettlementInfoEntity hsSettlementInfoEntity = new HsSettlementInfoEntity();
            BeanUtils.copyProperties((Object)settleInfo.getSetlinfo(), (Object)hsSettlementInfoEntity);
            hsSettlementInfoEntity.setSetldetail(JSONObject.toJSONString((Object)settleInfo.getSetldetail()));
            hsSettlementInfoEntity.setTenantId(this.commonRequest.getTenant());
            hsSettlementInfoEntity.setSettlmentStatus("1");
            hsSettlementInfoEntity.setInsuplc_admdvs(insuplcAdmdvs);
            hsSettlementInfoEntity.setRefdSetlFlag(Integer.valueOf(0));
            hsSettlementInfoEntity.setVisit_type("ZY");
            hsSettlementInfoEntity.setIpt_otp_no(inpatRegist.getInpatNo());
            ((InpatSettleMapper)this.baseMapper).insertHsSettleInfo(hsSettlementInfoEntity);
            JSONArray jsonArray = JSONObject.parseArray((String)hsSettlementInfoEntity.getSetldetail());
            if (jsonArray != null && !jsonArray.isEmpty()) {
                ArrayList<OutHsSettlementInfoDetaiEntity> detailList = new ArrayList<OutHsSettlementInfoDetaiEntity>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    OutHsSettlementInfoDetaiEntity detail = new OutHsSettlementInfoDetaiEntity();
                    detail.setTenantId(hsSettlementInfoEntity.getTenantId());
                    detail.setSetlId(hsSettlementInfoEntity.getSetl_id());
                    detail.setFundPayType(jsonObject.getString("fund_pay_type"));
                    if (!StrUtil.isBlank((CharSequence)detail.getFundPayType())) {
                        SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
                        sysDictValueDTO.setType("fund_pay_type");
                        sysDictValueDTO.setValue(detail.getFundPayType());
                        ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
                        List data = ((Page)pageResponseData.getData()).getRecords();
                        detail.setFundPayTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
                    }
                    detail.setFundPayamt(jsonObject.getBigDecimal("fund_payamt"));
                    detail.setInscpScpAmt(jsonObject.getBigDecimal("inscp_scp_amt"));
                    detail.setSetlProcInfo(jsonObject.getString("setl_proc_info"));
                    detailList.add(detail);
                }
                ((InpatSettleMapper)this.baseMapper).batchinsertHsSettleInfoDetail(detailList);
            }
            iGoto = 2;
            InpatSettleDTO inpatSettleDTO = new InpatSettleDTO();
            inpatSettleDTO.setInpatRegId(inParam.getInpatRegId());
            inpatSettleDTO.setPatientName(settleInfo.getSetlinfo().getPsn_name());
            inpatSettleDTO.setTotalAmount(settleInfo.getSetlinfo().getMedfee_sumamt());
            inpatSettleDTO.setTotalInsurAmount(settleInfo.getSetlinfo().getFund_pay_sumamt().add(settleInfo.getSetlinfo().getAcct_pay()).add(settleInfo.getSetlinfo().getAcct_mulaid_pay()));
            inpatSettleDTO.setTotalPrepayAmount(inParam.getTotalPrepayAmount());
            inpatSettleDTO.setRecvBackAmount(inParam.getRecvBackAmount());
            inpatSettleDTO.setIsOwed(inParam.getIsOwed());
            inpatSettleDTO.setRecvBackCode(inParam.getRecvBackCode());
            inpatSettleDTO.setRecvBackName(inParam.getRecvBackName());
            inpatSettleDTO.setSettleTypeCode(inParam.getSettleTypeCode());
            inpatSettleDTO.setSettleTypeName(inParam.getSettleTypeName());
            inpatSettleDTO.setPaymentTypeCode(inParam.getPaymentTypeCode());
            inpatSettleDTO.setPaymentTypeName(inParam.getPaymentTypeName());
            inpatSettleDTO.setPaymentTypeFlag(inParam.getPaymentTypeFlag());
            inpatSettleDTO.setPsnNo(settleInfo.getSetlinfo().getPsn_no());
            inpatSettleDTO.setInsurTypeCode(settleInfo.getSetlinfo().getInsutype());
            SysDictValueDTO sysDictValueDTO = new SysDictValueDTO();
            sysDictValueDTO.setType("insutype");
            sysDictValueDTO.setValue(settleInfo.getSetlinfo().getInsutype());
            inpatSettleDTO.setInsurSettleId(settleInfo.getSetlinfo().getSetl_id());
            inpatSettleDTO.setMdtrtId(settleInfo.getSetlinfo().getMdtrt_id());
            ResponseData pageResponseData = this.sysServiceFeign.sysDictValueById(sysDictValueDTO, hsSettlementInfoEntity.getTenantId() + "");
            List data = ((Page)pageResponseData.getData()).getRecords();
            inpatSettleDTO.setInsurTypeName(data == null || data.isEmpty() ? "" : ((SysDictValueVo)data.get(0)).getLabel());
            inpatSettleDTO.setInsuplcAdmdvs(insuplcAdmdvs);
            InpatSettle inpatSettle = this.doSettle(inpatSettleDTO);
            iGoto = 3;
            settleInfo.setInpatSettle(inpatSettle);
        }
        catch (Exception ex) {
            log.error("\u8fdb\u5165\u4f4f\u9662\u7ed3\u7b97\u5f02\u5e38\u6355\u83b7");
            String msg = "";
            switch (iGoto) {
                case 0: {
                    msg = "\u4f4f\u9662\u7ed3\u7b97\u63a5\u53e3\u5f02\u5e38;" + ex.getMessage();
                    break;
                }
                case 1: {
                    msg = "\u533b\u4fdd\u4f4f\u9662\u7ed3\u7b97\u5931\u8d25;" + ex.getMessage() + ";\u8c03\u7528\u51b2\u6b63;";
                    CzRequest czRequest = new CzRequest();
                    czRequest.setOmsgid(settleInfo.getSetlinfo().getMedins_setl_id());
                    czRequest.setInsuplc_admdvs(insuplcAdmdvs);
                    czRequest.setPsn_no(psnNo);
                    czRequest.setOpter_name(this.commonRequest.getUserName());
                    czRequest.setOpter(String.valueOf(this.commonRequest.getUserId()));
                    czRequest.setOpter_type("1");
                    czRequest.setTenantId(this.commonRequest.getTenant());
                    czRequest.setOinfno("2304");
                    ResponseData writeOffRes = this.hsServiceFeign.czTransaction(czRequest);
                    msg = msg + writeOffRes.getMsg();
                }
            }
            throw new BusinessException(msg);
        }
        return settleInfo;
    }

    public int checkInpatSettle(Integer statusCode, Integer inpatRegId) {
        return ((InpatSettleMapper)this.baseMapper).checkInpatSettle(statusCode, inpatRegId);
    }
}

