/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.byh.inpatient.api.enums.InpatWardBedUseStatus;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.InpatWardBed;
import com.byh.inpatient.api.model.dto.InpatWardBedDTO;
import com.byh.inpatient.api.model.vo.InpatWardBedFeeInfoVO;
import com.byh.inpatient.api.model.vo.WristbandCardPrintVo;
import com.byh.inpatient.api.util.BeanUtil;
import com.byh.inpatient.data.repository.InpatWardBedMapper;
import com.byh.inpatient.web.service.IInpatMedicalRecordDiagService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.IInpatWardBedService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InpatWardBedServiceImpl
extends ServiceImpl<InpatWardBedMapper, InpatWardBed>
implements IInpatWardBedService {
    @Autowired
    InpatWardBedMapper inpatWardBedMapper;
    @Autowired
    IInpatRegistService inpatRegistService;
    @Autowired
    IInpatMedicalRecordDiagService iInpatMedicalRecordDiagService;

    public InpatWardBed saveWardBed(InpatWardBedDTO inpatWardBedDTO) {
        InpatWardBed inpatWardBed = (InpatWardBed)this.inpatWardBedMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getBedNo, (Object)inpatWardBedDTO.getBedNo())).eq(InpatWardBed::getWardId, (Object)inpatWardBedDTO.getWardId()));
        Assert.isNull((Object)inpatWardBed, (String)"\u540c\u4e00\u4e2a\u75c5\u533a\uff0c\u4e0d\u80fd\u6709\u91cd\u590d\u7684\u5e8a\u53f7");
        inpatWardBed = new InpatWardBed();
        BeanUtil.copy((Object)inpatWardBedDTO, (Object)inpatWardBed);
        inpatWardBed.setUseStatusCode(InpatWardBedUseStatus.NOT_USED.getUseStatusCode());
        inpatWardBed.setUseStatusName(InpatWardBedUseStatus.NOT_USED.getUseStatusName());
        int insert = this.inpatWardBedMapper.insert((Object)inpatWardBed);
        Assert.isTrue((insert == 1 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5e8a\u4f4d\u5931\u8d25");
        return inpatWardBed;
    }

    public InpatWardBed updateWardBedInfo(InpatWardBed inpatWardBed) {
        Assert.notNull((Object)inpatWardBed.getId(), (String)"\u5e8a\u4f4d\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inpatWardBed.getWardId(), (String)"\u75c5\u533a\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)inpatWardBed.getBedNo(), (String)"\u5e8a\u4f4d\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        InpatWardBed updateBed = (InpatWardBed)this.inpatWardBedMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getBedNo, (Object)inpatWardBed.getBedNo())).eq(InpatWardBed::getWardId, (Object)inpatWardBed.getWardId())).ne(InpatWardBed::getId, (Object)inpatWardBed.getId()));
        Assert.isNull((Object)updateBed, (String)"\u540c\u4e00\u4e2a\u75c5\u533a\u623f\u95f4\u5185\uff0c\u4e0d\u80fd\u6709\u91cd\u590d\u7684\u5e8a\u53f7");
        int i = this.inpatWardBedMapper.updateById((Object)inpatWardBed);
        Assert.isTrue((i == 1 ? 1 : 0) != 0, (String)"\u4fee\u6539\u5e8a\u4f4d\u5931\u8d25");
        return inpatWardBed;
    }

    public List<InpatWardBedFeeInfoVO> selectListWithOrderItemAndChargeItem(String id) {
        Assert.hasText((String)id, (String)"\u5e8a\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        return this.inpatWardBedMapper.selectListWithOrderItemAndChargeItem(id);
    }

    public InpatWardBed doModifyingBedUseStatus(Integer wardId, String bedNo, InpatWardBedUseStatus status) {
        Assert.notNull((Object)wardId, (String)"\u75c5\u533a\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.hasText((String)bedNo, (String)"\u5e8a\u4f4d\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.isTrue((status != null ? 1 : 0) != 0, (String)"\u5e8a\u4f4d\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        InpatWardBed inpatWardBed = (InpatWardBed)this.inpatWardBedMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getBedNo, (Object)bedNo)).eq(InpatWardBed::getWardId, (Object)wardId));
        Assert.notNull((Object)inpatWardBed, (String)("\u672a\u67e5\u8be2\u5230[" + wardId + "]\u75c5\u533a[" + bedNo + "]\u53f7\u5e8a\u76f8\u5173\u4fe1\u606f!"));
        InpatWardBed newInpatWardBed = new InpatWardBed();
        newInpatWardBed.setId(inpatWardBed.getId());
        if (status.getUseStatusCode().equals(InpatWardBedUseStatus.NOT_USED.getUseStatusCode())) {
            newInpatWardBed.setUseStatusCode(InpatWardBedUseStatus.NOT_USED.getUseStatusCode());
            newInpatWardBed.setUseStatusName(InpatWardBedUseStatus.NOT_USED.getUseStatusName());
            int updateWardBedCount = this.inpatWardBedMapper.update((Object)newInpatWardBed, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getId, (Object)inpatWardBed.getId())).eq(InpatWardBed::getUseStatusCode, (Object)InpatWardBedUseStatus.USED.getUseStatusCode()));
            Assert.isTrue((updateWardBedCount == 1 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4f4f\u9662\u5e8a\u4f4d\u4fe1\u606f\u5931\u8d25,\u5e8a\u4f4d\u672a\u4f7f\u7528!");
        } else {
            newInpatWardBed.setUseStatusCode(InpatWardBedUseStatus.USED.getUseStatusCode());
            newInpatWardBed.setUseStatusName(InpatWardBedUseStatus.USED.getUseStatusName());
            int updateWardBedCount = this.inpatWardBedMapper.update((Object)newInpatWardBed, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getId, (Object)inpatWardBed.getId())).eq(InpatWardBed::getUseStatusCode, (Object)InpatWardBedUseStatus.NOT_USED.getUseStatusCode()));
            Assert.isTrue((updateWardBedCount == 1 ? 1 : 0) != 0, (String)(inpatWardBed.getWardName() + "[" + inpatWardBed.getBedNo() + "]\u53f7\u5e8a\u4f4d\u5df2\u88ab\u4f7f\u7528!"));
        }
        return inpatWardBed;
    }

    public List<InpatWardBed> selectWardBedByWardId(Integer wardId) {
        Assert.notNull((Object)wardId, (String)"\u75c5\u533a\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
        List inpatWardBeds = this.inpatWardBedMapper.selectList((Wrapper)Wrappers.lambdaQuery(InpatWardBed.class).eq(InpatWardBed::getWardId, (Object)wardId));
        return inpatWardBeds;
    }

    public List<InpatWardBed> lockByWardIdAndBedNoList(Integer wardId, List<String> bedNoList) {
        return this.inpatWardBedMapper.lockByWardIdAndBedNoList(wardId, bedNoList);
    }

    public WristbandCardPrintVo wristbandCardPrint(String inpatNo) {
        Assert.hasText((String)inpatNo, (String)"\u4f4f\u9662\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        InpatRegist inpatRegist = this.inpatRegistService.selectByInpatNo(inpatNo);
        Assert.notNull((Object)inpatRegist, (String)("\u672a\u80fd\u6839\u636e\u4f4f\u9662\u53f7\uff1a\u3010" + inpatNo + "\u3011 \u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f"));
        return this.inpatWardBedMapper.wristbandCardPrint(inpatNo);
    }
}

