/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.byh.inpatient.api.enums.InpatpatientDataStatusEnum;
import com.byh.inpatient.api.enums.OrderTypeEnum;
import com.byh.inpatient.api.enums.ProjectDetailsStatusEnum;
import com.byh.inpatient.api.model.Entrustment;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.dto.InpatOrderChargeFeeDTO;
import com.byh.inpatient.api.model.order.InpatOrder;
import com.byh.inpatient.api.model.prescription.InpatPrescription;
import com.byh.inpatient.api.model.prescription.InpatPrescriptionDrug;
import com.byh.inpatient.api.model.treatment.InpatTreatmentItems;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.vo.nurse.ExecutionOfMedicalOrdersReqVo;
import com.byh.inpatient.api.vo.nurse.ExecutionOfMedicalOrdersResVo;
import com.byh.inpatient.api.vo.nurse.SelectPatientByNurseReqVo;
import com.byh.inpatient.api.vo.nurse.UpdateMedicalOrdersReqVo;
import com.byh.inpatient.api.vo.nurse.UpdateTeskinTestResultReqVo;
import com.byh.inpatient.data.repository.EntrustmentMapper;
import com.byh.inpatient.data.repository.InpatOrderMapper;
import com.byh.inpatient.data.repository.InpatPrescriptionMapper;
import com.byh.inpatient.data.repository.InpatTreatmentItemsMapper;
import com.byh.inpatient.data.repository.InpatWardBedMapper;
import com.byh.inpatient.data.repository.OutPrescriptionDrugMapper;
import com.byh.inpatient.web.mvc.enums.PrescriptionStatusEnum;
import com.byh.inpatient.web.service.IInpatFeeService;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.InpatOrderService;
import com.byh.inpatient.web.service.NurseService;
import com.byh.inpatient.web.service.impl.OutPrescriptionDrugServiceImpl;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NurseServiceImpl
implements NurseService {
    @Autowired
    private InpatPrescriptionMapper inpatPrescriptionMapper;
    @Autowired
    private InpatTreatmentItemsMapper inpatTreatmentItemsMapper;
    @Autowired
    private OutPrescriptionDrugMapper outPrescriptionDrugMapper;
    @Autowired
    private IInpatRegistService iInpatRegistService;
    @Autowired
    private InpatOrderService inpatOrderService;
    @Autowired
    private InpatOrderMapper inpatOrderMapper;
    @Autowired
    private EntrustmentMapper entrustmentMapper;
    @Autowired
    private InpatWardBedMapper inpatWardBedMapper;
    @Autowired
    private IInpatFeeService inpatFeeService;
    private static Logger log = LoggerFactory.getLogger(OutPrescriptionDrugServiceImpl.class);
    private static final List<String> CFCODELIST = Lists.newArrayList((Object[])new String[]{"20", "21", "30", "31", "32", "40", "41"});
    private static final List<String> JYJCZLHLLIST = Lists.newArrayList((Object[])new String[]{"50", "51", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "70"});

    public ResponseData<List<InpatRegist>> selectPatientByNurse(SelectPatientByNurseReqVo param) {
        List res = this.inpatWardBedMapper.selectPatientByNurse(param.getNurseId(), param.getDeptId(), param.getSearchParam());
        return ResponseData.success((Object)res);
    }

    public ResponseData<Page<ExecutionOfMedicalOrdersResVo>> executionOfMedicalOrders(ExecutionOfMedicalOrdersReqVo param) {
        Page page = new Page((long)param.getPageNum(), (long)param.getPageSize());
        this.inpatWardBedMapper.executionOfMedicalOrders(page, param);
        return ResponseData.success((Object)page);
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> updateMedicalOrders(UpdateMedicalOrdersReqVo param) {
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"id", new Object[]{param.getOrderId()})).eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue());
        InpatOrder outOrder = (InpatOrder)this.inpatOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355");
        }
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(outOrder.getInpatNo());
        if (inpatRegist == null) {
            return ResponseData.error((String)"\u60a3\u8005\u5df2\u7ecf\u51fa\u9662");
        }
        if (param.getTypeCode().equals(OrderTypeEnum.ZT_PROJECTS_ORDERS.getValue())) {
            Entrustment entrustment = (Entrustment)this.entrustmentMapper.selectById((Serializable)((Object)param.getPrescriptionDetailNo()));
            if (null == entrustment) {
                return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230");
            }
            if (param.getUpdateStatus().equals(ProjectDetailsStatusEnum.IN_PROGRESS.getValue())) {
                entrustment.setRealStarTime(new Date());
            }
            entrustment.setUpdateId(param.getOperatorId());
            entrustment.setStatus(param.getUpdateStatus());
            this.entrustmentMapper.updateById((Object)entrustment);
        }
        InpatOrderChargeFeeDTO inpatOrderChargeFeeDTO = new InpatOrderChargeFeeDTO();
        inpatOrderChargeFeeDTO.setInpatNo(outOrder.getInpatNo());
        inpatOrderChargeFeeDTO.setBusineDeptId(inpatRegist.getDeptId());
        inpatOrderChargeFeeDTO.setBusineDeptName(inpatRegist.getDeptName());
        inpatOrderChargeFeeDTO.setBusineDoctorId(outOrder.getCreateId());
        inpatOrderChargeFeeDTO.setBusineDoctorName(outOrder.getCreateName());
        inpatOrderChargeFeeDTO.setOperationId(param.getOperatorId());
        inpatOrderChargeFeeDTO.setOperationName(param.getOperatorName());
        inpatOrderChargeFeeDTO.setBusineWardId(inpatRegist.getWardId());
        inpatOrderChargeFeeDTO.setBusineWardName(inpatRegist.getWardName());
        inpatOrderChargeFeeDTO.setOperationDeptId(param.getOperationDeptId());
        inpatOrderChargeFeeDTO.setOperationDeptName(param.getOperationDeptName());
        if (CFCODELIST.contains(param.getTypeCode())) {
            InpatPrescriptionDrug inpatPrescriptionDrug = (InpatPrescriptionDrug)this.outPrescriptionDrugMapper.selectById((Serializable)((Object)param.getPrescriptionDetailNo()));
            if (null == inpatPrescriptionDrug) {
                return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u5904\u65b9\u836f\u54c1\u4fe1\u606f");
            }
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
            query.eq((Object)"prescription_status", (Object)PrescriptionStatusEnum.STATUS_NORMAL.getValue());
            InpatPrescription prescription = (InpatPrescription)this.inpatPrescriptionMapper.selectOne((Wrapper)query);
            if (prescription == null) {
                return ResponseData.error((String)"\u67e5\u8be2\u4e0d\u5230\u5904\u65b9\uff01");
            }
            if (param.getUpdateStatus().equals(ProjectDetailsStatusEnum.COMPLETED.getValue())) {
                inpatPrescriptionDrug.setRealStarTime(new Date());
                ArrayList<InpatPrescriptionDrug> prescriptionDrug = new ArrayList<InpatPrescriptionDrug>();
                prescriptionDrug.add(inpatPrescriptionDrug);
                inpatOrderChargeFeeDTO.setPrescriptionDrug(prescriptionDrug);
                this.inpatFeeService.chargeByPrescriptionDrug(inpatOrderChargeFeeDTO);
            }
            inpatPrescriptionDrug.setStatus(param.getUpdateStatus());
            inpatPrescriptionDrug.setUpdateId(param.getOperatorId());
            this.outPrescriptionDrugMapper.updateById((Object)inpatPrescriptionDrug);
            if (param.getUpdateStatus().equals(ProjectDetailsStatusEnum.INVALID.getValue())) {
                QueryWrapper outPrescriptionDrugMapperquery = new QueryWrapper();
                query.eq((Object)"prescription_no", (Object)outOrder.getPrescriptionNo());
                query.gt((Object)"status", (Object)ProjectDetailsStatusEnum.PENDING_EXECUTION);
                List inpatPrescriptionDrugs = this.outPrescriptionDrugMapper.selectList((Wrapper)outPrescriptionDrugMapperquery);
                if (null != inpatPrescriptionDrugs && inpatPrescriptionDrugs.size() > 0) {
                    return ResponseData.error((String)"\u8be5\u5904\u65b9\u6709\u6b63\u5728\u6267\u884c\u7684\u836f\u54c1\uff0c\u4e0d\u53ef\u64a4\u9500\uff01");
                }
                prescription.setPrescriptionStatus(PrescriptionStatusEnum.STATUS_DELETE.getValue());
                prescription.setUpdateId(param.getOperatorId());
                this.inpatPrescriptionMapper.updateById((Object)prescription);
                outOrder.setStatus(InpatpatientDataStatusEnum.STATUS_VOID.getValue());
                outOrder.setUpdateId(param.getOperatorId());
                this.inpatOrderMapper.updateById((Object)outOrder);
            }
        }
        if (JYJCZLHLLIST.contains(param.getTypeCode())) {
            InpatTreatmentItems inpatTreatmentItems = (InpatTreatmentItems)this.inpatTreatmentItemsMapper.selectById((Serializable)((Object)param.getPrescriptionDetailNo()));
            if (null == inpatTreatmentItems) {
                return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u68c0\u9a8c\u68c0\u67e5\u533b\u5631\u4fe1\u606f");
            }
            if (param.getUpdateStatus().equals(ProjectDetailsStatusEnum.COMPLETED.getValue())) {
                inpatTreatmentItems.setRealStarTime(new Date());
                ArrayList<InpatTreatmentItems> treatmentItems = new ArrayList<InpatTreatmentItems>();
                treatmentItems.add(inpatTreatmentItems);
                inpatOrderChargeFeeDTO.setTreatmentItems(treatmentItems);
                this.inpatFeeService.chargeByTreatmentItems(inpatOrderChargeFeeDTO);
            }
            inpatTreatmentItems.setStatus(param.getUpdateStatus());
            inpatTreatmentItems.setUpdateId(param.getOperatorId());
            this.inpatTreatmentItemsMapper.updateById((Object)inpatTreatmentItems);
        }
        if (param.getUpdateStatus().equals(ProjectDetailsStatusEnum.INVALID.getValue())) {
            outOrder.setStatus(InpatpatientDataStatusEnum.STATUS_VOID.getValue());
            outOrder.setUpdateId(param.getOperatorId());
            this.inpatOrderMapper.updateById((Object)outOrder);
        }
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public ResponseData<String> updaTeskinTestResult(UpdateTeskinTestResultReqVo param) {
        InpatPrescriptionDrug inpatPrescriptionDrug = (InpatPrescriptionDrug)this.outPrescriptionDrugMapper.selectById((Serializable)((Object)param.getPrescriptionDetailNo()));
        if (null == inpatPrescriptionDrug) {
            return ResponseData.error((String)"\u672a\u67e5\u8be2\u5230\u5904\u65b9\u836f\u54c1\u4fe1\u606f");
        }
        if (inpatPrescriptionDrug.getIsSkinTest() == 1) {
            return ResponseData.error((String)"\u8be5\u836f\u54c1\u65e0\u9700\u76ae\u8bd5");
        }
        inpatPrescriptionDrug.setIsSkinTest(Integer.valueOf(3));
        inpatPrescriptionDrug.setSkinTestResult(param.getSkinTestResult());
        inpatPrescriptionDrug.setUpdateId(param.getOperatorId());
        inpatPrescriptionDrug.setUpdateTime(new Date());
        this.outPrescriptionDrugMapper.updateById((Object)inpatPrescriptionDrug);
        return ResponseData.success((String)"\u64cd\u4f5c\u6210\u529f", (Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

