/*
 * Decompiled with CFR 0.152.
 */
package com.byh.inpatient.web.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.byh.inpatient.api.dto.order.SaveOrderDto;
import com.byh.inpatient.api.enums.InpatpatientDataStatusEnum;
import com.byh.inpatient.api.enums.OrderTypeEnum;
import com.byh.inpatient.api.enums.ProjectDetailsStatusEnum;
import com.byh.inpatient.api.model.InpatRegist;
import com.byh.inpatient.api.model.order.InpatOrder;
import com.byh.inpatient.api.model.treatment.InpatTreatmentDetails;
import com.byh.inpatient.api.model.treatment.InpatTreatmentItems;
import com.byh.inpatient.api.model.treatment.QueryInspectDetailResVo;
import com.byh.inpatient.api.model.vo.order.QueryFeeDetailsListVo;
import com.byh.inpatient.api.sysModel.respones.BasePageEntity;
import com.byh.inpatient.api.sysModel.respones.SysTreatmentItemVo;
import com.byh.inpatient.api.treatment.QueryItemsDto;
import com.byh.inpatient.api.treatment.SaveTreatmentItemsDto;
import com.byh.inpatient.api.util.ResponseData;
import com.byh.inpatient.api.vo.treatment.QueryItemsVo;
import com.byh.inpatient.data.repository.InpatOrderMapper;
import com.byh.inpatient.data.repository.InpatTreatmentDetailsMapper;
import com.byh.inpatient.data.repository.InpatTreatmentImplementMapper;
import com.byh.inpatient.data.repository.InpatTreatmentItemsMapper;
import com.byh.inpatient.web.feign.SysServiceFeign;
import com.byh.inpatient.web.mvc.exception.RunDisplayException;
import com.byh.inpatient.web.mvc.utils.UUIDUtils;
import com.byh.inpatient.web.service.IInpatRegistService;
import com.byh.inpatient.web.service.InpatOrderService;
import com.byh.inpatient.web.service.TreatmentItemsService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TreatmentItemsServiceImpl
implements TreatmentItemsService {
    @Autowired
    private InpatTreatmentItemsMapper inpatTreatmentItemsMapper;
    @Autowired
    private InpatTreatmentDetailsMapper inpatTreatmentDetailsMapper;
    @Autowired
    private InpatOrderService inpatOrderService;
    @Autowired
    private SysServiceFeign sysServiceFeign;
    @Autowired
    IInpatRegistService iInpatRegistService;
    @Autowired
    private InpatOrderMapper outOrderMapper;
    @Autowired
    private InpatTreatmentImplementMapper outTreatmentImplementMapper;
    private static Logger log = LoggerFactory.getLogger(TreatmentItemsServiceImpl.class);

    public ResponseData<List<QueryItemsVo>> queryItems(QueryItemsDto parameter) {
        List outTreatmentItems = this.inpatTreatmentItemsMapper.queryItems(parameter);
        outTreatmentItems.forEach(queryItemsVo -> {
            queryItemsVo.setInpatTreatmentId(queryItemsVo.getId());
            queryItemsVo.setTreatmentCategoryName(OrderTypeEnum.getEnumByProjectType((String)String.valueOf(queryItemsVo.getTreatmentCategory())).getName());
        });
        return ResponseData.success((Object)outTreatmentItems);
    }

    public ResponseData<List<QueryFeeDetailsListVo>> queryItemsDetails(QueryItemsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getTreatmentItemsNo())) {
            ResponseData.error((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<Object> collect = new ArrayList();
        if (null == parameter.getInpatTreatmentId()) {
            Integer[] ids = new Integer[]{Integer.valueOf(parameter.getTreatmentItemsNo())};
            ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(ids);
            if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
                ResponseData.success();
            }
            for (SysTreatmentItemVo sysTreatmentItemVo : (List)listResponseData.getData()) {
                if (CollectionUtils.isEmpty((Collection)sysTreatmentItemVo.getSysTreatmentChargeVoList())) {
                    return ResponseData.error((String)"\u8be5\u9879\u76ee\u672a\u6dfb\u52a0\u6536\u8d39\u9879\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                List collected = sysTreatmentItemVo.getSysTreatmentChargeVoList().stream().map(SysTreatmentChargeVo2 -> {
                    QueryFeeDetailsListVo queryFeeDetailsListVo = new QueryFeeDetailsListVo();
                    queryFeeDetailsListVo.setMedicalInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                    queryFeeDetailsListVo.setMedicalInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                    queryFeeDetailsListVo.setInsuranceDrugCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                    queryFeeDetailsListVo.setLevel(SysTreatmentChargeVo2.getChargeItemLevel());
                    queryFeeDetailsListVo.setName(SysTreatmentChargeVo2.getChargeItemName());
                    queryFeeDetailsListVo.setQuantity(new BigDecimal(SysTreatmentChargeVo2.getQuantity()));
                    queryFeeDetailsListVo.setDrugPriceAmount(SysTreatmentChargeVo2.getItemPrice());
                    return queryFeeDetailsListVo;
                }).collect(Collectors.toList());
                collect.addAll(collected);
            }
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"inpat_treatment_id", (Object)parameter.getInpatTreatmentId());
            List outTreatmentDetails = this.inpatTreatmentDetailsMapper.selectList((Wrapper)queryWrapper);
            collect = outTreatmentDetails.stream().map(OutTreatmentDetails -> {
                QueryFeeDetailsListVo queryFeeDetailsListVo = new QueryFeeDetailsListVo();
                BeanUtils.copyProperties((Object)OutTreatmentDetails, (Object)queryFeeDetailsListVo);
                queryFeeDetailsListVo.setInsuranceDrugCode(OutTreatmentDetails.getMedicalInsuranceCode());
                queryFeeDetailsListVo.setName(OutTreatmentDetails.getTreatmentName());
                queryFeeDetailsListVo.setQuantity(new BigDecimal(OutTreatmentDetails.getQuantity()));
                queryFeeDetailsListVo.setTotalDrugAmount(OutTreatmentDetails.getTotalAmount());
                queryFeeDetailsListVo.setDrugPriceAmount(OutTreatmentDetails.getUnitPriceAmount());
                return queryFeeDetailsListVo;
            }).collect(Collectors.toList());
        }
        return ResponseData.success(collect);
    }

    public ResponseData<String> saveTreatmentItems(SaveTreatmentItemsDto parameter) {
        log.info("SaveTreatmentItemsDto{}", (Object)JSON.toJSONString((Object)parameter));
        InpatRegist inpatRegist = this.iInpatRegistService.selectByInpatNo(parameter.getInpatNo());
        Assert.notNull((Object)inpatRegist, (String)"\u672a\u627e\u5230\u4f4f\u9662\u767b\u8bb0\u4fe1\u606f!");
        List ids = parameter.getProjectList().stream().map(SaveTreatmentItemsDto.Project::getItemsNo).collect(Collectors.toList());
        Integer[] integerArray = (Integer[])ids.stream().map(Integer::parseInt).toArray(Integer[]::new);
        log.info("integerArray{}", (Object)JSON.toJSONString((Object)integerArray));
        ResponseData listResponseData = this.sysServiceFeign.selectListWithChargeItems(integerArray);
        log.info("listResponseData{}", (Object)JSON.toJSONString((Object)listResponseData));
        if (!listResponseData.isSuccess() || listResponseData.getData() == null) {
            ResponseData.success();
        }
        if (ids.size() != ((List)listResponseData.getData()).size()) {
            throw new RunDisplayException("\u67e5\u8be2\u9879\u76ee\u7f3a\u5931\uff01");
        }
        Map itemMap = ((List)listResponseData.getData()).stream().collect(Collectors.toMap(BasePageEntity::getId, Function.identity()));
        ArrayList treatmentDetails = new ArrayList();
        for (SaveTreatmentItemsDto.Project project : parameter.getProjectList()) {
            SysTreatmentItemVo itemVo = (SysTreatmentItemVo)itemMap.get(Integer.parseInt(project.getItemsNo()));
            InpatTreatmentItems treatmentItems = new InpatTreatmentItems();
            treatmentItems.setTreatmentNo(UUIDUtils.getTreatmentNo());
            treatmentItems.setCreateId(parameter.getOperatorId());
            treatmentItems.setTenantId(parameter.getTenantId());
            treatmentItems.setItemsNo(project.getItemsNo());
            treatmentItems.setName(itemVo.getItemName());
            treatmentItems.setUnit(itemVo.getUnit());
            treatmentItems.setInpatNo(parameter.getInpatNo());
            treatmentItems.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
            treatmentItems.setTreatmentCategory(Integer.valueOf(itemVo.getTreatmentTypeCode()));
            treatmentItems.setQuantity(project.getQuantity());
            treatmentItems.setExecutedTime((Date)DateUtil.parse((String)project.getStarTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            treatmentItems.setAbsenceExecutedQuantity(project.getQuantity());
            treatmentItems.setExecutedQuantity(Integer.valueOf(0));
            treatmentItems.setUnitPriceAmount(itemVo.getTotalPrice());
            treatmentItems.setTotalAmount(treatmentItems.getUnitPriceAmount().multiply(new BigDecimal(treatmentItems.getQuantity())));
            treatmentItems.setRemark(project.getRemark());
            treatmentItems.setPrescribingDoctorId(parameter.getOperatorId());
            treatmentItems.setPrescribingDoctorName(parameter.getOperatorName());
            treatmentItems.setIssueTime(new Date());
            treatmentItems.setStatus(ProjectDetailsStatusEnum.ISSUED.getValue());
            treatmentItems.setPrescribingDepartmentId(parameter.getPrescribingDepartmentId());
            treatmentItems.setPrescribingDepartmentName(parameter.getPrescribingDepartmentName());
            treatmentItems.setHospitalId(parameter.getHospitalId());
            treatmentItems.setHospitalName(parameter.getHospitalName());
            treatmentItems.setExecutedDeptId(itemVo.getExecuteDeptId());
            treatmentItems.setExecutedDept(itemVo.getExecuteDeptName());
            treatmentItems.setExecutedDeptPosition(itemVo.getExecuteDeptPosition());
            treatmentItems.setSpecimen(itemVo.getSpecimen());
            treatmentItems.setSpecimenLabel(itemVo.getSpecimenLabel());
            treatmentItems.setInspectType(itemVo.getTreatmentTypeCode());
            treatmentItems.setInspectTypeLabel(itemVo.getTreatmentTypeName());
            treatmentItems.setItemsCode(itemVo.getItemCode());
            if (treatmentItems.getTotalAmount().compareTo(new BigDecimal(project.getTotalAmount())) != 0) {
                return ResponseData.error((String)"\u91d1\u989d\u6821\u9a8c\u9519\u8bef\uff01");
            }
            if (StringUtils.isNotEmpty((CharSequence)project.getId())) {
                treatmentItems.setId(Integer.valueOf(Integer.parseInt(project.getId())));
                this.inpatTreatmentItemsMapper.updateById((Object)treatmentItems);
            } else {
                this.inpatTreatmentItemsMapper.insert((Object)treatmentItems);
            }
            SaveOrderDto saveOrderDto = new SaveOrderDto();
            saveOrderDto.setOperatorId(parameter.getOperatorId());
            saveOrderDto.setOperatorName(parameter.getOperatorName());
            saveOrderDto.setTenantId(parameter.getTenantId());
            saveOrderDto.setPrescriptionNo(String.valueOf(treatmentItems.getId()));
            saveOrderDto.setInpatNo(parameter.getInpatNo());
            saveOrderDto.setPatientName(inpatRegist.getPatientName());
            saveOrderDto.setMedicalRecordNo(inpatRegist.getMedicalRecordNo());
            saveOrderDto.setOrderAmount(treatmentItems.getTotalAmount());
            saveOrderDto.setActualOtherPayment(new BigDecimal(0));
            saveOrderDto.setRegTime(DateUtil.formatDateTime((Date)new Date()));
            saveOrderDto.setPatientCardNo(inpatRegist.getCardNo());
            saveOrderDto.setCreateName(parameter.getOperatorName());
            this.inpatOrderService.saveOrder(OrderTypeEnum.getEnumByProjectType((String)project.getProjectType()), saveOrderDto);
            List detailsList = itemVo.getSysTreatmentChargeVoList().stream().map(SysTreatmentChargeVo2 -> {
                InpatTreatmentDetails outTreatmentDetails = new InpatTreatmentDetails();
                outTreatmentDetails.setCreateId(parameter.getOperatorId());
                outTreatmentDetails.setTenantId(parameter.getTenantId());
                outTreatmentDetails.setInpatTreatmentId(treatmentItems.getId());
                outTreatmentDetails.setUnit(SysTreatmentChargeVo2.getUnit());
                outTreatmentDetails.setTreatmentName(SysTreatmentChargeVo2.getChargeItemName());
                outTreatmentDetails.setMedicalInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                outTreatmentDetails.setMedicalInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                outTreatmentDetails.setInsuranceCode(SysTreatmentChargeVo2.getMedicalInsuranceCode());
                outTreatmentDetails.setInsuranceName(SysTreatmentChargeVo2.getMedicalInsuranceName());
                outTreatmentDetails.setMedicalInsuranceType(SysTreatmentChargeVo2.getMedicalInsuranceTypeCode());
                outTreatmentDetails.setMedicalInsuranceTypeName(SysTreatmentChargeVo2.getMedicalInsuranceTypeName());
                outTreatmentDetails.setLevel(SysTreatmentChargeVo2.getChargeItemLevel());
                List projectList = parameter.getProjectList();
                Integer quantity = projectList.stream().filter(obj -> treatmentItems.getItemsNo().equals(obj.getItemsNo())).map(SaveTreatmentItemsDto.Project::getQuantity).findFirst().orElse(1);
                outTreatmentDetails.setQuantity(quantity);
                outTreatmentDetails.setUnitPriceAmount(SysTreatmentChargeVo2.getItemPrice());
                outTreatmentDetails.setTotalAmount(outTreatmentDetails.getUnitPriceAmount().multiply(new BigDecimal(outTreatmentDetails.getQuantity())));
                outTreatmentDetails.setTreatmentCode(SysTreatmentChargeVo2.getChargeItemCode());
                return outTreatmentDetails;
            }).collect(Collectors.toList());
            treatmentDetails.addAll(detailsList);
        }
        this.inpatTreatmentDetailsMapper.batchInsert(treatmentDetails);
        return ResponseData.success((String)"\u64cd\u4f5c\u5b8c\u6210\uff01", (Object)"\u64cd\u4f5c\u5b8c\u6210\uff01");
    }

    public ResponseData<String> voidItems(QueryItemsDto parameter) {
        if (StringUtils.isEmpty((CharSequence)parameter.getTreatmentItemsNo())) {
            ResponseData.error((String)"\u6cbb\u7597\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)parameter.getInpatTreatmentId());
        InpatTreatmentItems outTreatmentItems = (InpatTreatmentItems)this.inpatTreatmentItemsMapper.selectOne((Wrapper)queryWrapper);
        if (outTreatmentItems == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u9879\u76ee");
        }
        if (outTreatmentItems.getStatus() > ProjectDetailsStatusEnum.PENDING_EXECUTION.getValue()) {
            return ResponseData.error((String)"\u8be5\u72b6\u6001\u4e0d\u53ef\u4f5c\u5e9f");
        }
        QueryWrapper queryrOrder = new QueryWrapper();
        ((QueryWrapper)queryrOrder.in((Object)"prescription_no", new Object[]{outTreatmentItems.getId()})).eq((Object)"status", (Object)InpatpatientDataStatusEnum.NORMAL.getValue());
        InpatOrder outOrder = (InpatOrder)this.outOrderMapper.selectOne((Wrapper)queryrOrder);
        if (outOrder == null) {
            return ResponseData.error((String)"\u6ca1\u6709\u627e\u5230\u8ba2\u5355");
        }
        outOrder.setStatus(InpatpatientDataStatusEnum.STATUS_VOID.getValue());
        this.outOrderMapper.updateById((Object)outOrder);
        outTreatmentItems.setStatus(ProjectDetailsStatusEnum.INVALID.getValue());
        outTreatmentItems.setUpdateId(parameter.getOperatorId());
        this.inpatTreatmentItemsMapper.updateById((Object)outTreatmentItems);
        return ResponseData.success((String)"\u64cd\u4f5c\u5b8c\u6210", (Object)"\u64cd\u4f5c\u5b8c\u6210");
    }

    public ResponseData<QueryInspectDetailResVo> queryInspectDetail(QueryItemsDto parameter) {
        QueryInspectDetailResVo queryInspectDetailResVo = new QueryInspectDetailResVo();
        InpatTreatmentItems inpatTreatmentItems = (InpatTreatmentItems)this.inpatTreatmentItemsMapper.selectById((Serializable)parameter.getInpatTreatmentId());
        BeanUtils.copyProperties((Object)inpatTreatmentItems, (Object)queryInspectDetailResVo);
        if (null != inpatTreatmentItems.getExecutedTime()) {
            queryInspectDetailResVo.setExecutedTime(DateUtil.format((Date)inpatTreatmentItems.getExecutedTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (null != inpatTreatmentItems.getRealStarTime()) {
            queryInspectDetailResVo.setRealStarTime(DateUtil.format((Date)inpatTreatmentItems.getRealStarTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return ResponseData.success((Object)queryInspectDetailResVo);
    }

    public List<Integer> selectTreatmentItemsList(List<String> inpatNoList) {
        return this.inpatTreatmentItemsMapper.selectTreatmentItemsList(inpatNoList);
    }
}

